// chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const AutocompleteControllerTypeSpec = { $: mojo.internal.Enum() };
export var AutocompleteControllerType;
(function (AutocompleteControllerType) {
    AutocompleteControllerType[AutocompleteControllerType["MIN_VALUE"] = 0] = "MIN_VALUE";
    AutocompleteControllerType[AutocompleteControllerType["MAX_VALUE"] = 2] = "MAX_VALUE";
    AutocompleteControllerType[AutocompleteControllerType["kBrowser"] = 0] = "kBrowser";
    AutocompleteControllerType[AutocompleteControllerType["kDebug"] = 1] = "kDebug";
    AutocompleteControllerType[AutocompleteControllerType["kMlDisabledDebug"] = 2] = "kMlDisabledDebug";
})(AutocompleteControllerType || (AutocompleteControllerType = {}));
export class OmniboxPageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'mojom.OmniboxPageHandler', scope);
    }
}
export class OmniboxPageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(OmniboxPageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setClientPage(page) {
        this.proxy.sendMessage(0, OmniboxPageHandler_SetClientPage_ParamsSpec.$, null, [
            page
        ], false);
    }
    startOmniboxQuery(inputString, resetAutocompleteController, cursorPosition, zeroSuggest, preventInlineAutocomplete, preferKeyword, currentUrl, pageClassification) {
        this.proxy.sendMessage(1, OmniboxPageHandler_StartOmniboxQuery_ParamsSpec.$, null, [
            inputString,
            resetAutocompleteController,
            cursorPosition,
            zeroSuggest,
            preventInlineAutocomplete,
            preferKeyword,
            currentUrl,
            pageClassification
        ], false);
    }
    getMlModelVersion() {
        return this.proxy.sendMessage(2, OmniboxPageHandler_GetMlModelVersion_ParamsSpec.$, OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec.$, [], false);
    }
    startMl(signals) {
        return this.proxy.sendMessage(3, OmniboxPageHandler_StartMl_ParamsSpec.$, OmniboxPageHandler_StartMl_ResponseParamsSpec.$, [
            signals
        ], false);
    }
}
;
/**
 * An object which receives request messages for the OmniboxPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OmniboxPageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OmniboxPageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, OmniboxPageHandler_SetClientPage_ParamsSpec.$, null, impl.setClientPage.bind(impl), false);
        this.helper_internal_.registerHandler(1, OmniboxPageHandler_StartOmniboxQuery_ParamsSpec.$, null, impl.startOmniboxQuery.bind(impl), false);
        this.helper_internal_.registerHandler(2, OmniboxPageHandler_GetMlModelVersion_ParamsSpec.$, OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec.$, impl.getMlModelVersion.bind(impl), false);
        this.helper_internal_.registerHandler(3, OmniboxPageHandler_StartMl_ParamsSpec.$, OmniboxPageHandler_StartMl_ResponseParamsSpec.$, impl.startMl.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class OmniboxPageHandler {
    static get $interfaceName() {
        return "mojom.OmniboxPageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new OmniboxPageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the OmniboxPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OmniboxPageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    setClientPage;
    startOmniboxQuery;
    getMlModelVersion;
    startMl;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OmniboxPageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setClientPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, OmniboxPageHandler_SetClientPage_ParamsSpec.$, null, this.setClientPage.createReceiverHandler(false /* expectsResponse */), false);
        this.startOmniboxQuery =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, OmniboxPageHandler_StartOmniboxQuery_ParamsSpec.$, null, this.startOmniboxQuery.createReceiverHandler(false /* expectsResponse */), false);
        this.getMlModelVersion =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, OmniboxPageHandler_GetMlModelVersion_ParamsSpec.$, OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec.$, this.getMlModelVersion.createReceiverHandler(true /* expectsResponse */), false);
        this.startMl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, OmniboxPageHandler_StartMl_ParamsSpec.$, OmniboxPageHandler_StartMl_ResponseParamsSpec.$, this.startMl.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class OmniboxPagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'mojom.OmniboxPage', scope);
    }
}
export class OmniboxPageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(OmniboxPagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    handleNewAutocompleteQuery(autocompleteControllerType, inputText) {
        this.proxy.sendMessage(0, OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec.$, null, [
            autocompleteControllerType,
            inputText
        ], false);
    }
    handleNewAutocompleteResponse(autocompleteControllerType, response) {
        this.proxy.sendMessage(1, OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec.$, null, [
            autocompleteControllerType,
            response
        ], false);
    }
    handleNewMlResponse(autocompleteControllerType, inputText, matches) {
        this.proxy.sendMessage(2, OmniboxPage_HandleNewMlResponse_ParamsSpec.$, null, [
            autocompleteControllerType,
            inputText,
            matches
        ], false);
    }
    handleAnswerIconImageData(autocompleteControllerType, imageUrl, imageData) {
        this.proxy.sendMessage(3, OmniboxPage_HandleAnswerIconImageData_ParamsSpec.$, null, [
            autocompleteControllerType,
            imageUrl,
            imageData
        ], false);
    }
}
;
/**
 * An object which receives request messages for the OmniboxPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OmniboxPageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OmniboxPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec.$, null, impl.handleNewAutocompleteQuery.bind(impl), false);
        this.helper_internal_.registerHandler(1, OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec.$, null, impl.handleNewAutocompleteResponse.bind(impl), false);
        this.helper_internal_.registerHandler(2, OmniboxPage_HandleNewMlResponse_ParamsSpec.$, null, impl.handleNewMlResponse.bind(impl), false);
        this.helper_internal_.registerHandler(3, OmniboxPage_HandleAnswerIconImageData_ParamsSpec.$, null, impl.handleAnswerIconImageData.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class OmniboxPage {
    static get $interfaceName() {
        return "mojom.OmniboxPage";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new OmniboxPageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the OmniboxPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OmniboxPageCallbackRouter {
    helper_internal_;
    $;
    router_;
    handleNewAutocompleteQuery;
    handleNewAutocompleteResponse;
    handleNewMlResponse;
    handleAnswerIconImageData;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OmniboxPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.handleNewAutocompleteQuery =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec.$, null, this.handleNewAutocompleteQuery.createReceiverHandler(false /* expectsResponse */), false);
        this.handleNewAutocompleteResponse =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec.$, null, this.handleNewAutocompleteResponse.createReceiverHandler(false /* expectsResponse */), false);
        this.handleNewMlResponse =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, OmniboxPage_HandleNewMlResponse_ParamsSpec.$, null, this.handleNewMlResponse.createReceiverHandler(false /* expectsResponse */), false);
        this.handleAnswerIconImageData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, OmniboxPage_HandleAnswerIconImageData_ParamsSpec.$, null, this.handleAnswerIconImageData.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ACMatchClassificationSpec = { $: {} };
export const SignalsSpec = { $: {} };
export const AutocompleteMatchSpec = { $: {} };
export const AutocompleteResultsForProviderSpec = { $: {} };
export const OmniboxResponseSpec = { $: {} };
export const OmniboxPageHandler_SetClientPage_ParamsSpec = { $: {} };
export const OmniboxPageHandler_StartOmniboxQuery_ParamsSpec = { $: {} };
export const OmniboxPageHandler_GetMlModelVersion_ParamsSpec = { $: {} };
export const OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec = { $: {} };
export const OmniboxPageHandler_StartMl_ParamsSpec = { $: {} };
export const OmniboxPageHandler_StartMl_ResponseParamsSpec = { $: {} };
export const OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec = { $: {} };
export const OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec = { $: {} };
export const OmniboxPage_HandleNewMlResponse_ParamsSpec = { $: {} };
export const OmniboxPage_HandleAnswerIconImageData_ParamsSpec = { $: {} };
mojo.internal.Struct(ACMatchClassificationSpec.$, 'ACMatchClassification', [
    mojo.internal.StructField('offset', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('style', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SignalsSpec.$, 'Signals', [
    mojo.internal.StructField('typed_count_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "typed_count_$value",
        originalFieldName: "typedCount",
    }, undefined),
    mojo.internal.StructField('typed_count_$value', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "typedCount",
    }, undefined),
    mojo.internal.StructField('visit_count_$flag', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "visit_count_$value",
        originalFieldName: "visitCount",
    }, undefined),
    mojo.internal.StructField('visit_count_$value', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "visitCount",
    }, undefined),
    mojo.internal.StructField('elapsed_time_last_visit_secs_$flag', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "elapsed_time_last_visit_secs_$value",
        originalFieldName: "elapsedTimeLastVisitSecs",
    }, undefined),
    mojo.internal.StructField('elapsed_time_last_visit_secs_$value', 16, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "elapsedTimeLastVisitSecs",
    }, undefined),
    mojo.internal.StructField('shortcut_visit_count_$flag', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "shortcut_visit_count_$value",
        originalFieldName: "shortcutVisitCount",
    }, undefined),
    mojo.internal.StructField('shortcut_visit_count_$value', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "shortcutVisitCount",
    }, undefined),
    mojo.internal.StructField('shortest_shortcut_len_$flag', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "shortest_shortcut_len_$value",
        originalFieldName: "shortestShortcutLen",
    }, undefined),
    mojo.internal.StructField('shortest_shortcut_len_$value', 24, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "shortestShortcutLen",
    }, undefined),
    mojo.internal.StructField('elapsed_time_last_shortcut_visit_sec_$flag', 0, 5, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "elapsed_time_last_shortcut_visit_sec_$value",
        originalFieldName: "elapsedTimeLastShortcutVisitSec",
    }, undefined),
    mojo.internal.StructField('elapsed_time_last_shortcut_visit_sec_$value', 32, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "elapsedTimeLastShortcutVisitSec",
    }, undefined),
    mojo.internal.StructField('is_host_only_$flag', 0, 6, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_host_only_$value",
        originalFieldName: "isHostOnly",
    }, undefined),
    mojo.internal.StructField('is_host_only_$value', 0, 7, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isHostOnly",
    }, undefined),
    mojo.internal.StructField('num_bookmarks_of_url_$flag', 1, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "num_bookmarks_of_url_$value",
        originalFieldName: "numBookmarksOfUrl",
    }, undefined),
    mojo.internal.StructField('num_bookmarks_of_url_$value', 28, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "numBookmarksOfUrl",
    }, undefined),
    mojo.internal.StructField('first_bookmark_title_match_position_$flag', 1, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "first_bookmark_title_match_position_$value",
        originalFieldName: "firstBookmarkTitleMatchPosition",
    }, undefined),
    mojo.internal.StructField('first_bookmark_title_match_position_$value', 40, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "firstBookmarkTitleMatchPosition",
    }, undefined),
    mojo.internal.StructField('total_bookmark_title_match_length_$flag', 1, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "total_bookmark_title_match_length_$value",
        originalFieldName: "totalBookmarkTitleMatchLength",
    }, undefined),
    mojo.internal.StructField('total_bookmark_title_match_length_$value', 44, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "totalBookmarkTitleMatchLength",
    }, undefined),
    mojo.internal.StructField('num_input_terms_matched_by_bookmark_title_$flag', 1, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "num_input_terms_matched_by_bookmark_title_$value",
        originalFieldName: "numInputTermsMatchedByBookmarkTitle",
    }, undefined),
    mojo.internal.StructField('num_input_terms_matched_by_bookmark_title_$value', 48, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "numInputTermsMatchedByBookmarkTitle",
    }, undefined),
    mojo.internal.StructField('first_url_match_position_$flag', 1, 4, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "first_url_match_position_$value",
        originalFieldName: "firstUrlMatchPosition",
    }, undefined),
    mojo.internal.StructField('first_url_match_position_$value', 52, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "firstUrlMatchPosition",
    }, undefined),
    mojo.internal.StructField('total_url_match_length_$flag', 1, 5, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "total_url_match_length_$value",
        originalFieldName: "totalUrlMatchLength",
    }, undefined),
    mojo.internal.StructField('total_url_match_length_$value', 56, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "totalUrlMatchLength",
    }, undefined),
    mojo.internal.StructField('host_match_at_word_boundary_$flag', 1, 6, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "host_match_at_word_boundary_$value",
        originalFieldName: "hostMatchAtWordBoundary",
    }, undefined),
    mojo.internal.StructField('host_match_at_word_boundary_$value', 1, 7, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "hostMatchAtWordBoundary",
    }, undefined),
    mojo.internal.StructField('total_host_match_length_$flag', 2, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "total_host_match_length_$value",
        originalFieldName: "totalHostMatchLength",
    }, undefined),
    mojo.internal.StructField('total_host_match_length_$value', 60, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "totalHostMatchLength",
    }, undefined),
    mojo.internal.StructField('total_path_match_length_$flag', 2, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "total_path_match_length_$value",
        originalFieldName: "totalPathMatchLength",
    }, undefined),
    mojo.internal.StructField('total_path_match_length_$value', 64, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "totalPathMatchLength",
    }, undefined),
    mojo.internal.StructField('total_query_or_ref_match_length_$flag', 2, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "total_query_or_ref_match_length_$value",
        originalFieldName: "totalQueryOrRefMatchLength",
    }, undefined),
    mojo.internal.StructField('total_query_or_ref_match_length_$value', 68, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "totalQueryOrRefMatchLength",
    }, undefined),
    mojo.internal.StructField('total_title_match_length_$flag', 2, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "total_title_match_length_$value",
        originalFieldName: "totalTitleMatchLength",
    }, undefined),
    mojo.internal.StructField('total_title_match_length_$value', 72, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "totalTitleMatchLength",
    }, undefined),
    mojo.internal.StructField('has_non_scheme_www_match_$flag', 2, 4, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "has_non_scheme_www_match_$value",
        originalFieldName: "hasNonSchemeWwwMatch",
    }, undefined),
    mojo.internal.StructField('has_non_scheme_www_match_$value', 2, 5, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "hasNonSchemeWwwMatch",
    }, undefined),
    mojo.internal.StructField('num_input_terms_matched_by_title_$flag', 2, 6, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "num_input_terms_matched_by_title_$value",
        originalFieldName: "numInputTermsMatchedByTitle",
    }, undefined),
    mojo.internal.StructField('num_input_terms_matched_by_title_$value', 76, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "numInputTermsMatchedByTitle",
    }, undefined),
    mojo.internal.StructField('num_input_terms_matched_by_url_$flag', 2, 7, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "num_input_terms_matched_by_url_$value",
        originalFieldName: "numInputTermsMatchedByUrl",
    }, undefined),
    mojo.internal.StructField('num_input_terms_matched_by_url_$value', 80, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "numInputTermsMatchedByUrl",
    }, undefined),
    mojo.internal.StructField('length_of_url_$flag', 3, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "length_of_url_$value",
        originalFieldName: "lengthOfUrl",
    }, undefined),
    mojo.internal.StructField('length_of_url_$value', 84, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "lengthOfUrl",
    }, undefined),
    mojo.internal.StructField('site_engagement_$flag', 3, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "site_engagement_$value",
        originalFieldName: "siteEngagement",
    }, undefined),
    mojo.internal.StructField('site_engagement_$value', 88, 0, mojo.internal.Float, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "siteEngagement",
    }, undefined),
    mojo.internal.StructField('allowed_to_be_default_match_$flag', 3, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "allowed_to_be_default_match_$value",
        originalFieldName: "allowedToBeDefaultMatch",
    }, undefined),
    mojo.internal.StructField('allowed_to_be_default_match_$value', 3, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "allowedToBeDefaultMatch",
    }, undefined),
    mojo.internal.StructField('search_suggest_relevance_$flag', 3, 4, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "search_suggest_relevance_$value",
        originalFieldName: "searchSuggestRelevance",
    }, undefined),
    mojo.internal.StructField('search_suggest_relevance_$value', 92, 0, mojo.internal.Int32, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "searchSuggestRelevance",
    }, undefined),
    mojo.internal.StructField('is_search_suggest_entity_$flag', 3, 5, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_search_suggest_entity_$value",
        originalFieldName: "isSearchSuggestEntity",
    }, undefined),
    mojo.internal.StructField('is_search_suggest_entity_$value', 3, 6, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isSearchSuggestEntity",
    }, undefined),
    mojo.internal.StructField('is_verbatim_$flag', 3, 7, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_verbatim_$value",
        originalFieldName: "isVerbatim",
    }, undefined),
    mojo.internal.StructField('is_verbatim_$value', 96, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isVerbatim",
    }, undefined),
    mojo.internal.StructField('is_navsuggest_$flag', 96, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_navsuggest_$value",
        originalFieldName: "isNavsuggest",
    }, undefined),
    mojo.internal.StructField('is_navsuggest_$value', 96, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isNavsuggest",
    }, undefined),
    mojo.internal.StructField('is_search_suggest_tail_$flag', 96, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_search_suggest_tail_$value",
        originalFieldName: "isSearchSuggestTail",
    }, undefined),
    mojo.internal.StructField('is_search_suggest_tail_$value', 96, 4, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isSearchSuggestTail",
    }, undefined),
    mojo.internal.StructField('is_answer_suggest_$flag', 96, 5, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_answer_suggest_$value",
        originalFieldName: "isAnswerSuggest",
    }, undefined),
    mojo.internal.StructField('is_answer_suggest_$value', 96, 6, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isAnswerSuggest",
    }, undefined),
    mojo.internal.StructField('is_calculator_suggest_$flag', 96, 7, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_calculator_suggest_$value",
        originalFieldName: "isCalculatorSuggest",
    }, undefined),
    mojo.internal.StructField('is_calculator_suggest_$value', 97, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isCalculatorSuggest",
    }, undefined),
], [[0, 112],]);
mojo.internal.Struct(AutocompleteMatchSpec.$, 'AutocompleteMatch', [
    mojo.internal.StructField('providerName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('providerDone', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('relevance', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deletable', 8, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fillIntoEdit', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inlineAutocompletion', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('destinationUrl', 32, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('strippedDestinationUrl', 40, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('icon', 48, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('image', 56, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('contents', 64, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('contentsClass', 72, 0, mojo.internal.Array(ACMatchClassificationSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('description', 80, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('descriptionClass', 88, 0, mojo.internal.Array(ACMatchClassificationSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('swapContentsAndDescription', 8, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('answer', 96, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('transition', 104, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('allowedToBeDefaultMatch', 8, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 112, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isSearchType', 8, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('aqsTypeSubtypes', 120, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasTabMatch', 8, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('associatedKeyword', 128, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('keyword', 136, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('starred', 8, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('duplicates', 144, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fromPrevious', 8, 7, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pedalId', 148, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scoringSignals', 152, 0, SignalsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('additionalInfo', 160, 0, mojo.internal.Map(mojo.internal.String, mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 176],]);
mojo.internal.Struct(AutocompleteResultsForProviderSpec.$, 'AutocompleteResultsForProvider', [
    mojo.internal.StructField('providerName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('results', 8, 0, mojo.internal.Array(AutocompleteMatchSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(OmniboxResponseSpec.$, 'OmniboxResponse', [
    mojo.internal.StructField('cursorPosition', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timeSinceOmniboxStartedMs', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('done', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('host', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isTypedHost', 8, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputText', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('combinedResults', 40, 0, mojo.internal.Array(AutocompleteMatchSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resultsByProvider', 48, 0, mojo.internal.Array(AutocompleteResultsForProviderSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(OmniboxPageHandler_SetClientPage_ParamsSpec.$, 'OmniboxPageHandler_SetClientPage_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(OmniboxPageRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OmniboxPageHandler_StartOmniboxQuery_ParamsSpec.$, 'OmniboxPageHandler_StartOmniboxQuery_Params', [
    mojo.internal.StructField('inputString', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resetAutocompleteController', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('cursorPosition', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('zeroSuggest', 8, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('preventInlineAutocomplete', 8, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('preferKeyword', 8, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('currentUrl', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageClassification', 24, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(OmniboxPageHandler_GetMlModelVersion_ParamsSpec.$, 'OmniboxPageHandler_GetMlModelVersion_Params', [], [[0, 8],]);
mojo.internal.Struct(OmniboxPageHandler_GetMlModelVersion_ResponseParamsSpec.$, 'OmniboxPageHandler_GetMlModelVersion_ResponseParams', [
    mojo.internal.StructField('version', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OmniboxPageHandler_StartMl_ParamsSpec.$, 'OmniboxPageHandler_StartMl_Params', [
    mojo.internal.StructField('signals', 0, 0, SignalsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OmniboxPageHandler_StartMl_ResponseParamsSpec.$, 'OmniboxPageHandler_StartMl_ResponseParams', [
    mojo.internal.StructField('score', 0, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OmniboxPage_HandleNewAutocompleteQuery_ParamsSpec.$, 'OmniboxPage_HandleNewAutocompleteQuery_Params', [
    mojo.internal.StructField('autocompleteControllerType', 0, 0, AutocompleteControllerTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputText', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(OmniboxPage_HandleNewAutocompleteResponse_ParamsSpec.$, 'OmniboxPage_HandleNewAutocompleteResponse_Params', [
    mojo.internal.StructField('autocompleteControllerType', 0, 0, AutocompleteControllerTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('response', 8, 0, OmniboxResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(OmniboxPage_HandleNewMlResponse_ParamsSpec.$, 'OmniboxPage_HandleNewMlResponse_Params', [
    mojo.internal.StructField('autocompleteControllerType', 0, 0, AutocompleteControllerTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputText', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('matches', 16, 0, mojo.internal.Array(AutocompleteMatchSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(OmniboxPage_HandleAnswerIconImageData_ParamsSpec.$, 'OmniboxPage_HandleAnswerIconImageData_Params', [
    mojo.internal.StructField('autocompleteControllerType', 0, 0, AutocompleteControllerTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('imageUrl', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('imageData', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
