// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/icons.html.js';
import './ntp_promo_icons.html.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './setup_list_item.css.js';
import { getHtml } from './setup_list_item.html.js';
/**
 * Entry in an NTP Setup List. Represents a single promotion to show.
 */
export class SetupListItemElement extends CrLitElement {
    static get is() {
        return 'setup-list-item';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            actionButtonText: { type: String, reflect: true, useDefault: true },
            bodyIconName: { type: String, reflect: true, useDefault: true },
            bodyText: { type: String, reflect: true, useDefault: true },
            completed: { type: Boolean, reflect: true, useDefault: true },
            promoId: { type: String, reflect: true, useDefault: true },
        };
    }
    #actionButtonText_accessor_storage = '';
    get actionButtonText() { return this.#actionButtonText_accessor_storage; }
    set actionButtonText(value) { this.#actionButtonText_accessor_storage = value; }
    #bodyIconName_accessor_storage = '';
    get bodyIconName() { return this.#bodyIconName_accessor_storage; }
    set bodyIconName(value) { this.#bodyIconName_accessor_storage = value; }
    #bodyText_accessor_storage = '';
    get bodyText() { return this.#bodyText_accessor_storage; }
    set bodyText(value) { this.#bodyText_accessor_storage = value; }
    #completed_accessor_storage = false;
    get completed() { return this.#completed_accessor_storage; }
    set completed(value) { this.#completed_accessor_storage = value; }
    #promoId_accessor_storage = '';
    get promoId() { return this.#promoId_accessor_storage; }
    set promoId(value) { this.#promoId_accessor_storage = value; }
    onClick_() {
        const event = new CustomEvent('ntp-promo-click', { composed: true, bubbles: true, detail: this.promoId });
        this.dispatchEvent(event);
    }
}
customElements.define(SetupListItemElement.is, SetupListItemElement);
