import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/icons.html.js';
import './ntp_promo_icons.html.js';
import type { CrIconElement } from '//resources/cr_elements/cr_icon/cr_icon.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
export interface SetupListItemElement {
    $: {
        actionIcon: CrIconElement;
        backing: HTMLElement;
        bodyIcon: HTMLElement;
        bodyText: HTMLElement;
    };
}
/**
 * Entry in an NTP Setup List. Represents a single promotion to show.
 */
export declare class SetupListItemElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        actionButtonText: {
            type: StringConstructor;
            reflect: boolean;
            useDefault: boolean;
        };
        bodyIconName: {
            type: StringConstructor;
            reflect: boolean;
            useDefault: boolean;
        };
        bodyText: {
            type: StringConstructor;
            reflect: boolean;
            useDefault: boolean;
        };
        completed: {
            type: BooleanConstructor;
            reflect: boolean;
            useDefault: boolean;
        };
        promoId: {
            type: StringConstructor;
            reflect: boolean;
            useDefault: boolean;
        };
    };
    accessor actionButtonText: string;
    accessor bodyIconName: string;
    accessor bodyText: string;
    accessor completed: boolean;
    accessor promoId: string;
    protected onClick_(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'setup-list-item': SetupListItemElement;
    }
}
