// chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { MicrosoftAuthUntrustedDocumentRemote as newTabPage_mojom_MicrosoftAuthUntrustedDocumentRemote } from './ntp_microsoft_auth_shared_ui.mojom-webui.js';
import { MostVisitedThemeSpec as mostVisited_mojom_MostVisitedThemeSpec } from '//resources/cr_components/most_visited/most_visited.mojom-webui.js';
import { TileTypeSpec as ntpTiles_mojom_TileTypeSpec } from '//resources/mojo/components/ntp_tiles/tile_type.mojom-webui.js';
import { SkColorSpec as skia_mojom_SkColorSpec } from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const NtpBackgroundImageSourceSpec = { $: mojo.internal.Enum() };
export var NtpBackgroundImageSource;
(function (NtpBackgroundImageSource) {
    NtpBackgroundImageSource[NtpBackgroundImageSource["MIN_VALUE"] = 0] = "MIN_VALUE";
    NtpBackgroundImageSource[NtpBackgroundImageSource["MAX_VALUE"] = 6] = "MAX_VALUE";
    NtpBackgroundImageSource[NtpBackgroundImageSource["kNoImage"] = 0] = "kNoImage";
    NtpBackgroundImageSource[NtpBackgroundImageSource["kFirstPartyThemeWithoutDailyRefresh"] = 1] = "kFirstPartyThemeWithoutDailyRefresh";
    NtpBackgroundImageSource[NtpBackgroundImageSource["kFirstPartyThemeWithDailyRefresh"] = 2] = "kFirstPartyThemeWithDailyRefresh";
    NtpBackgroundImageSource[NtpBackgroundImageSource["kThirdPartyTheme"] = 3] = "kThirdPartyTheme";
    NtpBackgroundImageSource[NtpBackgroundImageSource["kUploadedImage"] = 4] = "kUploadedImage";
    NtpBackgroundImageSource[NtpBackgroundImageSource["kWallpaperSearch"] = 5] = "kWallpaperSearch";
    NtpBackgroundImageSource[NtpBackgroundImageSource["kWallpaperSearchInspiration"] = 6] = "kWallpaperSearchInspiration";
})(NtpBackgroundImageSource || (NtpBackgroundImageSource = {}));
export const IphFeatureSpec = { $: mojo.internal.Enum() };
export var IphFeature;
(function (IphFeature) {
    IphFeature[IphFeature["MIN_VALUE"] = 0] = "MIN_VALUE";
    IphFeature[IphFeature["MAX_VALUE"] = 1] = "MAX_VALUE";
    IphFeature[IphFeature["kCustomizeChrome"] = 0] = "kCustomizeChrome";
    IphFeature[IphFeature["kCustomizeModules"] = 1] = "kCustomizeModules";
})(IphFeature || (IphFeature = {}));
export const DoodleImageTypeSpec = { $: mojo.internal.Enum() };
export var DoodleImageType;
(function (DoodleImageType) {
    DoodleImageType[DoodleImageType["MIN_VALUE"] = 0] = "MIN_VALUE";
    DoodleImageType[DoodleImageType["MAX_VALUE"] = 2] = "MAX_VALUE";
    DoodleImageType[DoodleImageType["kAnimation"] = 0] = "kAnimation";
    DoodleImageType[DoodleImageType["kCta"] = 1] = "kCta";
    DoodleImageType[DoodleImageType["kStatic"] = 2] = "kStatic";
})(DoodleImageType || (DoodleImageType = {}));
export const DoodleShareChannelSpec = { $: mojo.internal.Enum() };
export var DoodleShareChannel;
(function (DoodleShareChannel) {
    DoodleShareChannel[DoodleShareChannel["MIN_VALUE"] = 0] = "MIN_VALUE";
    DoodleShareChannel[DoodleShareChannel["MAX_VALUE"] = 3] = "MAX_VALUE";
    DoodleShareChannel[DoodleShareChannel["kFacebook"] = 0] = "kFacebook";
    DoodleShareChannel[DoodleShareChannel["kTwitter"] = 1] = "kTwitter";
    DoodleShareChannel[DoodleShareChannel["kEmail"] = 2] = "kEmail";
    DoodleShareChannel[DoodleShareChannel["kLinkCopy"] = 3] = "kLinkCopy";
})(DoodleShareChannel || (DoodleShareChannel = {}));
export const CustomizeDialogActionSpec = { $: mojo.internal.Enum() };
export var CustomizeDialogAction;
(function (CustomizeDialogAction) {
    CustomizeDialogAction[CustomizeDialogAction["MIN_VALUE"] = 0] = "MIN_VALUE";
    CustomizeDialogAction[CustomizeDialogAction["MAX_VALUE"] = 11] = "MAX_VALUE";
    CustomizeDialogAction[CustomizeDialogAction["kCancelClicked"] = 0] = "kCancelClicked";
    CustomizeDialogAction[CustomizeDialogAction["kDoneClicked"] = 1] = "kDoneClicked";
    CustomizeDialogAction[CustomizeDialogAction["kOpenClicked"] = 2] = "kOpenClicked";
    CustomizeDialogAction[CustomizeDialogAction["kBackgroundsBackClicked"] = 3] = "kBackgroundsBackClicked";
    CustomizeDialogAction[CustomizeDialogAction["kBackgroundsNoBackgroundSelected"] = 4] = "kBackgroundsNoBackgroundSelected";
    CustomizeDialogAction[CustomizeDialogAction["kBackgroundsCollectionOpened"] = 5] = "kBackgroundsCollectionOpened";
    CustomizeDialogAction[CustomizeDialogAction["kBackgroundsRefreshToggleClicked"] = 6] = "kBackgroundsRefreshToggleClicked";
    CustomizeDialogAction[CustomizeDialogAction["kBackgroundsImageSelected"] = 7] = "kBackgroundsImageSelected";
    CustomizeDialogAction[CustomizeDialogAction["kBackgroundsUploadFromDeviceClicked"] = 8] = "kBackgroundsUploadFromDeviceClicked";
    CustomizeDialogAction[CustomizeDialogAction["kShortcutsCustomLinksClicked"] = 9] = "kShortcutsCustomLinksClicked";
    CustomizeDialogAction[CustomizeDialogAction["kShortcutsMostVisitedClicked"] = 10] = "kShortcutsMostVisitedClicked";
    CustomizeDialogAction[CustomizeDialogAction["kShortcutsVisibilityToggleClicked"] = 11] = "kShortcutsVisibilityToggleClicked";
})(CustomizeDialogAction || (CustomizeDialogAction = {}));
export const OptInStatusSpec = { $: mojo.internal.Enum() };
export var OptInStatus;
(function (OptInStatus) {
    OptInStatus[OptInStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    OptInStatus[OptInStatus["MAX_VALUE"] = 2] = "MAX_VALUE";
    OptInStatus[OptInStatus["kExplicitOptIn"] = 0] = "kExplicitOptIn";
    OptInStatus[OptInStatus["kImplicitOptIn"] = 1] = "kImplicitOptIn";
    OptInStatus[OptInStatus["kOptOut"] = 2] = "kOptOut";
})(OptInStatus || (OptInStatus = {}));
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'new_tab_page.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "new_tab_page.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'new_tab_page.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setMostVisitedSettings(shortcutsType, shortcutsVisible) {
        this.proxy.sendMessage(0, PageHandler_SetMostVisitedSettings_ParamsSpec.$, null, [
            shortcutsType,
            shortcutsVisible
        ], false);
    }
    getMostVisitedSettings() {
        return this.proxy.sendMessage(1, PageHandler_GetMostVisitedSettings_ParamsSpec.$, PageHandler_GetMostVisitedSettings_ResponseParamsSpec.$, [], false);
    }
    getDoodle() {
        return this.proxy.sendMessage(2, PageHandler_GetDoodle_ParamsSpec.$, PageHandler_GetDoodle_ResponseParamsSpec.$, [], false);
    }
    updatePromoData() {
        this.proxy.sendMessage(3, PageHandler_UpdatePromoData_ParamsSpec.$, null, [], false);
    }
    blocklistPromo(promoId) {
        this.proxy.sendMessage(4, PageHandler_BlocklistPromo_ParamsSpec.$, null, [
            promoId
        ], false);
    }
    undoBlocklistPromo(promoId) {
        this.proxy.sendMessage(5, PageHandler_UndoBlocklistPromo_ParamsSpec.$, null, [
            promoId
        ], false);
    }
    onDismissModule(moduleId) {
        this.proxy.sendMessage(6, PageHandler_OnDismissModule_ParamsSpec.$, null, [
            moduleId
        ], false);
    }
    onRestoreModule(moduleId) {
        this.proxy.sendMessage(7, PageHandler_OnRestoreModule_ParamsSpec.$, null, [
            moduleId
        ], false);
    }
    setModulesVisible(visible) {
        this.proxy.sendMessage(8, PageHandler_SetModulesVisible_ParamsSpec.$, null, [
            visible
        ], false);
    }
    setModuleDisabled(moduleId, disabled) {
        this.proxy.sendMessage(9, PageHandler_SetModuleDisabled_ParamsSpec.$, null, [
            moduleId,
            disabled
        ], false);
    }
    updateDisabledModules() {
        this.proxy.sendMessage(10, PageHandler_UpdateDisabledModules_ParamsSpec.$, null, [], false);
    }
    onModulesLoadedWithData(moduleIds) {
        this.proxy.sendMessage(11, PageHandler_OnModulesLoadedWithData_ParamsSpec.$, null, [
            moduleIds
        ], false);
    }
    onModuleUsed(moduleId) {
        this.proxy.sendMessage(12, PageHandler_OnModuleUsed_ParamsSpec.$, null, [
            moduleId
        ], false);
    }
    getModulesIdNames() {
        return this.proxy.sendMessage(13, PageHandler_GetModulesIdNames_ParamsSpec.$, PageHandler_GetModulesIdNames_ResponseParamsSpec.$, [], false);
    }
    setModulesOrder(moduleIds) {
        this.proxy.sendMessage(14, PageHandler_SetModulesOrder_ParamsSpec.$, null, [
            moduleIds
        ], false);
    }
    getModulesOrder() {
        return this.proxy.sendMessage(15, PageHandler_GetModulesOrder_ParamsSpec.$, PageHandler_GetModulesOrder_ResponseParamsSpec.$, [], false);
    }
    updateModulesLoadable() {
        this.proxy.sendMessage(16, PageHandler_UpdateModulesLoadable_ParamsSpec.$, null, [], false);
    }
    updateActionChipsVisibility() {
        this.proxy.sendMessage(17, PageHandler_UpdateActionChipsVisibility_ParamsSpec.$, null, [], false);
    }
    updateFooterVisibility() {
        this.proxy.sendMessage(18, PageHandler_UpdateFooterVisibility_ParamsSpec.$, null, [], false);
    }
    maybeShowFeaturePromo(iphFeature) {
        this.proxy.sendMessage(19, PageHandler_MaybeShowFeaturePromo_ParamsSpec.$, null, [
            iphFeature
        ], false);
    }
    incrementComposeButtonShownCount() {
        this.proxy.sendMessage(20, PageHandler_IncrementComposeButtonShownCount_ParamsSpec.$, null, [], false);
    }
    maybeTriggerAutomaticCustomizeChromePromo() {
        this.proxy.sendMessage(21, PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_ParamsSpec.$, null, [], false);
    }
    onOneGoogleBarRendered(time) {
        this.proxy.sendMessage(22, PageHandler_OnOneGoogleBarRendered_ParamsSpec.$, null, [
            time
        ], false);
    }
    onPromoRendered(time, logUrl) {
        this.proxy.sendMessage(23, PageHandler_OnPromoRendered_ParamsSpec.$, null, [
            time,
            logUrl
        ], false);
    }
    onCustomizeDialogAction(action) {
        this.proxy.sendMessage(24, PageHandler_OnCustomizeDialogAction_ParamsSpec.$, null, [
            action
        ], false);
    }
    onDoodleImageClicked(type, logUrl) {
        this.proxy.sendMessage(25, PageHandler_OnDoodleImageClicked_ParamsSpec.$, null, [
            type,
            logUrl
        ], false);
    }
    onDoodleImageRendered(type, time, logUrl) {
        return this.proxy.sendMessage(26, PageHandler_OnDoodleImageRendered_ParamsSpec.$, PageHandler_OnDoodleImageRendered_ResponseParamsSpec.$, [
            type,
            time,
            logUrl
        ], false);
    }
    onDoodleShared(channel, doodleId, shareId) {
        this.proxy.sendMessage(27, PageHandler_OnDoodleShared_ParamsSpec.$, null, [
            channel,
            doodleId,
            shareId
        ], false);
    }
    onPromoLinkClicked() {
        this.proxy.sendMessage(28, PageHandler_OnPromoLinkClicked_ParamsSpec.$, null, [], false);
    }
    onAppRendered(time) {
        this.proxy.sendMessage(29, PageHandler_OnAppRendered_ParamsSpec.$, null, [
            time
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_SetMostVisitedSettings_ParamsSpec.$, null, impl.setMostVisitedSettings.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_GetMostVisitedSettings_ParamsSpec.$, PageHandler_GetMostVisitedSettings_ResponseParamsSpec.$, impl.getMostVisitedSettings.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_GetDoodle_ParamsSpec.$, PageHandler_GetDoodle_ResponseParamsSpec.$, impl.getDoodle.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_UpdatePromoData_ParamsSpec.$, null, impl.updatePromoData.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_BlocklistPromo_ParamsSpec.$, null, impl.blocklistPromo.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_UndoBlocklistPromo_ParamsSpec.$, null, impl.undoBlocklistPromo.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_OnDismissModule_ParamsSpec.$, null, impl.onDismissModule.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_OnRestoreModule_ParamsSpec.$, null, impl.onRestoreModule.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_SetModulesVisible_ParamsSpec.$, null, impl.setModulesVisible.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_SetModuleDisabled_ParamsSpec.$, null, impl.setModuleDisabled.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_UpdateDisabledModules_ParamsSpec.$, null, impl.updateDisabledModules.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_OnModulesLoadedWithData_ParamsSpec.$, null, impl.onModulesLoadedWithData.bind(impl), false);
        this.helper_internal_.registerHandler(12, PageHandler_OnModuleUsed_ParamsSpec.$, null, impl.onModuleUsed.bind(impl), false);
        this.helper_internal_.registerHandler(13, PageHandler_GetModulesIdNames_ParamsSpec.$, PageHandler_GetModulesIdNames_ResponseParamsSpec.$, impl.getModulesIdNames.bind(impl), false);
        this.helper_internal_.registerHandler(14, PageHandler_SetModulesOrder_ParamsSpec.$, null, impl.setModulesOrder.bind(impl), false);
        this.helper_internal_.registerHandler(15, PageHandler_GetModulesOrder_ParamsSpec.$, PageHandler_GetModulesOrder_ResponseParamsSpec.$, impl.getModulesOrder.bind(impl), false);
        this.helper_internal_.registerHandler(16, PageHandler_UpdateModulesLoadable_ParamsSpec.$, null, impl.updateModulesLoadable.bind(impl), false);
        this.helper_internal_.registerHandler(17, PageHandler_UpdateActionChipsVisibility_ParamsSpec.$, null, impl.updateActionChipsVisibility.bind(impl), false);
        this.helper_internal_.registerHandler(18, PageHandler_UpdateFooterVisibility_ParamsSpec.$, null, impl.updateFooterVisibility.bind(impl), false);
        this.helper_internal_.registerHandler(19, PageHandler_MaybeShowFeaturePromo_ParamsSpec.$, null, impl.maybeShowFeaturePromo.bind(impl), false);
        this.helper_internal_.registerHandler(20, PageHandler_IncrementComposeButtonShownCount_ParamsSpec.$, null, impl.incrementComposeButtonShownCount.bind(impl), false);
        this.helper_internal_.registerHandler(21, PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_ParamsSpec.$, null, impl.maybeTriggerAutomaticCustomizeChromePromo.bind(impl), false);
        this.helper_internal_.registerHandler(22, PageHandler_OnOneGoogleBarRendered_ParamsSpec.$, null, impl.onOneGoogleBarRendered.bind(impl), false);
        this.helper_internal_.registerHandler(23, PageHandler_OnPromoRendered_ParamsSpec.$, null, impl.onPromoRendered.bind(impl), false);
        this.helper_internal_.registerHandler(24, PageHandler_OnCustomizeDialogAction_ParamsSpec.$, null, impl.onCustomizeDialogAction.bind(impl), false);
        this.helper_internal_.registerHandler(25, PageHandler_OnDoodleImageClicked_ParamsSpec.$, null, impl.onDoodleImageClicked.bind(impl), false);
        this.helper_internal_.registerHandler(26, PageHandler_OnDoodleImageRendered_ParamsSpec.$, PageHandler_OnDoodleImageRendered_ResponseParamsSpec.$, impl.onDoodleImageRendered.bind(impl), false);
        this.helper_internal_.registerHandler(27, PageHandler_OnDoodleShared_ParamsSpec.$, null, impl.onDoodleShared.bind(impl), false);
        this.helper_internal_.registerHandler(28, PageHandler_OnPromoLinkClicked_ParamsSpec.$, null, impl.onPromoLinkClicked.bind(impl), false);
        this.helper_internal_.registerHandler(29, PageHandler_OnAppRendered_ParamsSpec.$, null, impl.onAppRendered.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "new_tab_page.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    setMostVisitedSettings;
    getMostVisitedSettings;
    getDoodle;
    updatePromoData;
    blocklistPromo;
    undoBlocklistPromo;
    onDismissModule;
    onRestoreModule;
    setModulesVisible;
    setModuleDisabled;
    updateDisabledModules;
    onModulesLoadedWithData;
    onModuleUsed;
    getModulesIdNames;
    setModulesOrder;
    getModulesOrder;
    updateModulesLoadable;
    updateActionChipsVisibility;
    updateFooterVisibility;
    maybeShowFeaturePromo;
    incrementComposeButtonShownCount;
    maybeTriggerAutomaticCustomizeChromePromo;
    onOneGoogleBarRendered;
    onPromoRendered;
    onCustomizeDialogAction;
    onDoodleImageClicked;
    onDoodleImageRendered;
    onDoodleShared;
    onPromoLinkClicked;
    onAppRendered;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setMostVisitedSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_SetMostVisitedSettings_ParamsSpec.$, null, this.setMostVisitedSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.getMostVisitedSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_GetMostVisitedSettings_ParamsSpec.$, PageHandler_GetMostVisitedSettings_ResponseParamsSpec.$, this.getMostVisitedSettings.createReceiverHandler(true /* expectsResponse */), false);
        this.getDoodle =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_GetDoodle_ParamsSpec.$, PageHandler_GetDoodle_ResponseParamsSpec.$, this.getDoodle.createReceiverHandler(true /* expectsResponse */), false);
        this.updatePromoData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_UpdatePromoData_ParamsSpec.$, null, this.updatePromoData.createReceiverHandler(false /* expectsResponse */), false);
        this.blocklistPromo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_BlocklistPromo_ParamsSpec.$, null, this.blocklistPromo.createReceiverHandler(false /* expectsResponse */), false);
        this.undoBlocklistPromo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_UndoBlocklistPromo_ParamsSpec.$, null, this.undoBlocklistPromo.createReceiverHandler(false /* expectsResponse */), false);
        this.onDismissModule =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_OnDismissModule_ParamsSpec.$, null, this.onDismissModule.createReceiverHandler(false /* expectsResponse */), false);
        this.onRestoreModule =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_OnRestoreModule_ParamsSpec.$, null, this.onRestoreModule.createReceiverHandler(false /* expectsResponse */), false);
        this.setModulesVisible =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_SetModulesVisible_ParamsSpec.$, null, this.setModulesVisible.createReceiverHandler(false /* expectsResponse */), false);
        this.setModuleDisabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_SetModuleDisabled_ParamsSpec.$, null, this.setModuleDisabled.createReceiverHandler(false /* expectsResponse */), false);
        this.updateDisabledModules =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_UpdateDisabledModules_ParamsSpec.$, null, this.updateDisabledModules.createReceiverHandler(false /* expectsResponse */), false);
        this.onModulesLoadedWithData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_OnModulesLoadedWithData_ParamsSpec.$, null, this.onModulesLoadedWithData.createReceiverHandler(false /* expectsResponse */), false);
        this.onModuleUsed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, PageHandler_OnModuleUsed_ParamsSpec.$, null, this.onModuleUsed.createReceiverHandler(false /* expectsResponse */), false);
        this.getModulesIdNames =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, PageHandler_GetModulesIdNames_ParamsSpec.$, PageHandler_GetModulesIdNames_ResponseParamsSpec.$, this.getModulesIdNames.createReceiverHandler(true /* expectsResponse */), false);
        this.setModulesOrder =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, PageHandler_SetModulesOrder_ParamsSpec.$, null, this.setModulesOrder.createReceiverHandler(false /* expectsResponse */), false);
        this.getModulesOrder =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, PageHandler_GetModulesOrder_ParamsSpec.$, PageHandler_GetModulesOrder_ResponseParamsSpec.$, this.getModulesOrder.createReceiverHandler(true /* expectsResponse */), false);
        this.updateModulesLoadable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, PageHandler_UpdateModulesLoadable_ParamsSpec.$, null, this.updateModulesLoadable.createReceiverHandler(false /* expectsResponse */), false);
        this.updateActionChipsVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, PageHandler_UpdateActionChipsVisibility_ParamsSpec.$, null, this.updateActionChipsVisibility.createReceiverHandler(false /* expectsResponse */), false);
        this.updateFooterVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, PageHandler_UpdateFooterVisibility_ParamsSpec.$, null, this.updateFooterVisibility.createReceiverHandler(false /* expectsResponse */), false);
        this.maybeShowFeaturePromo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, PageHandler_MaybeShowFeaturePromo_ParamsSpec.$, null, this.maybeShowFeaturePromo.createReceiverHandler(false /* expectsResponse */), false);
        this.incrementComposeButtonShownCount =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, PageHandler_IncrementComposeButtonShownCount_ParamsSpec.$, null, this.incrementComposeButtonShownCount.createReceiverHandler(false /* expectsResponse */), false);
        this.maybeTriggerAutomaticCustomizeChromePromo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_ParamsSpec.$, null, this.maybeTriggerAutomaticCustomizeChromePromo.createReceiverHandler(false /* expectsResponse */), false);
        this.onOneGoogleBarRendered =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, PageHandler_OnOneGoogleBarRendered_ParamsSpec.$, null, this.onOneGoogleBarRendered.createReceiverHandler(false /* expectsResponse */), false);
        this.onPromoRendered =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, PageHandler_OnPromoRendered_ParamsSpec.$, null, this.onPromoRendered.createReceiverHandler(false /* expectsResponse */), false);
        this.onCustomizeDialogAction =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(24, PageHandler_OnCustomizeDialogAction_ParamsSpec.$, null, this.onCustomizeDialogAction.createReceiverHandler(false /* expectsResponse */), false);
        this.onDoodleImageClicked =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(25, PageHandler_OnDoodleImageClicked_ParamsSpec.$, null, this.onDoodleImageClicked.createReceiverHandler(false /* expectsResponse */), false);
        this.onDoodleImageRendered =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(26, PageHandler_OnDoodleImageRendered_ParamsSpec.$, PageHandler_OnDoodleImageRendered_ResponseParamsSpec.$, this.onDoodleImageRendered.createReceiverHandler(true /* expectsResponse */), false);
        this.onDoodleShared =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(27, PageHandler_OnDoodleShared_ParamsSpec.$, null, this.onDoodleShared.createReceiverHandler(false /* expectsResponse */), false);
        this.onPromoLinkClicked =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(28, PageHandler_OnPromoLinkClicked_ParamsSpec.$, null, this.onPromoLinkClicked.createReceiverHandler(false /* expectsResponse */), false);
        this.onAppRendered =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(29, PageHandler_OnAppRendered_ParamsSpec.$, null, this.onAppRendered.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'new_tab_page.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setTheme(theme) {
        this.proxy.sendMessage(0, Page_SetTheme_ParamsSpec.$, null, [
            theme
        ], false);
    }
    setDisabledModules(all, ids) {
        this.proxy.sendMessage(1, Page_SetDisabledModules_ParamsSpec.$, null, [
            all,
            ids
        ], false);
    }
    setModulesLoadable() {
        this.proxy.sendMessage(2, Page_SetModulesLoadable_ParamsSpec.$, null, [], false);
    }
    setActionChipsVisibility(visible) {
        this.proxy.sendMessage(3, Page_SetActionChipsVisibility_ParamsSpec.$, null, [
            visible
        ], false);
    }
    setPromo(promo) {
        this.proxy.sendMessage(4, Page_SetPromo_ParamsSpec.$, null, [
            promo
        ], false);
    }
    showWebstoreToast() {
        this.proxy.sendMessage(5, Page_ShowWebstoreToast_ParamsSpec.$, null, [], false);
    }
    setWallpaperSearchButtonVisibility(visible) {
        this.proxy.sendMessage(6, Page_SetWallpaperSearchButtonVisibility_ParamsSpec.$, null, [
            visible
        ], false);
    }
    footerVisibilityUpdated(visible) {
        this.proxy.sendMessage(7, Page_FooterVisibilityUpdated_ParamsSpec.$, null, [
            visible
        ], false);
    }
    connectToParentDocument(childUntrustedDocumentRemote) {
        this.proxy.sendMessage(8, Page_ConnectToParentDocument_ParamsSpec.$, null, [
            childUntrustedDocumentRemote
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_SetTheme_ParamsSpec.$, null, impl.setTheme.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_SetDisabledModules_ParamsSpec.$, null, impl.setDisabledModules.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_SetModulesLoadable_ParamsSpec.$, null, impl.setModulesLoadable.bind(impl), false);
        this.helper_internal_.registerHandler(3, Page_SetActionChipsVisibility_ParamsSpec.$, null, impl.setActionChipsVisibility.bind(impl), false);
        this.helper_internal_.registerHandler(4, Page_SetPromo_ParamsSpec.$, null, impl.setPromo.bind(impl), false);
        this.helper_internal_.registerHandler(5, Page_ShowWebstoreToast_ParamsSpec.$, null, impl.showWebstoreToast.bind(impl), false);
        this.helper_internal_.registerHandler(6, Page_SetWallpaperSearchButtonVisibility_ParamsSpec.$, null, impl.setWallpaperSearchButtonVisibility.bind(impl), false);
        this.helper_internal_.registerHandler(7, Page_FooterVisibilityUpdated_ParamsSpec.$, null, impl.footerVisibilityUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(8, Page_ConnectToParentDocument_ParamsSpec.$, null, impl.connectToParentDocument.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "new_tab_page.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    setTheme;
    setDisabledModules;
    setModulesLoadable;
    setActionChipsVisibility;
    setPromo;
    showWebstoreToast;
    setWallpaperSearchButtonVisibility;
    footerVisibilityUpdated;
    connectToParentDocument;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setTheme =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_SetTheme_ParamsSpec.$, null, this.setTheme.createReceiverHandler(false /* expectsResponse */), false);
        this.setDisabledModules =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_SetDisabledModules_ParamsSpec.$, null, this.setDisabledModules.createReceiverHandler(false /* expectsResponse */), false);
        this.setModulesLoadable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_SetModulesLoadable_ParamsSpec.$, null, this.setModulesLoadable.createReceiverHandler(false /* expectsResponse */), false);
        this.setActionChipsVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Page_SetActionChipsVisibility_ParamsSpec.$, null, this.setActionChipsVisibility.createReceiverHandler(false /* expectsResponse */), false);
        this.setPromo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Page_SetPromo_ParamsSpec.$, null, this.setPromo.createReceiverHandler(false /* expectsResponse */), false);
        this.showWebstoreToast =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, Page_ShowWebstoreToast_ParamsSpec.$, null, this.showWebstoreToast.createReceiverHandler(false /* expectsResponse */), false);
        this.setWallpaperSearchButtonVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, Page_SetWallpaperSearchButtonVisibility_ParamsSpec.$, null, this.setWallpaperSearchButtonVisibility.createReceiverHandler(false /* expectsResponse */), false);
        this.footerVisibilityUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, Page_FooterVisibilityUpdated_ParamsSpec.$, null, this.footerVisibilityUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.connectToParentDocument =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, Page_ConnectToParentDocument_ParamsSpec.$, null, this.connectToParentDocument.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const BackgroundImageSpec = { $: {} };
export const ThemeSpec = { $: {} };
export const ImageDoodleSpec = { $: {} };
export const AllModeImageDoodleSpec = { $: {} };
export const InteractiveDoodleSpec = { $: {} };
export const DoodleSpec = { $: {} };
export const PromoImagePartSpec = { $: {} };
export const PromoLinkPartSpec = { $: {} };
export const PromoTextPartSpec = { $: {} };
export const PromoSpec = { $: {} };
export const ModuleIdNameSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_SetMostVisitedSettings_ParamsSpec = { $: {} };
export const PageHandler_GetMostVisitedSettings_ParamsSpec = { $: {} };
export const PageHandler_GetMostVisitedSettings_ResponseParamsSpec = { $: {} };
export const PageHandler_GetDoodle_ParamsSpec = { $: {} };
export const PageHandler_GetDoodle_ResponseParamsSpec = { $: {} };
export const PageHandler_UpdatePromoData_ParamsSpec = { $: {} };
export const PageHandler_BlocklistPromo_ParamsSpec = { $: {} };
export const PageHandler_UndoBlocklistPromo_ParamsSpec = { $: {} };
export const PageHandler_OnDismissModule_ParamsSpec = { $: {} };
export const PageHandler_OnRestoreModule_ParamsSpec = { $: {} };
export const PageHandler_SetModulesVisible_ParamsSpec = { $: {} };
export const PageHandler_SetModuleDisabled_ParamsSpec = { $: {} };
export const PageHandler_UpdateDisabledModules_ParamsSpec = { $: {} };
export const PageHandler_OnModulesLoadedWithData_ParamsSpec = { $: {} };
export const PageHandler_OnModuleUsed_ParamsSpec = { $: {} };
export const PageHandler_GetModulesIdNames_ParamsSpec = { $: {} };
export const PageHandler_GetModulesIdNames_ResponseParamsSpec = { $: {} };
export const PageHandler_SetModulesOrder_ParamsSpec = { $: {} };
export const PageHandler_GetModulesOrder_ParamsSpec = { $: {} };
export const PageHandler_GetModulesOrder_ResponseParamsSpec = { $: {} };
export const PageHandler_UpdateModulesLoadable_ParamsSpec = { $: {} };
export const PageHandler_UpdateActionChipsVisibility_ParamsSpec = { $: {} };
export const PageHandler_UpdateFooterVisibility_ParamsSpec = { $: {} };
export const PageHandler_MaybeShowFeaturePromo_ParamsSpec = { $: {} };
export const PageHandler_IncrementComposeButtonShownCount_ParamsSpec = { $: {} };
export const PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_ParamsSpec = { $: {} };
export const PageHandler_OnOneGoogleBarRendered_ParamsSpec = { $: {} };
export const PageHandler_OnPromoRendered_ParamsSpec = { $: {} };
export const PageHandler_OnCustomizeDialogAction_ParamsSpec = { $: {} };
export const PageHandler_OnDoodleImageClicked_ParamsSpec = { $: {} };
export const PageHandler_OnDoodleImageRendered_ParamsSpec = { $: {} };
export const PageHandler_OnDoodleImageRendered_ResponseParamsSpec = { $: {} };
export const PageHandler_OnDoodleShared_ParamsSpec = { $: {} };
export const PageHandler_OnPromoLinkClicked_ParamsSpec = { $: {} };
export const PageHandler_OnAppRendered_ParamsSpec = { $: {} };
export const Page_SetTheme_ParamsSpec = { $: {} };
export const Page_SetDisabledModules_ParamsSpec = { $: {} };
export const Page_SetModulesLoadable_ParamsSpec = { $: {} };
export const Page_SetActionChipsVisibility_ParamsSpec = { $: {} };
export const Page_SetPromo_ParamsSpec = { $: {} };
export const Page_ShowWebstoreToast_ParamsSpec = { $: {} };
export const Page_SetWallpaperSearchButtonVisibility_ParamsSpec = { $: {} };
export const Page_FooterVisibilityUpdated_ParamsSpec = { $: {} };
export const Page_ConnectToParentDocument_ParamsSpec = { $: {} };
export const PromoPartSpec = { $: {} };
mojo.internal.Struct(BackgroundImageSpec.$, 'BackgroundImage', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url2x', 8, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('attributionUrl', 16, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('size', 24, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('repeatX', 32, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('repeatY', 40, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('positionX', 48, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('positionY', 56, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('imageSource', 64, 0, NtpBackgroundImageSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 80],]);
mojo.internal.Struct(ThemeSpec.$, 'Theme', [
    mojo.internal.StructField('textColor', 0, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backgroundColor', 8, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isBaseline', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isCustomBackground', 16, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dailyRefreshEnabled', 16, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isDark', 16, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('logoColor', 24, 0, skia_mojom_SkColorSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backgroundImageCollectionId', 32, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backgroundImage', 40, 0, BackgroundImageSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backgroundImageAttribution1', 48, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backgroundImageAttribution2', 56, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backgroundImageAttributionUrl', 64, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mostVisited', 72, 0, mostVisited_mojom_MostVisitedThemeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 88],]);
mojo.internal.Struct(ImageDoodleSpec.$, 'ImageDoodle', [
    mojo.internal.StructField('imageUrl', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('animationUrl', 8, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('width', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 20, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backgroundColor', 24, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('imageImpressionLogUrl', 32, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('animationImpressionLogUrl', 40, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(AllModeImageDoodleSpec.$, 'AllModeImageDoodle', [
    mojo.internal.StructField('light', 0, 0, ImageDoodleSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dark', 8, 0, ImageDoodleSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('onClickUrl', 16, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shareUrl', 24, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(InteractiveDoodleSpec.$, 'InteractiveDoodle', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('width', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DoodleSpec.$, 'Doodle', [
    mojo.internal.StructField('image', 0, 0, AllModeImageDoodleSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('interactive', 8, 0, InteractiveDoodleSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('description', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PromoImagePartSpec.$, 'PromoImagePart', [
    mojo.internal.StructField('imageUrl', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('target', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PromoLinkPartSpec.$, 'PromoLinkPart', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PromoTextPartSpec.$, 'PromoTextPart', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PromoSpec.$, 'Promo', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('logUrl', 8, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('middleSlotParts', 16, 0, mojo.internal.Array(PromoPartSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(ModuleIdNameSpec.$, 'ModuleIdName', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_SetMostVisitedSettings_ParamsSpec.$, 'PageHandler_SetMostVisitedSettings_Params', [
    mojo.internal.StructField('shortcutsType', 0, 0, ntpTiles_mojom_TileTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shortcutsVisible', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetMostVisitedSettings_ParamsSpec.$, 'PageHandler_GetMostVisitedSettings_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetMostVisitedSettings_ResponseParamsSpec.$, 'PageHandler_GetMostVisitedSettings_ResponseParams', [
    mojo.internal.StructField('shortcutsType', 0, 0, ntpTiles_mojom_TileTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shortcutsVisible', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetDoodle_ParamsSpec.$, 'PageHandler_GetDoodle_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetDoodle_ResponseParamsSpec.$, 'PageHandler_GetDoodle_ResponseParams', [
    mojo.internal.StructField('doodle', 0, 0, DoodleSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_UpdatePromoData_ParamsSpec.$, 'PageHandler_UpdatePromoData_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_BlocklistPromo_ParamsSpec.$, 'PageHandler_BlocklistPromo_Params', [
    mojo.internal.StructField('promoId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_UndoBlocklistPromo_ParamsSpec.$, 'PageHandler_UndoBlocklistPromo_Params', [
    mojo.internal.StructField('promoId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OnDismissModule_ParamsSpec.$, 'PageHandler_OnDismissModule_Params', [
    mojo.internal.StructField('moduleId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OnRestoreModule_ParamsSpec.$, 'PageHandler_OnRestoreModule_Params', [
    mojo.internal.StructField('moduleId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetModulesVisible_ParamsSpec.$, 'PageHandler_SetModulesVisible_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetModuleDisabled_ParamsSpec.$, 'PageHandler_SetModuleDisabled_Params', [
    mojo.internal.StructField('moduleId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('disabled', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_UpdateDisabledModules_ParamsSpec.$, 'PageHandler_UpdateDisabledModules_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OnModulesLoadedWithData_ParamsSpec.$, 'PageHandler_OnModulesLoadedWithData_Params', [
    mojo.internal.StructField('moduleIds', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OnModuleUsed_ParamsSpec.$, 'PageHandler_OnModuleUsed_Params', [
    mojo.internal.StructField('moduleId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetModulesIdNames_ParamsSpec.$, 'PageHandler_GetModulesIdNames_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetModulesIdNames_ResponseParamsSpec.$, 'PageHandler_GetModulesIdNames_ResponseParams', [
    mojo.internal.StructField('data', 0, 0, mojo.internal.Array(ModuleIdNameSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetModulesOrder_ParamsSpec.$, 'PageHandler_SetModulesOrder_Params', [
    mojo.internal.StructField('moduleIds', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetModulesOrder_ParamsSpec.$, 'PageHandler_GetModulesOrder_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetModulesOrder_ResponseParamsSpec.$, 'PageHandler_GetModulesOrder_ResponseParams', [
    mojo.internal.StructField('moduleIds', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_UpdateModulesLoadable_ParamsSpec.$, 'PageHandler_UpdateModulesLoadable_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_UpdateActionChipsVisibility_ParamsSpec.$, 'PageHandler_UpdateActionChipsVisibility_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_UpdateFooterVisibility_ParamsSpec.$, 'PageHandler_UpdateFooterVisibility_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_MaybeShowFeaturePromo_ParamsSpec.$, 'PageHandler_MaybeShowFeaturePromo_Params', [
    mojo.internal.StructField('iphFeature', 0, 0, IphFeatureSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_IncrementComposeButtonShownCount_ParamsSpec.$, 'PageHandler_IncrementComposeButtonShownCount_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_ParamsSpec.$, 'PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OnOneGoogleBarRendered_ParamsSpec.$, 'PageHandler_OnOneGoogleBarRendered_Params', [
    mojo.internal.StructField('time', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OnPromoRendered_ParamsSpec.$, 'PageHandler_OnPromoRendered_Params', [
    mojo.internal.StructField('time', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('logUrl', 8, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_OnCustomizeDialogAction_ParamsSpec.$, 'PageHandler_OnCustomizeDialogAction_Params', [
    mojo.internal.StructField('action', 0, 0, CustomizeDialogActionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OnDoodleImageClicked_ParamsSpec.$, 'PageHandler_OnDoodleImageClicked_Params', [
    mojo.internal.StructField('type', 0, 0, DoodleImageTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('logUrl', 8, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_OnDoodleImageRendered_ParamsSpec.$, 'PageHandler_OnDoodleImageRendered_Params', [
    mojo.internal.StructField('type', 0, 0, DoodleImageTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('time', 8, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('logUrl', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_OnDoodleImageRendered_ResponseParamsSpec.$, 'PageHandler_OnDoodleImageRendered_ResponseParams', [
    mojo.internal.StructField('imageClickParams', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('interactionLogUrl', 8, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shareId', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_OnDoodleShared_ParamsSpec.$, 'PageHandler_OnDoodleShared_Params', [
    mojo.internal.StructField('channel', 0, 0, DoodleShareChannelSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('doodleId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shareId', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_OnPromoLinkClicked_ParamsSpec.$, 'PageHandler_OnPromoLinkClicked_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OnAppRendered_ParamsSpec.$, 'PageHandler_OnAppRendered_Params', [
    mojo.internal.StructField('time', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_SetTheme_ParamsSpec.$, 'Page_SetTheme_Params', [
    mojo.internal.StructField('theme', 0, 0, ThemeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_SetDisabledModules_ParamsSpec.$, 'Page_SetDisabledModules_Params', [
    mojo.internal.StructField('all', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('ids', 8, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_SetModulesLoadable_ParamsSpec.$, 'Page_SetModulesLoadable_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_SetActionChipsVisibility_ParamsSpec.$, 'Page_SetActionChipsVisibility_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_SetPromo_ParamsSpec.$, 'Page_SetPromo_Params', [
    mojo.internal.StructField('promo', 0, 0, PromoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_ShowWebstoreToast_ParamsSpec.$, 'Page_ShowWebstoreToast_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_SetWallpaperSearchButtonVisibility_ParamsSpec.$, 'Page_SetWallpaperSearchButtonVisibility_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_FooterVisibilityUpdated_ParamsSpec.$, 'Page_FooterVisibilityUpdated_Params', [
    mojo.internal.StructField('visible', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_ConnectToParentDocument_ParamsSpec.$, 'Page_ConnectToParentDocument_Params', [
    mojo.internal.StructField('childUntrustedDocumentRemote', 0, 0, mojo.internal.InterfaceProxy(newTabPage_mojom_MicrosoftAuthUntrustedDocumentRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(PromoPartSpec.$, 'PromoPart', {
    'image': {
        'ordinal': 0,
        'type': PromoImagePartSpec.$,
    },
    'link': {
        'ordinal': 1,
        'type': PromoLinkPartSpec.$,
    },
    'text': {
        'ordinal': 2,
        'type': PromoTextPartSpec.$,
    },
});
export var PromoPartFieldTags;
(function (PromoPartFieldTags) {
    PromoPartFieldTags[PromoPartFieldTags["IMAGE"] = 0] = "IMAGE";
    PromoPartFieldTags[PromoPartFieldTags["LINK"] = 1] = "LINK";
    PromoPartFieldTags[PromoPartFieldTags["TEXT"] = 2] = "TEXT";
})(PromoPartFieldTags || (PromoPartFieldTags = {}));
export function whichPromoPart(u) {
    if (u.image !== null && u.image !== undefined) {
        return PromoPartFieldTags.IMAGE;
    }
    if (u.link !== null && u.link !== undefined) {
        return PromoPartFieldTags.LINK;
    }
    if (u.text !== null && u.text !== undefined) {
        return PromoPartFieldTags.TEXT;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
