import { ComposeboxMode } from 'chrome://resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { ChipType } from '../action_chips.mojom-webui.js';
import { getCss } from './action_chips.css.js';
import { getHtml } from './action_chips.html.js';
import { ActionChipsApiProxyImpl } from './action_chips_proxy.js';
var ActionChipsConstants;
(function (ActionChipsConstants) {
    ActionChipsConstants.EMPTY_QUERY_STRING = '';
})(ActionChipsConstants || (ActionChipsConstants = {})); // namespace
// Records a click metric for the given action chip type.
function recordClick(chipType) {
    chrome.metricsPrivate.recordEnumerationValue('NewTabPage.ActionChips.Click', chipType, ChipType.MAX_VALUE + 1);
}
/**
 * The element for displaying Action Chips.
 */
export class ActionChipsElement extends CrLitElement {
    static get is() {
        return 'ntp-action-chips';
    }
    static get styles() {
        return getCss();
    }
    static get properties() {
        return {
            actionChips_: { type: Array, state: true },
        };
    }
    handler;
    callbackRouter;
    #actionChips__accessor_storage = [];
    get actionChips_() { return this.#actionChips__accessor_storage; }
    set actionChips_(value) { this.#actionChips__accessor_storage = value; }
    onActionChipChangedListenerId_ = null;
    delayTabUploads_ = loadTimeData.getBoolean('addTabUploadDelayOnActionChipClick');
    render() {
        return getHtml.bind(this)();
    }
    getAdditionalIconClasses_(chip) {
        switch (chip.type) {
            case ChipType.kImage:
                return 'banana';
            case ChipType.kDeepSearch:
                return 'deep-search';
            default:
                return '';
        }
    }
    getId(chip) {
        switch (chip.type) {
            case ChipType.kImage:
                return 'nano-banana';
            case ChipType.kDeepSearch:
                return 'deep-search';
            case ChipType.kRecentTab:
                return 'tab-context';
            default:
                return null;
        }
    }
    constructor() {
        super();
        const proxy = ActionChipsApiProxyImpl.getInstance();
        this.handler = proxy.getHandler();
        this.callbackRouter = proxy.getCallbackRouter();
    }
    connectedCallback() {
        super.connectedCallback();
        this.onActionChipChangedListenerId_ =
            this.callbackRouter.onActionChipsChanged.addListener((actionChips) => {
                this.actionChips_ = actionChips;
            });
        this.handler.startActionChipsRetrieval();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.callbackRouter.removeListener(this.onActionChipChangedListenerId_);
    }
    onCreateImageClick_() {
        recordClick(ChipType.kImage);
        this.onActionChipClick_(ActionChipsConstants.EMPTY_QUERY_STRING, [], ComposeboxMode.CREATE_IMAGE);
    }
    onDeepSearchClick_() {
        recordClick(ChipType.kDeepSearch);
        this.onActionChipClick_(ActionChipsConstants.EMPTY_QUERY_STRING, [], ComposeboxMode.DEEP_SEARCH);
    }
    onTabContextClick_(tab) {
        recordClick(ChipType.kRecentTab);
        const recentTabInfo = {
            tabId: tab.tabId,
            url: tab.url,
            title: tab.title,
            delayUpload: this.delayTabUploads_,
        };
        this.onActionChipClick_(ActionChipsConstants.EMPTY_QUERY_STRING, [recentTabInfo], ComposeboxMode.DEFAULT);
    }
    handleClick_(chip) {
        switch (chip.type) {
            case ChipType.kImage:
                this.onCreateImageClick_();
                break;
            case ChipType.kDeepSearch:
                this.onDeepSearchClick_();
                break;
            case ChipType.kRecentTab:
                this.onTabContextClick_(chip.tab);
                break;
            default:
            // Do nothing yet...
        }
    }
    getFaviconUrl_(url) {
        const faviconUrl = new URL('chrome://favicon2/');
        faviconUrl.searchParams.set('size', '24');
        faviconUrl.searchParams.set('scaleFactor', '1x');
        faviconUrl.searchParams.set('showFallbackMonogram', '');
        faviconUrl.searchParams.set('pageUrl', url);
        return faviconUrl.href;
    }
    getMostRecentTabFaviconUrl_(chip) {
        return chip.tab ? this.getFaviconUrl_(chip.tab.url.url) : '';
    }
    onActionChipClick_(query, contextFiles, mode) {
        this.fire('action-chip-click', { searchboxText: query, contextFiles, mode });
    }
}
customElements.define(ActionChipsElement.is, ActionChipsElement);
