import {html} from '//resources/lit/v3_0/lit.rollup.js';
import type {VoiceSearchOverlayElement} from './voice_search_overlay.js';

export function getHtml(this: VoiceSearchOverlayElement) {
  return html`<!--_html_template_start_--><dialog id="dialog" @close="${this.onOverlayClose_}"
    @click="${this.onOverlayClick_}" @keydown="${this.onOverlayKeydown_}">
  <div id="content" tabindex="-1">
    <cr-page-selector id="texts" selected="${this.getText_()}" show-all
        attr-for-selected="text" fallback-selection="none" aria-live="polite"
        selected-attribute="visible" class="display-stack">
      <div text="none"></div>
      <div text="waiting">$i18n{waiting}</div>
      <div text="speak" class="display-stack">
        <div id="speak">$i18n{speak}</div>
        <div id="listening">$i18n{listening}</div>
      </div>
      <div text="result" aria-hidden="true">
        <span id="finalResult">${this.finalResult_}</span>
        <span>${this.interimResult_}</span>
      </div>
      <div text="error">
        <cr-page-selector id="errors" selected="${this.getErrorText_()}"
            attr-for-selected="error">
          <span error="no-speech">$i18n{noVoice}</span>
          <span error="audio-capture">$i18n{audioError}</span>
          <span error="network">$i18n{networkError}</span>
          <span error="not-allowed">$i18n{permissionError}</span>
          <span error="language-not-supported">$i18n{languageError}</span>
          <span error="no-match">$i18n{noTranslation}</span>
          <span error="other">$i18n{otherError}</span>
        </cr-page-selector>
        <cr-page-selector id="errorLinks" selected="${this.getErrorLink_()}"
            attr-for-selected="link">
          <span link="none"></span>
          <a link="learn-more" target="_blank" href="${this.helpUrl_}"
              @click="${this.onLearnMoreClick_}"
              @keydown="${this.onLinkKeydown_}"
              aria-label="$i18nPolymer{learnMoreA11yLabel}"><!--
            -->$i18n{learnMore}
          </a>
          <a link="details" target="_blank" href="${this.helpUrl_}"
              @keydown="${this.onLinkKeydown_}"
              aria-label="$i18nPolymer{learnMoreA11yLabel}"><!--
            -->$i18n{details}
          </a>
          <a link="try-again" id="retryLink" href="#"
              @click="${this.onTryAgainClick_}"
              @keydown="${this.onLinkKeydown_}"><!--
            -->$i18n{tryAgain}
          </a>
        </cr-page-selector>
      </div>
    </cr-page-selector>
    <div id="micContainer" class="${this.getMicClass_()} display-stack">
      <div id="micVolume"
          .style="--mic-volume-level: ${this.micVolumeLevel_};
                --mic-volume-duration: ${this.micVolumeDuration_}ms;">
        <div id="micVolumeCutout">
        </div>
      </div>
      <div id="micIconContainer">
        <div id="micIcon"></div>
      </div>
    </div>
  </div>
  <cr-icon-button id="closeButton" class="icon-clear" title="$i18n{close}">
  </cr-icon-button>
</dialog>
<!--_html_template_end_-->`;
}