// chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ColorSpec as tabGroups_mojom_ColorSpec,
  Color as tabGroups_mojom_Color
} from './tab_group_types.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'ntp.tab_groups.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  createNewTabGroup(): void;
  getTabGroups(): Promise<{
        tabGroups: (TabGroup[] | null),
        showZeroState: boolean, }>;
  openTabGroup(id: string): void;
  dismissModule(): void;
  restoreModule(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createNewTabGroup(): void {
    this.proxy.sendMessage(
        0,
        PageHandler_CreateNewTabGroup_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getTabGroups(): Promise<{
        tabGroups: (TabGroup[] | null),
        showZeroState: boolean, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_GetTabGroups_ParamsSpec.$,
        PageHandler_GetTabGroups_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  openTabGroup(
      id: string): void {
    this.proxy.sendMessage(
        2,
        PageHandler_OpenTabGroup_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  dismissModule(): void {
    this.proxy.sendMessage(
        3,
        PageHandler_DismissModule_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  restoreModule(): void {
    this.proxy.sendMessage(
        4,
        PageHandler_RestoreModule_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_CreateNewTabGroup_ParamsSpec.$,
        null,
        impl.createNewTabGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetTabGroups_ParamsSpec.$,
        PageHandler_GetTabGroups_ResponseParamsSpec.$,
        impl.getTabGroups.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_OpenTabGroup_ParamsSpec.$,
        null,
        impl.openTabGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_DismissModule_ParamsSpec.$,
        null,
        impl.dismissModule.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_RestoreModule_ParamsSpec.$,
        null,
        impl.restoreModule.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "ntp.tab_groups.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createNewTabGroup: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTabGroups: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openTabGroup: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  dismissModule: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  restoreModule: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createNewTabGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_CreateNewTabGroup_ParamsSpec.$,
        null,
        this.createNewTabGroup.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getTabGroups =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetTabGroups_ParamsSpec.$,
        PageHandler_GetTabGroups_ResponseParamsSpec.$,
        this.getTabGroups.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openTabGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_OpenTabGroup_ParamsSpec.$,
        null,
        this.openTabGroup.createReceiverHandler(false /* expectsResponse */),
        false);
    this.dismissModule =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_DismissModule_ParamsSpec.$,
        null,
        this.dismissModule.createReceiverHandler(false /* expectsResponse */),
        false);
    this.restoreModule =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_RestoreModule_ParamsSpec.$,
        null,
        this.restoreModule.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const TabGroupSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CreateNewTabGroup_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabGroups_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabGroups_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenTabGroup_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DismissModule_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RestoreModule_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface TabGroupMojoType {
  id: string;
  title: string;
  updateTime: string;
  deviceName: (string | null);
  totalTabCount: number;
  color: tabGroups_mojom_Color;
  faviconUrls: url_mojom_Url[];
  isSharedTabGroup: boolean;
}


export type TabGroup = TabGroupMojoType;
mojo.internal.Struct<TabGroupMojoType>(
    TabGroupSpec.$,
    'TabGroup',
    [
      mojo.internal.StructField<TabGroupMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, string>(
        'updateTime', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, string>(
        'deviceName', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, number>(
        'totalTabCount', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, tabGroups_mojom_Color>(
        'color', 36,
        0,
        tabGroups_mojom_ColorSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, url_mojom_Url[]>(
        'faviconUrls', 40,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, boolean>(
        'isSharedTabGroup', 48,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface PageHandler_CreateNewTabGroup_ParamsMojoType {
}


export type PageHandler_CreateNewTabGroup_Params = PageHandler_CreateNewTabGroup_ParamsMojoType;
mojo.internal.Struct<PageHandler_CreateNewTabGroup_ParamsMojoType>(
    PageHandler_CreateNewTabGroup_ParamsSpec.$,
    'PageHandler_CreateNewTabGroup_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetTabGroups_ParamsMojoType {
}


export type PageHandler_GetTabGroups_Params = PageHandler_GetTabGroups_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabGroups_ParamsMojoType>(
    PageHandler_GetTabGroups_ParamsSpec.$,
    'PageHandler_GetTabGroups_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetTabGroups_ResponseParamsMojoType {
  tabGroups: (TabGroup[] | null);
  showZeroState: boolean;
}


export type PageHandler_GetTabGroups_ResponseParams = PageHandler_GetTabGroups_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabGroups_ResponseParamsMojoType>(
    PageHandler_GetTabGroups_ResponseParamsSpec.$,
    'PageHandler_GetTabGroups_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTabGroups_ResponseParamsMojoType, TabGroup[]>(
        'tabGroups', 0,
        0,
        mojo.internal.Array(TabGroupSpec.$, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_GetTabGroups_ResponseParamsMojoType, boolean>(
        'showZeroState', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_OpenTabGroup_ParamsMojoType {
  id: string;
}


export type PageHandler_OpenTabGroup_Params = PageHandler_OpenTabGroup_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenTabGroup_ParamsMojoType>(
    PageHandler_OpenTabGroup_ParamsSpec.$,
    'PageHandler_OpenTabGroup_Params',
    [
      mojo.internal.StructField<PageHandler_OpenTabGroup_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DismissModule_ParamsMojoType {
}


export type PageHandler_DismissModule_Params = PageHandler_DismissModule_ParamsMojoType;
mojo.internal.Struct<PageHandler_DismissModule_ParamsMojoType>(
    PageHandler_DismissModule_ParamsSpec.$,
    'PageHandler_DismissModule_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RestoreModule_ParamsMojoType {
}


export type PageHandler_RestoreModule_Params = PageHandler_RestoreModule_ParamsMojoType;
mojo.internal.Struct<PageHandler_RestoreModule_ParamsMojoType>(
    PageHandler_RestoreModule_ParamsSpec.$,
    'PageHandler_RestoreModule_Params',
    [
    ],
    [[0, 8],]);



