// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert,assertNotReached}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{getFallbackTheme,getShaderLayerColorRgbas,modifyRgbaTransparency}from"./color_utils.js";import{CubicBezier}from"./cubic_bezier.js";import{getTemplate}from"./overlay_shimmer_canvas.html.js";import{ShimmerControlRequester}from"./selection_utils.js";import{Wiggle}from"./wiggle.js";const STEADY_STATE_FREQ_VAL=.06;const INTERACTION_STATE_FREQ_VAL=.03;const INVOCATION_OPACITY_PERCENT=0;const INVOCATION_RADIUS_PERCENT=0;const INVOCATION_CENTER_X_PERCENT=50;const INVOCATION_CENTER_Y_PERCENT=0;const INVOCATION_RADIUS_AMPLITUDE_PERCENT=0;const INVOCATION_CENTER_X_AMPLITUDE_PERCENT=0;const INVOCATION_CENTER_Y_AMPLITUDE_PERCENT=0;const STEADY_STATE_OPACITY_PERCENT=.3;const STEADY_STATE_RADIUS_PERCENT=21;const STEADY_STATE_CIRCLE_BLUR=2;const STEADY_STATE_CENTER_X_PERCENT_OFFSET=50;const STEADY_STATE_CENTER_Y_PERCENT_OFFSET=30;const STEADY_STATE_RADIUS_AMPLITUDE_PERCENT=0;const STEADY_STATE_CENTER_X_AMPLITUDE_PERCENT=21;const STEADY_STATE_CENTER_Y_AMPLITUDE_PERCENT=21;const STEADY_STATE_TRANSITION_DURATION=800;const STEADY_STATE_EASING_FUNCTION=new CubicBezier(.05,.7,.1,1);const INTERACTION_STATE_OPACITY_PERCENT=.4;const INTERACTION_STATE_EASING_FUNCTION=new CubicBezier(.2,0,0,1);const CURSOR_STATE_RADIUS_PERCENT=0;const CURSOR_STATE_RADIUS_AMPLITUDE_PERCENT=0;const CURSOR_STATE_CENTER_X_AMPLITUDE_PERCENT=0;const CURSOR_STATE_CENTER_Y_AMPLITUDE_PERCENT=0;const CURSOR_STATE_TRANSITION_DURATION=1e3;const CURSOR_SHRINK_TRANSITION_DURATION=750;const FADE_OUT_STATE_OPACITY_PERCENT=0;const FADE_OUT_TRANSITION_DURATION=100;const FADE_OUT_EASING_FUNCTION=new CubicBezier(0,0,1,1);const REGION_SELECTION_STATE_RADIUS_PERCENT=45;const REGION_SELECTION_STATE_CIRCLE_BLUR=1.8;const REGION_SELECTION_STATE_RADIUS_AMPLITUDE_PERCENT=0;const REGION_SELECTION_STATE_CENTER_X_AMPLITUDE_PERCENT=40;const REGION_SELECTION_STATE_CENTER_Y_AMPLITUDE_PERCENT=40;const REGION_SELECTION_TRANSITION_DURATION=750;const SEGMENTATION_STATE_OPACITY_PERCENT=.3;const SEGMENTATION_STATE_RADIUS_PERCENT=30;const SEGMENTATION_STATE_CIRCLE_BLUR=1.8;const SEGMENTATION_STATE_RADIUS_AMPLITUDE_PERCENT=0;const SEGMENTATION_STATE_CENTER_X_AMPLITUDE_PERCENT=20;const SEGMENTATION_STATE_CENTER_Y_AMPLITUDE_PERCENT=20;const SEGMENTATION_TRANSITION_DURATION=750;const SEARCHBOX_STATE_RADIUS_PERCENT=45;const SEARCHBOX_STATE_CIRCLE_BLUR=2;const SEARCHBOX_STATE_RADIUS_AMPLITUDE_PERCENT=5;const SEARCHBOX_STATE_CENTER_X_AMPLITUDE_PERCENT=40;const SEARCHBOX_STATE_CENTER_Y_AMPLITUDE_PERCENT=40;const SEARCHBOX_TRANSITION_DURATION=750;const SPARKLES_OPACITY=1;var ShimmerState;(function(ShimmerState){ShimmerState[ShimmerState["NONE"]=0]="NONE";ShimmerState[ShimmerState["INVOCATION"]=1]="INVOCATION";ShimmerState[ShimmerState["TRANSITION_TO_STEADY_STATE"]=2]="TRANSITION_TO_STEADY_STATE";ShimmerState[ShimmerState["STEADY_STATE"]=3]="STEADY_STATE";ShimmerState[ShimmerState["TRANSITION_SHRINK_TO_CURSOR"]=4]="TRANSITION_SHRINK_TO_CURSOR";ShimmerState[ShimmerState["CURSOR"]=5]="CURSOR";ShimmerState[ShimmerState["TRANSITION_FADE_IN_TO_REGION"]=6]="TRANSITION_FADE_IN_TO_REGION";ShimmerState[ShimmerState["REGION"]=7]="REGION";ShimmerState[ShimmerState["TRANSITION_FADE_OUT_TO_CURSOR"]=8]="TRANSITION_FADE_OUT_TO_CURSOR";ShimmerState[ShimmerState["TRANSITION_FADE_OUT_TO_REGION"]=9]="TRANSITION_FADE_OUT_TO_REGION";ShimmerState[ShimmerState["TRANSITION_FADE_IN_TO_SEGMENTATION"]=10]="TRANSITION_FADE_IN_TO_SEGMENTATION";ShimmerState[ShimmerState["SEGMENTATION"]=11]="SEGMENTATION";ShimmerState[ShimmerState["TRANSITION_FADE_OUT_TO_SEGMENTATION"]=12]="TRANSITION_FADE_OUT_TO_SEGMENTATION";ShimmerState[ShimmerState["TRANSITION_FADE_OUT_TO_TRANSLATE"]=13]="TRANSITION_FADE_OUT_TO_TRANSLATE";ShimmerState[ShimmerState["TRANSLATE"]=14]="TRANSLATE";ShimmerState[ShimmerState["TRANSITION_FADE_IN_TO_SEARCHBOX"]=15]="TRANSITION_FADE_IN_TO_SEARCHBOX";ShimmerState[ShimmerState["SEARCHBOX"]=16]="SEARCHBOX"})(ShimmerState||(ShimmerState={}));function lerp(a,b,x){x=Math.max(0,Math.min(1,x));return a+(b-a)*x}function createCircleGradient(ctx,centerX,centerY,radius,colorRgba){const radialGradient=ctx.createRadialGradient(centerX,centerY,0,centerX,centerY,radius);radialGradient.addColorStop(0,modifyRgbaTransparency(colorRgba,1));radialGradient.addColorStop(.125,modifyRgbaTransparency(colorRgba,.957));radialGradient.addColorStop(.25,modifyRgbaTransparency(colorRgba,.84375));radialGradient.addColorStop(.375,modifyRgbaTransparency(colorRgba,.68359));radialGradient.addColorStop(.5,modifyRgbaTransparency(colorRgba,.5));radialGradient.addColorStop(.625,modifyRgbaTransparency(colorRgba,.3164));radialGradient.addColorStop(.75,modifyRgbaTransparency(colorRgba,.15625));radialGradient.addColorStop(.875,modifyRgbaTransparency(colorRgba,.04297));radialGradient.addColorStop(1,modifyRgbaTransparency(colorRgba,0));return radialGradient}export class OverlayShimmerCanvasElement extends PolymerElement{static get is(){return"overlay-shimmer-canvas"}static get template(){return getTemplate()}static get properties(){return{canvasHeight:Number,canvasWidth:Number,shaderLayerRgbaColors:{type:Array,computed:"computeShaderLayerColorRgbas(theme)"},theme:{type:Object,value:()=>getFallbackTheme()}}}circles=[];isWiggling=true;eventTracker_=new EventTracker;shimmerControllerStack=[ShimmerControlRequester.NONE];previousPostSelection;areResultsShowing=false;listenerIds;canvasPhysicalHeight;canvasPhysicalWidth;canvas;context;shimmerAnimation=[];cursorCenter;regionCenter;regionWidth;regionHeight;sparklesPattern=null;sparklesOffset=0;sparklesIntervalId;enableSparkles=loadTimeData.getBoolean("enableShimmerSparkles");shimmerState=ShimmerState.NONE;animationStartTime=undefined;didLastTransitionFinish=true;ready(){super.ready();this.canvas=this.$.shaderCanvas.transferControlToOffscreen();this.context=this.canvas.getContext("2d")}connectedCallback(){super.connectedCallback();this.eventTracker_.add(document,"focus-region",(e=>{this.onFocusRegion(e)}));this.eventTracker_.add(document,"unfocus-region",(e=>{this.onUnfocusRegion(e)}));this.listenerIds=[BrowserProxyImpl.getInstance().callbackRouter.notifyResultsPanelOpened.addListener((()=>{this.areResultsShowing=true}))]}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll();this.listenerIds.forEach((id=>assert(BrowserProxyImpl.getInstance().callbackRouter.removeListener(id))));this.listenerIds=[];if(this.sparklesIntervalId){clearInterval(this.sparklesIntervalId);this.sparklesIntervalId=undefined}}onSparklesLoad(){if(!this.enableSparkles){return}this.sparklesPattern=this.context.createPattern(this.$.sparklesSvg,"repeat");this.sparklesIntervalId=setInterval((()=>{this.sparklesOffset=Math.round(Math.random()*500)}),100)}startAnimation(){this.context.globalAlpha=INVOCATION_OPACITY_PERCENT;this.shimmerState=ShimmerState.INVOCATION;this.circles=this.shaderLayerRgbaColors.map((colorRgbaString=>({colorRgba:colorRgbaString,steadyStateCenter:{x:50-STEADY_STATE_CENTER_X_PERCENT_OFFSET*(Math.random()*2-1),y:50-STEADY_STATE_CENTER_Y_PERCENT_OFFSET*(Math.random()*2-1)},blur:STEADY_STATE_CIRCLE_BLUR,radius:INVOCATION_RADIUS_PERCENT,center:this.regionCenter?this.regionCenter:{x:INVOCATION_CENTER_X_PERCENT,y:INVOCATION_CENTER_Y_PERCENT},centerXAmpPercent:INVOCATION_CENTER_X_AMPLITUDE_PERCENT,centerYAmpPercent:INVOCATION_CENTER_Y_AMPLITUDE_PERCENT,radiusAmpPercent:INVOCATION_RADIUS_AMPLITUDE_PERCENT,radiusWiggle:new Wiggle(STEADY_STATE_FREQ_VAL),centerXWiggle:new Wiggle(STEADY_STATE_FREQ_VAL),centerYWiggle:new Wiggle(STEADY_STATE_FREQ_VAL)})));requestAnimationFrame((timeMs=>{this.stepAnimation(timeMs);if(this.regionCenter){this.isWiggling=false;this.setTransitionState(ShimmerState.TRANSITION_FADE_IN_TO_REGION);return}this.setTransitionState(ShimmerState.TRANSITION_TO_STEADY_STATE)}))}setCanvasSizeTo(width,height){this.canvasWidth=width;this.canvasHeight=height;this.canvasPhysicalWidth=Math.floor(width*window.devicePixelRatio);this.canvasPhysicalHeight=Math.floor(height*window.devicePixelRatio)}computeShaderLayerColorRgbas(){return getShaderLayerColorRgbas(this.theme)}stepAnimation(timeMs){if(!this.resetCanvasSizeIfNeeded()){this.context.clearRect(0,0,this.canvasWidth,this.canvasHeight)}this.resetCanvasPixelRatioIfNeeded();this.drawCircles(timeMs);this.drawSparkles();requestAnimationFrame(this.stepAnimation.bind(this))}onFocusRegion(e){const centerX=e.detail.left+e.detail.width/2;const centerY=e.detail.top+e.detail.height/2;if(e.detail.requester!==ShimmerControlRequester.TRANSLATE&&e.detail.requester!==ShimmerControlRequester.SEARCHBOX&&(centerX<=0||centerY<=0)){return}if(e.detail.requester===ShimmerControlRequester.POST_SELECTION){if(!this.shimmerControllerStack.includes(ShimmerControlRequester.POST_SELECTION)){this.shimmerControllerStack.push(ShimmerControlRequester.POST_SELECTION);this.shimmerControllerStack.sort()}this.previousPostSelection=e.detail}if(e.detail.requester===ShimmerControlRequester.CURSOR){this.cursorCenter={x:centerX*100,y:centerY*100}}this.focusRegion(centerX,centerY,e.detail.width,e.detail.height,e.detail.requester)}onUnfocusRegion(e){const controllerBeforeUnfocus=this.getCurrentShimmerController();const index=this.shimmerControllerStack.indexOf(e.detail.requester);if(index===-1){return}this.shimmerControllerStack.splice(index,1);const newCurrentController=this.getCurrentShimmerController();if(newCurrentController===controllerBeforeUnfocus){return}if(newCurrentController===ShimmerControlRequester.POST_SELECTION&&this.previousPostSelection){const centerX=this.previousPostSelection.left+this.previousPostSelection.width/2;const centerY=this.previousPostSelection.top+this.previousPostSelection.height/2;this.focusRegion(centerX,centerY,this.previousPostSelection.width,this.previousPostSelection.height,this.previousPostSelection.requester)}else if(newCurrentController===ShimmerControlRequester.CURSOR){this.focusRegion(this.cursorCenter.x/100,this.cursorCenter.y/100,0,0,newCurrentController)}else if(newCurrentController===ShimmerControlRequester.NONE){if(controllerBeforeUnfocus===ShimmerControlRequester.SEARCHBOX){this.setTransitionState(ShimmerState.TRANSITION_FADE_OUT_TO_CURSOR);this.focusRegion(0,0,0,0,ShimmerControlRequester.CURSOR);return}this.setTransitionState(ShimmerState.TRANSITION_TO_STEADY_STATE)}}focusRegion(centerX,centerY,width,height,requester){const currentShimmerController=this.getCurrentShimmerController();if(currentShimmerController>requester){return}else if(currentShimmerController<requester){this.shimmerControllerStack.push(requester)}switch(requester){case ShimmerControlRequester.SEGMENTATION:this.regionCenter={x:centerX*100,y:centerY*100};this.regionWidth=width;this.regionHeight=height;this.setTransitionState(ShimmerState.TRANSITION_FADE_OUT_TO_SEGMENTATION);break;case ShimmerControlRequester.POST_SELECTION:this.regionCenter={x:centerX*100,y:centerY*100};this.regionWidth=width;this.regionHeight=height;if(currentShimmerController===ShimmerControlRequester.POST_SELECTION){this.setTransitionState(ShimmerState.TRANSITION_FADE_IN_TO_REGION);break}if(this.shimmerState===ShimmerState.REGION||this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_REGION){this.setTransitionState(ShimmerState.TRANSITION_FADE_OUT_TO_REGION);break}if(this.shimmerState!==ShimmerState.TRANSITION_FADE_OUT_TO_REGION){this.setTransitionState(ShimmerState.TRANSITION_FADE_IN_TO_REGION)}break;case ShimmerControlRequester.MANUAL_REGION:this.regionCenter={x:centerX*100,y:centerY*100};this.regionWidth=width;this.regionHeight=height;if(this.shimmerState!==ShimmerState.TRANSITION_FADE_IN_TO_REGION){this.setTransitionState(ShimmerState.TRANSITION_FADE_IN_TO_REGION)}break;case ShimmerControlRequester.CURSOR:this.cursorCenter={x:centerX*100,y:centerY*100};if(this.shimmerState!==ShimmerState.TRANSITION_FADE_OUT_TO_CURSOR&&this.shimmerState!==ShimmerState.TRANSITION_SHRINK_TO_CURSOR&&this.shimmerState!==ShimmerState.CURSOR){const transitionState=currentShimmerController===ShimmerControlRequester.NONE?ShimmerState.TRANSITION_SHRINK_TO_CURSOR:ShimmerState.TRANSITION_FADE_OUT_TO_CURSOR;this.setTransitionState(transitionState)}break;case ShimmerControlRequester.TRANSLATE:this.setTransitionState(ShimmerState.TRANSITION_FADE_OUT_TO_TRANSLATE);break;case ShimmerControlRequester.SEARCHBOX:this.regionCenter={x:centerX*100,y:centerY*100};this.regionWidth=width;this.regionHeight=height;this.setTransitionState(ShimmerState.TRANSITION_FADE_IN_TO_SEARCHBOX);break;default:assertNotReached()}if(requester===ShimmerControlRequester.POST_SELECTION){this.isWiggling=false}else{this.isWiggling=true}}drawCircles(timeMs){this.setCurrentAnimationStartTimeIfNeeded(timeMs);const elapsed=this.getElapsedAnimationTime(timeMs);const easingFunction=this.getEasingFunctionForCurrentState();this.animateOpacityIfNeeded(elapsed,easingFunction);for(let i=0;i<this.circles.length;i++){const circle=this.circles[i];const shimmerAnimation=this.shimmerAnimation[i];this.setWiggleFrequency(circle);let radiusWiggle=circle.radiusWiggle.getPreviousWiggleValue();let centerXWiggle=circle.centerXWiggle.getPreviousWiggleValue();let centerYWiggle=circle.centerYWiggle.getPreviousWiggleValue();if(this.isWiggling){radiusWiggle=circle.radiusWiggle.calculateNext(timeMs/1e3);centerXWiggle=circle.centerXWiggle.calculateNext(timeMs/1e3);centerYWiggle=circle.centerYWiggle.calculateNext(timeMs/1e3)}this.stepUpdateCircle(circle,shimmerAnimation,elapsed,easingFunction);if(this.shimmerState===ShimmerState.CURSOR){circle.center.x=this.cursorCenter.x;circle.center.y=this.cursorCenter.y}const baseRadius=circle.radius/100*Math.max(this.canvasPhysicalWidth,this.canvasPhysicalHeight)*circle.blur;const baseCircleX=circle.center.x/100*this.canvasPhysicalWidth;const baseCircleY=circle.center.y/100*this.canvasPhysicalHeight;const radiusAmp=circle.radiusAmpPercent/100*Math.max(this.canvasPhysicalWidth,this.canvasPhysicalHeight);const centerXAmp=circle.centerXAmpPercent/100*this.canvasPhysicalWidth;const centerYAmp=circle.centerYAmpPercent/100*this.canvasPhysicalHeight;const adjustedRadius=Math.floor((baseRadius+radiusAmp*radiusWiggle)/window.devicePixelRatio);const adjustedCenterX=Math.floor((baseCircleX+centerXAmp*centerXWiggle)/window.devicePixelRatio);const adjustedCenterY=Math.floor((baseCircleY+centerYAmp*centerYWiggle)/window.devicePixelRatio);this.drawCircle(adjustedRadius,adjustedCenterX,adjustedCenterY,circle.colorRgba)}this.finishAnimationIfNeeded(elapsed)}drawSparkles(){if(!this.sparklesPattern){return}this.sparklesPattern.setTransform((new DOMMatrixReadOnly).translate(this.sparklesOffset,this.sparklesOffset));this.context.save();this.context.beginPath();this.context.rect(0,0,this.canvasWidth,this.canvasHeight);this.context.closePath();this.context.globalCompositeOperation="source-atop";this.context.globalAlpha=SPARKLES_OPACITY;this.context.fillStyle=this.sparklesPattern;this.context.fill();this.context.restore()}resetCanvasSizeIfNeeded(){if(this.canvas.width!==this.canvasPhysicalWidth||this.canvas.height!==this.canvasPhysicalHeight){const currentOpacity=this.context.globalAlpha;this.canvas.height=this.canvasPhysicalHeight;this.canvas.width=this.canvasPhysicalWidth;this.context.globalAlpha=currentOpacity;return true}return false}resetCanvasPixelRatioIfNeeded(){const transform=this.context.getTransform();if(transform.a!==window.devicePixelRatio||transform.d!==window.devicePixelRatio){this.context.setTransform(window.devicePixelRatio,0,0,window.devicePixelRatio,0,0)}}animateOpacityIfNeeded(elapsed,easingFunction){if(this.isShimmerInTransitionState()){const shimmerAnimation=this.shimmerAnimation[0];if(shimmerAnimation){const opacityProgress=Math.min(elapsed/this.getTransitionDuration(),1);const easedOpacityProgress=Math.min(easingFunction.solveForY(opacityProgress),1);this.context.globalAlpha=lerp(shimmerAnimation.startKeyframe.opacity,shimmerAnimation.endKeyframe.opacity,easedOpacityProgress)}}}stepUpdateCircle(circle,shimmerAnimation,elapsed,easingFunction){if(this.isShimmerInTransitionState()){let endCenter=structuredClone(shimmerAnimation.endKeyframe.center);let endCenterXAmpPrecent=shimmerAnimation.endKeyframe.centerXAmpPercent;let endCenterYAmpPrecent=shimmerAnimation.endKeyframe.centerYAmpPercent;let endRadius=shimmerAnimation.endKeyframe.radius;let endRadiusAmpPercent=shimmerAnimation.endKeyframe.radiusAmpPercent;if(this.shimmerState===ShimmerState.TRANSITION_SHRINK_TO_CURSOR){endCenter=structuredClone(this.cursorCenter)}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_REGION||this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEGMENTATION||this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEARCHBOX){const smallestLength=Math.min(this.regionHeight,this.regionWidth);endCenter=structuredClone(this.regionCenter);endCenterXAmpPrecent=endCenterXAmpPrecent*this.regionWidth;endCenterYAmpPrecent=endCenterYAmpPrecent*this.regionHeight;endRadius=endRadius*smallestLength;endRadiusAmpPercent=endRadiusAmpPercent*smallestLength}const progress=Math.min(elapsed/this.getTransitionDuration(),1);const easedProgress=Math.min(easingFunction.solveForY(progress),1);let easedRadiusProgress=easedProgress;if(this.shimmerState===ShimmerState.TRANSITION_SHRINK_TO_CURSOR){const radiusProgress=Math.min(elapsed/CURSOR_STATE_TRANSITION_DURATION,1);easedRadiusProgress=Math.min(easingFunction.solveForY(radiusProgress),1)}circle.center.x=lerp(shimmerAnimation.startKeyframe.center.x,endCenter.x,easedProgress);circle.center.y=lerp(shimmerAnimation.startKeyframe.center.y,endCenter.y,easedProgress);circle.centerXAmpPercent=lerp(shimmerAnimation.startKeyframe.centerXAmpPercent,endCenterXAmpPrecent,easedProgress);circle.centerYAmpPercent=lerp(shimmerAnimation.startKeyframe.centerYAmpPercent,endCenterYAmpPrecent,easedProgress);circle.radiusAmpPercent=lerp(shimmerAnimation.startKeyframe.radiusAmpPercent,endRadiusAmpPercent,easedProgress);circle.radius=lerp(shimmerAnimation.startKeyframe.radius,endRadius,easedRadiusProgress)}}drawCircle(radius,centerX,centerY,colorRgba){this.context.beginPath();this.context.fillStyle=createCircleGradient(this.context,centerX,centerY,radius,colorRgba);this.context.arc(centerX,centerY,radius,0,2*Math.PI);this.context.closePath();this.context.fill()}createShimmerAnimation(){this.shimmerAnimation=this.circles.map((item=>({startKeyframe:this.createStartKeyframeFromCircle(item),endKeyframe:this.createEndKeyframeFromCircle(item)})))}setWiggleFrequency(circle){if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_REGION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_REGION||this.shimmerState===ShimmerState.REGION||this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEGMENTATION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_SEGMENTATION||this.shimmerState===ShimmerState.SEGMENTATION){circle.radiusWiggle.setFrequency(INTERACTION_STATE_FREQ_VAL);circle.centerXWiggle.setFrequency(INTERACTION_STATE_FREQ_VAL);circle.centerYWiggle.setFrequency(INTERACTION_STATE_FREQ_VAL);return}circle.radiusWiggle.setFrequency(STEADY_STATE_FREQ_VAL);circle.centerXWiggle.setFrequency(STEADY_STATE_FREQ_VAL);circle.centerYWiggle.setFrequency(STEADY_STATE_FREQ_VAL)}createStartKeyframeFromCircle(circle){const centerPoint={x:circle.center.x,y:circle.center.y};let blur=circle.blur;let centerXAmpPercent=circle.centerXAmpPercent;let centerYAmpPercent=circle.centerYAmpPercent;let radius=circle.radius;let radiusAmpPercent=circle.radiusAmpPercent;if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_REGION){const smallestLength=Math.min(this.regionHeight,this.regionWidth);centerPoint.x=this.regionCenter.x;centerPoint.y=this.regionCenter.y;radius=REGION_SELECTION_STATE_RADIUS_PERCENT*smallestLength;radiusAmpPercent=REGION_SELECTION_STATE_RADIUS_AMPLITUDE_PERCENT*smallestLength;blur=REGION_SELECTION_STATE_CIRCLE_BLUR;centerXAmpPercent=REGION_SELECTION_STATE_CENTER_X_AMPLITUDE_PERCENT*this.regionWidth;centerYAmpPercent=REGION_SELECTION_STATE_CENTER_Y_AMPLITUDE_PERCENT*this.regionHeight}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEGMENTATION){const smallestLength=Math.min(this.regionHeight,this.regionWidth);centerPoint.x=this.regionCenter.x;centerPoint.y=this.regionCenter.y;radius=SEGMENTATION_STATE_RADIUS_PERCENT*smallestLength;radiusAmpPercent=SEGMENTATION_STATE_RADIUS_AMPLITUDE_PERCENT*smallestLength;blur=SEGMENTATION_STATE_CIRCLE_BLUR;centerXAmpPercent=SEGMENTATION_STATE_CENTER_X_AMPLITUDE_PERCENT*this.regionWidth;centerYAmpPercent=SEGMENTATION_STATE_CENTER_Y_AMPLITUDE_PERCENT*this.regionHeight}return{blur:blur,center:centerPoint,centerXAmpPercent:centerXAmpPercent,centerYAmpPercent:centerYAmpPercent,radius:radius,radiusAmpPercent:radiusAmpPercent,radiusWiggleValue:circle.radiusWiggle.getPreviousWiggleValue(),centerXWiggleValue:circle.centerXWiggle.getPreviousWiggleValue(),centerYWiggleValue:circle.centerYWiggle.getPreviousWiggleValue(),opacity:this.context.globalAlpha}}createEndKeyframeFromCircle(circle){const keyframe=this.createStartKeyframeFromCircle(circle);if(this.shimmerState===ShimmerState.TRANSITION_TO_STEADY_STATE){keyframe.blur=STEADY_STATE_CIRCLE_BLUR;keyframe.center=structuredClone(circle.steadyStateCenter);keyframe.centerXAmpPercent=STEADY_STATE_CENTER_X_AMPLITUDE_PERCENT;keyframe.centerYAmpPercent=STEADY_STATE_CENTER_Y_AMPLITUDE_PERCENT;keyframe.radius=STEADY_STATE_RADIUS_PERCENT;keyframe.radiusAmpPercent=STEADY_STATE_RADIUS_AMPLITUDE_PERCENT;keyframe.opacity=STEADY_STATE_OPACITY_PERCENT}else if(this.shimmerState===ShimmerState.TRANSITION_SHRINK_TO_CURSOR){keyframe.centerXAmpPercent=CURSOR_STATE_CENTER_X_AMPLITUDE_PERCENT;keyframe.centerYAmpPercent=CURSOR_STATE_CENTER_Y_AMPLITUDE_PERCENT;keyframe.radiusAmpPercent=CURSOR_STATE_RADIUS_AMPLITUDE_PERCENT;keyframe.radius=CURSOR_STATE_RADIUS_PERCENT}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_CURSOR||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_REGION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_SEGMENTATION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_TRANSLATE){keyframe.opacity=FADE_OUT_STATE_OPACITY_PERCENT}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_REGION){keyframe.blur=REGION_SELECTION_STATE_CIRCLE_BLUR;keyframe.centerXAmpPercent=REGION_SELECTION_STATE_CENTER_X_AMPLITUDE_PERCENT;keyframe.centerYAmpPercent=REGION_SELECTION_STATE_CENTER_Y_AMPLITUDE_PERCENT;keyframe.radius=REGION_SELECTION_STATE_RADIUS_PERCENT;keyframe.radiusAmpPercent=REGION_SELECTION_STATE_RADIUS_AMPLITUDE_PERCENT;keyframe.opacity=INTERACTION_STATE_OPACITY_PERCENT}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEGMENTATION){keyframe.blur=SEGMENTATION_STATE_CIRCLE_BLUR;keyframe.centerXAmpPercent=SEGMENTATION_STATE_CENTER_X_AMPLITUDE_PERCENT;keyframe.centerYAmpPercent=SEGMENTATION_STATE_CENTER_Y_AMPLITUDE_PERCENT;keyframe.radius=SEGMENTATION_STATE_RADIUS_PERCENT;keyframe.radiusAmpPercent=SEGMENTATION_STATE_RADIUS_AMPLITUDE_PERCENT;keyframe.opacity=SEGMENTATION_STATE_OPACITY_PERCENT}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEARCHBOX){keyframe.blur=SEARCHBOX_STATE_CIRCLE_BLUR;keyframe.centerXAmpPercent=SEARCHBOX_STATE_CENTER_X_AMPLITUDE_PERCENT;keyframe.centerYAmpPercent=SEARCHBOX_STATE_CENTER_Y_AMPLITUDE_PERCENT;keyframe.radius=SEARCHBOX_STATE_RADIUS_PERCENT;keyframe.radiusAmpPercent=SEARCHBOX_STATE_RADIUS_AMPLITUDE_PERCENT;keyframe.opacity=INTERACTION_STATE_OPACITY_PERCENT}return keyframe}isShimmerInTransitionState(){return this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_REGION||this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEGMENTATION||this.shimmerState===ShimmerState.TRANSITION_TO_STEADY_STATE||this.shimmerState===ShimmerState.TRANSITION_SHRINK_TO_CURSOR||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_CURSOR||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_REGION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_SEGMENTATION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_TRANSLATE||this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEARCHBOX}setCurrentAnimationStartTimeIfNeeded(currentTimeMs){if(this.isShimmerInTransitionState()&&this.animationStartTime===undefined){this.createShimmerAnimation();this.animationStartTime=currentTimeMs}}getElapsedAnimationTime(currentTimeMs){if(this.animationStartTime&&this.animationStartTime>0){return currentTimeMs-this.animationStartTime}return 0}getEasingFunctionForCurrentState(){if(this.shimmerState===ShimmerState.TRANSITION_TO_STEADY_STATE){return STEADY_STATE_EASING_FUNCTION}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_CURSOR||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_REGION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_SEGMENTATION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_TRANSLATE){return FADE_OUT_EASING_FUNCTION}return INTERACTION_STATE_EASING_FUNCTION}setTransitionState(state){if(this.isShimmerInTransitionState()){this.didLastTransitionFinish=false}this.dispatchEvent(new CustomEvent("shimmer-fade-out-complete",{bubbles:true,composed:true,detail:state!==ShimmerState.TRANSITION_FADE_OUT_TO_REGION&&state!==ShimmerState.TRANSITION_FADE_OUT_TO_SEGMENTATION&&state!==ShimmerState.TRANSITION_FADE_OUT_TO_TRANSLATE}));this.animationStartTime=undefined;this.shimmerState=state}finishAnimationIfNeeded(elapsed){if(this.shimmerState===ShimmerState.TRANSITION_TO_STEADY_STATE&&elapsed>=STEADY_STATE_TRANSITION_DURATION){this.shimmerState=ShimmerState.STEADY_STATE;this.didLastTransitionFinish=true}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_REGION&&elapsed>=REGION_SELECTION_TRANSITION_DURATION){this.shimmerState=ShimmerState.REGION;this.didLastTransitionFinish=true}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEGMENTATION&&elapsed>=SEGMENTATION_TRANSITION_DURATION){this.shimmerState=ShimmerState.SEGMENTATION;this.didLastTransitionFinish=true}else if(this.shimmerState===ShimmerState.TRANSITION_SHRINK_TO_CURSOR&&elapsed>=CURSOR_STATE_TRANSITION_DURATION){this.shimmerState=ShimmerState.CURSOR;this.didLastTransitionFinish=true}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_CURSOR&&elapsed>=FADE_OUT_TRANSITION_DURATION){this.shimmerState=ShimmerState.CURSOR;this.didLastTransitionFinish=true}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_REGION&&elapsed>=FADE_OUT_TRANSITION_DURATION){this.dispatchEvent(new CustomEvent("shimmer-fade-out-complete",{bubbles:true,composed:true,detail:true}));this.didLastTransitionFinish=true;this.shimmerState=ShimmerState.NONE;this.setTransitionState(ShimmerState.TRANSITION_FADE_IN_TO_REGION)}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_SEGMENTATION&&elapsed>=FADE_OUT_TRANSITION_DURATION){this.dispatchEvent(new CustomEvent("shimmer-fade-out-complete",{bubbles:true,composed:true,detail:true}));this.didLastTransitionFinish=true;this.shimmerState=ShimmerState.NONE;this.setTransitionState(ShimmerState.TRANSITION_FADE_IN_TO_SEGMENTATION)}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_TRANSLATE&&elapsed>=FADE_OUT_TRANSITION_DURATION){this.dispatchEvent(new CustomEvent("shimmer-fade-out-complete",{bubbles:true,composed:true,detail:true}));this.didLastTransitionFinish=true;this.shimmerState=ShimmerState.TRANSLATE}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEARCHBOX&&elapsed>=SEARCHBOX_TRANSITION_DURATION){this.didLastTransitionFinish=true;this.shimmerState=ShimmerState.SEARCHBOX}}getTransitionDuration(){if(this.shimmerState===ShimmerState.TRANSITION_TO_STEADY_STATE){return STEADY_STATE_TRANSITION_DURATION}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_REGION){return REGION_SELECTION_TRANSITION_DURATION}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEGMENTATION){return SEGMENTATION_TRANSITION_DURATION}else if(this.shimmerState===ShimmerState.TRANSITION_SHRINK_TO_CURSOR){return CURSOR_SHRINK_TRANSITION_DURATION}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_CURSOR||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_REGION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_SEGMENTATION||this.shimmerState===ShimmerState.TRANSITION_FADE_OUT_TO_TRANSLATE){return FADE_OUT_TRANSITION_DURATION}else if(this.shimmerState===ShimmerState.TRANSITION_FADE_IN_TO_SEARCHBOX){return SEARCHBOX_TRANSITION_DURATION}return 0}getCurrentShimmerController(){return this.shimmerControllerStack[this.shimmerControllerStack.length-1]}}customElements.define(OverlayShimmerCanvasElement.is,OverlayShimmerCanvasElement);