import { type PageInterface, type PanelStateKind, ProfileReadyState } from './glic.mojom-webui.js';
export declare enum AppView {
    GLIC = 0,
    FRE = 1
}
/**
 * This class manages the main view of the Glic WebUI, switching between the
 * First Run Experience (FRE) and the main GLIC application. It handles
 * the outcome of the FRE and delegates browser interactions to controllers.
 */
export declare class AppRouter implements PageInterface {
    private glicController;
    private freAppController;
    private glicContainer;
    private freContainer;
    private browserProxy;
    private currentView;
    private currentPanelStateKind;
    constructor();
    switchToView(view: AppView): void;
    intentToShow(): void;
    setProfileReadyState(state: ProfileReadyState): void;
    updatePageState(panelStateKind: PanelStateKind): void;
    close(): void;
    reload(): void;
    showDebug(): void;
}
