// chrome/browser/glic/fre/glic_fre.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const FreWebUiStateSpec = { $: mojo.internal.Enum() };
export var FreWebUiState;
(function (FreWebUiState) {
    FreWebUiState[FreWebUiState["MIN_VALUE"] = 0] = "MIN_VALUE";
    FreWebUiState[FreWebUiState["MAX_VALUE"] = 8] = "MAX_VALUE";
    FreWebUiState[FreWebUiState["kUninitialized"] = 0] = "kUninitialized";
    FreWebUiState[FreWebUiState["kBeginLoading"] = 1] = "kBeginLoading";
    FreWebUiState[FreWebUiState["kShowLoading"] = 2] = "kShowLoading";
    FreWebUiState[FreWebUiState["kHoldLoading"] = 3] = "kHoldLoading";
    FreWebUiState[FreWebUiState["kFinishLoading"] = 4] = "kFinishLoading";
    FreWebUiState[FreWebUiState["kError"] = 5] = "kError";
    FreWebUiState[FreWebUiState["kOffline"] = 6] = "kOffline";
    FreWebUiState[FreWebUiState["kReady"] = 7] = "kReady";
    FreWebUiState[FreWebUiState["kDisabledByAdmin"] = 8] = "kDisabledByAdmin";
})(FreWebUiState || (FreWebUiState = {}));
export class FrePageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'glic.mojom.FrePageHandlerFactory', scope);
    }
}
export class FrePageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(FrePageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(receiver) {
        this.proxy.sendMessage(0, FrePageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            receiver
        ], false);
    }
}
;
/**
 * An object which receives request messages for the FrePageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FrePageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FrePageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, FrePageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class FrePageHandlerFactory {
    static get $interfaceName() {
        return "glic.mojom.FrePageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new FrePageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the FrePageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FrePageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FrePageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, FrePageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class FrePageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'glic.mojom.FrePageHandler', scope);
    }
}
export class FrePageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(FrePageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    acceptFre() {
        this.proxy.sendMessage(0, FrePageHandler_AcceptFre_ParamsSpec.$, null, [], false);
    }
    rejectFre() {
        this.proxy.sendMessage(1, FrePageHandler_RejectFre_ParamsSpec.$, null, [], false);
    }
    dismissFre(panel) {
        this.proxy.sendMessage(2, FrePageHandler_DismissFre_ParamsSpec.$, null, [
            panel
        ], false);
    }
    freReloaded() {
        this.proxy.sendMessage(3, FrePageHandler_FreReloaded_ParamsSpec.$, null, [], false);
    }
    prepareForClient() {
        return this.proxy.sendMessage(4, FrePageHandler_PrepareForClient_ParamsSpec.$, FrePageHandler_PrepareForClient_ResponseParamsSpec.$, [], false);
    }
    validateAndOpenLinkInNewTab(url) {
        this.proxy.sendMessage(5, FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec.$, null, [
            url
        ], false);
    }
    webUiStateChanged(newState) {
        this.proxy.sendMessage(6, FrePageHandler_WebUiStateChanged_ParamsSpec.$, null, [
            newState
        ], false);
    }
    exceededTimeoutError() {
        this.proxy.sendMessage(7, FrePageHandler_ExceededTimeoutError_ParamsSpec.$, null, [], false);
    }
    logWebUiLoadComplete() {
        this.proxy.sendMessage(8, FrePageHandler_LogWebUiLoadComplete_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the FrePageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FrePageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FrePageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, FrePageHandler_AcceptFre_ParamsSpec.$, null, impl.acceptFre.bind(impl), false);
        this.helper_internal_.registerHandler(1, FrePageHandler_RejectFre_ParamsSpec.$, null, impl.rejectFre.bind(impl), false);
        this.helper_internal_.registerHandler(2, FrePageHandler_DismissFre_ParamsSpec.$, null, impl.dismissFre.bind(impl), false);
        this.helper_internal_.registerHandler(3, FrePageHandler_FreReloaded_ParamsSpec.$, null, impl.freReloaded.bind(impl), false);
        this.helper_internal_.registerHandler(4, FrePageHandler_PrepareForClient_ParamsSpec.$, FrePageHandler_PrepareForClient_ResponseParamsSpec.$, impl.prepareForClient.bind(impl), false);
        this.helper_internal_.registerHandler(5, FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec.$, null, impl.validateAndOpenLinkInNewTab.bind(impl), false);
        this.helper_internal_.registerHandler(6, FrePageHandler_WebUiStateChanged_ParamsSpec.$, null, impl.webUiStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(7, FrePageHandler_ExceededTimeoutError_ParamsSpec.$, null, impl.exceededTimeoutError.bind(impl), false);
        this.helper_internal_.registerHandler(8, FrePageHandler_LogWebUiLoadComplete_ParamsSpec.$, null, impl.logWebUiLoadComplete.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class FrePageHandler {
    static get $interfaceName() {
        return "glic.mojom.FrePageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new FrePageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the FrePageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FrePageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    acceptFre;
    rejectFre;
    dismissFre;
    freReloaded;
    prepareForClient;
    validateAndOpenLinkInNewTab;
    webUiStateChanged;
    exceededTimeoutError;
    logWebUiLoadComplete;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FrePageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.acceptFre =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, FrePageHandler_AcceptFre_ParamsSpec.$, null, this.acceptFre.createReceiverHandler(false /* expectsResponse */), false);
        this.rejectFre =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, FrePageHandler_RejectFre_ParamsSpec.$, null, this.rejectFre.createReceiverHandler(false /* expectsResponse */), false);
        this.dismissFre =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, FrePageHandler_DismissFre_ParamsSpec.$, null, this.dismissFre.createReceiverHandler(false /* expectsResponse */), false);
        this.freReloaded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, FrePageHandler_FreReloaded_ParamsSpec.$, null, this.freReloaded.createReceiverHandler(false /* expectsResponse */), false);
        this.prepareForClient =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, FrePageHandler_PrepareForClient_ParamsSpec.$, FrePageHandler_PrepareForClient_ResponseParamsSpec.$, this.prepareForClient.createReceiverHandler(true /* expectsResponse */), false);
        this.validateAndOpenLinkInNewTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec.$, null, this.validateAndOpenLinkInNewTab.createReceiverHandler(false /* expectsResponse */), false);
        this.webUiStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, FrePageHandler_WebUiStateChanged_ParamsSpec.$, null, this.webUiStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.exceededTimeoutError =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, FrePageHandler_ExceededTimeoutError_ParamsSpec.$, null, this.exceededTimeoutError.createReceiverHandler(false /* expectsResponse */), false);
        this.logWebUiLoadComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, FrePageHandler_LogWebUiLoadComplete_ParamsSpec.$, null, this.logWebUiLoadComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const FrePageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const FrePageHandler_AcceptFre_ParamsSpec = { $: {} };
export const FrePageHandler_RejectFre_ParamsSpec = { $: {} };
export const FrePageHandler_DismissFre_ParamsSpec = { $: {} };
export const FrePageHandler_FreReloaded_ParamsSpec = { $: {} };
export const FrePageHandler_PrepareForClient_ParamsSpec = { $: {} };
export const FrePageHandler_PrepareForClient_ResponseParamsSpec = { $: {} };
export const FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec = { $: {} };
export const FrePageHandler_WebUiStateChanged_ParamsSpec = { $: {} };
export const FrePageHandler_ExceededTimeoutError_ParamsSpec = { $: {} };
export const FrePageHandler_LogWebUiLoadComplete_ParamsSpec = { $: {} };
mojo.internal.Struct(FrePageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'FrePageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('receiver', 0, 0, mojo.internal.InterfaceRequest(FrePageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(FrePageHandler_AcceptFre_ParamsSpec.$, 'FrePageHandler_AcceptFre_Params', [], [[0, 8],]);
mojo.internal.Struct(FrePageHandler_RejectFre_ParamsSpec.$, 'FrePageHandler_RejectFre_Params', [], [[0, 8],]);
mojo.internal.Struct(FrePageHandler_DismissFre_ParamsSpec.$, 'FrePageHandler_DismissFre_Params', [
    mojo.internal.StructField('panel', 0, 0, FreWebUiStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(FrePageHandler_FreReloaded_ParamsSpec.$, 'FrePageHandler_FreReloaded_Params', [], [[0, 8],]);
mojo.internal.Struct(FrePageHandler_PrepareForClient_ParamsSpec.$, 'FrePageHandler_PrepareForClient_Params', [], [[0, 8],]);
mojo.internal.Struct(FrePageHandler_PrepareForClient_ResponseParamsSpec.$, 'FrePageHandler_PrepareForClient_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec.$, 'FrePageHandler_ValidateAndOpenLinkInNewTab_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(FrePageHandler_WebUiStateChanged_ParamsSpec.$, 'FrePageHandler_WebUiStateChanged_Params', [
    mojo.internal.StructField('newState', 0, 0, FreWebUiStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(FrePageHandler_ExceededTimeoutError_ParamsSpec.$, 'FrePageHandler_ExceededTimeoutError_Params', [], [[0, 8],]);
mojo.internal.Struct(FrePageHandler_LogWebUiLoadComplete_ParamsSpec.$, 'FrePageHandler_LogWebUiLoadComplete_Params', [], [[0, 8],]);
