// chrome/browser/glic/fre/glic_fre.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const FreWebUiStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum FreWebUiState {

  MIN_VALUE = 0,
  MAX_VALUE = 8,
  kUninitialized = 0,
  kBeginLoading = 1,
  kShowLoading = 2,
  kHoldLoading = 3,
  kFinishLoading = 4,
  kError = 5,
  kOffline = 6,
  kReady = 7,
  kDisabledByAdmin = 8,
}



export type FrePageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<FrePageHandlerFactoryPendingReceiver>;

export class FrePageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<FrePageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<FrePageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|FrePageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'glic.mojom.FrePageHandlerFactory',
        scope);
  }
}

export interface FrePageHandlerFactoryInterface {
  createPageHandler(receiver: FrePageHandlerPendingReceiver): void;
}

export class FrePageHandlerFactoryRemote implements FrePageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<FrePageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<FrePageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|FrePageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FrePageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      receiver: FrePageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        FrePageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FrePageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FrePageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    FrePageHandlerFactoryRemote, FrePageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    FrePageHandlerFactoryRemote, FrePageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: FrePageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FrePageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FrePageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FrePageHandlerFactory {
  static get $interfaceName(): string {
    return "glic.mojom.FrePageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): FrePageHandlerFactoryRemote {
    let remote = new FrePageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the FrePageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FrePageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    FrePageHandlerFactoryRemote, FrePageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    FrePageHandlerFactoryRemote, FrePageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FrePageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FrePageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type FrePageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<FrePageHandlerPendingReceiver>;

export class FrePageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<FrePageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<FrePageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|FrePageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'glic.mojom.FrePageHandler',
        scope);
  }
}

export interface FrePageHandlerInterface {
  acceptFre(): void;
  rejectFre(): void;
  dismissFre(panel: FreWebUiState): void;
  freReloaded(): void;
  prepareForClient(): Promise<{
        success: boolean, }>;
  validateAndOpenLinkInNewTab(url: url_mojom_Url): void;
  webUiStateChanged(newState: FreWebUiState): void;
  exceededTimeoutError(): void;
  logWebUiLoadComplete(): void;
}

export class FrePageHandlerRemote implements FrePageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<FrePageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<FrePageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|FrePageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FrePageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  acceptFre(): void {
    this.proxy.sendMessage(
        0,
        FrePageHandler_AcceptFre_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  rejectFre(): void {
    this.proxy.sendMessage(
        1,
        FrePageHandler_RejectFre_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  dismissFre(
      panel: FreWebUiState): void {
    this.proxy.sendMessage(
        2,
        FrePageHandler_DismissFre_ParamsSpec.$,
        null,
        [
          panel
        ],
        false);
  }

  freReloaded(): void {
    this.proxy.sendMessage(
        3,
        FrePageHandler_FreReloaded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  prepareForClient(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        4,
        FrePageHandler_PrepareForClient_ParamsSpec.$,
        FrePageHandler_PrepareForClient_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  validateAndOpenLinkInNewTab(
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        5,
        FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  webUiStateChanged(
      newState: FreWebUiState): void {
    this.proxy.sendMessage(
        6,
        FrePageHandler_WebUiStateChanged_ParamsSpec.$,
        null,
        [
          newState
        ],
        false);
  }

  exceededTimeoutError(): void {
    this.proxy.sendMessage(
        7,
        FrePageHandler_ExceededTimeoutError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  logWebUiLoadComplete(): void {
    this.proxy.sendMessage(
        8,
        FrePageHandler_LogWebUiLoadComplete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FrePageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FrePageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    FrePageHandlerRemote, FrePageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    FrePageHandlerRemote, FrePageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: FrePageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FrePageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FrePageHandler_AcceptFre_ParamsSpec.$,
        null,
        impl.acceptFre.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FrePageHandler_RejectFre_ParamsSpec.$,
        null,
        impl.rejectFre.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FrePageHandler_DismissFre_ParamsSpec.$,
        null,
        impl.dismissFre.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FrePageHandler_FreReloaded_ParamsSpec.$,
        null,
        impl.freReloaded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        FrePageHandler_PrepareForClient_ParamsSpec.$,
        FrePageHandler_PrepareForClient_ResponseParamsSpec.$,
        impl.prepareForClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec.$,
        null,
        impl.validateAndOpenLinkInNewTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        FrePageHandler_WebUiStateChanged_ParamsSpec.$,
        null,
        impl.webUiStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        FrePageHandler_ExceededTimeoutError_ParamsSpec.$,
        null,
        impl.exceededTimeoutError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        FrePageHandler_LogWebUiLoadComplete_ParamsSpec.$,
        null,
        impl.logWebUiLoadComplete.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FrePageHandler {
  static get $interfaceName(): string {
    return "glic.mojom.FrePageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): FrePageHandlerRemote {
    let remote = new FrePageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the FrePageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FrePageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    FrePageHandlerRemote, FrePageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    FrePageHandlerRemote, FrePageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  acceptFre: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  rejectFre: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  dismissFre: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  freReloaded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  prepareForClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  validateAndOpenLinkInNewTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  webUiStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  exceededTimeoutError: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  logWebUiLoadComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FrePageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.acceptFre =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FrePageHandler_AcceptFre_ParamsSpec.$,
        null,
        this.acceptFre.createReceiverHandler(false /* expectsResponse */),
        false);
    this.rejectFre =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FrePageHandler_RejectFre_ParamsSpec.$,
        null,
        this.rejectFre.createReceiverHandler(false /* expectsResponse */),
        false);
    this.dismissFre =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FrePageHandler_DismissFre_ParamsSpec.$,
        null,
        this.dismissFre.createReceiverHandler(false /* expectsResponse */),
        false);
    this.freReloaded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FrePageHandler_FreReloaded_ParamsSpec.$,
        null,
        this.freReloaded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.prepareForClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        FrePageHandler_PrepareForClient_ParamsSpec.$,
        FrePageHandler_PrepareForClient_ResponseParamsSpec.$,
        this.prepareForClient.createReceiverHandler(true /* expectsResponse */),
        false);
    this.validateAndOpenLinkInNewTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec.$,
        null,
        this.validateAndOpenLinkInNewTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.webUiStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        FrePageHandler_WebUiStateChanged_ParamsSpec.$,
        null,
        this.webUiStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.exceededTimeoutError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        FrePageHandler_ExceededTimeoutError_ParamsSpec.$,
        null,
        this.exceededTimeoutError.createReceiverHandler(false /* expectsResponse */),
        false);
    this.logWebUiLoadComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        FrePageHandler_LogWebUiLoadComplete_ParamsSpec.$,
        null,
        this.logWebUiLoadComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const FrePageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_AcceptFre_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_RejectFre_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_DismissFre_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_FreReloaded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_PrepareForClient_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_PrepareForClient_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_WebUiStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_ExceededTimeoutError_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrePageHandler_LogWebUiLoadComplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface FrePageHandlerFactory_CreatePageHandler_ParamsMojoType {
  receiver: FrePageHandlerPendingReceiver;
}


export type FrePageHandlerFactory_CreatePageHandler_Params = FrePageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<FrePageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    FrePageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'FrePageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<FrePageHandlerFactory_CreatePageHandler_ParamsMojoType, FrePageHandlerPendingReceiver>(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(FrePageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface FrePageHandler_AcceptFre_ParamsMojoType {
}


export type FrePageHandler_AcceptFre_Params = FrePageHandler_AcceptFre_ParamsMojoType;
mojo.internal.Struct<FrePageHandler_AcceptFre_ParamsMojoType>(
    FrePageHandler_AcceptFre_ParamsSpec.$,
    'FrePageHandler_AcceptFre_Params',
    [
    ],
    [[0, 8],]);





export interface FrePageHandler_RejectFre_ParamsMojoType {
}


export type FrePageHandler_RejectFre_Params = FrePageHandler_RejectFre_ParamsMojoType;
mojo.internal.Struct<FrePageHandler_RejectFre_ParamsMojoType>(
    FrePageHandler_RejectFre_ParamsSpec.$,
    'FrePageHandler_RejectFre_Params',
    [
    ],
    [[0, 8],]);





export interface FrePageHandler_DismissFre_ParamsMojoType {
  panel: FreWebUiState;
}


export type FrePageHandler_DismissFre_Params = FrePageHandler_DismissFre_ParamsMojoType;
mojo.internal.Struct<FrePageHandler_DismissFre_ParamsMojoType>(
    FrePageHandler_DismissFre_ParamsSpec.$,
    'FrePageHandler_DismissFre_Params',
    [
      mojo.internal.StructField<FrePageHandler_DismissFre_ParamsMojoType, FreWebUiState>(
        'panel', 0,
        0,
        FreWebUiStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface FrePageHandler_FreReloaded_ParamsMojoType {
}


export type FrePageHandler_FreReloaded_Params = FrePageHandler_FreReloaded_ParamsMojoType;
mojo.internal.Struct<FrePageHandler_FreReloaded_ParamsMojoType>(
    FrePageHandler_FreReloaded_ParamsSpec.$,
    'FrePageHandler_FreReloaded_Params',
    [
    ],
    [[0, 8],]);





export interface FrePageHandler_PrepareForClient_ParamsMojoType {
}


export type FrePageHandler_PrepareForClient_Params = FrePageHandler_PrepareForClient_ParamsMojoType;
mojo.internal.Struct<FrePageHandler_PrepareForClient_ParamsMojoType>(
    FrePageHandler_PrepareForClient_ParamsSpec.$,
    'FrePageHandler_PrepareForClient_Params',
    [
    ],
    [[0, 8],]);





export interface FrePageHandler_PrepareForClient_ResponseParamsMojoType {
  success: boolean;
}


export type FrePageHandler_PrepareForClient_ResponseParams = FrePageHandler_PrepareForClient_ResponseParamsMojoType;
mojo.internal.Struct<FrePageHandler_PrepareForClient_ResponseParamsMojoType>(
    FrePageHandler_PrepareForClient_ResponseParamsSpec.$,
    'FrePageHandler_PrepareForClient_ResponseParams',
    [
      mojo.internal.StructField<FrePageHandler_PrepareForClient_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsMojoType {
  url: url_mojom_Url;
}


export type FrePageHandler_ValidateAndOpenLinkInNewTab_Params = FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsMojoType;
mojo.internal.Struct<FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsMojoType>(
    FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsSpec.$,
    'FrePageHandler_ValidateAndOpenLinkInNewTab_Params',
    [
      mojo.internal.StructField<FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface FrePageHandler_WebUiStateChanged_ParamsMojoType {
  newState: FreWebUiState;
}


export type FrePageHandler_WebUiStateChanged_Params = FrePageHandler_WebUiStateChanged_ParamsMojoType;
mojo.internal.Struct<FrePageHandler_WebUiStateChanged_ParamsMojoType>(
    FrePageHandler_WebUiStateChanged_ParamsSpec.$,
    'FrePageHandler_WebUiStateChanged_Params',
    [
      mojo.internal.StructField<FrePageHandler_WebUiStateChanged_ParamsMojoType, FreWebUiState>(
        'newState', 0,
        0,
        FreWebUiStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface FrePageHandler_ExceededTimeoutError_ParamsMojoType {
}


export type FrePageHandler_ExceededTimeoutError_Params = FrePageHandler_ExceededTimeoutError_ParamsMojoType;
mojo.internal.Struct<FrePageHandler_ExceededTimeoutError_ParamsMojoType>(
    FrePageHandler_ExceededTimeoutError_ParamsSpec.$,
    'FrePageHandler_ExceededTimeoutError_Params',
    [
    ],
    [[0, 8],]);





export interface FrePageHandler_LogWebUiLoadComplete_ParamsMojoType {
}


export type FrePageHandler_LogWebUiLoadComplete_Params = FrePageHandler_LogWebUiLoadComplete_ParamsMojoType;
mojo.internal.Struct<FrePageHandler_LogWebUiLoadComplete_ParamsMojoType>(
    FrePageHandler_LogWebUiLoadComplete_ParamsSpec.$,
    'FrePageHandler_LogWebUiLoadComplete_Params',
    [
    ],
    [[0, 8],]);



