// chrome/browser/ui/webui/downloads/downloads.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const DangerTypeSpec = { $: mojo.internal.Enum() };
export var DangerType;
(function (DangerType) {
    DangerType[DangerType["MIN_VALUE"] = 0] = "MIN_VALUE";
    DangerType[DangerType["MAX_VALUE"] = 17] = "MAX_VALUE";
    DangerType[DangerType["kNoApplicableDangerType"] = 0] = "kNoApplicableDangerType";
    DangerType[DangerType["kDangerousFile"] = 1] = "kDangerousFile";
    DangerType[DangerType["kDangerousUrl"] = 2] = "kDangerousUrl";
    DangerType[DangerType["kDangerousContent"] = 3] = "kDangerousContent";
    DangerType[DangerType["kCookieTheft"] = 4] = "kCookieTheft";
    DangerType[DangerType["kUncommonContent"] = 5] = "kUncommonContent";
    DangerType[DangerType["kDangerousHost"] = 6] = "kDangerousHost";
    DangerType[DangerType["kPotentiallyUnwanted"] = 7] = "kPotentiallyUnwanted";
    DangerType[DangerType["kAsyncScanning"] = 8] = "kAsyncScanning";
    DangerType[DangerType["kAsyncLocalPasswordScanning"] = 9] = "kAsyncLocalPasswordScanning";
    DangerType[DangerType["kBlockedPasswordProtected"] = 10] = "kBlockedPasswordProtected";
    DangerType[DangerType["kBlockedTooLarge"] = 11] = "kBlockedTooLarge";
    DangerType[DangerType["kSensitiveContentWarning"] = 12] = "kSensitiveContentWarning";
    DangerType[DangerType["kSensitiveContentBlock"] = 13] = "kSensitiveContentBlock";
    DangerType[DangerType["kDeepScannedFailed"] = 14] = "kDeepScannedFailed";
    DangerType[DangerType["kDeepScannedSafe"] = 15] = "kDeepScannedSafe";
    DangerType[DangerType["kDeepScannedOpenedDangerous"] = 16] = "kDeepScannedOpenedDangerous";
    DangerType[DangerType["kBlockedScanFailed"] = 17] = "kBlockedScanFailed";
})(DangerType || (DangerType = {}));
export const TailoredWarningTypeSpec = { $: mojo.internal.Enum() };
export var TailoredWarningType;
(function (TailoredWarningType) {
    TailoredWarningType[TailoredWarningType["MIN_VALUE"] = 0] = "MIN_VALUE";
    TailoredWarningType[TailoredWarningType["MAX_VALUE"] = 2] = "MAX_VALUE";
    TailoredWarningType[TailoredWarningType["kNoApplicableTailoredWarningType"] = 0] = "kNoApplicableTailoredWarningType";
    TailoredWarningType[TailoredWarningType["kCookieTheft"] = 1] = "kCookieTheft";
    TailoredWarningType[TailoredWarningType["kSuspiciousArchive"] = 2] = "kSuspiciousArchive";
})(TailoredWarningType || (TailoredWarningType = {}));
export const StateSpec = { $: mojo.internal.Enum() };
export var State;
(function (State) {
    State[State["MIN_VALUE"] = 0] = "MIN_VALUE";
    State[State["MAX_VALUE"] = 9] = "MAX_VALUE";
    State[State["kInProgress"] = 0] = "kInProgress";
    State[State["kCancelled"] = 1] = "kCancelled";
    State[State["kComplete"] = 2] = "kComplete";
    State[State["kPaused"] = 3] = "kPaused";
    State[State["kDangerous"] = 4] = "kDangerous";
    State[State["kInterrupted"] = 5] = "kInterrupted";
    State[State["kInsecure"] = 6] = "kInsecure";
    State[State["kAsyncScanning"] = 7] = "kAsyncScanning";
    State[State["kPromptForScanning"] = 8] = "kPromptForScanning";
    State[State["kPromptForLocalPasswordScanning"] = 9] = "kPromptForLocalPasswordScanning";
})(State || (State = {}));
export const SafeBrowsingStateSpec = { $: mojo.internal.Enum() };
export var SafeBrowsingState;
(function (SafeBrowsingState) {
    SafeBrowsingState[SafeBrowsingState["MIN_VALUE"] = 0] = "MIN_VALUE";
    SafeBrowsingState[SafeBrowsingState["MAX_VALUE"] = 2] = "MAX_VALUE";
    SafeBrowsingState[SafeBrowsingState["kNoSafeBrowsing"] = 0] = "kNoSafeBrowsing";
    SafeBrowsingState[SafeBrowsingState["kStandardProtection"] = 1] = "kStandardProtection";
    SafeBrowsingState[SafeBrowsingState["kEnhancedProtection"] = 2] = "kEnhancedProtection";
})(SafeBrowsingState || (SafeBrowsingState = {}));
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'downloads.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "downloads.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'downloads.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getDownloads(searchTerms) {
        this.proxy.sendMessage(0, PageHandler_GetDownloads_ParamsSpec.$, null, [
            searchTerms
        ], false);
    }
    openFileRequiringGesture(id) {
        this.proxy.sendMessage(1, PageHandler_OpenFileRequiringGesture_ParamsSpec.$, null, [
            id
        ], false);
    }
    drag(id) {
        this.proxy.sendMessage(2, PageHandler_Drag_ParamsSpec.$, null, [
            id
        ], false);
    }
    saveSuspiciousRequiringGesture(id) {
        this.proxy.sendMessage(3, PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec.$, null, [
            id
        ], false);
    }
    recordOpenBypassWarningDialog(id) {
        this.proxy.sendMessage(4, PageHandler_RecordOpenBypassWarningDialog_ParamsSpec.$, null, [
            id
        ], false);
    }
    saveDangerousFromDialogRequiringGesture(id) {
        this.proxy.sendMessage(5, PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec.$, null, [
            id
        ], false);
    }
    recordCancelBypassWarningDialog(id) {
        this.proxy.sendMessage(6, PageHandler_RecordCancelBypassWarningDialog_ParamsSpec.$, null, [
            id
        ], false);
    }
    discardDangerous(id) {
        this.proxy.sendMessage(7, PageHandler_DiscardDangerous_ParamsSpec.$, null, [
            id
        ], false);
    }
    retryDownload(id) {
        this.proxy.sendMessage(8, PageHandler_RetryDownload_ParamsSpec.$, null, [
            id
        ], false);
    }
    show(id) {
        this.proxy.sendMessage(9, PageHandler_Show_ParamsSpec.$, null, [
            id
        ], false);
    }
    pause(id) {
        this.proxy.sendMessage(10, PageHandler_Pause_ParamsSpec.$, null, [
            id
        ], false);
    }
    resume(id) {
        this.proxy.sendMessage(11, PageHandler_Resume_ParamsSpec.$, null, [
            id
        ], false);
    }
    remove(id) {
        this.proxy.sendMessage(12, PageHandler_Remove_ParamsSpec.$, null, [
            id
        ], false);
    }
    undo() {
        this.proxy.sendMessage(13, PageHandler_Undo_ParamsSpec.$, null, [], false);
    }
    cancel(id) {
        this.proxy.sendMessage(14, PageHandler_Cancel_ParamsSpec.$, null, [
            id
        ], false);
    }
    clearAll() {
        this.proxy.sendMessage(15, PageHandler_ClearAll_ParamsSpec.$, null, [], false);
    }
    openDownloadsFolderRequiringGesture() {
        this.proxy.sendMessage(16, PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec.$, null, [], false);
    }
    openEsbSettings() {
        this.proxy.sendMessage(17, PageHandler_OpenEsbSettings_ParamsSpec.$, null, [], false);
    }
    logEsbPromotionRowViewed() {
        this.proxy.sendMessage(18, PageHandler_LogEsbPromotionRowViewed_ParamsSpec.$, null, [], false);
    }
    openDuringScanningRequiringGesture(id) {
        this.proxy.sendMessage(19, PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec.$, null, [
            id
        ], false);
    }
    reviewDangerousRequiringGesture(id) {
        this.proxy.sendMessage(20, PageHandler_ReviewDangerousRequiringGesture_ParamsSpec.$, null, [
            id
        ], false);
    }
    deepScan(id) {
        this.proxy.sendMessage(21, PageHandler_DeepScan_ParamsSpec.$, null, [
            id
        ], false);
    }
    bypassDeepScanRequiringGesture(id) {
        this.proxy.sendMessage(22, PageHandler_BypassDeepScanRequiringGesture_ParamsSpec.$, null, [
            id
        ], false);
    }
    isEligibleForEsbPromo() {
        return this.proxy.sendMessage(23, PageHandler_IsEligibleForEsbPromo_ParamsSpec.$, PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetDownloads_ParamsSpec.$, null, impl.getDownloads.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_OpenFileRequiringGesture_ParamsSpec.$, null, impl.openFileRequiringGesture.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_Drag_ParamsSpec.$, null, impl.drag.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec.$, null, impl.saveSuspiciousRequiringGesture.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_RecordOpenBypassWarningDialog_ParamsSpec.$, null, impl.recordOpenBypassWarningDialog.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec.$, null, impl.saveDangerousFromDialogRequiringGesture.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_RecordCancelBypassWarningDialog_ParamsSpec.$, null, impl.recordCancelBypassWarningDialog.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_DiscardDangerous_ParamsSpec.$, null, impl.discardDangerous.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_RetryDownload_ParamsSpec.$, null, impl.retryDownload.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_Show_ParamsSpec.$, null, impl.show.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_Pause_ParamsSpec.$, null, impl.pause.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_Resume_ParamsSpec.$, null, impl.resume.bind(impl), false);
        this.helper_internal_.registerHandler(12, PageHandler_Remove_ParamsSpec.$, null, impl.remove.bind(impl), false);
        this.helper_internal_.registerHandler(13, PageHandler_Undo_ParamsSpec.$, null, impl.undo.bind(impl), false);
        this.helper_internal_.registerHandler(14, PageHandler_Cancel_ParamsSpec.$, null, impl.cancel.bind(impl), false);
        this.helper_internal_.registerHandler(15, PageHandler_ClearAll_ParamsSpec.$, null, impl.clearAll.bind(impl), false);
        this.helper_internal_.registerHandler(16, PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec.$, null, impl.openDownloadsFolderRequiringGesture.bind(impl), false);
        this.helper_internal_.registerHandler(17, PageHandler_OpenEsbSettings_ParamsSpec.$, null, impl.openEsbSettings.bind(impl), false);
        this.helper_internal_.registerHandler(18, PageHandler_LogEsbPromotionRowViewed_ParamsSpec.$, null, impl.logEsbPromotionRowViewed.bind(impl), false);
        this.helper_internal_.registerHandler(19, PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec.$, null, impl.openDuringScanningRequiringGesture.bind(impl), false);
        this.helper_internal_.registerHandler(20, PageHandler_ReviewDangerousRequiringGesture_ParamsSpec.$, null, impl.reviewDangerousRequiringGesture.bind(impl), false);
        this.helper_internal_.registerHandler(21, PageHandler_DeepScan_ParamsSpec.$, null, impl.deepScan.bind(impl), false);
        this.helper_internal_.registerHandler(22, PageHandler_BypassDeepScanRequiringGesture_ParamsSpec.$, null, impl.bypassDeepScanRequiringGesture.bind(impl), false);
        this.helper_internal_.registerHandler(23, PageHandler_IsEligibleForEsbPromo_ParamsSpec.$, PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec.$, impl.isEligibleForEsbPromo.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "downloads.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getDownloads;
    openFileRequiringGesture;
    drag;
    saveSuspiciousRequiringGesture;
    recordOpenBypassWarningDialog;
    saveDangerousFromDialogRequiringGesture;
    recordCancelBypassWarningDialog;
    discardDangerous;
    retryDownload;
    show;
    pause;
    resume;
    remove;
    undo;
    cancel;
    clearAll;
    openDownloadsFolderRequiringGesture;
    openEsbSettings;
    logEsbPromotionRowViewed;
    openDuringScanningRequiringGesture;
    reviewDangerousRequiringGesture;
    deepScan;
    bypassDeepScanRequiringGesture;
    isEligibleForEsbPromo;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getDownloads =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetDownloads_ParamsSpec.$, null, this.getDownloads.createReceiverHandler(false /* expectsResponse */), false);
        this.openFileRequiringGesture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_OpenFileRequiringGesture_ParamsSpec.$, null, this.openFileRequiringGesture.createReceiverHandler(false /* expectsResponse */), false);
        this.drag =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_Drag_ParamsSpec.$, null, this.drag.createReceiverHandler(false /* expectsResponse */), false);
        this.saveSuspiciousRequiringGesture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec.$, null, this.saveSuspiciousRequiringGesture.createReceiverHandler(false /* expectsResponse */), false);
        this.recordOpenBypassWarningDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_RecordOpenBypassWarningDialog_ParamsSpec.$, null, this.recordOpenBypassWarningDialog.createReceiverHandler(false /* expectsResponse */), false);
        this.saveDangerousFromDialogRequiringGesture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec.$, null, this.saveDangerousFromDialogRequiringGesture.createReceiverHandler(false /* expectsResponse */), false);
        this.recordCancelBypassWarningDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_RecordCancelBypassWarningDialog_ParamsSpec.$, null, this.recordCancelBypassWarningDialog.createReceiverHandler(false /* expectsResponse */), false);
        this.discardDangerous =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_DiscardDangerous_ParamsSpec.$, null, this.discardDangerous.createReceiverHandler(false /* expectsResponse */), false);
        this.retryDownload =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_RetryDownload_ParamsSpec.$, null, this.retryDownload.createReceiverHandler(false /* expectsResponse */), false);
        this.show =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_Show_ParamsSpec.$, null, this.show.createReceiverHandler(false /* expectsResponse */), false);
        this.pause =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_Pause_ParamsSpec.$, null, this.pause.createReceiverHandler(false /* expectsResponse */), false);
        this.resume =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_Resume_ParamsSpec.$, null, this.resume.createReceiverHandler(false /* expectsResponse */), false);
        this.remove =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, PageHandler_Remove_ParamsSpec.$, null, this.remove.createReceiverHandler(false /* expectsResponse */), false);
        this.undo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, PageHandler_Undo_ParamsSpec.$, null, this.undo.createReceiverHandler(false /* expectsResponse */), false);
        this.cancel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, PageHandler_Cancel_ParamsSpec.$, null, this.cancel.createReceiverHandler(false /* expectsResponse */), false);
        this.clearAll =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, PageHandler_ClearAll_ParamsSpec.$, null, this.clearAll.createReceiverHandler(false /* expectsResponse */), false);
        this.openDownloadsFolderRequiringGesture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec.$, null, this.openDownloadsFolderRequiringGesture.createReceiverHandler(false /* expectsResponse */), false);
        this.openEsbSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, PageHandler_OpenEsbSettings_ParamsSpec.$, null, this.openEsbSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.logEsbPromotionRowViewed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, PageHandler_LogEsbPromotionRowViewed_ParamsSpec.$, null, this.logEsbPromotionRowViewed.createReceiverHandler(false /* expectsResponse */), false);
        this.openDuringScanningRequiringGesture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec.$, null, this.openDuringScanningRequiringGesture.createReceiverHandler(false /* expectsResponse */), false);
        this.reviewDangerousRequiringGesture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, PageHandler_ReviewDangerousRequiringGesture_ParamsSpec.$, null, this.reviewDangerousRequiringGesture.createReceiverHandler(false /* expectsResponse */), false);
        this.deepScan =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, PageHandler_DeepScan_ParamsSpec.$, null, this.deepScan.createReceiverHandler(false /* expectsResponse */), false);
        this.bypassDeepScanRequiringGesture =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, PageHandler_BypassDeepScanRequiringGesture_ParamsSpec.$, null, this.bypassDeepScanRequiringGesture.createReceiverHandler(false /* expectsResponse */), false);
        this.isEligibleForEsbPromo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, PageHandler_IsEligibleForEsbPromo_ParamsSpec.$, PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec.$, this.isEligibleForEsbPromo.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'downloads.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    removeItem(index) {
        this.proxy.sendMessage(0, Page_RemoveItem_ParamsSpec.$, null, [
            index
        ], false);
    }
    updateItem(index, data) {
        this.proxy.sendMessage(1, Page_UpdateItem_ParamsSpec.$, null, [
            index,
            data
        ], false);
    }
    insertItems(index, items) {
        this.proxy.sendMessage(2, Page_InsertItems_ParamsSpec.$, null, [
            index,
            items
        ], false);
    }
    clearAll() {
        this.proxy.sendMessage(3, Page_ClearAll_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_RemoveItem_ParamsSpec.$, null, impl.removeItem.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_UpdateItem_ParamsSpec.$, null, impl.updateItem.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_InsertItems_ParamsSpec.$, null, impl.insertItems.bind(impl), false);
        this.helper_internal_.registerHandler(3, Page_ClearAll_ParamsSpec.$, null, impl.clearAll.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "downloads.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    removeItem;
    updateItem;
    insertItems;
    clearAll;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.removeItem =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_RemoveItem_ParamsSpec.$, null, this.removeItem.createReceiverHandler(false /* expectsResponse */), false);
        this.updateItem =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_UpdateItem_ParamsSpec.$, null, this.updateItem.createReceiverHandler(false /* expectsResponse */), false);
        this.insertItems =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_InsertItems_ParamsSpec.$, null, this.insertItems.createReceiverHandler(false /* expectsResponse */), false);
        this.clearAll =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Page_ClearAll_ParamsSpec.$, null, this.clearAll.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const DataSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_GetDownloads_ParamsSpec = { $: {} };
export const PageHandler_OpenFileRequiringGesture_ParamsSpec = { $: {} };
export const PageHandler_Drag_ParamsSpec = { $: {} };
export const PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec = { $: {} };
export const PageHandler_RecordOpenBypassWarningDialog_ParamsSpec = { $: {} };
export const PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec = { $: {} };
export const PageHandler_RecordCancelBypassWarningDialog_ParamsSpec = { $: {} };
export const PageHandler_DiscardDangerous_ParamsSpec = { $: {} };
export const PageHandler_RetryDownload_ParamsSpec = { $: {} };
export const PageHandler_Show_ParamsSpec = { $: {} };
export const PageHandler_Pause_ParamsSpec = { $: {} };
export const PageHandler_Resume_ParamsSpec = { $: {} };
export const PageHandler_Remove_ParamsSpec = { $: {} };
export const PageHandler_Undo_ParamsSpec = { $: {} };
export const PageHandler_Cancel_ParamsSpec = { $: {} };
export const PageHandler_ClearAll_ParamsSpec = { $: {} };
export const PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec = { $: {} };
export const PageHandler_OpenEsbSettings_ParamsSpec = { $: {} };
export const PageHandler_LogEsbPromotionRowViewed_ParamsSpec = { $: {} };
export const PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec = { $: {} };
export const PageHandler_ReviewDangerousRequiringGesture_ParamsSpec = { $: {} };
export const PageHandler_DeepScan_ParamsSpec = { $: {} };
export const PageHandler_BypassDeepScanRequiringGesture_ParamsSpec = { $: {} };
export const PageHandler_IsEligibleForEsbPromo_ParamsSpec = { $: {} };
export const PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec = { $: {} };
export const Page_RemoveItem_ParamsSpec = { $: {} };
export const Page_UpdateItem_ParamsSpec = { $: {} };
export const Page_InsertItems_ParamsSpec = { $: {} };
export const Page_ClearAll_ParamsSpec = { $: {} };
mojo.internal.Struct(DataSpec.$, 'Data', [
    mojo.internal.StructField('fileExternallyRemoved', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isDangerous', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isInsecure', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isReviewable', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('otr', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resume', 0, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('retry', 0, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('percent', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('started', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('total', 16, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('byExtId', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('byExtName', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dangerType', 12, 0, DangerTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tailoredWarningType', 40, 0, TailoredWarningTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dateString', 48, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fileName', 56, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('filePath', 64, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fileUrl', 72, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 80, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastReasonText', 88, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('progressStatusText', 96, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showInFolderText', 104, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sinceString', 112, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('state', 44, 0, StateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayInitiatorOrigin', 120, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 128, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayUrl', 136, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('safeBrowsingState', 144, 0, SafeBrowsingStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasSafeBrowsingVerdict', 0, 7, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 160],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetDownloads_ParamsSpec.$, 'PageHandler_GetDownloads_Params', [
    mojo.internal.StructField('searchTerms', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenFileRequiringGesture_ParamsSpec.$, 'PageHandler_OpenFileRequiringGesture_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_Drag_ParamsSpec.$, 'PageHandler_Drag_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec.$, 'PageHandler_SaveSuspiciousRequiringGesture_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RecordOpenBypassWarningDialog_ParamsSpec.$, 'PageHandler_RecordOpenBypassWarningDialog_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec.$, 'PageHandler_SaveDangerousFromDialogRequiringGesture_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RecordCancelBypassWarningDialog_ParamsSpec.$, 'PageHandler_RecordCancelBypassWarningDialog_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_DiscardDangerous_ParamsSpec.$, 'PageHandler_DiscardDangerous_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RetryDownload_ParamsSpec.$, 'PageHandler_RetryDownload_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_Show_ParamsSpec.$, 'PageHandler_Show_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_Pause_ParamsSpec.$, 'PageHandler_Pause_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_Resume_ParamsSpec.$, 'PageHandler_Resume_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_Remove_ParamsSpec.$, 'PageHandler_Remove_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_Undo_ParamsSpec.$, 'PageHandler_Undo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_Cancel_ParamsSpec.$, 'PageHandler_Cancel_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ClearAll_ParamsSpec.$, 'PageHandler_ClearAll_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec.$, 'PageHandler_OpenDownloadsFolderRequiringGesture_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenEsbSettings_ParamsSpec.$, 'PageHandler_OpenEsbSettings_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_LogEsbPromotionRowViewed_ParamsSpec.$, 'PageHandler_LogEsbPromotionRowViewed_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec.$, 'PageHandler_OpenDuringScanningRequiringGesture_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ReviewDangerousRequiringGesture_ParamsSpec.$, 'PageHandler_ReviewDangerousRequiringGesture_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_DeepScan_ParamsSpec.$, 'PageHandler_DeepScan_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_BypassDeepScanRequiringGesture_ParamsSpec.$, 'PageHandler_BypassDeepScanRequiringGesture_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_IsEligibleForEsbPromo_ParamsSpec.$, 'PageHandler_IsEligibleForEsbPromo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec.$, 'PageHandler_IsEligibleForEsbPromo_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_RemoveItem_ParamsSpec.$, 'Page_RemoveItem_Params', [
    mojo.internal.StructField('index', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_UpdateItem_ParamsSpec.$, 'Page_UpdateItem_Params', [
    mojo.internal.StructField('index', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('data', 8, 0, DataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_InsertItems_ParamsSpec.$, 'Page_InsertItems_Params', [
    mojo.internal.StructField('index', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('items', 8, 0, mojo.internal.Array(DataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_ClearAll_ParamsSpec.$, 'Page_ClearAll_Params', [], [[0, 8],]);
