import './icons.html.js';
import '/strings.m.js';
import './textarea.js';
import './result_text.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_chip/cr_chip.js';
import '//resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_loading_gradient/cr_loading_gradient.js';
import '//resources/cr_elements/cr_scrollable.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/icons.html.js';
import '//resources/cr_elements/md_select.css.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import type { CrButtonElement } from '//resources/cr_elements/cr_button/cr_button.js';
import type { CrChipElement } from '//resources/cr_elements/cr_chip/cr_chip.js';
import type { CrFeedbackButtonsElement } from '//resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js';
import { CrFeedbackOption } from '//resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { InputMode, StyleModifier } from './compose.mojom-webui.js';
import type { ComposeResultTextElement } from './result_text.js';
import type { ComposeTextareaElement } from './textarea.js';
export interface ComposeAppState {
    editedInput?: string;
    input: string;
    inputMode: InputMode;
    isEditingSubmittedInput?: boolean;
}
export interface ComposeAppElement {
    $: {
        firstRunDialog: HTMLElement;
        firstRunFooter: HTMLElement;
        firstRunOkButton: CrButtonElement;
        freMsbbDialog: HTMLElement;
        appDialog: HTMLElement;
        body: HTMLElement;
        bodyAndFooter: HTMLElement;
        cancelEditButton: CrButtonElement;
        closeButton: HTMLElement;
        firstRunCloseButton: HTMLElement;
        closeButtonMSBB: HTMLElement;
        editTextarea: ComposeTextareaElement;
        errorFooter: HTMLElement;
        errorGoBackButton: CrButtonElement;
        acceptButton: CrButtonElement;
        loading: HTMLElement;
        undoButton: CrButtonElement;
        redoButton: CrButtonElement;
        resultContainer: HTMLElement;
        resultTextContainer: HTMLElement;
        resultFooter: HTMLElement;
        submitButton: CrButtonElement;
        submitEditButton: CrButtonElement;
        submitFooter: HTMLElement;
        onDeviceUsedFooter: HTMLElement;
        textarea: ComposeTextareaElement;
        modifierMenu: HTMLSelectElement;
        resultText: ComposeResultTextElement;
        feedbackButtons: CrFeedbackButtonsElement;
        polishChip: CrChipElement;
        elaborateChip: CrChipElement;
        formalizeChip: CrChipElement;
    };
}
/**
 * Delay required for screen readers to read out consecutive messages while
 * focus is being moved between elements.
 */
export declare const TIMEOUT_MS: number;
declare const ComposeAppElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class ComposeAppElement extends ComposeAppElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        editedInput_: {
            type: StringConstructor;
            observer: string;
        };
        enableAnimations: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        enableUpfrontInputModes: {
            type: BooleanConstructor;
            value: boolean;
        };
        feedbackState_: {
            type: StringConstructor;
            value: CrFeedbackOption;
        };
        hasPartialOutput_: {
            type: BooleanConstructor;
        };
        input_: {
            type: StringConstructor;
            observer: string;
        };
        inputParams_: {
            type: ObjectConstructor;
        };
        isEditingSubmittedInput_: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
            observer: string;
        };
        isEditingResultText_: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        isEditSubmitEnabled_: {
            type: BooleanConstructor;
            value: boolean;
        };
        isSubmitEnabled_: {
            type: BooleanConstructor;
            value: boolean;
        };
        loading_: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        loadingIndicatorShown_: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            computed: string;
        };
        response_: {
            type: ObjectConstructor;
            value: null;
        };
        partialResponse_: {
            type: ObjectConstructor;
            value: null;
        };
        showInputModes_: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            computed: string;
        };
        selectedInputMode_: {
            type: NumberConstructor;
            value: InputMode;
        };
        selectedModifier_: {
            type: StringConstructor;
        };
        polishChipIcon_: {
            type: StringConstructor;
            value: string;
            reflectToAttribute: boolean;
        };
        elaborateChipIcon_: {
            type: StringConstructor;
            value: string;
            reflectToAttribute: boolean;
        };
        formalizeChipIcon_: {
            type: StringConstructor;
            value: string;
            reflectToAttribute: boolean;
        };
        textSelected_: {
            type: BooleanConstructor;
        };
        enterprise_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showMainAppDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        submitted_: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        undoEnabled_: {
            type: BooleanConstructor;
            value: boolean;
        };
        redoEnabled_: {
            type: BooleanConstructor;
            value: boolean;
        };
        feedbackEnabled_: {
            type: BooleanConstructor;
            value: boolean;
        };
        responseText_: {
            type: StringConstructor;
            computed: string;
        };
        showFirstRunDialog_: {
            type: BooleanConstructor;
        };
        showMSBBDialog_: {
            type: BooleanConstructor;
        };
        outputComplete_: {
            type: BooleanConstructor;
            value: boolean;
        };
        hasOutput_: {
            type: BooleanConstructor;
            value: boolean;
        };
        displayedText_: {
            type: StringConstructor;
        };
        modifierOptions_: {
            type: ArrayConstructor;
            value: () => ({
                value: StyleModifier;
                label: string;
                isDefault: boolean;
            } | {
                value: StyleModifier;
                label: string;
                isDefault?: undefined;
            })[];
        };
    };
    static get observers(): string[];
    enableAnimations: boolean;
    enableUpfrontInputModes: boolean;
    private animator_;
    private apiProxy_;
    private eventTracker_;
    private router_;
    private hasPartialOutput_;
    private showFirstRunDialog_;
    private showMainAppDialog_;
    private showMSBBDialog_;
    private shouldShowMSBBDialog_;
    private editedInput_;
    private feedbackState_;
    private input_;
    private inputParams_;
    private isEditingSubmittedInput_;
    private isEditingResultText_;
    private isEditSubmitEnabled_;
    private isSubmitEnabled_;
    private loading_;
    private loadingIndicatorShown_;
    private response_;
    private partialResponse_;
    private showInputModes_;
    private saveAppStateDebouncer_;
    private scrollCheckDebouncer_;
    private updateResultCompleteDebouncer_;
    private selectedInputMode_;
    private selectedModifier_;
    private polishChipIcon_;
    private elaborateChipIcon_;
    private formalizeChipIcon_;
    private textSelected_;
    private enterprise_;
    private submitted_;
    private undoEnabled_;
    private redoEnabled_;
    private feedbackEnabled_;
    private userHasModifiedState_;
    private lastTriggerElement_;
    private outputComplete_;
    private hasOutput_;
    private displayedText_;
    private modifierOptions_;
    private responseText_;
    private userResponseText_;
    constructor();
    private getResponseText_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private debounceSaveComposeAppState_;
    private getInitialState_;
    private getTrimmedResult_;
    private getTrimmedPartialResult_;
    private onFirstRunOkButtonClick_;
    private onFirstRunBottomTextClick_;
    private onCancelEditClick_;
    private onClose_;
    private onEditedInputChanged_;
    private onEditClick_;
    private onIsEditingSubmittedInputChanged_;
    private onSubmit_;
    private onSubmitEdit_;
    private onAccept_;
    private onInputChanged_;
    private onModifierChanged_;
    private shouldShowInputModes_;
    private onPolishChipClick_;
    private onElaborateChipClick_;
    private onFormalizeChipClick_;
    private updateInputMode_;
    private openModifierMenuOnKeyDown_;
    private onFooterClick_;
    private onMsbbSettingsClick_;
    private compose_;
    private rewrite_;
    private debounceUpdateResultComplete_;
    private updateResultComplete_;
    private composeResponseReceived_;
    private partialComposeResponseReceived_;
    private isLoadingIndicatorShown_;
    private hideResults_;
    private hasSuccessfulResponse_;
    private hasPartialResponse_;
    private hasPartialOrCompleteResponse_;
    private hasFailedResponse_;
    private hasErrorWithLink_;
    private hasUnsupportedLanguageResponse_;
    private hasPermissionDeniedResponse_;
    private onDeviceEvaluationUsed_;
    private showOnDeviceDogfoodFooter_;
    private acceptButtonText_;
    private failedResponseErrorText_;
    private isBackFromErrorAvailable_;
    private onResultEdit_;
    private onSetResultFocus_;
    private saveComposeAppState_;
    private onUndoClick_;
    private onErrorGoBackButton_;
    private onRedoClick_;
    private updateWithNewState_;
    private screenReaderAnnounce_;
    private onFeedbackSelectedOptionChanged_;
}
declare global {
    interface HTMLElementTagNameMap {
        'compose-app': ComposeAppElement;
    }
}
export {};
