// chrome/common/compose/compose.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ComposeStatusSpec as compose_mojom_ComposeStatusSpec,
  ComposeStatus as compose_mojom_ComposeStatus
} from './compose_enums.mojom-webui.js';





export const InputModeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum InputMode {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kUnset = 0,
  kPolish = 1,
  kElaborate = 2,
  kFormalize = 3,
}

export const StyleModifierSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum StyleModifier {

  MIN_VALUE = 0,
  MAX_VALUE = 5,
  kUnset = 0,
  kFormal = 1,
  kCasual = 2,
  kLonger = 3,
  kShorter = 4,
  kRetry = 5,
}

export const CloseReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CloseReason {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kFirstRunCloseButton = 0,
  kCloseButton = 1,
  kInsertButton = 2,
  kMSBBCloseButton = 3,
}

export const UserFeedbackSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UserFeedback {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUserFeedbackUnspecified = 0,
  kUserFeedbackNegative = 1,
  kUserFeedbackPositive = 2,
}



export type ComposeSessionUntrustedPageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ComposeSessionUntrustedPageHandlerFactoryPendingReceiver>;

export class ComposeSessionUntrustedPageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ComposeSessionUntrustedPageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<ComposeSessionUntrustedPageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|ComposeSessionUntrustedPageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'compose.mojom.ComposeSessionUntrustedPageHandlerFactory',
        scope);
  }
}

export interface ComposeSessionUntrustedPageHandlerFactoryInterface {
  createComposeSessionUntrustedPageHandler(clientHandler: ComposeClientUntrustedPageHandlerPendingReceiver, handler: ComposeSessionUntrustedPageHandlerPendingReceiver, dialog: ComposeUntrustedDialogRemote): void;
}

export class ComposeSessionUntrustedPageHandlerFactoryRemote implements ComposeSessionUntrustedPageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ComposeSessionUntrustedPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ComposeSessionUntrustedPageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ComposeSessionUntrustedPageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ComposeSessionUntrustedPageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createComposeSessionUntrustedPageHandler(
      clientHandler: ComposeClientUntrustedPageHandlerPendingReceiver,
      handler: ComposeSessionUntrustedPageHandlerPendingReceiver,
      dialog: ComposeUntrustedDialogRemote): void {
    this.proxy.sendMessage(
        0,
        ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsSpec.$,
        null,
        [
          clientHandler,
          handler,
          dialog
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ComposeSessionUntrustedPageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ComposeSessionUntrustedPageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ComposeSessionUntrustedPageHandlerFactoryRemote, ComposeSessionUntrustedPageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ComposeSessionUntrustedPageHandlerFactoryRemote, ComposeSessionUntrustedPageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ComposeSessionUntrustedPageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ComposeSessionUntrustedPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsSpec.$,
        null,
        impl.createComposeSessionUntrustedPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ComposeSessionUntrustedPageHandlerFactory {
  static get $interfaceName(): string {
    return "compose.mojom.ComposeSessionUntrustedPageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ComposeSessionUntrustedPageHandlerFactoryRemote {
    let remote = new ComposeSessionUntrustedPageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ComposeSessionUntrustedPageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ComposeSessionUntrustedPageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ComposeSessionUntrustedPageHandlerFactoryRemote, ComposeSessionUntrustedPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ComposeSessionUntrustedPageHandlerFactoryRemote, ComposeSessionUntrustedPageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createComposeSessionUntrustedPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ComposeSessionUntrustedPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createComposeSessionUntrustedPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsSpec.$,
        null,
        this.createComposeSessionUntrustedPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ComposeSessionUntrustedPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ComposeSessionUntrustedPageHandlerPendingReceiver>;

export class ComposeSessionUntrustedPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ComposeSessionUntrustedPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<ComposeSessionUntrustedPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|ComposeSessionUntrustedPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'compose.mojom.ComposeSessionUntrustedPageHandler',
        scope);
  }
}

export interface ComposeSessionUntrustedPageHandlerInterface {
  logCancelEdit(): void;
  compose(input: string, mode: InputMode, edited: boolean): void;
  rewrite(style: StyleModifier): void;
  logEditInput(): void;
  saveWebUIState(webuiState: string): void;
  acceptComposeResult(): Promise<{
        success: boolean, }>;
  requestInitialState(): Promise<{
        initialState: OpenMetadata, }>;
  undo(): Promise<{
        lastState: (ComposeState | null), }>;
  recoverFromErrorState(): Promise<{
        stateBeforeError: (ComposeState | null), }>;
  redo(): Promise<{
        nextState: (ComposeState | null), }>;
  openBugReportingLink(): void;
  openComposeLearnMorePage(): void;
  openEnterpriseComposeLearnMorePage(): void;
  openFeedbackSurveyLink(): void;
  openSignInPage(): void;
  setUserFeedback(feedback: UserFeedback): void;
  editResult(newResult: string): Promise<{
        isEdited: boolean, }>;
}

export class ComposeSessionUntrustedPageHandlerRemote implements ComposeSessionUntrustedPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ComposeSessionUntrustedPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ComposeSessionUntrustedPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ComposeSessionUntrustedPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ComposeSessionUntrustedPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  logCancelEdit(): void {
    this.proxy.sendMessage(
        0,
        ComposeSessionUntrustedPageHandler_LogCancelEdit_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  compose(
      input: string,
      mode: InputMode,
      edited: boolean): void {
    this.proxy.sendMessage(
        1,
        ComposeSessionUntrustedPageHandler_Compose_ParamsSpec.$,
        null,
        [
          input,
          mode,
          edited
        ],
        false);
  }

  rewrite(
      style: StyleModifier): void {
    this.proxy.sendMessage(
        2,
        ComposeSessionUntrustedPageHandler_Rewrite_ParamsSpec.$,
        null,
        [
          style
        ],
        false);
  }

  logEditInput(): void {
    this.proxy.sendMessage(
        3,
        ComposeSessionUntrustedPageHandler_LogEditInput_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  saveWebUIState(
      webuiState: string): void {
    this.proxy.sendMessage(
        4,
        ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsSpec.$,
        null,
        [
          webuiState
        ],
        false);
  }

  acceptComposeResult(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        5,
        ComposeSessionUntrustedPageHandler_AcceptComposeResult_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  requestInitialState(): Promise<{
        initialState: OpenMetadata, }> {
    return this.proxy.sendMessage(
        6,
        ComposeSessionUntrustedPageHandler_RequestInitialState_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  undo(): Promise<{
        lastState: (ComposeState | null), }> {
    return this.proxy.sendMessage(
        7,
        ComposeSessionUntrustedPageHandler_Undo_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_Undo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  recoverFromErrorState(): Promise<{
        stateBeforeError: (ComposeState | null), }> {
    return this.proxy.sendMessage(
        8,
        ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  redo(): Promise<{
        nextState: (ComposeState | null), }> {
    return this.proxy.sendMessage(
        9,
        ComposeSessionUntrustedPageHandler_Redo_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_Redo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  openBugReportingLink(): void {
    this.proxy.sendMessage(
        10,
        ComposeSessionUntrustedPageHandler_OpenBugReportingLink_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openComposeLearnMorePage(): void {
    this.proxy.sendMessage(
        11,
        ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openEnterpriseComposeLearnMorePage(): void {
    this.proxy.sendMessage(
        12,
        ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openFeedbackSurveyLink(): void {
    this.proxy.sendMessage(
        13,
        ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openSignInPage(): void {
    this.proxy.sendMessage(
        14,
        ComposeSessionUntrustedPageHandler_OpenSignInPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setUserFeedback(
      feedback: UserFeedback): void {
    this.proxy.sendMessage(
        15,
        ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsSpec.$,
        null,
        [
          feedback
        ],
        false);
  }

  editResult(
      newResult: string): Promise<{
        isEdited: boolean, }> {
    return this.proxy.sendMessage(
        16,
        ComposeSessionUntrustedPageHandler_EditResult_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsSpec.$,
        [
          newResult
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ComposeSessionUntrustedPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ComposeSessionUntrustedPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ComposeSessionUntrustedPageHandlerRemote, ComposeSessionUntrustedPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ComposeSessionUntrustedPageHandlerRemote, ComposeSessionUntrustedPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ComposeSessionUntrustedPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ComposeSessionUntrustedPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ComposeSessionUntrustedPageHandler_LogCancelEdit_ParamsSpec.$,
        null,
        impl.logCancelEdit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ComposeSessionUntrustedPageHandler_Compose_ParamsSpec.$,
        null,
        impl.compose.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ComposeSessionUntrustedPageHandler_Rewrite_ParamsSpec.$,
        null,
        impl.rewrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ComposeSessionUntrustedPageHandler_LogEditInput_ParamsSpec.$,
        null,
        impl.logEditInput.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsSpec.$,
        null,
        impl.saveWebUIState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ComposeSessionUntrustedPageHandler_AcceptComposeResult_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsSpec.$,
        impl.acceptComposeResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ComposeSessionUntrustedPageHandler_RequestInitialState_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsSpec.$,
        impl.requestInitialState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ComposeSessionUntrustedPageHandler_Undo_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_Undo_ResponseParamsSpec.$,
        impl.undo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsSpec.$,
        impl.recoverFromErrorState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        ComposeSessionUntrustedPageHandler_Redo_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_Redo_ResponseParamsSpec.$,
        impl.redo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        ComposeSessionUntrustedPageHandler_OpenBugReportingLink_ParamsSpec.$,
        null,
        impl.openBugReportingLink.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_ParamsSpec.$,
        null,
        impl.openComposeLearnMorePage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_ParamsSpec.$,
        null,
        impl.openEnterpriseComposeLearnMorePage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_ParamsSpec.$,
        null,
        impl.openFeedbackSurveyLink.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        ComposeSessionUntrustedPageHandler_OpenSignInPage_ParamsSpec.$,
        null,
        impl.openSignInPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsSpec.$,
        null,
        impl.setUserFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        ComposeSessionUntrustedPageHandler_EditResult_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsSpec.$,
        impl.editResult.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ComposeSessionUntrustedPageHandler {
  static get $interfaceName(): string {
    return "compose.mojom.ComposeSessionUntrustedPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ComposeSessionUntrustedPageHandlerRemote {
    let remote = new ComposeSessionUntrustedPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ComposeSessionUntrustedPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ComposeSessionUntrustedPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ComposeSessionUntrustedPageHandlerRemote, ComposeSessionUntrustedPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ComposeSessionUntrustedPageHandlerRemote, ComposeSessionUntrustedPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  logCancelEdit: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  compose: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  rewrite: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  logEditInput: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  saveWebUIState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  acceptComposeResult: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestInitialState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  undo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recoverFromErrorState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  redo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openBugReportingLink: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openComposeLearnMorePage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openEnterpriseComposeLearnMorePage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openFeedbackSurveyLink: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openSignInPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setUserFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  editResult: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ComposeSessionUntrustedPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.logCancelEdit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ComposeSessionUntrustedPageHandler_LogCancelEdit_ParamsSpec.$,
        null,
        this.logCancelEdit.createReceiverHandler(false /* expectsResponse */),
        false);
    this.compose =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ComposeSessionUntrustedPageHandler_Compose_ParamsSpec.$,
        null,
        this.compose.createReceiverHandler(false /* expectsResponse */),
        false);
    this.rewrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ComposeSessionUntrustedPageHandler_Rewrite_ParamsSpec.$,
        null,
        this.rewrite.createReceiverHandler(false /* expectsResponse */),
        false);
    this.logEditInput =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ComposeSessionUntrustedPageHandler_LogEditInput_ParamsSpec.$,
        null,
        this.logEditInput.createReceiverHandler(false /* expectsResponse */),
        false);
    this.saveWebUIState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsSpec.$,
        null,
        this.saveWebUIState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.acceptComposeResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ComposeSessionUntrustedPageHandler_AcceptComposeResult_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsSpec.$,
        this.acceptComposeResult.createReceiverHandler(true /* expectsResponse */),
        false);
    this.requestInitialState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ComposeSessionUntrustedPageHandler_RequestInitialState_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsSpec.$,
        this.requestInitialState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.undo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ComposeSessionUntrustedPageHandler_Undo_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_Undo_ResponseParamsSpec.$,
        this.undo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.recoverFromErrorState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsSpec.$,
        this.recoverFromErrorState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.redo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        ComposeSessionUntrustedPageHandler_Redo_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_Redo_ResponseParamsSpec.$,
        this.redo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openBugReportingLink =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        ComposeSessionUntrustedPageHandler_OpenBugReportingLink_ParamsSpec.$,
        null,
        this.openBugReportingLink.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openComposeLearnMorePage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_ParamsSpec.$,
        null,
        this.openComposeLearnMorePage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openEnterpriseComposeLearnMorePage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_ParamsSpec.$,
        null,
        this.openEnterpriseComposeLearnMorePage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openFeedbackSurveyLink =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_ParamsSpec.$,
        null,
        this.openFeedbackSurveyLink.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openSignInPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        ComposeSessionUntrustedPageHandler_OpenSignInPage_ParamsSpec.$,
        null,
        this.openSignInPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setUserFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsSpec.$,
        null,
        this.setUserFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    this.editResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        ComposeSessionUntrustedPageHandler_EditResult_ParamsSpec.$,
        ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsSpec.$,
        this.editResult.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ComposeClientUntrustedPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ComposeClientUntrustedPageHandlerPendingReceiver>;

export class ComposeClientUntrustedPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ComposeClientUntrustedPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<ComposeClientUntrustedPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|ComposeClientUntrustedPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'compose.mojom.ComposeClientUntrustedPageHandler',
        scope);
  }
}

export interface ComposeClientUntrustedPageHandlerInterface {
  showUI(): void;
  closeUI(reason: CloseReason): void;
  completeFirstRun(): void;
  openComposeSettings(): void;
}

export class ComposeClientUntrustedPageHandlerRemote implements ComposeClientUntrustedPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ComposeClientUntrustedPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ComposeClientUntrustedPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ComposeClientUntrustedPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ComposeClientUntrustedPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  showUI(): void {
    this.proxy.sendMessage(
        0,
        ComposeClientUntrustedPageHandler_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  closeUI(
      reason: CloseReason): void {
    this.proxy.sendMessage(
        1,
        ComposeClientUntrustedPageHandler_CloseUI_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }

  completeFirstRun(): void {
    this.proxy.sendMessage(
        2,
        ComposeClientUntrustedPageHandler_CompleteFirstRun_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openComposeSettings(): void {
    this.proxy.sendMessage(
        3,
        ComposeClientUntrustedPageHandler_OpenComposeSettings_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ComposeClientUntrustedPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ComposeClientUntrustedPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ComposeClientUntrustedPageHandlerRemote, ComposeClientUntrustedPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ComposeClientUntrustedPageHandlerRemote, ComposeClientUntrustedPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ComposeClientUntrustedPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ComposeClientUntrustedPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ComposeClientUntrustedPageHandler_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ComposeClientUntrustedPageHandler_CloseUI_ParamsSpec.$,
        null,
        impl.closeUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ComposeClientUntrustedPageHandler_CompleteFirstRun_ParamsSpec.$,
        null,
        impl.completeFirstRun.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ComposeClientUntrustedPageHandler_OpenComposeSettings_ParamsSpec.$,
        null,
        impl.openComposeSettings.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ComposeClientUntrustedPageHandler {
  static get $interfaceName(): string {
    return "compose.mojom.ComposeClientUntrustedPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ComposeClientUntrustedPageHandlerRemote {
    let remote = new ComposeClientUntrustedPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ComposeClientUntrustedPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ComposeClientUntrustedPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ComposeClientUntrustedPageHandlerRemote, ComposeClientUntrustedPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ComposeClientUntrustedPageHandlerRemote, ComposeClientUntrustedPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  showUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closeUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  completeFirstRun: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openComposeSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ComposeClientUntrustedPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ComposeClientUntrustedPageHandler_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closeUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ComposeClientUntrustedPageHandler_CloseUI_ParamsSpec.$,
        null,
        this.closeUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.completeFirstRun =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ComposeClientUntrustedPageHandler_CompleteFirstRun_ParamsSpec.$,
        null,
        this.completeFirstRun.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openComposeSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ComposeClientUntrustedPageHandler_OpenComposeSettings_ParamsSpec.$,
        null,
        this.openComposeSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ComposeUntrustedDialogPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ComposeUntrustedDialogPendingReceiver>;

export class ComposeUntrustedDialogPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ComposeUntrustedDialog> {

  handle: mojo.internal.interfaceSupport.Endpoint<ComposeUntrustedDialogPendingReceiver>;
  constructor(handle: MojoHandle|ComposeUntrustedDialogPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'compose.mojom.ComposeUntrustedDialog',
        scope);
  }
}

export interface ComposeUntrustedDialogInterface {
  responseReceived(response: ComposeResponse): void;
  partialResponseReceived(partialResponse: PartialComposeResponse): void;
}

export class ComposeUntrustedDialogRemote implements ComposeUntrustedDialogInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ComposeUntrustedDialogPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ComposeUntrustedDialogPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ComposeUntrustedDialogPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ComposeUntrustedDialogPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  responseReceived(
      response: ComposeResponse): void {
    this.proxy.sendMessage(
        0,
        ComposeUntrustedDialog_ResponseReceived_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }

  partialResponseReceived(
      partialResponse: PartialComposeResponse): void {
    this.proxy.sendMessage(
        1,
        ComposeUntrustedDialog_PartialResponseReceived_ParamsSpec.$,
        null,
        [
          partialResponse
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ComposeUntrustedDialog
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ComposeUntrustedDialogReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ComposeUntrustedDialogRemote, ComposeUntrustedDialogPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ComposeUntrustedDialogRemote, ComposeUntrustedDialogPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ComposeUntrustedDialogInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ComposeUntrustedDialogRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ComposeUntrustedDialog_ResponseReceived_ParamsSpec.$,
        null,
        impl.responseReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ComposeUntrustedDialog_PartialResponseReceived_ParamsSpec.$,
        null,
        impl.partialResponseReceived.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ComposeUntrustedDialog {
  static get $interfaceName(): string {
    return "compose.mojom.ComposeUntrustedDialog";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ComposeUntrustedDialogRemote {
    let remote = new ComposeUntrustedDialogRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ComposeUntrustedDialog
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ComposeUntrustedDialogCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ComposeUntrustedDialogRemote, ComposeUntrustedDialogPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ComposeUntrustedDialogRemote, ComposeUntrustedDialogPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  responseReceived: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  partialResponseReceived: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ComposeUntrustedDialogRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.responseReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ComposeUntrustedDialog_ResponseReceived_ParamsSpec.$,
        null,
        this.responseReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    this.partialResponseReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ComposeUntrustedDialog_PartialResponseReceived_ParamsSpec.$,
        null,
        this.partialResponseReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ComposeResponseSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PartialComposeResponseSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ConfigurableParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OpenMetadataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_LogCancelEdit_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_Compose_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_Rewrite_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_LogEditInput_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_AcceptComposeResult_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_RequestInitialState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_Undo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_Undo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_Redo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_Redo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_OpenBugReportingLink_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_OpenSignInPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_EditResult_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeClientUntrustedPageHandler_ShowUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeClientUntrustedPageHandler_CloseUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeClientUntrustedPageHandler_CompleteFirstRun_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeClientUntrustedPageHandler_OpenComposeSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeUntrustedDialog_ResponseReceived_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ComposeUntrustedDialog_PartialResponseReceived_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ComposeResponseMojoType {
  status: compose_mojom_ComposeStatus;
  undoAvailable: boolean;
  redoAvailable: boolean;
  providedByUser: boolean;
  onDeviceEvaluationUsed: boolean;
  triggeredFromModifier: boolean;
  result: string;
}


export type ComposeResponse = ComposeResponseMojoType;
mojo.internal.Struct<ComposeResponseMojoType>(
    ComposeResponseSpec.$,
    'ComposeResponse',
    [
      mojo.internal.StructField<ComposeResponseMojoType, compose_mojom_ComposeStatus>(
        'status', 0,
        0,
        compose_mojom_ComposeStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeResponseMojoType, string>(
        'result', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeResponseMojoType, boolean>(
        'undoAvailable', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeResponseMojoType, boolean>(
        'redoAvailable', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeResponseMojoType, boolean>(
        'providedByUser', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeResponseMojoType, boolean>(
        'onDeviceEvaluationUsed', 4,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeResponseMojoType, boolean>(
        'triggeredFromModifier', 4,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PartialComposeResponseMojoType {
  result: string;
}


export type PartialComposeResponse = PartialComposeResponseMojoType;
mojo.internal.Struct<PartialComposeResponseMojoType>(
    PartialComposeResponseSpec.$,
    'PartialComposeResponse',
    [
      mojo.internal.StructField<PartialComposeResponseMojoType, string>(
        'result', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeStateMojoType {
  webuiState: string;
  response: (ComposeResponse | null);
  hasPendingRequest: boolean;
  feedback: UserFeedback;
}


export type ComposeState = ComposeStateMojoType;
mojo.internal.Struct<ComposeStateMojoType>(
    ComposeStateSpec.$,
    'ComposeState',
    [
      mojo.internal.StructField<ComposeStateMojoType, string>(
        'webuiState', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeStateMojoType, ComposeResponse>(
        'response', 8,
        0,
        ComposeResponseSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeStateMojoType, boolean>(
        'hasPendingRequest', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeStateMojoType, UserFeedback>(
        'feedback', 20,
        0,
        UserFeedbackSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ConfigurableParamsMojoType {
  minWordLimit: number;
  maxWordLimit: number;
  maxCharacterLimit: number;
}


export type ConfigurableParams = ConfigurableParamsMojoType;
mojo.internal.Struct<ConfigurableParamsMojoType>(
    ConfigurableParamsSpec.$,
    'ConfigurableParams',
    [
      mojo.internal.StructField<ConfigurableParamsMojoType, number>(
        'minWordLimit', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ConfigurableParamsMojoType, number>(
        'maxWordLimit', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ConfigurableParamsMojoType, number>(
        'maxCharacterLimit', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OpenMetadataMojoType {
  freComplete: boolean;
  msbbState: boolean;
  textSelected: boolean;
  initialInput: string;
  composeState: ComposeState;
  configurableParams: ConfigurableParams;
}


export type OpenMetadata = OpenMetadataMojoType;
mojo.internal.Struct<OpenMetadataMojoType>(
    OpenMetadataSpec.$,
    'OpenMetadata',
    [
      mojo.internal.StructField<OpenMetadataMojoType, boolean>(
        'freComplete', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OpenMetadataMojoType, boolean>(
        'msbbState', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OpenMetadataMojoType, string>(
        'initialInput', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OpenMetadataMojoType, boolean>(
        'textSelected', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OpenMetadataMojoType, ComposeState>(
        'composeState', 16,
        0,
        ComposeStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OpenMetadataMojoType, ConfigurableParams>(
        'configurableParams', 24,
        0,
        ConfigurableParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsMojoType {
  clientHandler: ComposeClientUntrustedPageHandlerPendingReceiver;
  handler: ComposeSessionUntrustedPageHandlerPendingReceiver;
  dialog: ComposeUntrustedDialogRemote;
}


export type ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params = ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsMojoType>(
    ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_Params',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsMojoType, ComposeClientUntrustedPageHandlerPendingReceiver>(
        'clientHandler', 0,
        0,
        mojo.internal.InterfaceRequest(ComposeClientUntrustedPageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsMojoType, ComposeSessionUntrustedPageHandlerPendingReceiver>(
        'handler', 4,
        0,
        mojo.internal.InterfaceRequest(ComposeSessionUntrustedPageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeSessionUntrustedPageHandlerFactory_CreateComposeSessionUntrustedPageHandler_ParamsMojoType, ComposeUntrustedDialogRemote>(
        'dialog', 8,
        0,
        mojo.internal.InterfaceProxy(ComposeUntrustedDialogRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ComposeSessionUntrustedPageHandler_LogCancelEdit_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_LogCancelEdit_Params = ComposeSessionUntrustedPageHandler_LogCancelEdit_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_LogCancelEdit_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_LogCancelEdit_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_LogCancelEdit_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_Compose_ParamsMojoType {
  input: string;
  mode: InputMode;
  edited: boolean;
}


export type ComposeSessionUntrustedPageHandler_Compose_Params = ComposeSessionUntrustedPageHandler_Compose_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_Compose_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_Compose_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_Compose_Params',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_Compose_ParamsMojoType, string>(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_Compose_ParamsMojoType, InputMode>(
        'mode', 8,
        0,
        InputModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_Compose_ParamsMojoType, boolean>(
        'edited', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ComposeSessionUntrustedPageHandler_Rewrite_ParamsMojoType {
  style: StyleModifier;
}


export type ComposeSessionUntrustedPageHandler_Rewrite_Params = ComposeSessionUntrustedPageHandler_Rewrite_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_Rewrite_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_Rewrite_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_Rewrite_Params',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_Rewrite_ParamsMojoType, StyleModifier>(
        'style', 0,
        0,
        StyleModifierSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeSessionUntrustedPageHandler_LogEditInput_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_LogEditInput_Params = ComposeSessionUntrustedPageHandler_LogEditInput_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_LogEditInput_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_LogEditInput_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_LogEditInput_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsMojoType {
  webuiState: string;
}


export type ComposeSessionUntrustedPageHandler_SaveWebUIState_Params = ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_SaveWebUIState_Params',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_SaveWebUIState_ParamsMojoType, string>(
        'webuiState', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeSessionUntrustedPageHandler_AcceptComposeResult_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params = ComposeSessionUntrustedPageHandler_AcceptComposeResult_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_AcceptComposeResult_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_AcceptComposeResult_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_AcceptComposeResult_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsMojoType {
  success: boolean;
}


export type ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams = ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsMojoType>(
    ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParams',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_AcceptComposeResult_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeSessionUntrustedPageHandler_RequestInitialState_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_RequestInitialState_Params = ComposeSessionUntrustedPageHandler_RequestInitialState_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_RequestInitialState_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_RequestInitialState_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_RequestInitialState_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsMojoType {
  initialState: OpenMetadata;
}


export type ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams = ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsMojoType>(
    ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParams',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_RequestInitialState_ResponseParamsMojoType, OpenMetadata>(
        'initialState', 0,
        0,
        OpenMetadataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeSessionUntrustedPageHandler_Undo_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_Undo_Params = ComposeSessionUntrustedPageHandler_Undo_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_Undo_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_Undo_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_Undo_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_Undo_ResponseParamsMojoType {
  lastState: (ComposeState | null);
}


export type ComposeSessionUntrustedPageHandler_Undo_ResponseParams = ComposeSessionUntrustedPageHandler_Undo_ResponseParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_Undo_ResponseParamsMojoType>(
    ComposeSessionUntrustedPageHandler_Undo_ResponseParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_Undo_ResponseParams',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_Undo_ResponseParamsMojoType, ComposeState>(
        'lastState', 0,
        0,
        ComposeStateSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params = ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_RecoverFromErrorState_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsMojoType {
  stateBeforeError: (ComposeState | null);
}


export type ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams = ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsMojoType>(
    ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParams',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_RecoverFromErrorState_ResponseParamsMojoType, ComposeState>(
        'stateBeforeError', 0,
        0,
        ComposeStateSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeSessionUntrustedPageHandler_Redo_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_Redo_Params = ComposeSessionUntrustedPageHandler_Redo_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_Redo_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_Redo_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_Redo_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_Redo_ResponseParamsMojoType {
  nextState: (ComposeState | null);
}


export type ComposeSessionUntrustedPageHandler_Redo_ResponseParams = ComposeSessionUntrustedPageHandler_Redo_ResponseParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_Redo_ResponseParamsMojoType>(
    ComposeSessionUntrustedPageHandler_Redo_ResponseParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_Redo_ResponseParams',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_Redo_ResponseParamsMojoType, ComposeState>(
        'nextState', 0,
        0,
        ComposeStateSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeSessionUntrustedPageHandler_OpenBugReportingLink_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params = ComposeSessionUntrustedPageHandler_OpenBugReportingLink_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_OpenBugReportingLink_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_OpenBugReportingLink_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_OpenBugReportingLink_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params = ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_OpenComposeLearnMorePage_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params = ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_OpenEnterpriseComposeLearnMorePage_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params = ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_OpenFeedbackSurveyLink_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_OpenSignInPage_ParamsMojoType {
}


export type ComposeSessionUntrustedPageHandler_OpenSignInPage_Params = ComposeSessionUntrustedPageHandler_OpenSignInPage_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_OpenSignInPage_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_OpenSignInPage_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_OpenSignInPage_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsMojoType {
  feedback: UserFeedback;
}


export type ComposeSessionUntrustedPageHandler_SetUserFeedback_Params = ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_SetUserFeedback_Params',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_SetUserFeedback_ParamsMojoType, UserFeedback>(
        'feedback', 0,
        0,
        UserFeedbackSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeSessionUntrustedPageHandler_EditResult_ParamsMojoType {
  newResult: string;
}


export type ComposeSessionUntrustedPageHandler_EditResult_Params = ComposeSessionUntrustedPageHandler_EditResult_ParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_EditResult_ParamsMojoType>(
    ComposeSessionUntrustedPageHandler_EditResult_ParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_EditResult_Params',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_EditResult_ParamsMojoType, string>(
        'newResult', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsMojoType {
  isEdited: boolean;
}


export type ComposeSessionUntrustedPageHandler_EditResult_ResponseParams = ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsMojoType;
mojo.internal.Struct<ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsMojoType>(
    ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsSpec.$,
    'ComposeSessionUntrustedPageHandler_EditResult_ResponseParams',
    [
      mojo.internal.StructField<ComposeSessionUntrustedPageHandler_EditResult_ResponseParamsMojoType, boolean>(
        'isEdited', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeClientUntrustedPageHandler_ShowUI_ParamsMojoType {
}


export type ComposeClientUntrustedPageHandler_ShowUI_Params = ComposeClientUntrustedPageHandler_ShowUI_ParamsMojoType;
mojo.internal.Struct<ComposeClientUntrustedPageHandler_ShowUI_ParamsMojoType>(
    ComposeClientUntrustedPageHandler_ShowUI_ParamsSpec.$,
    'ComposeClientUntrustedPageHandler_ShowUI_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeClientUntrustedPageHandler_CloseUI_ParamsMojoType {
  reason: CloseReason;
}


export type ComposeClientUntrustedPageHandler_CloseUI_Params = ComposeClientUntrustedPageHandler_CloseUI_ParamsMojoType;
mojo.internal.Struct<ComposeClientUntrustedPageHandler_CloseUI_ParamsMojoType>(
    ComposeClientUntrustedPageHandler_CloseUI_ParamsSpec.$,
    'ComposeClientUntrustedPageHandler_CloseUI_Params',
    [
      mojo.internal.StructField<ComposeClientUntrustedPageHandler_CloseUI_ParamsMojoType, CloseReason>(
        'reason', 0,
        0,
        CloseReasonSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeClientUntrustedPageHandler_CompleteFirstRun_ParamsMojoType {
}


export type ComposeClientUntrustedPageHandler_CompleteFirstRun_Params = ComposeClientUntrustedPageHandler_CompleteFirstRun_ParamsMojoType;
mojo.internal.Struct<ComposeClientUntrustedPageHandler_CompleteFirstRun_ParamsMojoType>(
    ComposeClientUntrustedPageHandler_CompleteFirstRun_ParamsSpec.$,
    'ComposeClientUntrustedPageHandler_CompleteFirstRun_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeClientUntrustedPageHandler_OpenComposeSettings_ParamsMojoType {
}


export type ComposeClientUntrustedPageHandler_OpenComposeSettings_Params = ComposeClientUntrustedPageHandler_OpenComposeSettings_ParamsMojoType;
mojo.internal.Struct<ComposeClientUntrustedPageHandler_OpenComposeSettings_ParamsMojoType>(
    ComposeClientUntrustedPageHandler_OpenComposeSettings_ParamsSpec.$,
    'ComposeClientUntrustedPageHandler_OpenComposeSettings_Params',
    [
    ],
    [[0, 8],]);





export interface ComposeUntrustedDialog_ResponseReceived_ParamsMojoType {
  response: ComposeResponse;
}


export type ComposeUntrustedDialog_ResponseReceived_Params = ComposeUntrustedDialog_ResponseReceived_ParamsMojoType;
mojo.internal.Struct<ComposeUntrustedDialog_ResponseReceived_ParamsMojoType>(
    ComposeUntrustedDialog_ResponseReceived_ParamsSpec.$,
    'ComposeUntrustedDialog_ResponseReceived_Params',
    [
      mojo.internal.StructField<ComposeUntrustedDialog_ResponseReceived_ParamsMojoType, ComposeResponse>(
        'response', 0,
        0,
        ComposeResponseSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ComposeUntrustedDialog_PartialResponseReceived_ParamsMojoType {
  partialResponse: PartialComposeResponse;
}


export type ComposeUntrustedDialog_PartialResponseReceived_Params = ComposeUntrustedDialog_PartialResponseReceived_ParamsMojoType;
mojo.internal.Struct<ComposeUntrustedDialog_PartialResponseReceived_ParamsMojoType>(
    ComposeUntrustedDialog_PartialResponseReceived_ParamsSpec.$,
    'ComposeUntrustedDialog_PartialResponseReceived_Params',
    [
      mojo.internal.StructField<ComposeUntrustedDialog_PartialResponseReceived_ParamsMojoType, PartialComposeResponse>(
        'partialResponse', 0,
        0,
        PartialComposeResponseSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



