import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ProductInfo as commerce_shared_mojom_ProductInfo, ProductSpecificationsSet as commerce_shared_mojom_ProductSpecificationsSet } from './shared.mojom-webui.js';
import { Uuid as mojoBase_mojom_Uuid } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import { Url as url_mojom_Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export declare const UserFeedbackSpec: {
    $: mojo.internal.MojomType;
};
export declare enum UserFeedback {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kUnspecified = 0,
    kThumbsUp = 1,
    kThumbsDown = 2
}
export type ShoppingServiceHandlerFactoryPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<ShoppingServiceHandlerFactoryPendingReceiver>;
export declare class ShoppingServiceHandlerFactoryPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<ShoppingServiceHandlerFactory> {
    handle: mojo.internal.interfaceSupport.Endpoint<ShoppingServiceHandlerFactoryPendingReceiver>;
    constructor(handle: MojoHandle | ShoppingServiceHandlerFactoryPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface ShoppingServiceHandlerFactoryInterface {
    createShoppingServiceHandler(handler: ShoppingServiceHandlerPendingReceiver): void;
}
export declare class ShoppingServiceHandlerFactoryRemote implements ShoppingServiceHandlerFactoryInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ShoppingServiceHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | ShoppingServiceHandlerFactoryPendingReceiverEndpoint);
    createShoppingServiceHandler(handler: ShoppingServiceHandlerPendingReceiver): void;
}
/**
 * An object which receives request messages for the ShoppingServiceHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class ShoppingServiceHandlerFactoryReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<ShoppingServiceHandlerFactoryRemote, ShoppingServiceHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: ShoppingServiceHandlerFactoryInterface);
}
export declare class ShoppingServiceHandlerFactory {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): ShoppingServiceHandlerFactoryRemote;
}
/**
 * An object which receives request messages for the ShoppingServiceHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class ShoppingServiceHandlerFactoryCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<ShoppingServiceHandlerFactoryRemote, ShoppingServiceHandlerFactoryPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createShoppingServiceHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type ShoppingServiceHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<ShoppingServiceHandlerPendingReceiver>;
export declare class ShoppingServiceHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<ShoppingServiceHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<ShoppingServiceHandlerPendingReceiver>;
    constructor(handle: MojoHandle | ShoppingServiceHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface ShoppingServiceHandlerInterface {
    getProductInfoForCurrentUrl(): Promise<{
        productInfo: commerce_shared_mojom_ProductInfo;
    }>;
    getProductInfoForUrl(url: url_mojom_Url): Promise<{
        url: url_mojom_Url;
        productInfo: commerce_shared_mojom_ProductInfo;
    }>;
    getProductInfoForUrls(urls: url_mojom_Url[]): Promise<{
        productInfos: commerce_shared_mojom_ProductInfo[];
    }>;
    getPriceInsightsInfoForCurrentUrl(): Promise<{
        priceInsightsInfo: PriceInsightsInfo;
    }>;
    getPriceInsightsInfoForUrl(url: url_mojom_Url): Promise<{
        url: url_mojom_Url;
        priceInsightsInfo: PriceInsightsInfo;
    }>;
    getProductSpecificationsForUrls(urls: url_mojom_Url[]): Promise<{
        productSpecs: ProductSpecifications;
    }>;
    getUrlInfosForProductTabs(): Promise<{
        urlInfos: UrlInfo[];
    }>;
    getUrlInfosForRecentlyViewedTabs(): Promise<{
        urlInfos: UrlInfo[];
    }>;
    isShoppingListEligible(): Promise<{
        eligible: boolean;
    }>;
    getPriceTrackingStatusForCurrentUrl(): Promise<{
        tracked: boolean;
    }>;
    openUrlInNewTab(url: url_mojom_Url): void;
    switchToOrOpenTab(url: url_mojom_Url): void;
    getAllProductSpecificationsSets(): Promise<{
        sets: commerce_shared_mojom_ProductSpecificationsSet[];
    }>;
    getProductSpecificationsSetByUuid(uuid: mojoBase_mojom_Uuid): Promise<{
        set: (commerce_shared_mojom_ProductSpecificationsSet | null);
    }>;
    addProductSpecificationsSet(name: string, urls: url_mojom_Url[]): Promise<{
        createdSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
    }>;
    deleteProductSpecificationsSet(uuid: mojoBase_mojom_Uuid): void;
    setNameForProductSpecificationsSet(uuid: mojoBase_mojom_Uuid, name: string): Promise<{
        updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
    }>;
    setUrlsForProductSpecificationsSet(uuid: mojoBase_mojom_Uuid, urls: url_mojom_Url[]): Promise<{
        updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
    }>;
    setProductSpecificationsUserFeedback(feedback: UserFeedback): void;
    getProductSpecificationsFeatureState(): Promise<{
        state: ProductSpecificationsFeatureState;
    }>;
}
export declare class ShoppingServiceHandlerRemote implements ShoppingServiceHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ShoppingServiceHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | ShoppingServiceHandlerPendingReceiverEndpoint);
    getProductInfoForCurrentUrl(): Promise<{
        productInfo: commerce_shared_mojom_ProductInfo;
    }>;
    getProductInfoForUrl(url: url_mojom_Url): Promise<{
        url: url_mojom_Url;
        productInfo: commerce_shared_mojom_ProductInfo;
    }>;
    getProductInfoForUrls(urls: url_mojom_Url[]): Promise<{
        productInfos: commerce_shared_mojom_ProductInfo[];
    }>;
    getPriceInsightsInfoForCurrentUrl(): Promise<{
        priceInsightsInfo: PriceInsightsInfo;
    }>;
    getPriceInsightsInfoForUrl(url: url_mojom_Url): Promise<{
        url: url_mojom_Url;
        priceInsightsInfo: PriceInsightsInfo;
    }>;
    getProductSpecificationsForUrls(urls: url_mojom_Url[]): Promise<{
        productSpecs: ProductSpecifications;
    }>;
    getUrlInfosForProductTabs(): Promise<{
        urlInfos: UrlInfo[];
    }>;
    getUrlInfosForRecentlyViewedTabs(): Promise<{
        urlInfos: UrlInfo[];
    }>;
    isShoppingListEligible(): Promise<{
        eligible: boolean;
    }>;
    getPriceTrackingStatusForCurrentUrl(): Promise<{
        tracked: boolean;
    }>;
    openUrlInNewTab(url: url_mojom_Url): void;
    switchToOrOpenTab(url: url_mojom_Url): void;
    getAllProductSpecificationsSets(): Promise<{
        sets: commerce_shared_mojom_ProductSpecificationsSet[];
    }>;
    getProductSpecificationsSetByUuid(uuid: mojoBase_mojom_Uuid): Promise<{
        set: (commerce_shared_mojom_ProductSpecificationsSet | null);
    }>;
    addProductSpecificationsSet(name: string, urls: url_mojom_Url[]): Promise<{
        createdSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
    }>;
    deleteProductSpecificationsSet(uuid: mojoBase_mojom_Uuid): void;
    setNameForProductSpecificationsSet(uuid: mojoBase_mojom_Uuid, name: string): Promise<{
        updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
    }>;
    setUrlsForProductSpecificationsSet(uuid: mojoBase_mojom_Uuid, urls: url_mojom_Url[]): Promise<{
        updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
    }>;
    setProductSpecificationsUserFeedback(feedback: UserFeedback): void;
    getProductSpecificationsFeatureState(): Promise<{
        state: ProductSpecificationsFeatureState;
    }>;
}
/**
 * An object which receives request messages for the ShoppingServiceHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class ShoppingServiceHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<ShoppingServiceHandlerRemote, ShoppingServiceHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: ShoppingServiceHandlerInterface);
}
export declare class ShoppingServiceHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): ShoppingServiceHandlerRemote;
}
/**
 * An object which receives request messages for the ShoppingServiceHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class ShoppingServiceHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<ShoppingServiceHandlerRemote, ShoppingServiceHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    getProductInfoForCurrentUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getProductInfoForUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getProductInfoForUrls: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getPriceInsightsInfoForCurrentUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getPriceInsightsInfoForUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getProductSpecificationsForUrls: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getUrlInfosForProductTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getUrlInfosForRecentlyViewedTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    isShoppingListEligible: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getPriceTrackingStatusForCurrentUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openUrlInNewTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    switchToOrOpenTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getAllProductSpecificationsSets: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getProductSpecificationsSetByUuid: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    addProductSpecificationsSet: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    deleteProductSpecificationsSet: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setNameForProductSpecificationsSet: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setUrlsForProductSpecificationsSet: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setProductSpecificationsUserFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getProductSpecificationsFeatureState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const PricePointSpec: {
    $: mojo.internal.MojomType;
};
export declare const UrlInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const PriceInsightsInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsDescriptionTextSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsOptionSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsDescriptionSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsValueSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsProductSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsFeatureStateSpec: {
    $: mojo.internal.MojomType;
};
export declare const ProductSpecificationsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface PricePointMojoType {
    date: string;
    price: number;
    formattedPrice: string;
}
export type PricePoint = PricePointMojoType;
export interface UrlInfoMojoType {
    title: string;
    url: url_mojom_Url;
    faviconUrl: url_mojom_Url;
    thumbnailUrl: url_mojom_Url;
    previewText: string;
}
export type UrlInfo = UrlInfoMojoType;
export declare const PriceInsightsInfo_PriceBucketSpec: {
    $: mojo.internal.MojomType;
};
export declare enum PriceInsightsInfo_PriceBucket {
    MIN_VALUE = 0,
    MAX_VALUE = 3,
    kUnknown = 0,
    kLow = 1,
    kTypical = 2,
    kHigh = 3
}
export interface PriceInsightsInfoMojoType {
    clusterId: bigint;
    typicalLowPrice: string;
    typicalHighPrice: string;
    catalogAttributes: string;
    jackpot: url_mojom_Url;
    bucket: PriceInsightsInfo_PriceBucket;
    hasMultipleCatalogs: boolean;
    history: PricePoint[];
    locale: string;
    currencyCode: string;
}
export type PriceInsightsInfo = PriceInsightsInfoMojoType;
export interface ProductSpecificationsDescriptionTextMojoType {
    text: string;
    urls: UrlInfo[];
}
export type ProductSpecificationsDescriptionText = ProductSpecificationsDescriptionTextMojoType;
export interface ProductSpecificationsOptionMojoType {
    descriptions: ProductSpecificationsDescriptionText[];
}
export type ProductSpecificationsOption = ProductSpecificationsOptionMojoType;
export interface ProductSpecificationsDescriptionMojoType {
    options: ProductSpecificationsOption[];
    label: string;
    altText: string;
}
export type ProductSpecificationsDescription = ProductSpecificationsDescriptionMojoType;
export interface ProductSpecificationsValueMojoType {
    specificationDescriptions: ProductSpecificationsDescription[];
    summary: ProductSpecificationsDescriptionText[];
}
export type ProductSpecificationsValue = ProductSpecificationsValueMojoType;
export interface ProductSpecificationsProductMojoType {
    productClusterId: bigint;
    title: string;
    imageUrl: url_mojom_Url;
    productDimensionValues: Map<bigint, ProductSpecificationsValue>;
    summary: ProductSpecificationsDescriptionText[];
    buyingOptionsUrl: url_mojom_Url;
}
export type ProductSpecificationsProduct = ProductSpecificationsProductMojoType;
export interface ProductSpecificationsFeatureStateMojoType {
    isSyncingTabCompare: boolean;
    canLoadFullPageUi: boolean;
    canManageSets: boolean;
    canFetchData: boolean;
    isAllowedForEnterprise: boolean;
    isQualityLoggingAllowed: boolean;
    isSignedIn: boolean;
}
export type ProductSpecificationsFeatureState = ProductSpecificationsFeatureStateMojoType;
export interface ProductSpecificationsMojoType {
    productDimensionMap: Map<bigint, string>;
    products: ProductSpecificationsProduct[];
}
export type ProductSpecifications = ProductSpecificationsMojoType;
export interface ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsMojoType {
    handler: ShoppingServiceHandlerPendingReceiver;
}
export type ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params = ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsMojoType;
export interface ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsMojoType {
}
export type ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params = ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsMojoType;
export interface ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsMojoType {
    productInfo: commerce_shared_mojom_ProductInfo;
}
export type ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams = ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsMojoType;
export interface ShoppingServiceHandler_GetProductInfoForUrl_ParamsMojoType {
    url: url_mojom_Url;
}
export type ShoppingServiceHandler_GetProductInfoForUrl_Params = ShoppingServiceHandler_GetProductInfoForUrl_ParamsMojoType;
export interface ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsMojoType {
    url: url_mojom_Url;
    productInfo: commerce_shared_mojom_ProductInfo;
}
export type ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams = ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsMojoType;
export interface ShoppingServiceHandler_GetProductInfoForUrls_ParamsMojoType {
    urls: url_mojom_Url[];
}
export type ShoppingServiceHandler_GetProductInfoForUrls_Params = ShoppingServiceHandler_GetProductInfoForUrls_ParamsMojoType;
export interface ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsMojoType {
    productInfos: commerce_shared_mojom_ProductInfo[];
}
export type ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams = ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsMojoType;
export interface ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsMojoType {
}
export type ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params = ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsMojoType;
export interface ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsMojoType {
    priceInsightsInfo: PriceInsightsInfo;
}
export type ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams = ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsMojoType;
export interface ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsMojoType {
    url: url_mojom_Url;
}
export type ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params = ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsMojoType;
export interface ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsMojoType {
    url: url_mojom_Url;
    priceInsightsInfo: PriceInsightsInfo;
}
export type ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams = ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsMojoType;
export interface ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsMojoType {
    urls: url_mojom_Url[];
}
export type ShoppingServiceHandler_GetProductSpecificationsForUrls_Params = ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsMojoType;
export interface ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsMojoType {
    productSpecs: ProductSpecifications;
}
export type ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams = ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsMojoType;
export interface ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsMojoType {
}
export type ShoppingServiceHandler_GetUrlInfosForProductTabs_Params = ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsMojoType;
export interface ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsMojoType {
    urlInfos: UrlInfo[];
}
export type ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams = ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsMojoType;
export interface ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsMojoType {
}
export type ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params = ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsMojoType;
export interface ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsMojoType {
    urlInfos: UrlInfo[];
}
export type ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams = ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsMojoType;
export interface ShoppingServiceHandler_IsShoppingListEligible_ParamsMojoType {
}
export type ShoppingServiceHandler_IsShoppingListEligible_Params = ShoppingServiceHandler_IsShoppingListEligible_ParamsMojoType;
export interface ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsMojoType {
    eligible: boolean;
}
export type ShoppingServiceHandler_IsShoppingListEligible_ResponseParams = ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsMojoType;
export interface ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsMojoType {
}
export type ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params = ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsMojoType;
export interface ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsMojoType {
    tracked: boolean;
}
export type ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams = ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsMojoType;
export interface ShoppingServiceHandler_OpenUrlInNewTab_ParamsMojoType {
    url: url_mojom_Url;
}
export type ShoppingServiceHandler_OpenUrlInNewTab_Params = ShoppingServiceHandler_OpenUrlInNewTab_ParamsMojoType;
export interface ShoppingServiceHandler_SwitchToOrOpenTab_ParamsMojoType {
    url: url_mojom_Url;
}
export type ShoppingServiceHandler_SwitchToOrOpenTab_Params = ShoppingServiceHandler_SwitchToOrOpenTab_ParamsMojoType;
export interface ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsMojoType {
}
export type ShoppingServiceHandler_GetAllProductSpecificationsSets_Params = ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsMojoType;
export interface ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsMojoType {
    sets: commerce_shared_mojom_ProductSpecificationsSet[];
}
export type ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams = ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsMojoType;
export interface ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
}
export type ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params = ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsMojoType;
export interface ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsMojoType {
    set: (commerce_shared_mojom_ProductSpecificationsSet | null);
}
export type ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams = ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsMojoType;
export interface ShoppingServiceHandler_AddProductSpecificationsSet_ParamsMojoType {
    name: string;
    urls: url_mojom_Url[];
}
export type ShoppingServiceHandler_AddProductSpecificationsSet_Params = ShoppingServiceHandler_AddProductSpecificationsSet_ParamsMojoType;
export interface ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsMojoType {
    createdSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
}
export type ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams = ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsMojoType;
export interface ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
}
export type ShoppingServiceHandler_DeleteProductSpecificationsSet_Params = ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsMojoType;
export interface ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
    name: string;
}
export type ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params = ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsMojoType;
export interface ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsMojoType {
    updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
}
export type ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams = ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsMojoType;
export interface ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
    urls: url_mojom_Url[];
}
export type ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params = ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsMojoType;
export interface ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsMojoType {
    updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
}
export type ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams = ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsMojoType;
export interface ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsMojoType {
    feedback: UserFeedback;
}
export type ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params = ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsMojoType;
export interface ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsMojoType {
}
export type ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params = ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsMojoType;
export interface ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsMojoType {
    state: ProductSpecificationsFeatureState;
}
export type ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams = ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsMojoType;
