import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import 'chrome://resources/cr_elements/cr_url_list_item/cr_url_list_item.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_hidden_style.css.js';
import './images/icons.html.js';
import '/strings.m.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrLazyRenderLitElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { UrlListEntry } from './utils.js';
export interface ProductSelectionMenuElement {
    $: {
        menu: CrLazyRenderLitElement<CrActionMenuElement>;
    };
}
export declare enum SectionType {
    NONE = 0,
    SUGGESTED = 1,
    RECENT = 2
}
interface MenuSection {
    title: string;
    entries: UrlListEntry[];
    expanded: boolean;
    sectionType: SectionType;
}
export declare class ProductSelectionMenuElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    static get properties(): {
        selectedUrl: {
            type: StringConstructor;
        };
        excludedUrls: {
            type: ArrayConstructor;
        };
        forNewColumn: {
            type: BooleanConstructor;
        };
        isTableFull: {
            type: BooleanConstructor;
        };
        sections: {
            type: ArrayConstructor;
        };
    };
    private shoppingApi_;
    accessor selectedUrl: string;
    accessor excludedUrls: string[];
    accessor forNewColumn: boolean;
    accessor isTableFull: boolean;
    accessor sections: MenuSection[];
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    showAt(element: HTMLElement): Promise<void>;
    close(): void;
    protected expandedChanged_(e: CustomEvent<{
        value: boolean;
    }>, section: MenuSection): void;
    private filterUrlInfos_;
    private urlInfosToListEntries_;
    protected onSelect_(e: Event): void;
    protected onRemoveClick_(): void;
    protected onClose_(): void;
    protected getUrl_(item: UrlListEntry): string;
    protected showEmptySuggestionsMessage_(): boolean;
    protected showTableFullMessage_(): boolean;
    protected isLastSection_(sectionIndex: number): boolean;
}
declare global {
    interface HTMLElementTagNameMap {
        'product-selection-menu': ProductSelectionMenuElement;
    }
}
export {};
