// components/commerce/core/mojom/product_specifications.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ProductSpecificationsSetSpec as commerce_shared_mojom_ProductSpecificationsSetSpec,
  ProductSpecificationsSet as commerce_shared_mojom_ProductSpecificationsSet
} from './shared.mojom-webui.js';
import {
  UuidSpec as mojoBase_mojom_UuidSpec,
  Uuid as mojoBase_mojom_Uuid
} from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const DisclosureVersionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum DisclosureVersion {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kUnknown = 0,
  kV1 = 1,
}

export const ShowSetDispositionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ShowSetDisposition {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kInNewTabs = 0,
  kInNewWindow = 1,
}



export type ProductSpecificationsHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ProductSpecificationsHandlerPendingReceiver>;

export class ProductSpecificationsHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ProductSpecificationsHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<ProductSpecificationsHandlerPendingReceiver>;
  constructor(handle: MojoHandle|ProductSpecificationsHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'commerce.product_specifications.mojom.ProductSpecificationsHandler',
        scope);
  }
}

export interface ProductSpecificationsHandlerInterface {
  setAcceptedDisclosureVersion(version: DisclosureVersion): void;
  maybeShowDisclosure(urls: url_mojom_Url[], name: string, setId: string): Promise<{
        disclosureShown: boolean, }>;
  declineDisclosure(): void;
  showSyncSetupFlow(): void;
  getPageTitleFromHistory(url: url_mojom_Url): Promise<{
        title: string, }>;
  showProductSpecificationsSetForUuid(uuid: mojoBase_mojom_Uuid, inNewTab: boolean): void;
  showProductSpecificationsSetsForUuids(uuids: mojoBase_mojom_Uuid[], disposition: ShowSetDisposition): void;
  showComparePage(inNewTab: boolean): void;
  getComparisonTableUrlForUuid(uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url, }>;
}

export class ProductSpecificationsHandlerRemote implements ProductSpecificationsHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ProductSpecificationsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ProductSpecificationsHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ProductSpecificationsHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProductSpecificationsHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setAcceptedDisclosureVersion(
      version: DisclosureVersion): void {
    this.proxy.sendMessage(
        0,
        ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsSpec.$,
        null,
        [
          version
        ],
        false);
  }

  maybeShowDisclosure(
      urls: url_mojom_Url[],
      name: string,
      setId: string): Promise<{
        disclosureShown: boolean, }> {
    return this.proxy.sendMessage(
        1,
        ProductSpecificationsHandler_MaybeShowDisclosure_ParamsSpec.$,
        ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsSpec.$,
        [
          urls,
          name,
          setId
        ],
        false);
  }

  declineDisclosure(): void {
    this.proxy.sendMessage(
        2,
        ProductSpecificationsHandler_DeclineDisclosure_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  showSyncSetupFlow(): void {
    this.proxy.sendMessage(
        3,
        ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getPageTitleFromHistory(
      url: url_mojom_Url): Promise<{
        title: string, }> {
    return this.proxy.sendMessage(
        4,
        ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsSpec.$,
        ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  showProductSpecificationsSetForUuid(
      uuid: mojoBase_mojom_Uuid,
      inNewTab: boolean): void {
    this.proxy.sendMessage(
        5,
        ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsSpec.$,
        null,
        [
          uuid,
          inNewTab
        ],
        false);
  }

  showProductSpecificationsSetsForUuids(
      uuids: mojoBase_mojom_Uuid[],
      disposition: ShowSetDisposition): void {
    this.proxy.sendMessage(
        6,
        ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsSpec.$,
        null,
        [
          uuids,
          disposition
        ],
        false);
  }

  showComparePage(
      inNewTab: boolean): void {
    this.proxy.sendMessage(
        7,
        ProductSpecificationsHandler_ShowComparePage_ParamsSpec.$,
        null,
        [
          inNewTab
        ],
        false);
  }

  getComparisonTableUrlForUuid(
      uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url, }> {
    return this.proxy.sendMessage(
        8,
        ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsSpec.$,
        ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProductSpecificationsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProductSpecificationsHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ProductSpecificationsHandlerRemote, ProductSpecificationsHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ProductSpecificationsHandlerRemote, ProductSpecificationsHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ProductSpecificationsHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProductSpecificationsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsSpec.$,
        null,
        impl.setAcceptedDisclosureVersion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ProductSpecificationsHandler_MaybeShowDisclosure_ParamsSpec.$,
        ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsSpec.$,
        impl.maybeShowDisclosure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ProductSpecificationsHandler_DeclineDisclosure_ParamsSpec.$,
        null,
        impl.declineDisclosure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsSpec.$,
        null,
        impl.showSyncSetupFlow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsSpec.$,
        ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsSpec.$,
        impl.getPageTitleFromHistory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsSpec.$,
        null,
        impl.showProductSpecificationsSetForUuid.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsSpec.$,
        null,
        impl.showProductSpecificationsSetsForUuids.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ProductSpecificationsHandler_ShowComparePage_ParamsSpec.$,
        null,
        impl.showComparePage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsSpec.$,
        ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsSpec.$,
        impl.getComparisonTableUrlForUuid.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProductSpecificationsHandler {
  static get $interfaceName(): string {
    return "commerce.product_specifications.mojom.ProductSpecificationsHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ProductSpecificationsHandlerRemote {
    let remote = new ProductSpecificationsHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ProductSpecificationsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProductSpecificationsHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ProductSpecificationsHandlerRemote, ProductSpecificationsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ProductSpecificationsHandlerRemote, ProductSpecificationsHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setAcceptedDisclosureVersion: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  maybeShowDisclosure: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  declineDisclosure: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showSyncSetupFlow: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getPageTitleFromHistory: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showProductSpecificationsSetForUuid: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showProductSpecificationsSetsForUuids: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showComparePage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getComparisonTableUrlForUuid: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProductSpecificationsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setAcceptedDisclosureVersion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsSpec.$,
        null,
        this.setAcceptedDisclosureVersion.createReceiverHandler(false /* expectsResponse */),
        false);
    this.maybeShowDisclosure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ProductSpecificationsHandler_MaybeShowDisclosure_ParamsSpec.$,
        ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsSpec.$,
        this.maybeShowDisclosure.createReceiverHandler(true /* expectsResponse */),
        false);
    this.declineDisclosure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ProductSpecificationsHandler_DeclineDisclosure_ParamsSpec.$,
        null,
        this.declineDisclosure.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showSyncSetupFlow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsSpec.$,
        null,
        this.showSyncSetupFlow.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getPageTitleFromHistory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsSpec.$,
        ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsSpec.$,
        this.getPageTitleFromHistory.createReceiverHandler(true /* expectsResponse */),
        false);
    this.showProductSpecificationsSetForUuid =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsSpec.$,
        null,
        this.showProductSpecificationsSetForUuid.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showProductSpecificationsSetsForUuids =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsSpec.$,
        null,
        this.showProductSpecificationsSetsForUuids.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showComparePage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ProductSpecificationsHandler_ShowComparePage_ParamsSpec.$,
        null,
        this.showComparePage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getComparisonTableUrlForUuid =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsSpec.$,
        ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsSpec.$,
        this.getComparisonTableUrlForUuid.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'commerce.product_specifications.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onProductSpecificationsSetAdded(set: commerce_shared_mojom_ProductSpecificationsSet): void;
  onProductSpecificationsSetUpdated(set: commerce_shared_mojom_ProductSpecificationsSet): void;
  onProductSpecificationsSetRemoved(uuid: mojoBase_mojom_Uuid): void;
  onSyncStateChanged(): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onProductSpecificationsSetAdded(
      set: commerce_shared_mojom_ProductSpecificationsSet): void {
    this.proxy.sendMessage(
        0,
        Page_OnProductSpecificationsSetAdded_ParamsSpec.$,
        null,
        [
          set
        ],
        false);
  }

  onProductSpecificationsSetUpdated(
      set: commerce_shared_mojom_ProductSpecificationsSet): void {
    this.proxy.sendMessage(
        1,
        Page_OnProductSpecificationsSetUpdated_ParamsSpec.$,
        null,
        [
          set
        ],
        false);
  }

  onProductSpecificationsSetRemoved(
      uuid: mojoBase_mojom_Uuid): void {
    this.proxy.sendMessage(
        2,
        Page_OnProductSpecificationsSetRemoved_ParamsSpec.$,
        null,
        [
          uuid
        ],
        false);
  }

  onSyncStateChanged(): void {
    this.proxy.sendMessage(
        3,
        Page_OnSyncStateChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnProductSpecificationsSetAdded_ParamsSpec.$,
        null,
        impl.onProductSpecificationsSetAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_OnProductSpecificationsSetUpdated_ParamsSpec.$,
        null,
        impl.onProductSpecificationsSetUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_OnProductSpecificationsSetRemoved_ParamsSpec.$,
        null,
        impl.onProductSpecificationsSetRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_OnSyncStateChanged_ParamsSpec.$,
        null,
        impl.onSyncStateChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "commerce.product_specifications.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onProductSpecificationsSetAdded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onProductSpecificationsSetUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onProductSpecificationsSetRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onSyncStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onProductSpecificationsSetAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnProductSpecificationsSetAdded_ParamsSpec.$,
        null,
        this.onProductSpecificationsSetAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onProductSpecificationsSetUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_OnProductSpecificationsSetUpdated_ParamsSpec.$,
        null,
        this.onProductSpecificationsSetUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onProductSpecificationsSetRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_OnProductSpecificationsSetRemoved_ParamsSpec.$,
        null,
        this.onProductSpecificationsSetRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onSyncStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_OnSyncStateChanged_ParamsSpec.$,
        null,
        this.onSyncStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ProductSpecificationsHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ProductSpecificationsHandlerFactoryPendingReceiver>;

export class ProductSpecificationsHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ProductSpecificationsHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<ProductSpecificationsHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|ProductSpecificationsHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'commerce.product_specifications.mojom.ProductSpecificationsHandlerFactory',
        scope);
  }
}

export interface ProductSpecificationsHandlerFactoryInterface {
  createProductSpecificationsHandler(page: PageRemote, handler: ProductSpecificationsHandlerPendingReceiver): void;
}

export class ProductSpecificationsHandlerFactoryRemote implements ProductSpecificationsHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ProductSpecificationsHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ProductSpecificationsHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ProductSpecificationsHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProductSpecificationsHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createProductSpecificationsHandler(
      page: PageRemote,
      handler: ProductSpecificationsHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProductSpecificationsHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProductSpecificationsHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ProductSpecificationsHandlerFactoryRemote, ProductSpecificationsHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ProductSpecificationsHandlerFactoryRemote, ProductSpecificationsHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ProductSpecificationsHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProductSpecificationsHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsSpec.$,
        null,
        impl.createProductSpecificationsHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProductSpecificationsHandlerFactory {
  static get $interfaceName(): string {
    return "commerce.product_specifications.mojom.ProductSpecificationsHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ProductSpecificationsHandlerFactoryRemote {
    let remote = new ProductSpecificationsHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ProductSpecificationsHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProductSpecificationsHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ProductSpecificationsHandlerFactoryRemote, ProductSpecificationsHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ProductSpecificationsHandlerFactoryRemote, ProductSpecificationsHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createProductSpecificationsHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProductSpecificationsHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createProductSpecificationsHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsSpec.$,
        null,
        this.createProductSpecificationsHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_MaybeShowDisclosure_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_DeclineDisclosure_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_ShowComparePage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnProductSpecificationsSetAdded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnProductSpecificationsSetUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnProductSpecificationsSetRemoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnSyncStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsMojoType {
  version: DisclosureVersion;
}


export type ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params = ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsMojoType>(
    ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsSpec.$,
    'ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_SetAcceptedDisclosureVersion_ParamsMojoType, DisclosureVersion>(
        'version', 0,
        0,
        DisclosureVersionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProductSpecificationsHandler_MaybeShowDisclosure_ParamsMojoType {
  urls: url_mojom_Url[];
  name: string;
  setId: string;
}


export type ProductSpecificationsHandler_MaybeShowDisclosure_Params = ProductSpecificationsHandler_MaybeShowDisclosure_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_MaybeShowDisclosure_ParamsMojoType>(
    ProductSpecificationsHandler_MaybeShowDisclosure_ParamsSpec.$,
    'ProductSpecificationsHandler_MaybeShowDisclosure_Params',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_MaybeShowDisclosure_ParamsMojoType, url_mojom_Url[]>(
        'urls', 0,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsHandler_MaybeShowDisclosure_ParamsMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsHandler_MaybeShowDisclosure_ParamsMojoType, string>(
        'setId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsMojoType {
  disclosureShown: boolean;
}


export type ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams = ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsMojoType>(
    ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsSpec.$,
    'ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParamsMojoType, boolean>(
        'disclosureShown', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProductSpecificationsHandler_DeclineDisclosure_ParamsMojoType {
}


export type ProductSpecificationsHandler_DeclineDisclosure_Params = ProductSpecificationsHandler_DeclineDisclosure_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_DeclineDisclosure_ParamsMojoType>(
    ProductSpecificationsHandler_DeclineDisclosure_ParamsSpec.$,
    'ProductSpecificationsHandler_DeclineDisclosure_Params',
    [
    ],
    [[0, 8],]);





export interface ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsMojoType {
}


export type ProductSpecificationsHandler_ShowSyncSetupFlow_Params = ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsMojoType>(
    ProductSpecificationsHandler_ShowSyncSetupFlow_ParamsSpec.$,
    'ProductSpecificationsHandler_ShowSyncSetupFlow_Params',
    [
    ],
    [[0, 8],]);





export interface ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsMojoType {
  url: url_mojom_Url;
}


export type ProductSpecificationsHandler_GetPageTitleFromHistory_Params = ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsMojoType>(
    ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsSpec.$,
    'ProductSpecificationsHandler_GetPageTitleFromHistory_Params',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_GetPageTitleFromHistory_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsMojoType {
  title: string;
}


export type ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams = ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsMojoType>(
    ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsSpec.$,
    'ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParamsMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
  inNewTab: boolean;
}


export type ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params = ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsMojoType>(
    ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsSpec.$,
    'ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_ParamsMojoType, boolean>(
        'inNewTab', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsMojoType {
  uuids: mojoBase_mojom_Uuid[];
  disposition: ShowSetDisposition;
}


export type ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params = ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsMojoType>(
    ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsSpec.$,
    'ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsMojoType, mojoBase_mojom_Uuid[]>(
        'uuids', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_UuidSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_ParamsMojoType, ShowSetDisposition>(
        'disposition', 8,
        0,
        ShowSetDispositionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ProductSpecificationsHandler_ShowComparePage_ParamsMojoType {
  inNewTab: boolean;
}


export type ProductSpecificationsHandler_ShowComparePage_Params = ProductSpecificationsHandler_ShowComparePage_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_ShowComparePage_ParamsMojoType>(
    ProductSpecificationsHandler_ShowComparePage_ParamsSpec.$,
    'ProductSpecificationsHandler_ShowComparePage_Params',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_ShowComparePage_ParamsMojoType, boolean>(
        'inNewTab', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
}


export type ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params = ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsMojoType>(
    ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsSpec.$,
    'ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsMojoType {
  url: url_mojom_Url;
}


export type ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams = ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsMojoType>(
    ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsSpec.$,
    'ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams',
    [
      mojo.internal.StructField<ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnProductSpecificationsSetAdded_ParamsMojoType {
  set: commerce_shared_mojom_ProductSpecificationsSet;
}


export type Page_OnProductSpecificationsSetAdded_Params = Page_OnProductSpecificationsSetAdded_ParamsMojoType;
mojo.internal.Struct<Page_OnProductSpecificationsSetAdded_ParamsMojoType>(
    Page_OnProductSpecificationsSetAdded_ParamsSpec.$,
    'Page_OnProductSpecificationsSetAdded_Params',
    [
      mojo.internal.StructField<Page_OnProductSpecificationsSetAdded_ParamsMojoType, commerce_shared_mojom_ProductSpecificationsSet>(
        'set', 0,
        0,
        commerce_shared_mojom_ProductSpecificationsSetSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnProductSpecificationsSetUpdated_ParamsMojoType {
  set: commerce_shared_mojom_ProductSpecificationsSet;
}


export type Page_OnProductSpecificationsSetUpdated_Params = Page_OnProductSpecificationsSetUpdated_ParamsMojoType;
mojo.internal.Struct<Page_OnProductSpecificationsSetUpdated_ParamsMojoType>(
    Page_OnProductSpecificationsSetUpdated_ParamsSpec.$,
    'Page_OnProductSpecificationsSetUpdated_Params',
    [
      mojo.internal.StructField<Page_OnProductSpecificationsSetUpdated_ParamsMojoType, commerce_shared_mojom_ProductSpecificationsSet>(
        'set', 0,
        0,
        commerce_shared_mojom_ProductSpecificationsSetSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnProductSpecificationsSetRemoved_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
}


export type Page_OnProductSpecificationsSetRemoved_Params = Page_OnProductSpecificationsSetRemoved_ParamsMojoType;
mojo.internal.Struct<Page_OnProductSpecificationsSetRemoved_ParamsMojoType>(
    Page_OnProductSpecificationsSetRemoved_ParamsSpec.$,
    'Page_OnProductSpecificationsSetRemoved_Params',
    [
      mojo.internal.StructField<Page_OnProductSpecificationsSetRemoved_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnSyncStateChanged_ParamsMojoType {
}


export type Page_OnSyncStateChanged_Params = Page_OnSyncStateChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnSyncStateChanged_ParamsMojoType>(
    Page_OnSyncStateChanged_ParamsSpec.$,
    'Page_OnSyncStateChanged_Params',
    [
    ],
    [[0, 8],]);





export interface ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsMojoType {
  page: PageRemote;
  handler: ProductSpecificationsHandlerPendingReceiver;
}


export type ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params = ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsMojoType;
mojo.internal.Struct<ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsMojoType>(
    ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsSpec.$,
    'ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params',
    [
      mojo.internal.StructField<ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_ParamsMojoType, ProductSpecificationsHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(ProductSpecificationsHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



