// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js";import"chrome://resources/cr_elements/cr_collapse/cr_collapse.js";import"chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js";import"chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js";import"chrome://resources/cr_elements/cr_url_list_item/cr_url_list_item.js";import"chrome://resources/cr_elements/cr_shared_style.css.js";import"chrome://resources/cr_elements/cr_hidden_style.css.js";import"./images/icons.html.js";import"/strings.m.js";import{ShoppingServiceBrowserProxyImpl}from"chrome://resources/cr_components/commerce/shopping_service_browser_proxy.js";import{AnchorAlignment}from"chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./product_selection_menu.css.js";import{getHtml}from"./product_selection_menu.html.js";import{getAbbreviatedUrl}from"./utils.js";export var SectionType;(function(SectionType){SectionType[SectionType["NONE"]=0]="NONE";SectionType[SectionType["SUGGESTED"]=1]="SUGGESTED";SectionType[SectionType["RECENT"]=2]="RECENT"})(SectionType||(SectionType={}));export class ProductSelectionMenuElement extends CrLitElement{static get is(){return"product-selection-menu"}static get styles(){return getCss()}static get properties(){return{selectedUrl:{type:String},excludedUrls:{type:Array},forNewColumn:{type:Boolean},isTableFull:{type:Boolean},sections:{type:Array}}}shoppingApi_=ShoppingServiceBrowserProxyImpl.getInstance();#selectedUrl_accessor_storage="";get selectedUrl(){return this.#selectedUrl_accessor_storage}set selectedUrl(value){this.#selectedUrl_accessor_storage=value}#excludedUrls_accessor_storage=[];get excludedUrls(){return this.#excludedUrls_accessor_storage}set excludedUrls(value){this.#excludedUrls_accessor_storage=value}#forNewColumn_accessor_storage=false;get forNewColumn(){return this.#forNewColumn_accessor_storage}set forNewColumn(value){this.#forNewColumn_accessor_storage=value}#isTableFull_accessor_storage=false;get isTableFull(){return this.#isTableFull_accessor_storage}set isTableFull(value){this.#isTableFull_accessor_storage=value}#sections_accessor_storage=[];get sections(){return this.#sections_accessor_storage}set sections(value){this.#sections_accessor_storage=value}render(){return getHtml.bind(this)()}async showAt(element){const suggestedUrlInfos=await this.shoppingApi_.getUrlInfosForProductTabs();const filteredSuggestedUrlInfos=this.filterUrlInfos_(suggestedUrlInfos.urlInfos);const suggestedTabs=this.urlInfosToListEntries_(filteredSuggestedUrlInfos);const recentlyViewedUrlInfos=await this.shoppingApi_.getUrlInfosForRecentlyViewedTabs();const filteredRecentlyViewedUrlInfos=this.filterUrlInfos_(recentlyViewedUrlInfos.urlInfos);const recentlyViewedTabs=this.urlInfosToListEntries_(filteredRecentlyViewedUrlInfos);const updatedSections=[];if(suggestedTabs.length>0){updatedSections.push({title:loadTimeData.getString("suggestedTabs"),entries:suggestedTabs,expanded:true,sectionType:SectionType.SUGGESTED})}if(recentlyViewedTabs.length>0){updatedSections.push({title:loadTimeData.getString("recentlyViewedTabs"),entries:recentlyViewedTabs,expanded:true,sectionType:SectionType.RECENT})}this.sections=updatedSections;const rect=element.getBoundingClientRect();this.$.menu.get().showAt(element,{anchorAlignmentX:AnchorAlignment.AFTER_START,top:rect.bottom,left:rect.left})}close(){const menu=this.$.menu.getIfExists();if(menu){menu.close()}}expandedChanged_(e,section){section.expanded=e.detail.value;this.requestUpdate()}filterUrlInfos_(urlInfos){return urlInfos.filter((urlInfo=>urlInfo.url.url!==this.selectedUrl&&!this.excludedUrls.includes(urlInfo.url.url)))}urlInfosToListEntries_(urlInfos){return urlInfos.map((({title:title,url:url})=>({title:title,url:url.url,imageUrl:url.url})))}onSelect_(e){const currentTarget=e.currentTarget;const itemIndex=Number(currentTarget.dataset["itemIndex"]);const sectionIndex=Number(currentTarget.dataset["sectionIndex"]);const sectionType=Number(currentTarget.dataset["sectionType"]);const item=this.sections[sectionIndex]?.entries[itemIndex]||null;assert(!!item);this.close();this.dispatchEvent(new CustomEvent("selected-url-change",{bubbles:true,composed:true,detail:{url:item.url,urlSection:sectionType}}))}onRemoveClick_(){this.close();this.dispatchEvent(new CustomEvent("remove-url",{bubbles:true,composed:true}))}onClose_(){this.dispatchEvent(new CustomEvent("close-menu",{bubbles:true,composed:true}))}getUrl_(item){return getAbbreviatedUrl(item.url)}showEmptySuggestionsMessage_(){return(!this.sections||this.sections.length===0)&&!this.showTableFullMessage_()}showTableFullMessage_(){return this.forNewColumn&&this.isTableFull}isLastSection_(sectionIndex){return this.sections&&sectionIndex===this.sections.length-1}}customElements.define(ProductSelectionMenuElement.is,ProductSelectionMenuElement);