// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Browser Proxy for Certificate Viewer. Helps make testing
 * easier.
 */
import { sendWithPromise } from 'chrome://resources/js/cr.js';
export class CertViewerBrowserProxyImpl {
    updateTrustState(newTrust) {
        return sendWithPromise('updateTrustState', newTrust);
    }
    addConstraint(constraint) {
        return sendWithPromise('addConstraint', constraint);
    }
    deleteConstraint(constraint) {
        return sendWithPromise('deleteConstraint', constraint);
    }
    static getInstance() {
        return instance || (instance = new CertViewerBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
