/**
 * @fileoverview The 'local-certs-section' component is a section of the
 * Certificate Management UI that shows local modifications to the the users
 * trusted roots for TLS server auth (e.g. roots imported from the platform).
 */
import './certificate_manager_icons.html.js';
import './certificate_manager_style.css.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/cr_link_row/cr_link_row.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/cr_toggle/cr_toggle.js';
import '//resources/cr_elements/cr_page_host_style.css.js';
import type { CrToggleElement } from '//resources/cr_elements/cr_toggle/cr_toggle.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { CertificateSource } from './certificate_manager.mojom-webui.js';
import { Page } from './navigation.js';
export interface LocalCertsSectionElement {
    $: {
        manageOsImportedCerts: HTMLElement;
        importOsCerts: CrToggleElement;
        importOsCertsManagedIcon: HTMLElement;
        viewOsImportedCerts: HTMLElement;
        numSystemCerts: HTMLElement;
    };
}
export declare class LocalCertsSectionElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        numPolicyCertsString_: StringConstructor;
        numUserCertsString_: StringConstructor;
        certManagementMetadata_: ObjectConstructor;
        numSystemCertsString_: StringConstructor;
        importOsCertsEnabled_: {
            type: BooleanConstructor;
            computed: string;
        };
        importOsCertsEnabledManaged_: {
            type: BooleanConstructor;
            computed: string;
        };
        showViewOsCertsLinkRow_: {
            type: BooleanConstructor;
            computed: string;
        };
        certificateSourceEnum_: {
            type: ObjectConstructor;
            value: typeof CertificateSource;
        };
        pageEnum_: {
            type: ObjectConstructor;
            value: typeof Page;
        };
    };
    private numPolicyCertsString_;
    private numUserCertsString_;
    private certManagementMetadata_;
    private numSystemCertsString_;
    private importOsCertsEnabled_;
    private importOsCertsEnabledManaged_;
    private showViewOsCertsLinkRow_;
    ready(): void;
    private onMetadataRefresh_;
    setFocusToLinkRow(p: Page): void;
    private updateNumCertsStrings_;
    private onPlatformCertsLinkRowClick_;
    private onAdminCertsInstalledLinkRowClick_;
    private onUserCertsInstalledLinkRowClick_;
    private computeImportOsCertsEnabled_;
    private computeImportOsCertsManaged_;
    private computeShowViewOsCertsLinkRow_;
    private showCustomSection_;
    private showPolicySection_;
    private showUserSection_;
    private onManageCertsExternal_;
    private onOsCertsToggleChanged_;
}
declare global {
    interface HTMLElementTagNameMap {
        'local-certs-section': LocalCertsSectionElement;
    }
}
