// chrome/browser/resources/certificate_manager/certificate_manager.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_TEST_UTILS_H_

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom.h"


namespace certificate_manager::mojom {


class  CertificateManagerPageHandlerFactoryInterceptorForTesting : public CertificateManagerPageHandlerFactory {
  virtual CertificateManagerPageHandlerFactory* GetForwardingInterface() = 0;
  void CreateCertificateManagerPageHandler(::mojo::PendingRemote<CertificateManagerPage> page, ::mojo::PendingReceiver<CertificateManagerPageHandler> handler) override;
};
class  CertificateManagerPageHandlerFactoryAsyncWaiter {
 public:
  explicit CertificateManagerPageHandlerFactoryAsyncWaiter(CertificateManagerPageHandlerFactory* proxy);

  CertificateManagerPageHandlerFactoryAsyncWaiter(const CertificateManagerPageHandlerFactoryAsyncWaiter&) = delete;
  CertificateManagerPageHandlerFactoryAsyncWaiter& operator=(const CertificateManagerPageHandlerFactoryAsyncWaiter&) = delete;

  ~CertificateManagerPageHandlerFactoryAsyncWaiter();

 private:
  CertificateManagerPageHandlerFactory* const proxy_;
};


class  CertificateManagerPageHandlerInterceptorForTesting : public CertificateManagerPageHandler {
  virtual CertificateManagerPageHandler* GetForwardingInterface() = 0;
  void GetCertificates(CertificateSource source, GetCertificatesCallback callback) override;
  void GetCertManagementMetadata(GetCertManagementMetadataCallback callback) override;
  void ViewCertificate(CertificateSource source, const std::string& sha256_hash_hex) override;
  void ExportCertificates(CertificateSource source) override;
  void ImportCertificate(CertificateSource source, ImportCertificateCallback callback) override;
  void ImportAndBindCertificate(CertificateSource source, ImportAndBindCertificateCallback callback) override;
  void DeleteCertificate(CertificateSource source, const std::string& display_name, const std::string& sha256_hash_hex, DeleteCertificateCallback callback) override;
  void ShowNativeManageCertificates() override;
  void SetIncludeSystemTrustStore(bool include) override;
};
class  CertificateManagerPageHandlerAsyncWaiter {
 public:
  explicit CertificateManagerPageHandlerAsyncWaiter(CertificateManagerPageHandler* proxy);

  CertificateManagerPageHandlerAsyncWaiter(const CertificateManagerPageHandlerAsyncWaiter&) = delete;
  CertificateManagerPageHandlerAsyncWaiter& operator=(const CertificateManagerPageHandlerAsyncWaiter&) = delete;

  ~CertificateManagerPageHandlerAsyncWaiter();
  void GetCertificates(
      CertificateSource source, std::vector<SummaryCertInfoPtr>* out_certs);
  std::vector<SummaryCertInfoPtr> GetCertificates(CertificateSource source);
  void GetCertManagementMetadata(
      CertManagementMetadataPtr* out_metadata);
  CertManagementMetadataPtr GetCertManagementMetadata();
  void ImportCertificate(
      CertificateSource source, ActionResultPtr* out_result);
  ActionResultPtr ImportCertificate(CertificateSource source);
  void ImportAndBindCertificate(
      CertificateSource source, ActionResultPtr* out_result);
  ActionResultPtr ImportAndBindCertificate(CertificateSource source);
  void DeleteCertificate(
      CertificateSource source, const std::string& display_name, const std::string& sha256_hash_hex, ActionResultPtr* out_result);
  ActionResultPtr DeleteCertificate(CertificateSource source, const std::string& display_name, const std::string& sha256_hash_hex);

 private:
  CertificateManagerPageHandler* const proxy_;
};


class  CertificateManagerPageInterceptorForTesting : public CertificateManagerPage {
  virtual CertificateManagerPage* GetForwardingInterface() = 0;
  void AskForImportPassword(AskForImportPasswordCallback callback) override;
  void AskForConfirmation(const std::string& title, const std::string& message, AskForConfirmationCallback callback) override;
  void TriggerReload(const std::vector<CertificateSource>& sources) override;
  void TriggerMetadataUpdate() override;
};
class  CertificateManagerPageAsyncWaiter {
 public:
  explicit CertificateManagerPageAsyncWaiter(CertificateManagerPage* proxy);

  CertificateManagerPageAsyncWaiter(const CertificateManagerPageAsyncWaiter&) = delete;
  CertificateManagerPageAsyncWaiter& operator=(const CertificateManagerPageAsyncWaiter&) = delete;

  ~CertificateManagerPageAsyncWaiter();
  void AskForImportPassword(
      std::optional<std::string>* out_password);
  std::optional<std::string> AskForImportPassword();
  void AskForConfirmation(
      const std::string& title, const std::string& message, bool* out_confirmed);
  bool AskForConfirmation(const std::string& title, const std::string& message);

 private:
  CertificateManagerPage* const proxy_;
};




}  // certificate_manager::mojom

#endif  // CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_TEST_UTILS_H_