// chrome/browser/resources/certificate_manager/certificate_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-shared-internal.h"


namespace certificate_manager::mojom {
class SummaryCertInfoDataView;

class CertManagementMetadataDataView;

class ActionResultDataView;


}  // certificate_manager::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::certificate_manager::mojom::SummaryCertInfoDataView> {
  using Data = ::certificate_manager::mojom::internal::SummaryCertInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::certificate_manager::mojom::CertManagementMetadataDataView> {
  using Data = ::certificate_manager::mojom::internal::CertManagementMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::certificate_manager::mojom::ActionResultDataView> {
  using Data = ::certificate_manager::mojom::internal::ActionResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace certificate_manager::mojom {


enum class CertificateSource : int32_t {
  
  kChromeRootStore = 1,
  
  kPlatformClientCert = 2,
  
  kEnterpriseTrustedCerts = 3,
  
  kEnterpriseIntermediateCerts = 4,
  
  kEnterpriseDistrustedCerts = 5,
  
  kPlatformUserTrustedCerts = 6,
  
  kPlatformUserIntermediateCerts = 7,
  
  kPlatformUserDistrustedCerts = 8,
  
  kProvisionedClientCert = 9,
  
  kUserTrustedCerts = 10,
  
  kUserIntermediateCerts = 11,
  
  kUserDistrustedCerts = 12,
  kMinValue = 1,
  kMaxValue = 12,
};

 std::ostream& operator<<(std::ostream& os, CertificateSource value);
inline bool IsKnownEnumValue(CertificateSource value) {
  return internal::CertificateSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SuccessResult : int32_t {
  
  kSuccess = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, SuccessResult value);
inline bool IsKnownEnumValue(SuccessResult value) {
  return internal::SuccessResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CertificateManagerPageHandlerFactoryInterfaceBase {};

using CertificateManagerPageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<CertificateManagerPageHandlerFactoryInterfaceBase>;
using CertificateManagerPageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<CertificateManagerPageHandlerFactoryInterfaceBase>;
using CertificateManagerPageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertificateManagerPageHandlerFactoryInterfaceBase>;
using CertificateManagerPageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertificateManagerPageHandlerFactoryInterfaceBase>;
class CertificateManagerPageHandlerInterfaceBase {};

using CertificateManagerPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<CertificateManagerPageHandlerInterfaceBase>;
using CertificateManagerPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<CertificateManagerPageHandlerInterfaceBase>;
using CertificateManagerPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertificateManagerPageHandlerInterfaceBase>;
using CertificateManagerPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertificateManagerPageHandlerInterfaceBase>;
class CertificateManagerPageInterfaceBase {};

using CertificateManagerPagePtrDataView =
    mojo::InterfacePtrDataView<CertificateManagerPageInterfaceBase>;
using CertificateManagerPageRequestDataView =
    mojo::InterfaceRequestDataView<CertificateManagerPageInterfaceBase>;
using CertificateManagerPageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertificateManagerPageInterfaceBase>;
using CertificateManagerPageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertificateManagerPageInterfaceBase>;


class SummaryCertInfoDataView {
 public:
  SummaryCertInfoDataView() = default;

  SummaryCertInfoDataView(
      internal::SummaryCertInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSha256hashHexDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSha256hashHex(UserType* output) {
    
    auto* pointer = data_->sha256hash_hex.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_deletable() const {
    return data_->is_deletable;
  }
 private:
  internal::SummaryCertInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CertManagementMetadataDataView {
 public:
  CertManagementMetadataDataView() = default;

  CertManagementMetadataDataView(
      internal::CertManagementMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool include_system_trust_store() const {
    return data_->include_system_trust_store;
  }
  uint8_t num_user_added_system_certs() const {
    return data_->num_user_added_system_certs;
  }
  bool is_include_system_trust_store_managed() const {
    return data_->is_include_system_trust_store_managed;
  }
  uint8_t num_policy_certs() const {
    return data_->num_policy_certs;
  }
  uint32_t num_user_certs() const {
    return data_->num_user_certs;
  }
  bool show_user_certs_ui() const {
    return data_->show_user_certs_ui;
  }
 private:
  internal::CertManagementMetadata_Data* data_ = nullptr;
};


class ActionResultDataView {
 public:
  using Tag = internal::ActionResult_Data::ActionResult_Tag;

  ActionResultDataView() = default;

  ActionResultDataView(
      internal::ActionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error.Get(), output, message_);
  }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    CHECK(is_success());
    return mojo::internal::Deserialize<::certificate_manager::mojom::SuccessResult>(
        data_->data.f_success, output);
  }
  SuccessResult success() const {
    CHECK(is_success());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::certificate_manager::mojom::SuccessResult>(data_->data.f_success));
  }

 private:
  internal::ActionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // certificate_manager::mojom

#endif  // CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_DATA_VIEW_H_