// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icons.css.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import { WebUiListenerMixinLit } from 'chrome://resources/cr_elements/web_ui_listener_mixin_lit.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { BrowserProxyImpl } from './browser_proxy.js';
import { getCss } from './promo_card.css.js';
import { getHtml } from './promo_card.html.js';
const PromoCardElementBase = WebUiListenerMixinLit(CrLitElement);
export class PromoCardElement extends PromoCardElementBase {
    static get is() {
        return 'promo-card';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            batchUploadPromoData_: { type: Object },
        };
    }
    #batchUploadPromoData__accessor_storage = {
        canShow: false,
        promoSubtitle: '',
    };
    get batchUploadPromoData_() { return this.#batchUploadPromoData__accessor_storage; }
    set batchUploadPromoData_(value) { this.#batchUploadPromoData__accessor_storage = value; }
    connectedCallback() {
        super.connectedCallback();
        this.browserProxy_.getBatchUploadPromoInfo().then(this.updateBatchUploadPromoData_.bind(this));
        this.addWebUiListener('batch-upload-promo-info-updated', this.updateBatchUploadPromoData_.bind(this));
    }
    browserProxy_ = BrowserProxyImpl.getInstance();
    updateBatchUploadPromoData_(promoData) {
        this.batchUploadPromoData_ = promoData;
        this.propagateShouldShowPromo_(this.batchUploadPromoData_.canShow);
    }
    onSaveToAccountClick_() {
        this.browserProxy_.onBatchUploadPromoClicked();
    }
    onCloseClick_() {
        this.browserProxy_.onBatchUploadPromoDismissed();
        // Allows to close the promo right away instead of waiting for the
        // notification from the browser.
        this.propagateShouldShowPromo_(false);
    }
    // Trigger update on the list.
    propagateShouldShowPromo_(shouldShow) {
        this.fire('on-should-show-promo-card', { shouldShowPromoCard: shouldShow });
    }
}
customElements.define(PromoCardElement.is, PromoCardElement);
