export type Query = string | {
    query?: string;
    url?: string;
    title?: string;
};
export interface BookmarksApiProxy {
    getTree(): Promise<chrome.bookmarks.BookmarkTreeNode[]>;
    search(query: Query): Promise<chrome.bookmarks.BookmarkTreeNode[]>;
    update(id: string, changes: {
        title?: string;
        url?: string;
    }): Promise<chrome.bookmarks.BookmarkTreeNode>;
    create(bookmark: chrome.bookmarks.CreateDetails): Promise<chrome.bookmarks.BookmarkTreeNode>;
}
export declare class BookmarksApiProxyImpl implements BookmarksApiProxy {
    getTree(): Promise<chrome.bookmarks.BookmarkTreeNode[]>;
    search(query: Query): Promise<chrome.bookmarks.BookmarkTreeNode[]>;
    update(id: string, changes: {
        title?: string;
        url?: string;
    }): Promise<chrome.bookmarks.BookmarkTreeNode>;
    create(bookmark: chrome.bookmarks.CreateDetails): Promise<chrome.bookmarks.BookmarkTreeNode>;
    static getInstance(): BookmarksApiProxy;
    static setInstance(obj: BookmarksApiProxy): void;
}
