/**
 * A list that displays ServiceListItems.
 */
export class ServiceListElement extends ExpandableListElement {
    /** @private {?string} */
    private deviceAddress_;
    /** @private {boolean} */
    private servicesRequested_;
    /** @override */
    override createItem(data: any): HTMLElement;
    /**
     * Loads the service list with an array of ServiceInfo from the
     * device with |deviceAddress|. If no active connection to the device
     * exists, one is created.
     * @param {string} deviceAddress
     */
    load(deviceAddress: string): void;
}
import { ExpandableListElement } from './expandable_list.js';
