/**
 * Enum of scan status for the devices page.
 */
export type ScanStatus = number;
export namespace ScanStatus {
    let OFF: number;
    let STARTING: number;
    let ON: number;
    let STOPPING: number;
}
/**
 * Page that contains a header and a DevicesView.
 */
export class DevicesPage extends Page {
    constructor();
    deviceTable: HTMLElement;
    scanBtn_: Element | null;
    /**
     * Sets the device collection for the page's device table.
     * @param {!DeviceCollection} devices
     */
    setDevices(devices: DeviceCollection): void;
    /**
     * Updates the inspect status of the given |deviceInfo| in the device table.
     * @param {!DeviceInfo} deviceInfo
     * @param {boolean} isInspecting
     */
    setInspecting(deviceInfo: DeviceInfo, isInspecting: boolean): void;
    /**
     * If Bluetooth is currently powered off do not show start discovery button.
     * @param {boolean} powered
     */
    updatedScanButtonVisibility(powered: boolean): void;
    setScanStatus(status: any): void;
}
import { Page } from './page.js';
import { DeviceCollection } from './device_collection.js';
