/**
 * A table that lists the devices and responds to changes in the given
 * DeviceCollection. Fires events for inspection requests from listed
 * devices.
 */
export class DeviceTableElement extends CustomElement {
    static get is(): string;
    /** @private {?DeviceCollection} */
    private devices_;
    /** @private {?HTMLTBodyElement} */
    private body_;
    /** @private {?NodeListOf<Element>} */
    private headers_;
    /** @private {!Map<!DeviceInfo, boolean>} */
    private inspectionMap_;
    /**
     * Decorates an element as a UI element class. Caches references to the
     *    table body and headers.
     */
    connectedCallback(): void;
    /**
     * Sets the tables device collection.
     * @param {!DeviceCollection} deviceCollection
     */
    setDevices(deviceCollection: DeviceCollection): void;
    /**
     * Updates the inspect status of the row matching the given |deviceInfo|.
     * If |isInspecting| is true, the forget link is enabled otherwise it's
     * disabled.
     * @param {!DeviceInfo} deviceInfo
     * @param {boolean} isInspecting
     */
    setInspecting(deviceInfo: DeviceInfo, isInspecting: boolean): void;
    /**
     * Fires a forget pressed event for the row |index|.
     * @param {number} index
     * @private
     */
    private handleForgetClick_;
    /**
     * Updates table row on change event of the device collection.
     * @param {!CustomEvent<number>} event
     * @private
     */
    private handleDeviceUpdate_;
    /**
     * Fires an inspect pressed event for the row |index|.
     * @param {number} index
     * @private
     */
    private handleInspectClick_;
    /**
     * Updates table row on splice event of the device collection.
     * @param {!CustomEvent<device: DeviceInfo, index: number>} event
     * @private
     */
    private handleDeviceAdded_;
    /**
     * Inserts a new row at |index| and updates it with info from |device|.
     * @param {!DeviceInfo} device
     * @param {?number} index
     * @private
     */
    private insertRow_;
    /**
     * Deletes and recreates the table using the cached |devices_|.
     * @private
     */
    private redraw_;
    /**
     * Updates the row at |index| with the info from |device|.
     * @param {!DeviceInfo} device
     * @param {number} index
     * @private
     */
    private updateRow_;
}
import { CustomElement } from 'chrome://resources/js/custom_element.js';
import { DeviceCollection } from './device_collection.js';
