/**
 * Enum of connection status for a device.
 */
export type ConnectionStatus = number;
export namespace ConnectionStatus {
    let DISCONNECTED: number;
    let CONNECTING: number;
    let CONNECTED: number;
}
/**
 * Collection of devices. Extends EventTarget to notify observers when the
 * collection changes.
 */
export class DeviceCollection extends EventTarget {
    /**
     * @param {!Array<!DeviceInfo>} array The starting
     *     collection of devices.
     */
    constructor(array: Array<DeviceInfo>);
    /** @private {!Array<!DeviceInfo>} */
    private array_;
    /** @private {!Object<string, boolean>} */
    private removedDevices_;
    /** @return {number} */
    get length(): number;
    /**
     * @param {number}
     * @return {DeviceInfo}
     */
    item(index: any): DeviceInfo;
    /**
     * Finds the Device in the collection with the matching address.
     * @param {string} address
     * @return {number} The index where the device was found.
     */
    getByAddress(address: string): number;
    /**
     * Adds or updates a Device with new DeviceInfo.
     * @param {!DeviceInfo} deviceInfo
     */
    addOrUpdate(deviceInfo: DeviceInfo): void;
    /**
     * Marks the Device as removed.
     * @param {!DeviceInfo} deviceInfo
     */
    remove(deviceInfo: DeviceInfo): void;
    /**
     * Return true if device was "removed" -- previously found via scan but
     * either no longer advertising or no longer nearby.
     * @param {!DeviceInfo} deviceInfo
     * @return {boolean}
     */
    isRemoved(deviceInfo: DeviceInfo): boolean;
    resetForTest(): void;
}
