export function initializeViews(bluetoothInternalsHandler: any): Promise<void>;
/**
 * Check if the system has all the needed system permissions for using
 * bluetooth.
 * @param {BluetoothInternalsHandlerRemote} bluetoothInternalsHandler Mojo
 *     remote handler.
 * @param {Function} successCallback The callback to be called when the system
 *     has the permissions for using bluetooth.
 */
export function checkSystemPermissions(bluetoothInternalsHandler: BluetoothInternalsHandlerRemote, successCallback: Function): Promise<void>;
/** @type {AdapterBroker} */
export let adapterBroker: AdapterBroker;
/** @type {DeviceCollection} */
export let devices: DeviceCollection;
/** @type {Sidebar} */
export let sidebarObj: Sidebar;
/** @type {PageManager} */
export const pageManager: PageManager;
import { BluetoothInternalsHandlerRemote } from './bluetooth_internals.mojom-webui.js';
import { AdapterBroker } from './adapter_broker.js';
import { DeviceCollection } from './device_collection.js';
import { Sidebar } from './sidebar.js';
import { PageManager } from './page_manager.js';
