// device/bluetooth/public/mojom/adapter.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  DeviceRemote as bluetooth_mojom_DeviceRemote,
  DeviceInfoSpec as bluetooth_mojom_DeviceInfoSpec,
  DeviceInfo as bluetooth_mojom_DeviceInfo
} from './device.mojom-webui.js';
import {
  GattCharacteristicPermissionsSpec as bluetooth_mojom_GattCharacteristicPermissionsSpec,
  GattCharacteristicPermissions as bluetooth_mojom_GattCharacteristicPermissions
} from './gatt_characteristic_permissions.mojom-webui.js';
import {
  GattCharacteristicPropertiesSpec as bluetooth_mojom_GattCharacteristicPropertiesSpec,
  GattCharacteristicProperties as bluetooth_mojom_GattCharacteristicProperties
} from './gatt_characteristic_properties.mojom-webui.js';
import {
  GattServiceErrorCodeSpec as bluetooth_mojom_GattServiceErrorCodeSpec,
  GattServiceErrorCode as bluetooth_mojom_GattServiceErrorCode
} from './gatt_service_error_code.mojom-webui.js';
import {
  UUIDSpec as bluetooth_mojom_UUIDSpec,
  UUID as bluetooth_mojom_UUID
} from './uuid.mojom-webui.js';





export const ConnectResultSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ConnectResult {

  MIN_VALUE = 0,
  MAX_VALUE = 22,
  SUCCESS = 0,
  AUTH_CANCELED = 1,
  AUTH_FAILED = 2,
  AUTH_REJECTED = 3,
  AUTH_TIMEOUT = 4,
  FAILED = 5,
  INPROGRESS = 6,
  UNKNOWN = 7,
  UNSUPPORTED_DEVICE = 8,
  DEVICE_NO_LONGER_IN_RANGE = 9,
  NOT_READY = 10,
  ALREADY_CONNECTED = 11,
  ALREADY_EXISTS = 12,
  NOT_CONNECTED = 13,
  DOES_NOT_EXIST = 14,
  INVALID_ARGS = 15,
  NON_AUTH_TIMEOUT = 16,
  NO_MEMORY = 17,
  JNI_ENVIRONMENT = 18,
  JNI_THREAD_ATTACH = 19,
  WAKELOCK = 20,
  UNEXPECTED_STATE = 21,
  SOCKET = 22,
}



export type AdvertisementPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<AdvertisementPendingReceiver>;

export class AdvertisementPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Advertisement> {

  handle: mojo.internal.interfaceSupport.Endpoint<AdvertisementPendingReceiver>;
  constructor(handle: MojoHandle|AdvertisementPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'bluetooth.mojom.Advertisement',
        scope);
  }
}

export interface AdvertisementInterface {
  unregister(): Promise<void>;
}

export class AdvertisementRemote implements AdvertisementInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<AdvertisementPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<AdvertisementPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|AdvertisementPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AdvertisementPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  unregister(): Promise<void> {
    return this.proxy.sendMessage(
        0,
        Advertisement_Unregister_ParamsSpec.$,
        Advertisement_Unregister_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Advertisement
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AdvertisementReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AdvertisementRemote, AdvertisementPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AdvertisementRemote, AdvertisementPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: AdvertisementInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AdvertisementRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Advertisement_Unregister_ParamsSpec.$,
        Advertisement_Unregister_ResponseParamsSpec.$,
        impl.unregister.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Advertisement {
  static get $interfaceName(): string {
    return "bluetooth.mojom.Advertisement";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): AdvertisementRemote {
    let remote = new AdvertisementRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Advertisement
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AdvertisementCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AdvertisementRemote, AdvertisementPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AdvertisementRemote, AdvertisementPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  unregister: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AdvertisementRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.unregister =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Advertisement_Unregister_ParamsSpec.$,
        Advertisement_Unregister_ResponseParamsSpec.$,
        this.unregister.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type DiscoverySessionPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<DiscoverySessionPendingReceiver>;

export class DiscoverySessionPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<DiscoverySession> {

  handle: mojo.internal.interfaceSupport.Endpoint<DiscoverySessionPendingReceiver>;
  constructor(handle: MojoHandle|DiscoverySessionPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'bluetooth.mojom.DiscoverySession',
        scope);
  }
}

export interface DiscoverySessionInterface {
  isActive(): Promise<{
        active: boolean, }>;
  stop(): Promise<{
        success: boolean, }>;
}

export class DiscoverySessionRemote implements DiscoverySessionInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<DiscoverySessionPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<DiscoverySessionPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|DiscoverySessionPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DiscoverySessionPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  isActive(): Promise<{
        active: boolean, }> {
    return this.proxy.sendMessage(
        0,
        DiscoverySession_IsActive_ParamsSpec.$,
        DiscoverySession_IsActive_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  stop(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        1,
        DiscoverySession_Stop_ParamsSpec.$,
        DiscoverySession_Stop_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DiscoverySession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DiscoverySessionReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    DiscoverySessionRemote, DiscoverySessionPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    DiscoverySessionRemote, DiscoverySessionPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: DiscoverySessionInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DiscoverySessionRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DiscoverySession_IsActive_ParamsSpec.$,
        DiscoverySession_IsActive_ResponseParamsSpec.$,
        impl.isActive.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DiscoverySession_Stop_ParamsSpec.$,
        DiscoverySession_Stop_ResponseParamsSpec.$,
        impl.stop.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DiscoverySession {
  static get $interfaceName(): string {
    return "bluetooth.mojom.DiscoverySession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): DiscoverySessionRemote {
    let remote = new DiscoverySessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the DiscoverySession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DiscoverySessionCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    DiscoverySessionRemote, DiscoverySessionPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    DiscoverySessionRemote, DiscoverySessionPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  isActive: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stop: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DiscoverySessionRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.isActive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DiscoverySession_IsActive_ParamsSpec.$,
        DiscoverySession_IsActive_ResponseParamsSpec.$,
        this.isActive.createReceiverHandler(true /* expectsResponse */),
        false);
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DiscoverySession_Stop_ParamsSpec.$,
        DiscoverySession_Stop_ResponseParamsSpec.$,
        this.stop.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type SocketPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<SocketPendingReceiver>;

export class SocketPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Socket> {

  handle: mojo.internal.interfaceSupport.Endpoint<SocketPendingReceiver>;
  constructor(handle: MojoHandle|SocketPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'bluetooth.mojom.Socket',
        scope);
  }
}

export interface SocketInterface {
  disconnect(): Promise<void>;
}

export class SocketRemote implements SocketInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<SocketPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<SocketPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|SocketPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SocketPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  disconnect(): Promise<void> {
    return this.proxy.sendMessage(
        0,
        Socket_Disconnect_ParamsSpec.$,
        Socket_Disconnect_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Socket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SocketReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    SocketRemote, SocketPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    SocketRemote, SocketPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: SocketInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SocketRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Socket_Disconnect_ParamsSpec.$,
        Socket_Disconnect_ResponseParamsSpec.$,
        impl.disconnect.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Socket {
  static get $interfaceName(): string {
    return "bluetooth.mojom.Socket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): SocketRemote {
    let remote = new SocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Socket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SocketCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    SocketRemote, SocketPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    SocketRemote, SocketPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  disconnect: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SocketRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.disconnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Socket_Disconnect_ParamsSpec.$,
        Socket_Disconnect_ResponseParamsSpec.$,
        this.disconnect.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ServerSocketPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ServerSocketPendingReceiver>;

export class ServerSocketPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ServerSocket> {

  handle: mojo.internal.interfaceSupport.Endpoint<ServerSocketPendingReceiver>;
  constructor(handle: MojoHandle|ServerSocketPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'bluetooth.mojom.ServerSocket',
        scope);
  }
}

export interface ServerSocketInterface {
  accept(): Promise<{
        result: (AcceptConnectionResult | null), }>;
  disconnect(): Promise<void>;
}

export class ServerSocketRemote implements ServerSocketInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ServerSocketPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ServerSocketPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ServerSocketPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServerSocketPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  accept(): Promise<{
        result: (AcceptConnectionResult | null), }> {
    return this.proxy.sendMessage(
        0,
        ServerSocket_Accept_ParamsSpec.$,
        ServerSocket_Accept_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  disconnect(): Promise<void> {
    return this.proxy.sendMessage(
        1,
        ServerSocket_Disconnect_ParamsSpec.$,
        ServerSocket_Disconnect_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServerSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServerSocketReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ServerSocketRemote, ServerSocketPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ServerSocketRemote, ServerSocketPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ServerSocketInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServerSocketRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServerSocket_Accept_ParamsSpec.$,
        ServerSocket_Accept_ResponseParamsSpec.$,
        impl.accept.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServerSocket_Disconnect_ParamsSpec.$,
        ServerSocket_Disconnect_ResponseParamsSpec.$,
        impl.disconnect.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServerSocket {
  static get $interfaceName(): string {
    return "bluetooth.mojom.ServerSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ServerSocketRemote {
    let remote = new ServerSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ServerSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServerSocketCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ServerSocketRemote, ServerSocketPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ServerSocketRemote, ServerSocketPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  accept: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  disconnect: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServerSocketRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.accept =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServerSocket_Accept_ParamsSpec.$,
        ServerSocket_Accept_ResponseParamsSpec.$,
        this.accept.createReceiverHandler(true /* expectsResponse */),
        false);
    this.disconnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServerSocket_Disconnect_ParamsSpec.$,
        ServerSocket_Disconnect_ResponseParamsSpec.$,
        this.disconnect.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type GattServicePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<GattServicePendingReceiver>;

export class GattServicePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<GattService> {

  handle: mojo.internal.interfaceSupport.Endpoint<GattServicePendingReceiver>;
  constructor(handle: MojoHandle|GattServicePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'bluetooth.mojom.GattService',
        scope);
  }
}

export interface GattServiceInterface {
  createCharacteristic(characteristicUuid: bluetooth_mojom_UUID, permissions: bluetooth_mojom_GattCharacteristicPermissions, properties: bluetooth_mojom_GattCharacteristicProperties): Promise<{
        success: boolean, }>;
  register(): Promise<{
        errorCode: (bluetooth_mojom_GattServiceErrorCode | null), }>;
}

export class GattServiceRemote implements GattServiceInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<GattServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<GattServicePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|GattServicePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GattServicePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createCharacteristic(
      characteristicUuid: bluetooth_mojom_UUID,
      permissions: bluetooth_mojom_GattCharacteristicPermissions,
      properties: bluetooth_mojom_GattCharacteristicProperties): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        0,
        GattService_CreateCharacteristic_ParamsSpec.$,
        GattService_CreateCharacteristic_ResponseParamsSpec.$,
        [
          characteristicUuid,
          permissions,
          properties
        ],
        false);
  }

  register(): Promise<{
        errorCode: (bluetooth_mojom_GattServiceErrorCode | null), }> {
    return this.proxy.sendMessage(
        1,
        GattService_Register_ParamsSpec.$,
        GattService_Register_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GattService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GattServiceReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GattServiceRemote, GattServicePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GattServiceRemote, GattServicePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: GattServiceInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GattServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GattService_CreateCharacteristic_ParamsSpec.$,
        GattService_CreateCharacteristic_ResponseParamsSpec.$,
        impl.createCharacteristic.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        GattService_Register_ParamsSpec.$,
        GattService_Register_ResponseParamsSpec.$,
        impl.register.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GattService {
  static get $interfaceName(): string {
    return "bluetooth.mojom.GattService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): GattServiceRemote {
    let remote = new GattServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the GattService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GattServiceCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GattServiceRemote, GattServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GattServiceRemote, GattServicePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createCharacteristic: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  register: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GattServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createCharacteristic =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GattService_CreateCharacteristic_ParamsSpec.$,
        GattService_CreateCharacteristic_ResponseParamsSpec.$,
        this.createCharacteristic.createReceiverHandler(true /* expectsResponse */),
        false);
    this.register =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        GattService_Register_ParamsSpec.$,
        GattService_Register_ResponseParamsSpec.$,
        this.register.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type GattServiceObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<GattServiceObserverPendingReceiver>;

export class GattServiceObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<GattServiceObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<GattServiceObserverPendingReceiver>;
  constructor(handle: MojoHandle|GattServiceObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'bluetooth.mojom.GattServiceObserver',
        scope);
  }
}

export interface GattServiceObserverInterface {
  onLocalCharacteristicRead(remoteDevice: bluetooth_mojom_DeviceInfo, characteristicUuid: bluetooth_mojom_UUID, serviceUuid: bluetooth_mojom_UUID, offset: number): Promise<{
        readResult: LocalCharacteristicReadResult, }>;
}

export class GattServiceObserverRemote implements GattServiceObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<GattServiceObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<GattServiceObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|GattServiceObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GattServiceObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onLocalCharacteristicRead(
      remoteDevice: bluetooth_mojom_DeviceInfo,
      characteristicUuid: bluetooth_mojom_UUID,
      serviceUuid: bluetooth_mojom_UUID,
      offset: number): Promise<{
        readResult: LocalCharacteristicReadResult, }> {
    return this.proxy.sendMessage(
        0,
        GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec.$,
        GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec.$,
        [
          remoteDevice,
          characteristicUuid,
          serviceUuid,
          offset
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GattServiceObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GattServiceObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GattServiceObserverRemote, GattServiceObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GattServiceObserverRemote, GattServiceObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: GattServiceObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GattServiceObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec.$,
        GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec.$,
        impl.onLocalCharacteristicRead.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GattServiceObserver {
  static get $interfaceName(): string {
    return "bluetooth.mojom.GattServiceObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): GattServiceObserverRemote {
    let remote = new GattServiceObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the GattServiceObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GattServiceObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GattServiceObserverRemote, GattServiceObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GattServiceObserverRemote, GattServiceObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onLocalCharacteristicRead: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GattServiceObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onLocalCharacteristicRead =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec.$,
        GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec.$,
        this.onLocalCharacteristicRead.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type AdapterPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<AdapterPendingReceiver>;

export class AdapterPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Adapter> {

  handle: mojo.internal.interfaceSupport.Endpoint<AdapterPendingReceiver>;
  constructor(handle: MojoHandle|AdapterPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'bluetooth.mojom.Adapter',
        scope);
  }
}

export interface AdapterInterface {
  connectToDevice(address: string): Promise<{
        result: ConnectResult,
        device: (bluetooth_mojom_DeviceRemote | null), }>;
  getDevices(): Promise<{
        devices: bluetooth_mojom_DeviceInfo[], }>;
  getInfo(): Promise<{
        info: AdapterInfo, }>;
  addObserver(observer: AdapterObserverRemote): Promise<void>;
  registerAdvertisement(serviceId: bluetooth_mojom_UUID, serviceData: number[], useScanResponse: boolean, connectable: boolean): Promise<{
        advertisement: (AdvertisementRemote | null), }>;
  setDiscoverable(discoverable: boolean): Promise<{
        success: boolean, }>;
  setName(name: string): Promise<{
        success: boolean, }>;
  startDiscoverySession(clientName: string): Promise<{
        session: (DiscoverySessionRemote | null), }>;
  connectToServiceInsecurely(address: string, serviceUuid: bluetooth_mojom_UUID, shouldUnbondOnError: boolean): Promise<{
        result: (ConnectToServiceResult | null), }>;
  createRfcommServiceInsecurely(serviceName: string, serviceUuid: bluetooth_mojom_UUID): Promise<{
        serverSocket: (ServerSocketRemote | null), }>;
  createLocalGattService(serviceId: bluetooth_mojom_UUID, observer: GattServiceObserverRemote): Promise<{
        gattService: GattServiceRemote, }>;
  isLeScatternetDualRoleSupported(): Promise<{
        isSupported: boolean, }>;
}

export class AdapterRemote implements AdapterInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<AdapterPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<AdapterPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|AdapterPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AdapterPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  connectToDevice(
      address: string): Promise<{
        result: ConnectResult,
        device: (bluetooth_mojom_DeviceRemote | null), }> {
    return this.proxy.sendMessage(
        0,
        Adapter_ConnectToDevice_ParamsSpec.$,
        Adapter_ConnectToDevice_ResponseParamsSpec.$,
        [
          address
        ],
        false);
  }

  getDevices(): Promise<{
        devices: bluetooth_mojom_DeviceInfo[], }> {
    return this.proxy.sendMessage(
        1,
        Adapter_GetDevices_ParamsSpec.$,
        Adapter_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getInfo(): Promise<{
        info: AdapterInfo, }> {
    return this.proxy.sendMessage(
        2,
        Adapter_GetInfo_ParamsSpec.$,
        Adapter_GetInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  addObserver(
      observer: AdapterObserverRemote): Promise<void> {
    return this.proxy.sendMessage(
        3,
        Adapter_AddObserver_ParamsSpec.$,
        Adapter_AddObserver_ResponseParamsSpec.$,
        [
          observer
        ],
        false);
  }

  registerAdvertisement(
      serviceId: bluetooth_mojom_UUID,
      serviceData: number[],
      useScanResponse: boolean,
      connectable: boolean): Promise<{
        advertisement: (AdvertisementRemote | null), }> {
    return this.proxy.sendMessage(
        4,
        Adapter_RegisterAdvertisement_ParamsSpec.$,
        Adapter_RegisterAdvertisement_ResponseParamsSpec.$,
        [
          serviceId,
          serviceData,
          useScanResponse,
          connectable
        ],
        false);
  }

  setDiscoverable(
      discoverable: boolean): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        5,
        Adapter_SetDiscoverable_ParamsSpec.$,
        Adapter_SetDiscoverable_ResponseParamsSpec.$,
        [
          discoverable
        ],
        false);
  }

  setName(
      name: string): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        6,
        Adapter_SetName_ParamsSpec.$,
        Adapter_SetName_ResponseParamsSpec.$,
        [
          name
        ],
        false);
  }

  startDiscoverySession(
      clientName: string): Promise<{
        session: (DiscoverySessionRemote | null), }> {
    return this.proxy.sendMessage(
        7,
        Adapter_StartDiscoverySession_ParamsSpec.$,
        Adapter_StartDiscoverySession_ResponseParamsSpec.$,
        [
          clientName
        ],
        false);
  }

  connectToServiceInsecurely(
      address: string,
      serviceUuid: bluetooth_mojom_UUID,
      shouldUnbondOnError: boolean): Promise<{
        result: (ConnectToServiceResult | null), }> {
    return this.proxy.sendMessage(
        8,
        Adapter_ConnectToServiceInsecurely_ParamsSpec.$,
        Adapter_ConnectToServiceInsecurely_ResponseParamsSpec.$,
        [
          address,
          serviceUuid,
          shouldUnbondOnError
        ],
        false);
  }

  createRfcommServiceInsecurely(
      serviceName: string,
      serviceUuid: bluetooth_mojom_UUID): Promise<{
        serverSocket: (ServerSocketRemote | null), }> {
    return this.proxy.sendMessage(
        9,
        Adapter_CreateRfcommServiceInsecurely_ParamsSpec.$,
        Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec.$,
        [
          serviceName,
          serviceUuid
        ],
        false);
  }

  createLocalGattService(
      serviceId: bluetooth_mojom_UUID,
      observer: GattServiceObserverRemote): Promise<{
        gattService: GattServiceRemote, }> {
    return this.proxy.sendMessage(
        10,
        Adapter_CreateLocalGattService_ParamsSpec.$,
        Adapter_CreateLocalGattService_ResponseParamsSpec.$,
        [
          serviceId,
          observer
        ],
        false);
  }

  isLeScatternetDualRoleSupported(): Promise<{
        isSupported: boolean, }> {
    return this.proxy.sendMessage(
        11,
        Adapter_IsLeScatternetDualRoleSupported_ParamsSpec.$,
        Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Adapter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AdapterReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AdapterRemote, AdapterPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AdapterRemote, AdapterPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: AdapterInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AdapterRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Adapter_ConnectToDevice_ParamsSpec.$,
        Adapter_ConnectToDevice_ResponseParamsSpec.$,
        impl.connectToDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Adapter_GetDevices_ParamsSpec.$,
        Adapter_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Adapter_GetInfo_ParamsSpec.$,
        Adapter_GetInfo_ResponseParamsSpec.$,
        impl.getInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Adapter_AddObserver_ParamsSpec.$,
        Adapter_AddObserver_ResponseParamsSpec.$,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Adapter_RegisterAdvertisement_ParamsSpec.$,
        Adapter_RegisterAdvertisement_ResponseParamsSpec.$,
        impl.registerAdvertisement.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Adapter_SetDiscoverable_ParamsSpec.$,
        Adapter_SetDiscoverable_ResponseParamsSpec.$,
        impl.setDiscoverable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Adapter_SetName_ParamsSpec.$,
        Adapter_SetName_ResponseParamsSpec.$,
        impl.setName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Adapter_StartDiscoverySession_ParamsSpec.$,
        Adapter_StartDiscoverySession_ResponseParamsSpec.$,
        impl.startDiscoverySession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Adapter_ConnectToServiceInsecurely_ParamsSpec.$,
        Adapter_ConnectToServiceInsecurely_ResponseParamsSpec.$,
        impl.connectToServiceInsecurely.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        Adapter_CreateRfcommServiceInsecurely_ParamsSpec.$,
        Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec.$,
        impl.createRfcommServiceInsecurely.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        Adapter_CreateLocalGattService_ParamsSpec.$,
        Adapter_CreateLocalGattService_ResponseParamsSpec.$,
        impl.createLocalGattService.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        Adapter_IsLeScatternetDualRoleSupported_ParamsSpec.$,
        Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec.$,
        impl.isLeScatternetDualRoleSupported.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Adapter {
  static get $interfaceName(): string {
    return "bluetooth.mojom.Adapter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): AdapterRemote {
    let remote = new AdapterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Adapter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AdapterCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AdapterRemote, AdapterPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AdapterRemote, AdapterPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  connectToDevice: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDevices: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addObserver: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  registerAdvertisement: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setDiscoverable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setName: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  startDiscoverySession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  connectToServiceInsecurely: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  createRfcommServiceInsecurely: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  createLocalGattService: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isLeScatternetDualRoleSupported: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AdapterRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.connectToDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Adapter_ConnectToDevice_ParamsSpec.$,
        Adapter_ConnectToDevice_ResponseParamsSpec.$,
        this.connectToDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Adapter_GetDevices_ParamsSpec.$,
        Adapter_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Adapter_GetInfo_ParamsSpec.$,
        Adapter_GetInfo_ResponseParamsSpec.$,
        this.getInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Adapter_AddObserver_ParamsSpec.$,
        Adapter_AddObserver_ResponseParamsSpec.$,
        this.addObserver.createReceiverHandler(true /* expectsResponse */),
        false);
    this.registerAdvertisement =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Adapter_RegisterAdvertisement_ParamsSpec.$,
        Adapter_RegisterAdvertisement_ResponseParamsSpec.$,
        this.registerAdvertisement.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setDiscoverable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Adapter_SetDiscoverable_ParamsSpec.$,
        Adapter_SetDiscoverable_ResponseParamsSpec.$,
        this.setDiscoverable.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Adapter_SetName_ParamsSpec.$,
        Adapter_SetName_ResponseParamsSpec.$,
        this.setName.createReceiverHandler(true /* expectsResponse */),
        false);
    this.startDiscoverySession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Adapter_StartDiscoverySession_ParamsSpec.$,
        Adapter_StartDiscoverySession_ResponseParamsSpec.$,
        this.startDiscoverySession.createReceiverHandler(true /* expectsResponse */),
        false);
    this.connectToServiceInsecurely =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Adapter_ConnectToServiceInsecurely_ParamsSpec.$,
        Adapter_ConnectToServiceInsecurely_ResponseParamsSpec.$,
        this.connectToServiceInsecurely.createReceiverHandler(true /* expectsResponse */),
        false);
    this.createRfcommServiceInsecurely =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        Adapter_CreateRfcommServiceInsecurely_ParamsSpec.$,
        Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec.$,
        this.createRfcommServiceInsecurely.createReceiverHandler(true /* expectsResponse */),
        false);
    this.createLocalGattService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        Adapter_CreateLocalGattService_ParamsSpec.$,
        Adapter_CreateLocalGattService_ResponseParamsSpec.$,
        this.createLocalGattService.createReceiverHandler(true /* expectsResponse */),
        false);
    this.isLeScatternetDualRoleSupported =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        Adapter_IsLeScatternetDualRoleSupported_ParamsSpec.$,
        Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec.$,
        this.isLeScatternetDualRoleSupported.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type AdapterObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<AdapterObserverPendingReceiver>;

export class AdapterObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<AdapterObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<AdapterObserverPendingReceiver>;
  constructor(handle: MojoHandle|AdapterObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'bluetooth.mojom.AdapterObserver',
        scope);
  }
}

export interface AdapterObserverInterface {
  presentChanged(present: boolean): void;
  poweredChanged(powered: boolean): void;
  discoverableChanged(discoverable: boolean): void;
  discoveringChanged(discovering: boolean): void;
  deviceAdded(device: bluetooth_mojom_DeviceInfo): void;
  deviceChanged(device: bluetooth_mojom_DeviceInfo): void;
  deviceRemoved(device: bluetooth_mojom_DeviceInfo): void;
}

export class AdapterObserverRemote implements AdapterObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<AdapterObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<AdapterObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|AdapterObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AdapterObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  presentChanged(
      present: boolean): void {
    this.proxy.sendMessage(
        0,
        AdapterObserver_PresentChanged_ParamsSpec.$,
        null,
        [
          present
        ],
        false);
  }

  poweredChanged(
      powered: boolean): void {
    this.proxy.sendMessage(
        1,
        AdapterObserver_PoweredChanged_ParamsSpec.$,
        null,
        [
          powered
        ],
        false);
  }

  discoverableChanged(
      discoverable: boolean): void {
    this.proxy.sendMessage(
        2,
        AdapterObserver_DiscoverableChanged_ParamsSpec.$,
        null,
        [
          discoverable
        ],
        false);
  }

  discoveringChanged(
      discovering: boolean): void {
    this.proxy.sendMessage(
        3,
        AdapterObserver_DiscoveringChanged_ParamsSpec.$,
        null,
        [
          discovering
        ],
        false);
  }

  deviceAdded(
      device: bluetooth_mojom_DeviceInfo): void {
    this.proxy.sendMessage(
        4,
        AdapterObserver_DeviceAdded_ParamsSpec.$,
        null,
        [
          device
        ],
        false);
  }

  deviceChanged(
      device: bluetooth_mojom_DeviceInfo): void {
    this.proxy.sendMessage(
        5,
        AdapterObserver_DeviceChanged_ParamsSpec.$,
        null,
        [
          device
        ],
        false);
  }

  deviceRemoved(
      device: bluetooth_mojom_DeviceInfo): void {
    this.proxy.sendMessage(
        6,
        AdapterObserver_DeviceRemoved_ParamsSpec.$,
        null,
        [
          device
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AdapterObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AdapterObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AdapterObserverRemote, AdapterObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AdapterObserverRemote, AdapterObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: AdapterObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AdapterObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AdapterObserver_PresentChanged_ParamsSpec.$,
        null,
        impl.presentChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AdapterObserver_PoweredChanged_ParamsSpec.$,
        null,
        impl.poweredChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AdapterObserver_DiscoverableChanged_ParamsSpec.$,
        null,
        impl.discoverableChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AdapterObserver_DiscoveringChanged_ParamsSpec.$,
        null,
        impl.discoveringChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AdapterObserver_DeviceAdded_ParamsSpec.$,
        null,
        impl.deviceAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AdapterObserver_DeviceChanged_ParamsSpec.$,
        null,
        impl.deviceChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        AdapterObserver_DeviceRemoved_ParamsSpec.$,
        null,
        impl.deviceRemoved.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AdapterObserver {
  static get $interfaceName(): string {
    return "bluetooth.mojom.AdapterObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): AdapterObserverRemote {
    let remote = new AdapterObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the AdapterObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AdapterObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    AdapterObserverRemote, AdapterObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    AdapterObserverRemote, AdapterObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  presentChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  poweredChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  discoverableChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  discoveringChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deviceAdded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deviceChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deviceRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AdapterObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.presentChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AdapterObserver_PresentChanged_ParamsSpec.$,
        null,
        this.presentChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.poweredChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AdapterObserver_PoweredChanged_ParamsSpec.$,
        null,
        this.poweredChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.discoverableChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AdapterObserver_DiscoverableChanged_ParamsSpec.$,
        null,
        this.discoverableChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.discoveringChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AdapterObserver_DiscoveringChanged_ParamsSpec.$,
        null,
        this.discoveringChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.deviceAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AdapterObserver_DeviceAdded_ParamsSpec.$,
        null,
        this.deviceAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.deviceChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AdapterObserver_DeviceChanged_ParamsSpec.$,
        null,
        this.deviceChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.deviceRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        AdapterObserver_DeviceRemoved_ParamsSpec.$,
        null,
        this.deviceRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ConnectToServiceResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AcceptConnectionResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdapterInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Advertisement_Unregister_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Advertisement_Unregister_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DiscoverySession_IsActive_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DiscoverySession_IsActive_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DiscoverySession_Stop_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DiscoverySession_Stop_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Socket_Disconnect_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Socket_Disconnect_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ServerSocket_Accept_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ServerSocket_Accept_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ServerSocket_Disconnect_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ServerSocket_Disconnect_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GattService_CreateCharacteristic_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GattService_CreateCharacteristic_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GattService_Register_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GattService_Register_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_ConnectToDevice_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_ConnectToDevice_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_GetDevices_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_GetDevices_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_GetInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_GetInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_AddObserver_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_AddObserver_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_RegisterAdvertisement_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_RegisterAdvertisement_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_SetDiscoverable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_SetDiscoverable_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_SetName_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_SetName_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_StartDiscoverySession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_StartDiscoverySession_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_ConnectToServiceInsecurely_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_ConnectToServiceInsecurely_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_CreateRfcommServiceInsecurely_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_CreateLocalGattService_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_CreateLocalGattService_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_IsLeScatternetDualRoleSupported_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdapterObserver_PresentChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdapterObserver_PoweredChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdapterObserver_DiscoverableChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdapterObserver_DiscoveringChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdapterObserver_DeviceAdded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdapterObserver_DeviceChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdapterObserver_DeviceRemoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LocalCharacteristicReadResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ConnectToServiceResultMojoType {
  socket: SocketRemote;
  receiveStream: MojoHandle;
  sendStream: MojoHandle;
}


export type ConnectToServiceResult = ConnectToServiceResultMojoType;
mojo.internal.Struct<ConnectToServiceResultMojoType>(
    ConnectToServiceResultSpec.$,
    'ConnectToServiceResult',
    [
      mojo.internal.StructField<ConnectToServiceResultMojoType, SocketRemote>(
        'socket', 0,
        0,
        mojo.internal.InterfaceProxy(SocketRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ConnectToServiceResultMojoType, MojoHandle>(
        'receiveStream', 8,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ConnectToServiceResultMojoType, MojoHandle>(
        'sendStream', 12,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AcceptConnectionResultMojoType {
  device: bluetooth_mojom_DeviceInfo;
  socket: SocketRemote;
  receiveStream: MojoHandle;
  sendStream: MojoHandle;
}


export type AcceptConnectionResult = AcceptConnectionResultMojoType;
mojo.internal.Struct<AcceptConnectionResultMojoType>(
    AcceptConnectionResultSpec.$,
    'AcceptConnectionResult',
    [
      mojo.internal.StructField<AcceptConnectionResultMojoType, bluetooth_mojom_DeviceInfo>(
        'device', 0,
        0,
        bluetooth_mojom_DeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AcceptConnectionResultMojoType, SocketRemote>(
        'socket', 8,
        0,
        mojo.internal.InterfaceProxy(SocketRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AcceptConnectionResultMojoType, MojoHandle>(
        'receiveStream', 16,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AcceptConnectionResultMojoType, MojoHandle>(
        'sendStream', 20,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface AdapterInfoMojoType {
  address: string;
  name: string;
  systemName: string;
  floss: boolean;
  extendedAdvertisementSupport: boolean;
  initialized: boolean;
  present: boolean;
  powered: boolean;
  discoverable: boolean;
  discovering: boolean;
}


export type AdapterInfo = AdapterInfoMojoType;
mojo.internal.Struct<AdapterInfoMojoType>(
    AdapterInfoSpec.$,
    'AdapterInfo',
    [
      mojo.internal.StructField<AdapterInfoMojoType, string>(
        'address', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdapterInfoMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdapterInfoMojoType, string>(
        'systemName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdapterInfoMojoType, boolean>(
        'floss', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdapterInfoMojoType, boolean>(
        'extendedAdvertisementSupport', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdapterInfoMojoType, boolean>(
        'initialized', 24,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdapterInfoMojoType, boolean>(
        'present', 24,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdapterInfoMojoType, boolean>(
        'powered', 24,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdapterInfoMojoType, boolean>(
        'discoverable', 24,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdapterInfoMojoType, boolean>(
        'discovering', 24,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface Advertisement_Unregister_ParamsMojoType {
}


export type Advertisement_Unregister_Params = Advertisement_Unregister_ParamsMojoType;
mojo.internal.Struct<Advertisement_Unregister_ParamsMojoType>(
    Advertisement_Unregister_ParamsSpec.$,
    'Advertisement_Unregister_Params',
    [
    ],
    [[0, 8],]);





export interface Advertisement_Unregister_ResponseParamsMojoType {
}


export type Advertisement_Unregister_ResponseParams = Advertisement_Unregister_ResponseParamsMojoType;
mojo.internal.Struct<Advertisement_Unregister_ResponseParamsMojoType>(
    Advertisement_Unregister_ResponseParamsSpec.$,
    'Advertisement_Unregister_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface DiscoverySession_IsActive_ParamsMojoType {
}


export type DiscoverySession_IsActive_Params = DiscoverySession_IsActive_ParamsMojoType;
mojo.internal.Struct<DiscoverySession_IsActive_ParamsMojoType>(
    DiscoverySession_IsActive_ParamsSpec.$,
    'DiscoverySession_IsActive_Params',
    [
    ],
    [[0, 8],]);





export interface DiscoverySession_IsActive_ResponseParamsMojoType {
  active: boolean;
}


export type DiscoverySession_IsActive_ResponseParams = DiscoverySession_IsActive_ResponseParamsMojoType;
mojo.internal.Struct<DiscoverySession_IsActive_ResponseParamsMojoType>(
    DiscoverySession_IsActive_ResponseParamsSpec.$,
    'DiscoverySession_IsActive_ResponseParams',
    [
      mojo.internal.StructField<DiscoverySession_IsActive_ResponseParamsMojoType, boolean>(
        'active', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DiscoverySession_Stop_ParamsMojoType {
}


export type DiscoverySession_Stop_Params = DiscoverySession_Stop_ParamsMojoType;
mojo.internal.Struct<DiscoverySession_Stop_ParamsMojoType>(
    DiscoverySession_Stop_ParamsSpec.$,
    'DiscoverySession_Stop_Params',
    [
    ],
    [[0, 8],]);





export interface DiscoverySession_Stop_ResponseParamsMojoType {
  success: boolean;
}


export type DiscoverySession_Stop_ResponseParams = DiscoverySession_Stop_ResponseParamsMojoType;
mojo.internal.Struct<DiscoverySession_Stop_ResponseParamsMojoType>(
    DiscoverySession_Stop_ResponseParamsSpec.$,
    'DiscoverySession_Stop_ResponseParams',
    [
      mojo.internal.StructField<DiscoverySession_Stop_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Socket_Disconnect_ParamsMojoType {
}


export type Socket_Disconnect_Params = Socket_Disconnect_ParamsMojoType;
mojo.internal.Struct<Socket_Disconnect_ParamsMojoType>(
    Socket_Disconnect_ParamsSpec.$,
    'Socket_Disconnect_Params',
    [
    ],
    [[0, 8],]);





export interface Socket_Disconnect_ResponseParamsMojoType {
}


export type Socket_Disconnect_ResponseParams = Socket_Disconnect_ResponseParamsMojoType;
mojo.internal.Struct<Socket_Disconnect_ResponseParamsMojoType>(
    Socket_Disconnect_ResponseParamsSpec.$,
    'Socket_Disconnect_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface ServerSocket_Accept_ParamsMojoType {
}


export type ServerSocket_Accept_Params = ServerSocket_Accept_ParamsMojoType;
mojo.internal.Struct<ServerSocket_Accept_ParamsMojoType>(
    ServerSocket_Accept_ParamsSpec.$,
    'ServerSocket_Accept_Params',
    [
    ],
    [[0, 8],]);





export interface ServerSocket_Accept_ResponseParamsMojoType {
  result: (AcceptConnectionResult | null);
}


export type ServerSocket_Accept_ResponseParams = ServerSocket_Accept_ResponseParamsMojoType;
mojo.internal.Struct<ServerSocket_Accept_ResponseParamsMojoType>(
    ServerSocket_Accept_ResponseParamsSpec.$,
    'ServerSocket_Accept_ResponseParams',
    [
      mojo.internal.StructField<ServerSocket_Accept_ResponseParamsMojoType, AcceptConnectionResult>(
        'result', 0,
        0,
        AcceptConnectionResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ServerSocket_Disconnect_ParamsMojoType {
}


export type ServerSocket_Disconnect_Params = ServerSocket_Disconnect_ParamsMojoType;
mojo.internal.Struct<ServerSocket_Disconnect_ParamsMojoType>(
    ServerSocket_Disconnect_ParamsSpec.$,
    'ServerSocket_Disconnect_Params',
    [
    ],
    [[0, 8],]);





export interface ServerSocket_Disconnect_ResponseParamsMojoType {
}


export type ServerSocket_Disconnect_ResponseParams = ServerSocket_Disconnect_ResponseParamsMojoType;
mojo.internal.Struct<ServerSocket_Disconnect_ResponseParamsMojoType>(
    ServerSocket_Disconnect_ResponseParamsSpec.$,
    'ServerSocket_Disconnect_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface GattService_CreateCharacteristic_ParamsMojoType {
  characteristicUuid: bluetooth_mojom_UUID;
  permissions: bluetooth_mojom_GattCharacteristicPermissions;
  properties: bluetooth_mojom_GattCharacteristicProperties;
}


export type GattService_CreateCharacteristic_Params = GattService_CreateCharacteristic_ParamsMojoType;
mojo.internal.Struct<GattService_CreateCharacteristic_ParamsMojoType>(
    GattService_CreateCharacteristic_ParamsSpec.$,
    'GattService_CreateCharacteristic_Params',
    [
      mojo.internal.StructField<GattService_CreateCharacteristic_ParamsMojoType, bluetooth_mojom_UUID>(
        'characteristicUuid', 0,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GattService_CreateCharacteristic_ParamsMojoType, bluetooth_mojom_GattCharacteristicPermissions>(
        'permissions', 8,
        0,
        bluetooth_mojom_GattCharacteristicPermissionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GattService_CreateCharacteristic_ParamsMojoType, bluetooth_mojom_GattCharacteristicProperties>(
        'properties', 16,
        0,
        bluetooth_mojom_GattCharacteristicPropertiesSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface GattService_CreateCharacteristic_ResponseParamsMojoType {
  success: boolean;
}


export type GattService_CreateCharacteristic_ResponseParams = GattService_CreateCharacteristic_ResponseParamsMojoType;
mojo.internal.Struct<GattService_CreateCharacteristic_ResponseParamsMojoType>(
    GattService_CreateCharacteristic_ResponseParamsSpec.$,
    'GattService_CreateCharacteristic_ResponseParams',
    [
      mojo.internal.StructField<GattService_CreateCharacteristic_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GattService_Register_ParamsMojoType {
}


export type GattService_Register_Params = GattService_Register_ParamsMojoType;
mojo.internal.Struct<GattService_Register_ParamsMojoType>(
    GattService_Register_ParamsSpec.$,
    'GattService_Register_Params',
    [
    ],
    [[0, 8],]);





export interface GattService_Register_ResponseParamsMojoType {
  errorCode: (bluetooth_mojom_GattServiceErrorCode | null);
}


export type GattService_Register_ResponseParams = GattService_Register_ResponseParamsMojoType;
mojo.internal.Struct<GattService_Register_ResponseParamsMojoType>(
    GattService_Register_ResponseParamsSpec.$,
    'GattService_Register_ResponseParams',
    [
      mojo.internal.StructField<GattService_Register_ResponseParamsMojoType, boolean>(
        'error_code_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "error_code_$value",
          originalFieldName: "errorCode",
        },
        undefined,
    ),
      mojo.internal.StructField<GattService_Register_ResponseParamsMojoType, bluetooth_mojom_GattServiceErrorCode>(
        'error_code_$value', 4,
        0,
        bluetooth_mojom_GattServiceErrorCodeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "errorCode",
        },
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GattServiceObserver_OnLocalCharacteristicRead_ParamsMojoType {
  remoteDevice: bluetooth_mojom_DeviceInfo;
  characteristicUuid: bluetooth_mojom_UUID;
  serviceUuid: bluetooth_mojom_UUID;
  offset: number;
}


export type GattServiceObserver_OnLocalCharacteristicRead_Params = GattServiceObserver_OnLocalCharacteristicRead_ParamsMojoType;
mojo.internal.Struct<GattServiceObserver_OnLocalCharacteristicRead_ParamsMojoType>(
    GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec.$,
    'GattServiceObserver_OnLocalCharacteristicRead_Params',
    [
      mojo.internal.StructField<GattServiceObserver_OnLocalCharacteristicRead_ParamsMojoType, bluetooth_mojom_DeviceInfo>(
        'remoteDevice', 0,
        0,
        bluetooth_mojom_DeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GattServiceObserver_OnLocalCharacteristicRead_ParamsMojoType, bluetooth_mojom_UUID>(
        'characteristicUuid', 8,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GattServiceObserver_OnLocalCharacteristicRead_ParamsMojoType, bluetooth_mojom_UUID>(
        'serviceUuid', 16,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GattServiceObserver_OnLocalCharacteristicRead_ParamsMojoType, number>(
        'offset', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsMojoType {
  readResult: LocalCharacteristicReadResult;
}


export type GattServiceObserver_OnLocalCharacteristicRead_ResponseParams = GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsMojoType;
mojo.internal.Struct<GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsMojoType>(
    GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec.$,
    'GattServiceObserver_OnLocalCharacteristicRead_ResponseParams',
    [
      mojo.internal.StructField<GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsMojoType, LocalCharacteristicReadResult>(
        'readResult', 0,
        0,
        LocalCharacteristicReadResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Adapter_ConnectToDevice_ParamsMojoType {
  address: string;
}


export type Adapter_ConnectToDevice_Params = Adapter_ConnectToDevice_ParamsMojoType;
mojo.internal.Struct<Adapter_ConnectToDevice_ParamsMojoType>(
    Adapter_ConnectToDevice_ParamsSpec.$,
    'Adapter_ConnectToDevice_Params',
    [
      mojo.internal.StructField<Adapter_ConnectToDevice_ParamsMojoType, string>(
        'address', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_ConnectToDevice_ResponseParamsMojoType {
  result: ConnectResult;
  device: (bluetooth_mojom_DeviceRemote | null);
}


export type Adapter_ConnectToDevice_ResponseParams = Adapter_ConnectToDevice_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_ConnectToDevice_ResponseParamsMojoType>(
    Adapter_ConnectToDevice_ResponseParamsSpec.$,
    'Adapter_ConnectToDevice_ResponseParams',
    [
      mojo.internal.StructField<Adapter_ConnectToDevice_ResponseParamsMojoType, ConnectResult>(
        'result', 0,
        0,
        ConnectResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Adapter_ConnectToDevice_ResponseParamsMojoType, bluetooth_mojom_DeviceRemote>(
        'device', 4,
        0,
        mojo.internal.InterfaceProxy(bluetooth_mojom_DeviceRemote),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Adapter_GetDevices_ParamsMojoType {
}


export type Adapter_GetDevices_Params = Adapter_GetDevices_ParamsMojoType;
mojo.internal.Struct<Adapter_GetDevices_ParamsMojoType>(
    Adapter_GetDevices_ParamsSpec.$,
    'Adapter_GetDevices_Params',
    [
    ],
    [[0, 8],]);





export interface Adapter_GetDevices_ResponseParamsMojoType {
  devices: bluetooth_mojom_DeviceInfo[];
}


export type Adapter_GetDevices_ResponseParams = Adapter_GetDevices_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_GetDevices_ResponseParamsMojoType>(
    Adapter_GetDevices_ResponseParamsSpec.$,
    'Adapter_GetDevices_ResponseParams',
    [
      mojo.internal.StructField<Adapter_GetDevices_ResponseParamsMojoType, bluetooth_mojom_DeviceInfo[]>(
        'devices', 0,
        0,
        mojo.internal.Array(bluetooth_mojom_DeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_GetInfo_ParamsMojoType {
}


export type Adapter_GetInfo_Params = Adapter_GetInfo_ParamsMojoType;
mojo.internal.Struct<Adapter_GetInfo_ParamsMojoType>(
    Adapter_GetInfo_ParamsSpec.$,
    'Adapter_GetInfo_Params',
    [
    ],
    [[0, 8],]);





export interface Adapter_GetInfo_ResponseParamsMojoType {
  info: AdapterInfo;
}


export type Adapter_GetInfo_ResponseParams = Adapter_GetInfo_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_GetInfo_ResponseParamsMojoType>(
    Adapter_GetInfo_ResponseParamsSpec.$,
    'Adapter_GetInfo_ResponseParams',
    [
      mojo.internal.StructField<Adapter_GetInfo_ResponseParamsMojoType, AdapterInfo>(
        'info', 0,
        0,
        AdapterInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_AddObserver_ParamsMojoType {
  observer: AdapterObserverRemote;
}


export type Adapter_AddObserver_Params = Adapter_AddObserver_ParamsMojoType;
mojo.internal.Struct<Adapter_AddObserver_ParamsMojoType>(
    Adapter_AddObserver_ParamsSpec.$,
    'Adapter_AddObserver_Params',
    [
      mojo.internal.StructField<Adapter_AddObserver_ParamsMojoType, AdapterObserverRemote>(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(AdapterObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_AddObserver_ResponseParamsMojoType {
}


export type Adapter_AddObserver_ResponseParams = Adapter_AddObserver_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_AddObserver_ResponseParamsMojoType>(
    Adapter_AddObserver_ResponseParamsSpec.$,
    'Adapter_AddObserver_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface Adapter_RegisterAdvertisement_ParamsMojoType {
  serviceId: bluetooth_mojom_UUID;
  serviceData: number[];
  useScanResponse: boolean;
  connectable: boolean;
}


export type Adapter_RegisterAdvertisement_Params = Adapter_RegisterAdvertisement_ParamsMojoType;
mojo.internal.Struct<Adapter_RegisterAdvertisement_ParamsMojoType>(
    Adapter_RegisterAdvertisement_ParamsSpec.$,
    'Adapter_RegisterAdvertisement_Params',
    [
      mojo.internal.StructField<Adapter_RegisterAdvertisement_ParamsMojoType, bluetooth_mojom_UUID>(
        'serviceId', 0,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Adapter_RegisterAdvertisement_ParamsMojoType, number[]>(
        'serviceData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Adapter_RegisterAdvertisement_ParamsMojoType, boolean>(
        'useScanResponse', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Adapter_RegisterAdvertisement_ParamsMojoType, boolean>(
        'connectable', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface Adapter_RegisterAdvertisement_ResponseParamsMojoType {
  advertisement: (AdvertisementRemote | null);
}


export type Adapter_RegisterAdvertisement_ResponseParams = Adapter_RegisterAdvertisement_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_RegisterAdvertisement_ResponseParamsMojoType>(
    Adapter_RegisterAdvertisement_ResponseParamsSpec.$,
    'Adapter_RegisterAdvertisement_ResponseParams',
    [
      mojo.internal.StructField<Adapter_RegisterAdvertisement_ResponseParamsMojoType, AdvertisementRemote>(
        'advertisement', 0,
        0,
        mojo.internal.InterfaceProxy(AdvertisementRemote),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_SetDiscoverable_ParamsMojoType {
  discoverable: boolean;
}


export type Adapter_SetDiscoverable_Params = Adapter_SetDiscoverable_ParamsMojoType;
mojo.internal.Struct<Adapter_SetDiscoverable_ParamsMojoType>(
    Adapter_SetDiscoverable_ParamsSpec.$,
    'Adapter_SetDiscoverable_Params',
    [
      mojo.internal.StructField<Adapter_SetDiscoverable_ParamsMojoType, boolean>(
        'discoverable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_SetDiscoverable_ResponseParamsMojoType {
  success: boolean;
}


export type Adapter_SetDiscoverable_ResponseParams = Adapter_SetDiscoverable_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_SetDiscoverable_ResponseParamsMojoType>(
    Adapter_SetDiscoverable_ResponseParamsSpec.$,
    'Adapter_SetDiscoverable_ResponseParams',
    [
      mojo.internal.StructField<Adapter_SetDiscoverable_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_SetName_ParamsMojoType {
  name: string;
}


export type Adapter_SetName_Params = Adapter_SetName_ParamsMojoType;
mojo.internal.Struct<Adapter_SetName_ParamsMojoType>(
    Adapter_SetName_ParamsSpec.$,
    'Adapter_SetName_Params',
    [
      mojo.internal.StructField<Adapter_SetName_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_SetName_ResponseParamsMojoType {
  success: boolean;
}


export type Adapter_SetName_ResponseParams = Adapter_SetName_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_SetName_ResponseParamsMojoType>(
    Adapter_SetName_ResponseParamsSpec.$,
    'Adapter_SetName_ResponseParams',
    [
      mojo.internal.StructField<Adapter_SetName_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_StartDiscoverySession_ParamsMojoType {
  clientName: string;
}


export type Adapter_StartDiscoverySession_Params = Adapter_StartDiscoverySession_ParamsMojoType;
mojo.internal.Struct<Adapter_StartDiscoverySession_ParamsMojoType>(
    Adapter_StartDiscoverySession_ParamsSpec.$,
    'Adapter_StartDiscoverySession_Params',
    [
      mojo.internal.StructField<Adapter_StartDiscoverySession_ParamsMojoType, string>(
        'clientName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_StartDiscoverySession_ResponseParamsMojoType {
  session: (DiscoverySessionRemote | null);
}


export type Adapter_StartDiscoverySession_ResponseParams = Adapter_StartDiscoverySession_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_StartDiscoverySession_ResponseParamsMojoType>(
    Adapter_StartDiscoverySession_ResponseParamsSpec.$,
    'Adapter_StartDiscoverySession_ResponseParams',
    [
      mojo.internal.StructField<Adapter_StartDiscoverySession_ResponseParamsMojoType, DiscoverySessionRemote>(
        'session', 0,
        0,
        mojo.internal.InterfaceProxy(DiscoverySessionRemote),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_ConnectToServiceInsecurely_ParamsMojoType {
  address: string;
  serviceUuid: bluetooth_mojom_UUID;
  shouldUnbondOnError: boolean;
}


export type Adapter_ConnectToServiceInsecurely_Params = Adapter_ConnectToServiceInsecurely_ParamsMojoType;
mojo.internal.Struct<Adapter_ConnectToServiceInsecurely_ParamsMojoType>(
    Adapter_ConnectToServiceInsecurely_ParamsSpec.$,
    'Adapter_ConnectToServiceInsecurely_Params',
    [
      mojo.internal.StructField<Adapter_ConnectToServiceInsecurely_ParamsMojoType, string>(
        'address', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Adapter_ConnectToServiceInsecurely_ParamsMojoType, bluetooth_mojom_UUID>(
        'serviceUuid', 8,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Adapter_ConnectToServiceInsecurely_ParamsMojoType, boolean>(
        'shouldUnbondOnError', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface Adapter_ConnectToServiceInsecurely_ResponseParamsMojoType {
  result: (ConnectToServiceResult | null);
}


export type Adapter_ConnectToServiceInsecurely_ResponseParams = Adapter_ConnectToServiceInsecurely_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_ConnectToServiceInsecurely_ResponseParamsMojoType>(
    Adapter_ConnectToServiceInsecurely_ResponseParamsSpec.$,
    'Adapter_ConnectToServiceInsecurely_ResponseParams',
    [
      mojo.internal.StructField<Adapter_ConnectToServiceInsecurely_ResponseParamsMojoType, ConnectToServiceResult>(
        'result', 0,
        0,
        ConnectToServiceResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_CreateRfcommServiceInsecurely_ParamsMojoType {
  serviceName: string;
  serviceUuid: bluetooth_mojom_UUID;
}


export type Adapter_CreateRfcommServiceInsecurely_Params = Adapter_CreateRfcommServiceInsecurely_ParamsMojoType;
mojo.internal.Struct<Adapter_CreateRfcommServiceInsecurely_ParamsMojoType>(
    Adapter_CreateRfcommServiceInsecurely_ParamsSpec.$,
    'Adapter_CreateRfcommServiceInsecurely_Params',
    [
      mojo.internal.StructField<Adapter_CreateRfcommServiceInsecurely_ParamsMojoType, string>(
        'serviceName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Adapter_CreateRfcommServiceInsecurely_ParamsMojoType, bluetooth_mojom_UUID>(
        'serviceUuid', 8,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Adapter_CreateRfcommServiceInsecurely_ResponseParamsMojoType {
  serverSocket: (ServerSocketRemote | null);
}


export type Adapter_CreateRfcommServiceInsecurely_ResponseParams = Adapter_CreateRfcommServiceInsecurely_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_CreateRfcommServiceInsecurely_ResponseParamsMojoType>(
    Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec.$,
    'Adapter_CreateRfcommServiceInsecurely_ResponseParams',
    [
      mojo.internal.StructField<Adapter_CreateRfcommServiceInsecurely_ResponseParamsMojoType, ServerSocketRemote>(
        'serverSocket', 0,
        0,
        mojo.internal.InterfaceProxy(ServerSocketRemote),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_CreateLocalGattService_ParamsMojoType {
  serviceId: bluetooth_mojom_UUID;
  observer: GattServiceObserverRemote;
}


export type Adapter_CreateLocalGattService_Params = Adapter_CreateLocalGattService_ParamsMojoType;
mojo.internal.Struct<Adapter_CreateLocalGattService_ParamsMojoType>(
    Adapter_CreateLocalGattService_ParamsSpec.$,
    'Adapter_CreateLocalGattService_Params',
    [
      mojo.internal.StructField<Adapter_CreateLocalGattService_ParamsMojoType, bluetooth_mojom_UUID>(
        'serviceId', 0,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Adapter_CreateLocalGattService_ParamsMojoType, GattServiceObserverRemote>(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(GattServiceObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Adapter_CreateLocalGattService_ResponseParamsMojoType {
  gattService: GattServiceRemote;
}


export type Adapter_CreateLocalGattService_ResponseParams = Adapter_CreateLocalGattService_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_CreateLocalGattService_ResponseParamsMojoType>(
    Adapter_CreateLocalGattService_ResponseParamsSpec.$,
    'Adapter_CreateLocalGattService_ResponseParams',
    [
      mojo.internal.StructField<Adapter_CreateLocalGattService_ResponseParamsMojoType, GattServiceRemote>(
        'gattService', 0,
        0,
        mojo.internal.InterfaceProxy(GattServiceRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Adapter_IsLeScatternetDualRoleSupported_ParamsMojoType {
}


export type Adapter_IsLeScatternetDualRoleSupported_Params = Adapter_IsLeScatternetDualRoleSupported_ParamsMojoType;
mojo.internal.Struct<Adapter_IsLeScatternetDualRoleSupported_ParamsMojoType>(
    Adapter_IsLeScatternetDualRoleSupported_ParamsSpec.$,
    'Adapter_IsLeScatternetDualRoleSupported_Params',
    [
    ],
    [[0, 8],]);





export interface Adapter_IsLeScatternetDualRoleSupported_ResponseParamsMojoType {
  isSupported: boolean;
}


export type Adapter_IsLeScatternetDualRoleSupported_ResponseParams = Adapter_IsLeScatternetDualRoleSupported_ResponseParamsMojoType;
mojo.internal.Struct<Adapter_IsLeScatternetDualRoleSupported_ResponseParamsMojoType>(
    Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec.$,
    'Adapter_IsLeScatternetDualRoleSupported_ResponseParams',
    [
      mojo.internal.StructField<Adapter_IsLeScatternetDualRoleSupported_ResponseParamsMojoType, boolean>(
        'isSupported', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AdapterObserver_PresentChanged_ParamsMojoType {
  present: boolean;
}


export type AdapterObserver_PresentChanged_Params = AdapterObserver_PresentChanged_ParamsMojoType;
mojo.internal.Struct<AdapterObserver_PresentChanged_ParamsMojoType>(
    AdapterObserver_PresentChanged_ParamsSpec.$,
    'AdapterObserver_PresentChanged_Params',
    [
      mojo.internal.StructField<AdapterObserver_PresentChanged_ParamsMojoType, boolean>(
        'present', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AdapterObserver_PoweredChanged_ParamsMojoType {
  powered: boolean;
}


export type AdapterObserver_PoweredChanged_Params = AdapterObserver_PoweredChanged_ParamsMojoType;
mojo.internal.Struct<AdapterObserver_PoweredChanged_ParamsMojoType>(
    AdapterObserver_PoweredChanged_ParamsSpec.$,
    'AdapterObserver_PoweredChanged_Params',
    [
      mojo.internal.StructField<AdapterObserver_PoweredChanged_ParamsMojoType, boolean>(
        'powered', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AdapterObserver_DiscoverableChanged_ParamsMojoType {
  discoverable: boolean;
}


export type AdapterObserver_DiscoverableChanged_Params = AdapterObserver_DiscoverableChanged_ParamsMojoType;
mojo.internal.Struct<AdapterObserver_DiscoverableChanged_ParamsMojoType>(
    AdapterObserver_DiscoverableChanged_ParamsSpec.$,
    'AdapterObserver_DiscoverableChanged_Params',
    [
      mojo.internal.StructField<AdapterObserver_DiscoverableChanged_ParamsMojoType, boolean>(
        'discoverable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AdapterObserver_DiscoveringChanged_ParamsMojoType {
  discovering: boolean;
}


export type AdapterObserver_DiscoveringChanged_Params = AdapterObserver_DiscoveringChanged_ParamsMojoType;
mojo.internal.Struct<AdapterObserver_DiscoveringChanged_ParamsMojoType>(
    AdapterObserver_DiscoveringChanged_ParamsSpec.$,
    'AdapterObserver_DiscoveringChanged_Params',
    [
      mojo.internal.StructField<AdapterObserver_DiscoveringChanged_ParamsMojoType, boolean>(
        'discovering', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AdapterObserver_DeviceAdded_ParamsMojoType {
  device: bluetooth_mojom_DeviceInfo;
}


export type AdapterObserver_DeviceAdded_Params = AdapterObserver_DeviceAdded_ParamsMojoType;
mojo.internal.Struct<AdapterObserver_DeviceAdded_ParamsMojoType>(
    AdapterObserver_DeviceAdded_ParamsSpec.$,
    'AdapterObserver_DeviceAdded_Params',
    [
      mojo.internal.StructField<AdapterObserver_DeviceAdded_ParamsMojoType, bluetooth_mojom_DeviceInfo>(
        'device', 0,
        0,
        bluetooth_mojom_DeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AdapterObserver_DeviceChanged_ParamsMojoType {
  device: bluetooth_mojom_DeviceInfo;
}


export type AdapterObserver_DeviceChanged_Params = AdapterObserver_DeviceChanged_ParamsMojoType;
mojo.internal.Struct<AdapterObserver_DeviceChanged_ParamsMojoType>(
    AdapterObserver_DeviceChanged_ParamsSpec.$,
    'AdapterObserver_DeviceChanged_Params',
    [
      mojo.internal.StructField<AdapterObserver_DeviceChanged_ParamsMojoType, bluetooth_mojom_DeviceInfo>(
        'device', 0,
        0,
        bluetooth_mojom_DeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface AdapterObserver_DeviceRemoved_ParamsMojoType {
  device: bluetooth_mojom_DeviceInfo;
}


export type AdapterObserver_DeviceRemoved_Params = AdapterObserver_DeviceRemoved_ParamsMojoType;
mojo.internal.Struct<AdapterObserver_DeviceRemoved_ParamsMojoType>(
    AdapterObserver_DeviceRemoved_ParamsSpec.$,
    'AdapterObserver_DeviceRemoved_Params',
    [
      mojo.internal.StructField<AdapterObserver_DeviceRemoved_ParamsMojoType, bluetooth_mojom_DeviceInfo>(
        'device', 0,
        0,
        bluetooth_mojom_DeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    LocalCharacteristicReadResultSpec.$, 'LocalCharacteristicReadResult',
    {
      'errorCode': {
        'ordinal': 0,
        'type': bluetooth_mojom_GattServiceErrorCodeSpec.$,
      },
      'data': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
    });

export interface LocalCharacteristicReadResult {
  errorCode?: bluetooth_mojom_GattServiceErrorCode,
  data?: number[],
}

export enum LocalCharacteristicReadResultFieldTags {
  ERROR_CODE,
  DATA,
}

export function whichLocalCharacteristicReadResult(u: LocalCharacteristicReadResult): LocalCharacteristicReadResultFieldTags {
  if (u.errorCode !== null && u.errorCode !== undefined) {
    return LocalCharacteristicReadResultFieldTags.ERROR_CODE;
  }
  if (u.data !== null && u.data !== undefined) {
    return LocalCharacteristicReadResultFieldTags.DATA;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
