// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{PageManager,PageManagerObserver}from"./page_manager.js";let SidebarItem;export class Sidebar extends PageManagerObserver{constructor(sidebarDiv){super();this.sidebarDiv_=sidebarDiv;this.sidebarContent_=this.sidebarDiv_.querySelector(".sidebar-content");assert(this.sidebarContent_);this.sidebarList_=this.sidebarContent_.querySelector("ul");assert(this.sidebarList_);this.sidebarList_.querySelectorAll("li button").forEach((function(item){item.addEventListener("click",this.onItemClick_.bind(this))}),this);this.overlayDiv_=this.sidebarDiv_.querySelector(".overlay");assert(this.overlayDiv_);this.overlayDiv_.addEventListener("click",this.close.bind(this));window.matchMedia("screen and (max-width: 600px)").addListener(function(query){if(!query.matches){this.close()}}.bind(this))}addItem(item){const sidebarItem=document.createElement("li");sidebarItem.dataset.pageName=item.pageName.toLowerCase();const button=document.createElement("button");button.classList.add("custom-appearance");button.textContent=item.text;button.addEventListener("click",this.onItemClick_.bind(this));sidebarItem.appendChild(button);this.sidebarList_.appendChild(sidebarItem)}close(){this.sidebarDiv_.classList.remove("open");document.body.style.overflow="";document.dispatchEvent(new CustomEvent("contentfocus"))}open(){document.body.style.overflow="hidden";this.sidebarDiv_.classList.add("open");document.dispatchEvent(new CustomEvent("contentblur"))}removeItem(pageName){pageName=pageName.toLowerCase();const query='li[data-page-name="'+pageName+'"]';const selection=this.sidebarList_.querySelector(query);if(selection){this.sidebarList_.removeChild(selection)}}updateHistory(path){this.sidebarContent_.querySelectorAll("li").forEach((function(item){item.classList.toggle("selected",item.dataset.pageName===path)}))}onItemClick_(event){this.close();PageManager.getInstance().showPageByName(event.target.parentNode.dataset.pageName)}}