import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><h1>App Service Internals</h1>

<button on-click="save_">Save as .txt</button>

<ul>
  <li>
    <a href="#app-list">App List</a>
    <ul>
      <template is="dom-repeat" items="[[appList_]]">
        <li><a href="#app-[[item.id]]">[[item.name]]</a></li>
      </template>
    </ul>
  </li>
  <li><a href="#preferred-apps">Preferred Apps</a></li>
  <ul>
    <template is="dom-repeat" items="[[preferredAppList_]]">
      <li><a href="#preferred-app-[[item.id]]">[[item.name]]</a></li>
    </template>
  </ul>
  <li><a href="#promise-apps">Promise Apps</a></li>
  <li><a href="#app-capabilities">App Capabilities</a></li>
</ul>

<section>
  <h2 id="app-list">App List</h2>

  <template is="dom-repeat" items="[[appList_]]">
    <div id="app-[[item.id]]">
      <h3>[[item.name]]</h3>
      <img src="chrome://app-icon/[[item.id]]/128">
      <pre>[[item.debugInfo]]</pre>
    </div>
  </template>

  <h2 id="preferred-apps">Preferred Apps</h2>

  <template is="dom-repeat" items="[[preferredAppList_]]">
    <div id="preferred-app-[[item.id]]">
      <h3>[[item.name]]</h3>
      <pre>[[item.preferredFilters]]</pre>
    </div>
  </template>

  <h2 id="promise-apps">Promise Apps</h2>

  <template is="dom-repeat" items="[[promiseAppList_]]">
    <div id="promise-app-[[item.packageId]]">
      <h3>[[item.packageId]]</h3>
      <pre>[[item.debugInfo]]</pre>
    </div>
  </template>

  <h2 id="app-capabilities">App Capabilities</h2>

  <template is="dom-repeat" items="[[appCapabilityList_]]">
    <h3>[[item.name]]</h3>
    <pre>[[item.debugInfo]]</pre>
  </template>
</section>
<!--_html_template_end_-->`;
}
