// chrome/browser/resource_coordinator/lifecycle_unit_state.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/resource_coordinator/lifecycle_unit_state.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/resource_coordinator/lifecycle_unit_state.mojom-params-data.h"
namespace mojom {

NOINLINE static const char* LifecycleUnitStateToStringHelper(LifecycleUnitState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LifecycleUnitState::ACTIVE:
      return "ACTIVE";
    case LifecycleUnitState::FROZEN:
      return "FROZEN";
    case LifecycleUnitState::DISCARDED:
      return "DISCARDED";
    default:
      return nullptr;
  }
}

std::string LifecycleUnitStateToString(LifecycleUnitState value) {
  const char *str = LifecycleUnitStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LifecycleUnitState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LifecycleUnitState value) {
  return os << LifecycleUnitStateToString(value);
}

NOINLINE static const char* LifecycleUnitLoadingStateToStringHelper(LifecycleUnitLoadingState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LifecycleUnitLoadingState::UNLOADED:
      return "UNLOADED";
    case LifecycleUnitLoadingState::LOADING:
      return "LOADING";
    case LifecycleUnitLoadingState::LOADED:
      return "LOADED";
    default:
      return nullptr;
  }
}

std::string LifecycleUnitLoadingStateToString(LifecycleUnitLoadingState value) {
  const char *str = LifecycleUnitLoadingStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LifecycleUnitLoadingState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LifecycleUnitLoadingState value) {
  return os << LifecycleUnitLoadingStateToString(value);
}

NOINLINE static const char* LifecycleUnitStateChangeReasonToStringHelper(LifecycleUnitStateChangeReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LifecycleUnitStateChangeReason::BROWSER_INITIATED:
      return "BROWSER_INITIATED";
    case LifecycleUnitStateChangeReason::RENDERER_INITIATED:
      return "RENDERER_INITIATED";
    case LifecycleUnitStateChangeReason::SYSTEM_MEMORY_PRESSURE:
      return "SYSTEM_MEMORY_PRESSURE";
    case LifecycleUnitStateChangeReason::EXTENSION_INITIATED:
      return "EXTENSION_INITIATED";
    case LifecycleUnitStateChangeReason::USER_INITIATED:
      return "USER_INITIATED";
    default:
      return nullptr;
  }
}

std::string LifecycleUnitStateChangeReasonToString(LifecycleUnitStateChangeReason value) {
  const char *str = LifecycleUnitStateChangeReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LifecycleUnitStateChangeReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LifecycleUnitStateChangeReason value) {
  return os << LifecycleUnitStateChangeReasonToString(value);
}

NOINLINE static const char* LifecycleUnitDiscardReasonToStringHelper(LifecycleUnitDiscardReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LifecycleUnitDiscardReason::EXTERNAL:
      return "EXTERNAL";
    case LifecycleUnitDiscardReason::URGENT:
      return "URGENT";
    case LifecycleUnitDiscardReason::PROACTIVE:
      return "PROACTIVE";
    case LifecycleUnitDiscardReason::SUGGESTED:
      return "SUGGESTED";
    case LifecycleUnitDiscardReason::FROZEN_WITH_GROWING_MEMORY:
      return "FROZEN_WITH_GROWING_MEMORY";
    default:
      return nullptr;
  }
}

std::string LifecycleUnitDiscardReasonToString(LifecycleUnitDiscardReason value) {
  const char *str = LifecycleUnitDiscardReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LifecycleUnitDiscardReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LifecycleUnitDiscardReason value) {
  return os << LifecycleUnitDiscardReasonToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom

namespace perfetto {

// static
void TraceFormatTraits<::mojom::LifecycleUnitState>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojom::LifecycleUnitState value) {
  return std::move(context).WriteString(::mojom::LifecycleUnitStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::mojom::LifecycleUnitLoadingState>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojom::LifecycleUnitLoadingState value) {
  return std::move(context).WriteString(::mojom::LifecycleUnitLoadingStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::mojom::LifecycleUnitStateChangeReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojom::LifecycleUnitStateChangeReason value) {
  return std::move(context).WriteString(::mojom::LifecycleUnitStateChangeReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::mojom::LifecycleUnitDiscardReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojom::LifecycleUnitDiscardReason value) {
  return std::move(context).WriteString(::mojom::LifecycleUnitDiscardReasonToString(value));
}

} // namespace perfetto