// chrome/browser/lens/core/mojom/polygon.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/polygon.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/polygon.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/polygon.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace lens::mojom {






class  Vertex {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Vertex, T>::value>;
  using DataView = VertexDataView;
  using Data_ = internal::Vertex_Data;

  template <typename... Args>
  static VertexPtr New(Args&&... args) {
    return VertexPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VertexPtr From(const U& u) {
    return mojo::TypeConverter<VertexPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Vertex>::Convert(*this);
  }


  Vertex();

  Vertex(
      float x,
      float y);


  ~Vertex();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VertexPtr>
  VertexPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Vertex::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Vertex::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Vertex::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vertex::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vertex::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Vertex::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Vertex_UnserializedMessageContext<
            UserType, Vertex::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Vertex::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Vertex::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Vertex_UnserializedMessageContext<
            UserType, Vertex::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Vertex::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Vertex::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Vertex::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Vertex::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Vertex::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  Polygon {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Polygon, T>::value>;
  using DataView = PolygonDataView;
  using Data_ = internal::Polygon_Data;
  using VertexOrdering = Polygon_VertexOrdering;
  using CoordinateType = Polygon_CoordinateType;

  template <typename... Args>
  static PolygonPtr New(Args&&... args) {
    return PolygonPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PolygonPtr From(const U& u) {
    return mojo::TypeConverter<PolygonPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Polygon>::Convert(*this);
  }


  Polygon();

  Polygon(
      std::vector<VertexPtr> vertex,
      Polygon::VertexOrdering vertex_ordering,
      Polygon::CoordinateType coordinate_type);

Polygon(const Polygon&) = delete;
Polygon& operator=(const Polygon&) = delete;

  ~Polygon();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PolygonPtr>
  PolygonPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Polygon::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Polygon::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Polygon::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Polygon::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Polygon::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Polygon::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Polygon_UnserializedMessageContext<
            UserType, Polygon::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Polygon::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Polygon::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Polygon_UnserializedMessageContext<
            UserType, Polygon::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Polygon::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<VertexPtr> vertex;
  
  Polygon::VertexOrdering vertex_ordering;
  
  Polygon::CoordinateType coordinate_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Polygon::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Polygon::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Polygon::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Polygon::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
PolygonPtr Polygon::Clone() const {
  return New(
      mojo::Clone(vertex),
      mojo::Clone(vertex_ordering),
      mojo::Clone(coordinate_type)
  );
}

template <typename T, Polygon::EnableIfSame<T>*>
bool Polygon::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->vertex, other_struct.vertex))
    return false;
  if (!mojo::Equals(this->vertex_ordering, other_struct.vertex_ordering))
    return false;
  if (!mojo::Equals(this->coordinate_type, other_struct.coordinate_type))
    return false;
  return true;
}

template <typename T, Polygon::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.vertex < rhs.vertex)
    return true;
  if (rhs.vertex < lhs.vertex)
    return false;
  if (lhs.vertex_ordering < rhs.vertex_ordering)
    return true;
  if (rhs.vertex_ordering < lhs.vertex_ordering)
    return false;
  if (lhs.coordinate_type < rhs.coordinate_type)
    return true;
  if (rhs.coordinate_type < lhs.coordinate_type)
    return false;
  return false;
}
template <typename StructPtrType>
VertexPtr Vertex::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y)
  );
}

template <typename T, Vertex::EnableIfSame<T>*>
bool Vertex::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  return true;
}

template <typename T, Vertex::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  return false;
}


}  // lens::mojom

namespace mojo {


template <>
struct  StructTraits<::lens::mojom::Polygon::DataView,
                                         ::lens::mojom::PolygonPtr> {
  static bool IsNull(const ::lens::mojom::PolygonPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::PolygonPtr* output) { output->reset(); }

  static const decltype(::lens::mojom::Polygon::vertex)& vertex(
      const ::lens::mojom::PolygonPtr& input) {
    return input->vertex;
  }

  static decltype(::lens::mojom::Polygon::vertex_ordering) vertex_ordering(
      const ::lens::mojom::PolygonPtr& input) {
    return input->vertex_ordering;
  }

  static decltype(::lens::mojom::Polygon::coordinate_type) coordinate_type(
      const ::lens::mojom::PolygonPtr& input) {
    return input->coordinate_type;
  }

  static bool Read(::lens::mojom::Polygon::DataView input, ::lens::mojom::PolygonPtr* output);
};


template <>
struct  StructTraits<::lens::mojom::Vertex::DataView,
                                         ::lens::mojom::VertexPtr> {
  static bool IsNull(const ::lens::mojom::VertexPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::VertexPtr* output) { output->reset(); }

  static decltype(::lens::mojom::Vertex::x) x(
      const ::lens::mojom::VertexPtr& input) {
    return input->x;
  }

  static decltype(::lens::mojom::Vertex::y) y(
      const ::lens::mojom::VertexPtr& input) {
    return input->y;
  }

  static bool Read(::lens::mojom::Vertex::DataView input, ::lens::mojom::VertexPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_H_