// chrome/browser/lens/core/mojom/overlay_object.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_OVERLAY_OBJECT_MOJOM_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_OVERLAY_OBJECT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/overlay_object.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/overlay_object.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/overlay_object.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/geometry.mojom.h"
#include <string>
#include <vector>








namespace lens::mojom {








class  OverlayObject {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OverlayObject, T>::value>;
  using DataView = OverlayObjectDataView;
  using Data_ = internal::OverlayObject_Data;

  template <typename... Args>
  static OverlayObjectPtr New(Args&&... args) {
    return OverlayObjectPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OverlayObjectPtr From(const U& u) {
    return mojo::TypeConverter<OverlayObjectPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OverlayObject>::Convert(*this);
  }


  OverlayObject();

  OverlayObject(
      const std::string& id,
      ::lens::mojom::GeometryPtr geometry);

OverlayObject(const OverlayObject&) = delete;
OverlayObject& operator=(const OverlayObject&) = delete;

  ~OverlayObject();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OverlayObjectPtr>
  OverlayObjectPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OverlayObject::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OverlayObject::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OverlayObject::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OverlayObject::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OverlayObject::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OverlayObject::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OverlayObject_UnserializedMessageContext<
            UserType, OverlayObject::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OverlayObject::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OverlayObject::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OverlayObject_UnserializedMessageContext<
            UserType, OverlayObject::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OverlayObject::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  ::lens::mojom::GeometryPtr geometry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OverlayObject::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OverlayObject::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OverlayObject::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OverlayObject::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OverlayObjectPtr OverlayObject::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(geometry)
  );
}

template <typename T, OverlayObject::EnableIfSame<T>*>
bool OverlayObject::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->geometry, other_struct.geometry))
    return false;
  return true;
}

template <typename T, OverlayObject::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.geometry < rhs.geometry)
    return true;
  if (rhs.geometry < lhs.geometry)
    return false;
  return false;
}


}  // lens::mojom

namespace mojo {


template <>
struct  StructTraits<::lens::mojom::OverlayObject::DataView,
                                         ::lens::mojom::OverlayObjectPtr> {
  static bool IsNull(const ::lens::mojom::OverlayObjectPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::OverlayObjectPtr* output) { output->reset(); }

  static const decltype(::lens::mojom::OverlayObject::id)& id(
      const ::lens::mojom::OverlayObjectPtr& input) {
    return input->id;
  }

  static const decltype(::lens::mojom::OverlayObject::geometry)& geometry(
      const ::lens::mojom::OverlayObjectPtr& input) {
    return input->geometry;
  }

  static bool Read(::lens::mojom::OverlayObject::DataView input, ::lens::mojom::OverlayObjectPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_OVERLAY_OBJECT_MOJOM_H_