// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/devtools/protocol/target.h"

#include "chrome/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace protocol {
namespace Target {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Target";
const char Metainfo::commandPrefix[] = "Target.";
const char Metainfo::version[] = "1.3";


CRDTP_BEGIN_DESERIALIZER(RemoteLocation)
    CRDTP_DESERIALIZE_FIELD("host", m_host),
    CRDTP_DESERIALIZE_FIELD("port", m_port),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RemoteLocation)
    CRDTP_SERIALIZE_FIELD("host", m_host);
    CRDTP_SERIALIZE_FIELD("port", m_port);
CRDTP_END_SERIALIZER();


namespace WindowStateEnum {
const char Normal[] = "normal";
const char Minimized[] = "minimized";
const char Maximized[] = "maximized";
const char Fullscreen[] = "fullscreen";
} // namespace WindowStateEnum


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void createTarget(const crdtp::Dispatchable& dispatchable);
    void setRemoteLocations(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("createTarget"),
          &DomainDispatcherImpl::createTarget
    },
    {
          crdtp::SpanFrom("setRemoteLocations"),
          &DomainDispatcherImpl::setRemoteLocations
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct createTargetParams : public crdtp::DeserializableProtocolObject<createTargetParams> {
    String url;
    std::optional<int> left;
    std::optional<int> top;
    std::optional<int> width;
    std::optional<int> height;
    std::optional<String> windowState;
    std::optional<String> browserContextId;
    std::optional<bool> enableBeginFrameControl;
    std::optional<bool> newWindow;
    std::optional<bool> background;
    std::optional<bool> forTab;
    std::optional<bool> hidden;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(createTargetParams)
    CRDTP_DESERIALIZE_FIELD_OPT("background", background),
    CRDTP_DESERIALIZE_FIELD_OPT("browserContextId", browserContextId),
    CRDTP_DESERIALIZE_FIELD_OPT("enableBeginFrameControl", enableBeginFrameControl),
    CRDTP_DESERIALIZE_FIELD_OPT("forTab", forTab),
    CRDTP_DESERIALIZE_FIELD_OPT("height", height),
    CRDTP_DESERIALIZE_FIELD_OPT("hidden", hidden),
    CRDTP_DESERIALIZE_FIELD_OPT("left", left),
    CRDTP_DESERIALIZE_FIELD_OPT("newWindow", newWindow),
    CRDTP_DESERIALIZE_FIELD_OPT("top", top),
    CRDTP_DESERIALIZE_FIELD("url", url),
    CRDTP_DESERIALIZE_FIELD_OPT("width", width),
    CRDTP_DESERIALIZE_FIELD_OPT("windowState", windowState),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::createTarget(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    createTargetParams params;
    if (!createTargetParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_targetId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->CreateTarget(params.url, std::move(params.left), std::move(params.top), std::move(params.width), std::move(params.height), std::move(params.windowState), std::move(params.browserContextId), std::move(params.enableBeginFrameControl), std::move(params.newWindow), std::move(params.background), std::move(params.forTab), std::move(params.hidden), &out_targetId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Target.createTarget"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("targetId"), out_targetId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setRemoteLocationsParams : public crdtp::DeserializableProtocolObject<setRemoteLocationsParams> {
    std::unique_ptr<protocol::Array<protocol::Target::RemoteLocation>> locations;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setRemoteLocationsParams)
    CRDTP_DESERIALIZE_FIELD("locations", locations),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setRemoteLocations(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setRemoteLocationsParams params;
    if (!setRemoteLocationsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetRemoteLocations(std::move(params.locations));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Target.setRemoteLocations"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Target"), SortedRedirects(), std::move(dispatcher));
}

} // Target
} // namespace protocol
