// cc/mojom/render_frame_metadata.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "cc/mojom/render_frame_metadata.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "cc/mojom/render_frame_metadata.mojom-params-data.h"
#include "cc/mojom/render_frame_metadata.mojom-shared-message-ids.h"

#include "cc/mojom/render_frame_metadata.mojom-import-headers.h"
#include "cc/mojom/render_frame_metadata.mojom-test-utils.h"


namespace cc::mojom {
DelegatedInkBrowserMetadata::DelegatedInkBrowserMetadata()
    : delegated_ink_is_hovering() {}

DelegatedInkBrowserMetadata::DelegatedInkBrowserMetadata(
    bool delegated_ink_is_hovering_in)
    : delegated_ink_is_hovering(std::move(delegated_ink_is_hovering_in)) {}

DelegatedInkBrowserMetadata::~DelegatedInkBrowserMetadata() = default;
size_t DelegatedInkBrowserMetadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->delegated_ink_is_hovering);
  return seed;
}

void DelegatedInkBrowserMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegated_ink_is_hovering"), this->delegated_ink_is_hovering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DelegatedInkBrowserMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RenderFrameMetadata::RenderFrameMetadata()
    : root_background_color(),
      root_scroll_offset(),
      is_scroll_offset_at_top(),
      selection(),
      is_mobile_optimized(),
      delegated_ink_metadata(),
      device_scale_factor(),
      viewport_size_in_pixels(),
      local_surface_id(),
      page_scale_factor(),
      external_page_scale_factor(),
      top_controls_height(),
      top_controls_shown_ratio(),
      new_vertical_scroll_direction(),
      primary_main_frame_item_sequence_number() {}

RenderFrameMetadata::RenderFrameMetadata(
    const ::SkColor4f& root_background_color_in,
    const std::optional<::gfx::PointF>& root_scroll_offset_in,
    bool is_scroll_offset_at_top_in,
    const ::viz::Selection<::gfx::SelectionBound>& selection_in,
    bool is_mobile_optimized_in,
    DelegatedInkBrowserMetadataPtr delegated_ink_metadata_in,
    float device_scale_factor_in,
    const ::gfx::Size& viewport_size_in_pixels_in,
    const std::optional<::viz::LocalSurfaceId>& local_surface_id_in,
    float page_scale_factor_in,
    float external_page_scale_factor_in,
    float top_controls_height_in,
    float top_controls_shown_ratio_in,
    ::viz::VerticalScrollDirection new_vertical_scroll_direction_in,
    int64_t primary_main_frame_item_sequence_number_in)
    : root_background_color(std::move(root_background_color_in)),
      root_scroll_offset(std::move(root_scroll_offset_in)),
      is_scroll_offset_at_top(std::move(is_scroll_offset_at_top_in)),
      selection(std::move(selection_in)),
      is_mobile_optimized(std::move(is_mobile_optimized_in)),
      delegated_ink_metadata(std::move(delegated_ink_metadata_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      viewport_size_in_pixels(std::move(viewport_size_in_pixels_in)),
      local_surface_id(std::move(local_surface_id_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      external_page_scale_factor(std::move(external_page_scale_factor_in)),
      top_controls_height(std::move(top_controls_height_in)),
      top_controls_shown_ratio(std::move(top_controls_shown_ratio_in)),
      new_vertical_scroll_direction(std::move(new_vertical_scroll_direction_in)),
      primary_main_frame_item_sequence_number(std::move(primary_main_frame_item_sequence_number_in)) {}

RenderFrameMetadata::~RenderFrameMetadata() = default;

void RenderFrameMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_background_color"), this->root_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset"), this->root_scroll_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::PointF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_scroll_offset_at_top"), this->is_scroll_offset_at_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection"), this->selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::Selection<::gfx::SelectionBound>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_mobile_optimized"), this->is_mobile_optimized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegated_ink_metadata"), this->delegated_ink_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DelegatedInkBrowserMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport_size_in_pixels"), this->viewport_size_in_pixels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_surface_id"), this->local_surface_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::viz::LocalSurfaceId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "external_page_scale_factor"), this->external_page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_height"), this->top_controls_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_shown_ratio"), this->top_controls_shown_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_vertical_scroll_direction"), this->new_vertical_scroll_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::VerticalScrollDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_main_frame_item_sequence_number"), this->primary_main_frame_item_sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RenderFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

RenderFrameMetadataObserver::IPCStableHashFunction RenderFrameMetadataObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderFrameMetadataObserver>(message.name())) {
    case messages::RenderFrameMetadataObserver::kReportAllFrameSubmissionsForTesting: {
      return &RenderFrameMetadataObserver::ReportAllFrameSubmissionsForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderFrameMetadataObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderFrameMetadataObserver>(message.name())) {
      case messages::RenderFrameMetadataObserver::kReportAllFrameSubmissionsForTesting:
            return "Receive cc::mojom::RenderFrameMetadataObserver::ReportAllFrameSubmissionsForTesting";
    }
  } else {
    switch (static_cast<messages::RenderFrameMetadataObserver>(message.name())) {
      case messages::RenderFrameMetadataObserver::kReportAllFrameSubmissionsForTesting:
            return "Receive reply cc::mojom::RenderFrameMetadataObserver::ReportAllFrameSubmissionsForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderFrameMetadataObserver::ReportAllFrameSubmissionsForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80532f19;  // IPCStableHash for cc::mojom::RenderFrameMetadataObserver::ReportAllFrameSubmissionsForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RenderFrameMetadataObserverProxy::RenderFrameMetadataObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderFrameMetadataObserverProxy::ReportAllFrameSubmissionsForTesting(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cc::mojom::RenderFrameMetadataObserver::ReportAllFrameSubmissionsForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderFrameMetadataObserver::kReportAllFrameSubmissionsForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cc::mojom::internal::RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameMetadataObserver::Name_);
  message.set_method_name("ReportAllFrameSubmissionsForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RenderFrameMetadataObserverStubDispatch::Accept(
    RenderFrameMetadataObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderFrameMetadataObserver>(message->header()->name)) {
    case messages::RenderFrameMetadataObserver::kReportAllFrameSubmissionsForTesting: {
      DCHECK(message->is_serialized());
      internal::RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data* params =
          reinterpret_cast<internal::RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderFrameMetadataObserver.0
      bool success = true;
      bool p_enabled{};
      RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameMetadataObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAllFrameSubmissionsForTesting(        
        std::move(p_enabled));
      return true;
    }
  }
  return false;
}

// static
bool RenderFrameMetadataObserverStubDispatch::AcceptWithResponder(
    RenderFrameMetadataObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderFrameMetadataObserver>(message->header()->name)) {
    case messages::RenderFrameMetadataObserver::kReportAllFrameSubmissionsForTesting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRenderFrameMetadataObserverValidationInfo[] = {
    { &internal::RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params_Data::Validate,
     nullptr /* no response */},
};

bool RenderFrameMetadataObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::cc::mojom::RenderFrameMetadataObserver::Name_,
    kRenderFrameMetadataObserverValidationInfo);
}

// The declaration includes the definition on other builds.

RenderFrameMetadataObserverClient::IPCStableHashFunction RenderFrameMetadataObserverClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderFrameMetadataObserverClient>(message.name())) {
    case messages::RenderFrameMetadataObserverClient::kOnRenderFrameMetadataChanged: {
      return &RenderFrameMetadataObserverClient::OnRenderFrameMetadataChanged_Sym::IPCStableHash;
    }
    case messages::RenderFrameMetadataObserverClient::kOnFrameSubmissionForTesting: {
      return &RenderFrameMetadataObserverClient::OnFrameSubmissionForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderFrameMetadataObserverClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderFrameMetadataObserverClient>(message.name())) {
      case messages::RenderFrameMetadataObserverClient::kOnRenderFrameMetadataChanged:
            return "Receive cc::mojom::RenderFrameMetadataObserverClient::OnRenderFrameMetadataChanged";
      case messages::RenderFrameMetadataObserverClient::kOnFrameSubmissionForTesting:
            return "Receive cc::mojom::RenderFrameMetadataObserverClient::OnFrameSubmissionForTesting";
    }
  } else {
    switch (static_cast<messages::RenderFrameMetadataObserverClient>(message.name())) {
      case messages::RenderFrameMetadataObserverClient::kOnRenderFrameMetadataChanged:
            return "Receive reply cc::mojom::RenderFrameMetadataObserverClient::OnRenderFrameMetadataChanged";
      case messages::RenderFrameMetadataObserverClient::kOnFrameSubmissionForTesting:
            return "Receive reply cc::mojom::RenderFrameMetadataObserverClient::OnFrameSubmissionForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderFrameMetadataObserverClient::OnRenderFrameMetadataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c8fd538;  // IPCStableHash for cc::mojom::RenderFrameMetadataObserverClient::OnRenderFrameMetadataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderFrameMetadataObserverClient::OnFrameSubmissionForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d1ee457;  // IPCStableHash for cc::mojom::RenderFrameMetadataObserverClient::OnFrameSubmissionForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RenderFrameMetadataObserverClientProxy::RenderFrameMetadataObserverClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderFrameMetadataObserverClientProxy::OnRenderFrameMetadataChanged(
    uint32_t in_frame_token, const ::cc::RenderFrameMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cc::mojom::RenderFrameMetadataObserverClient::OnRenderFrameMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const ::cc::RenderFrameMetadata&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderFrameMetadataObserverClient::kOnRenderFrameMetadataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cc::mojom::internal::RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data> params(
          message);
  params.Allocate();

  params->frame_token = in_frame_token;
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::cc::mojom::RenderFrameMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in RenderFrameMetadataObserverClient.OnRenderFrameMetadataChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameMetadataObserverClient::Name_);
  message.set_method_name("OnRenderFrameMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderFrameMetadataObserverClientProxy::OnFrameSubmissionForTesting(
    uint32_t in_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cc::mojom::RenderFrameMetadataObserverClient::OnFrameSubmissionForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderFrameMetadataObserverClient::kOnFrameSubmissionForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cc::mojom::internal::RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data> params(
          message);
  params.Allocate();

  params->frame_token = in_frame_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderFrameMetadataObserverClient::Name_);
  message.set_method_name("OnFrameSubmissionForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RenderFrameMetadataObserverClientStubDispatch::Accept(
    RenderFrameMetadataObserverClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderFrameMetadataObserverClient>(message->header()->name)) {
    case messages::RenderFrameMetadataObserverClient::kOnRenderFrameMetadataChanged: {
      DCHECK(message->is_serialized());
      internal::RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderFrameMetadataObserverClient.0
      bool success = true;
      uint32_t p_frame_token{};
      ::cc::RenderFrameMetadata p_metadata{};
      RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_token = input_data_view.frame_token();
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameMetadataObserverClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRenderFrameMetadataChanged(        
        std::move(p_frame_token), 
        std::move(p_metadata));
      return true;
    }
    case messages::RenderFrameMetadataObserverClient::kOnFrameSubmissionForTesting: {
      DCHECK(message->is_serialized());
      internal::RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data* params =
          reinterpret_cast<internal::RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderFrameMetadataObserverClient.1
      bool success = true;
      uint32_t p_frame_token{};
      RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_token = input_data_view.frame_token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderFrameMetadataObserverClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameSubmissionForTesting(        
        std::move(p_frame_token));
      return true;
    }
  }
  return false;
}

// static
bool RenderFrameMetadataObserverClientStubDispatch::AcceptWithResponder(
    RenderFrameMetadataObserverClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderFrameMetadataObserverClient>(message->header()->name)) {
    case messages::RenderFrameMetadataObserverClient::kOnRenderFrameMetadataChanged: {
      break;
    }
    case messages::RenderFrameMetadataObserverClient::kOnFrameSubmissionForTesting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRenderFrameMetadataObserverClientValidationInfo[] = {
    { &internal::RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params_Data::Validate,
     nullptr /* no response */},
};

bool RenderFrameMetadataObserverClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::cc::mojom::RenderFrameMetadataObserverClient::Name_,
    kRenderFrameMetadataObserverClientValidationInfo);
}



}  // cc::mojom


namespace mojo {


// static
bool StructTraits<::cc::mojom::DelegatedInkBrowserMetadata::DataView, ::cc::mojom::DelegatedInkBrowserMetadataPtr>::Read(
    ::cc::mojom::DelegatedInkBrowserMetadata::DataView input,
    ::cc::mojom::DelegatedInkBrowserMetadataPtr* output) {
  bool success = true;
  ::cc::mojom::DelegatedInkBrowserMetadataPtr result(::cc::mojom::DelegatedInkBrowserMetadata::New());
  
      if (success)
        result->delegated_ink_is_hovering = input.delegated_ink_is_hovering();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cc::mojom::RenderFrameMetadata::DataView, ::cc::mojom::RenderFrameMetadataPtr>::Read(
    ::cc::mojom::RenderFrameMetadata::DataView input,
    ::cc::mojom::RenderFrameMetadataPtr* output) {
  bool success = true;
  ::cc::mojom::RenderFrameMetadataPtr result(::cc::mojom::RenderFrameMetadata::New());
  
      if (success && !input.ReadRootBackgroundColor(&result->root_background_color))
        success = false;
      if (success && !input.ReadRootScrollOffset(&result->root_scroll_offset))
        success = false;
      if (success)
        result->is_scroll_offset_at_top = input.is_scroll_offset_at_top();
      if (success && !input.ReadSelection(&result->selection))
        success = false;
      if (success)
        result->is_mobile_optimized = input.is_mobile_optimized();
      if (success && !input.ReadDelegatedInkMetadata(&result->delegated_ink_metadata))
        success = false;
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success && !input.ReadViewportSizeInPixels(&result->viewport_size_in_pixels))
        success = false;
      if (success && !input.ReadLocalSurfaceId(&result->local_surface_id))
        success = false;
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->external_page_scale_factor = input.external_page_scale_factor();
      if (success)
        result->top_controls_height = input.top_controls_height();
      if (success)
        result->top_controls_shown_ratio = input.top_controls_shown_ratio();
      if (success && !input.ReadNewVerticalScrollDirection(&result->new_vertical_scroll_direction))
        success = false;
      if (success)
        result->primary_main_frame_item_sequence_number = input.primary_main_frame_item_sequence_number();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace cc::mojom {


void RenderFrameMetadataObserverInterceptorForTesting::ReportAllFrameSubmissionsForTesting(bool enabled) {
  GetForwardingInterface()->ReportAllFrameSubmissionsForTesting(
    std::move(enabled)
    );
}
RenderFrameMetadataObserverAsyncWaiter::RenderFrameMetadataObserverAsyncWaiter(
    RenderFrameMetadataObserver* proxy) : proxy_(proxy) {}

RenderFrameMetadataObserverAsyncWaiter::~RenderFrameMetadataObserverAsyncWaiter() = default;





void RenderFrameMetadataObserverClientInterceptorForTesting::OnRenderFrameMetadataChanged(uint32_t frame_token, const ::cc::RenderFrameMetadata& metadata) {
  GetForwardingInterface()->OnRenderFrameMetadataChanged(
    std::move(frame_token)
    , 
    std::move(metadata)
    );
}
void RenderFrameMetadataObserverClientInterceptorForTesting::OnFrameSubmissionForTesting(uint32_t frame_token) {
  GetForwardingInterface()->OnFrameSubmissionForTesting(
    std::move(frame_token)
    );
}
RenderFrameMetadataObserverClientAsyncWaiter::RenderFrameMetadataObserverClientAsyncWaiter(
    RenderFrameMetadataObserverClient* proxy) : proxy_(proxy) {}

RenderFrameMetadataObserverClientAsyncWaiter::~RenderFrameMetadataObserverClientAsyncWaiter() = default;







}  // cc::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif