// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef v8_inspector_protocol_Debugger_h
#define v8_inspector_protocol_Debugger_h

#include "src/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "src/inspector/protocol/Runtime.h"
#include "include/inspector/Debugger.h"

namespace v8_inspector {
namespace protocol {
namespace Debugger {
using BreakpointId = String;
using CallFrameId = String;
class Location;
class ScriptPosition;
class LocationRange;
class CallFrame;
class Scope;
class SearchMatch;
class BreakLocation;
class WasmDisassemblyChunk;
using ScriptLanguage = String;
class DebugSymbols;
class ResolvedBreakpoint;

// ------------- Forward and enum declarations.

namespace ScriptLanguageEnum {
 extern const char JavaScript[];
 extern const char WebAssembly[];
} // namespace ScriptLanguageEnum

namespace ContinueToLocation {
namespace TargetCallFramesEnum {
 extern const char* Any;
 extern const char* Current;
} // TargetCallFramesEnum
} // ContinueToLocation

namespace RestartFrame {
namespace ModeEnum {
 extern const char* StepInto;
} // ModeEnum
} // RestartFrame

namespace SetInstrumentationBreakpoint {
namespace InstrumentationEnum {
 extern const char* BeforeScriptExecution;
 extern const char* BeforeScriptWithSourceMapExecution;
} // InstrumentationEnum
} // SetInstrumentationBreakpoint

namespace SetPauseOnExceptions {
namespace StateEnum {
 extern const char* None;
 extern const char* Caught;
 extern const char* Uncaught;
 extern const char* All;
} // StateEnum
} // SetPauseOnExceptions

namespace SetScriptSource {
namespace StatusEnum {
 extern const char* Ok;
 extern const char* CompileError;
 extern const char* BlockedByActiveGenerator;
 extern const char* BlockedByActiveFunction;
 extern const char* BlockedByTopLevelEsModuleChange;
} // StatusEnum
} // SetScriptSource

namespace Paused {
namespace ReasonEnum {
 extern const char* Ambiguous;
 extern const char* Assert;
 extern const char* CSPViolation;
 extern const char* DebugCommand;
 extern const char* DOM;
 extern const char* EventListener;
 extern const char* Exception;
 extern const char* Instrumentation;
 extern const char* OOM;
 extern const char* Other;
 extern const char* PromiseRejection;
 extern const char* XHR;
 extern const char* Step;
} // ReasonEnum
} // Paused

// ------------- Type and builder declarations.

class  Location : public ::v8_crdtp::ProtocolObject<Location> {
public:
    ~Location() override;  // Defined below

    String getScriptId() { return m_scriptId; }
    void setScriptId(const String& value);  // Defined below

    int getLineNumber() { return m_lineNumber; }
    void setLineNumber(int value);  // Defined below

    bool hasColumnNumber() { return !!m_columnNumber; }
    int getColumnNumber(int defaultValue) const {
       return m_columnNumber.value_or(defaultValue);
    }
    const std::optional<int>& getColumnNumber() const {
       return m_columnNumber;
    }
    void setColumnNumber(int value);  // Defined below

    template<int STATE>
    class LocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ScriptIdSet = 1 << 1,
            LineNumberSet = 1 << 2,
            AllFieldsSet = (ScriptIdSet | LineNumberSet | 0)};


        LocationBuilder<STATE | ScriptIdSet>& setScriptId(const String& value);  // Defined below

        LocationBuilder<STATE | LineNumberSet>& setLineNumber(int value);  // Defined below

        LocationBuilder<STATE>& setColumnNumber(int value);  // Defined below

        std::unique_ptr<Location> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Location;
        LocationBuilder() : m_result(new Location()) { }

        template<int STEP> LocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::Location> m_result;
    };

    static LocationBuilder<0> create()
    {
        return LocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Location();  // Defined below

    String m_scriptId;
    int m_lineNumber;
    std::optional<int> m_columnNumber;
};


class  ScriptPosition : public ::v8_crdtp::ProtocolObject<ScriptPosition> {
public:
    ~ScriptPosition() override;  // Defined below

    int getLineNumber() { return m_lineNumber; }
    void setLineNumber(int value);  // Defined below

    int getColumnNumber() { return m_columnNumber; }
    void setColumnNumber(int value);  // Defined below

    template<int STATE>
    class ScriptPositionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LineNumberSet = 1 << 1,
            ColumnNumberSet = 1 << 2,
            AllFieldsSet = (LineNumberSet | ColumnNumberSet | 0)};


        ScriptPositionBuilder<STATE | LineNumberSet>& setLineNumber(int value);  // Defined below

        ScriptPositionBuilder<STATE | ColumnNumberSet>& setColumnNumber(int value);  // Defined below

        std::unique_ptr<ScriptPosition> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScriptPosition;
        ScriptPositionBuilder() : m_result(new ScriptPosition()) { }

        template<int STEP> ScriptPositionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScriptPositionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::ScriptPosition> m_result;
    };

    static ScriptPositionBuilder<0> create()
    {
        return ScriptPositionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScriptPosition();  // Defined below

    int m_lineNumber;
    int m_columnNumber;
};


class  LocationRange : public ::v8_crdtp::ProtocolObject<LocationRange> {
public:
    ~LocationRange() override;  // Defined below

    String getScriptId() { return m_scriptId; }
    void setScriptId(const String& value);  // Defined below

    protocol::Debugger::ScriptPosition* getStart() { return m_start.get(); }
    void setStart(std::unique_ptr<protocol::Debugger::ScriptPosition> value);  // Defined below

    protocol::Debugger::ScriptPosition* getEnd() { return m_end.get(); }
    void setEnd(std::unique_ptr<protocol::Debugger::ScriptPosition> value);  // Defined below

    template<int STATE>
    class LocationRangeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ScriptIdSet = 1 << 1,
            StartSet = 1 << 2,
            EndSet = 1 << 3,
            AllFieldsSet = (ScriptIdSet | StartSet | EndSet | 0)};


        LocationRangeBuilder<STATE | ScriptIdSet>& setScriptId(const String& value);  // Defined below

        LocationRangeBuilder<STATE | StartSet>& setStart(std::unique_ptr<protocol::Debugger::ScriptPosition> value);  // Defined below

        LocationRangeBuilder<STATE | EndSet>& setEnd(std::unique_ptr<protocol::Debugger::ScriptPosition> value);  // Defined below

        std::unique_ptr<LocationRange> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LocationRange;
        LocationRangeBuilder() : m_result(new LocationRange()) { }

        template<int STEP> LocationRangeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LocationRangeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::LocationRange> m_result;
    };

    static LocationRangeBuilder<0> create()
    {
        return LocationRangeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LocationRange();  // Defined below

    String m_scriptId;
    std::unique_ptr<protocol::Debugger::ScriptPosition> m_start;
    std::unique_ptr<protocol::Debugger::ScriptPosition> m_end;
};


class  CallFrame : public ::v8_crdtp::ProtocolObject<CallFrame> {
public:
    ~CallFrame() override;  // Defined below

    String getCallFrameId() { return m_callFrameId; }
    void setCallFrameId(const String& value);  // Defined below

    String getFunctionName() { return m_functionName; }
    void setFunctionName(const String& value);  // Defined below

    bool hasFunctionLocation() { return !!m_functionLocation; }
    protocol::Debugger::Location* getFunctionLocation(protocol::Debugger::Location* defaultValue) {
       return m_functionLocation ? m_functionLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Debugger::Location>& getFunctionLocation() const {
       return m_functionLocation;
    }
    void setFunctionLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

    protocol::Debugger::Location* getLocation() { return m_location.get(); }
    void setLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    protocol::Array<protocol::Debugger::Scope>* getScopeChain() { return m_scopeChain.get(); }
    void setScopeChain(std::unique_ptr<protocol::Array<protocol::Debugger::Scope>> value);  // Defined below

    protocol::Runtime::RemoteObject* getThis() { return m_this.get(); }
    void setThis(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    bool hasReturnValue() { return !!m_returnValue; }
    protocol::Runtime::RemoteObject* getReturnValue(protocol::Runtime::RemoteObject* defaultValue) {
       return m_returnValue ? m_returnValue.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::RemoteObject>& getReturnValue() const {
       return m_returnValue;
    }
    void setReturnValue(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    bool hasCanBeRestarted() { return !!m_canBeRestarted; }
    bool getCanBeRestarted(bool defaultValue) const {
       return m_canBeRestarted.value_or(defaultValue);
    }
    const std::optional<bool>& getCanBeRestarted() const {
       return m_canBeRestarted;
    }
    void setCanBeRestarted(bool value);  // Defined below

    template<int STATE>
    class CallFrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CallFrameIdSet = 1 << 1,
            FunctionNameSet = 1 << 2,
            LocationSet = 1 << 3,
            UrlSet = 1 << 4,
            ScopeChainSet = 1 << 5,
            ThisSet = 1 << 6,
            AllFieldsSet = (CallFrameIdSet | FunctionNameSet | LocationSet | UrlSet | ScopeChainSet | ThisSet | 0)};


        CallFrameBuilder<STATE | CallFrameIdSet>& setCallFrameId(const String& value);  // Defined below

        CallFrameBuilder<STATE | FunctionNameSet>& setFunctionName(const String& value);  // Defined below

        CallFrameBuilder<STATE>& setFunctionLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

        CallFrameBuilder<STATE | LocationSet>& setLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

        CallFrameBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        CallFrameBuilder<STATE | ScopeChainSet>& setScopeChain(std::unique_ptr<protocol::Array<protocol::Debugger::Scope>> value);  // Defined below

        CallFrameBuilder<STATE | ThisSet>& setThis(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        CallFrameBuilder<STATE>& setReturnValue(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        CallFrameBuilder<STATE>& setCanBeRestarted(bool value);  // Defined below

        std::unique_ptr<CallFrame> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CallFrame;
        CallFrameBuilder() : m_result(new CallFrame()) { }

        template<int STEP> CallFrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CallFrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::CallFrame> m_result;
    };

    static CallFrameBuilder<0> create()
    {
        return CallFrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CallFrame();  // Defined below

    String m_callFrameId;
    String m_functionName;
    std::unique_ptr<protocol::Debugger::Location> m_functionLocation;
    std::unique_ptr<protocol::Debugger::Location> m_location;
    String m_url;
    std::unique_ptr<protocol::Array<protocol::Debugger::Scope>> m_scopeChain;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_this;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_returnValue;
    std::optional<bool> m_canBeRestarted;
};


class  Scope : public ::v8_crdtp::ProtocolObject<Scope> {
public:
    ~Scope() override;  // Defined below

    struct  TypeEnum {
        static const char* Global;
        static const char* Local;
        static const char* With;
        static const char* Closure;
        static const char* Catch;
        static const char* Block;
        static const char* Script;
        static const char* Eval;
        static const char* Module;
        static const char* WasmExpressionStack;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    protocol::Runtime::RemoteObject* getObject() { return m_object.get(); }
    void setObject(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

    bool hasName() { return !!m_name; }
    String getName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& getName() const {
       return m_name;
    }
    void setName(const String& value);  // Defined below

    bool hasStartLocation() { return !!m_startLocation; }
    protocol::Debugger::Location* getStartLocation(protocol::Debugger::Location* defaultValue) {
       return m_startLocation ? m_startLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Debugger::Location>& getStartLocation() const {
       return m_startLocation;
    }
    void setStartLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

    bool hasEndLocation() { return !!m_endLocation; }
    protocol::Debugger::Location* getEndLocation(protocol::Debugger::Location* defaultValue) {
       return m_endLocation ? m_endLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Debugger::Location>& getEndLocation() const {
       return m_endLocation;
    }
    void setEndLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

    template<int STATE>
    class ScopeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            ObjectSet = 1 << 2,
            AllFieldsSet = (TypeSet | ObjectSet | 0)};


        ScopeBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        ScopeBuilder<STATE | ObjectSet>& setObject(std::unique_ptr<protocol::Runtime::RemoteObject> value);  // Defined below

        ScopeBuilder<STATE>& setName(const String& value);  // Defined below

        ScopeBuilder<STATE>& setStartLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

        ScopeBuilder<STATE>& setEndLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

        std::unique_ptr<Scope> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Scope;
        ScopeBuilder() : m_result(new Scope()) { }

        template<int STEP> ScopeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScopeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::Scope> m_result;
    };

    static ScopeBuilder<0> create()
    {
        return ScopeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Scope();  // Defined below

    String m_type;
    std::unique_ptr<protocol::Runtime::RemoteObject> m_object;
    std::optional<String> m_name;
    std::unique_ptr<protocol::Debugger::Location> m_startLocation;
    std::unique_ptr<protocol::Debugger::Location> m_endLocation;
};


class  SearchMatch : public ::v8_crdtp::ProtocolObject<SearchMatch>,
    public API::SearchMatch {
public:
    ~SearchMatch() override;  // Defined below

    double getLineNumber() { return m_lineNumber; }
    void setLineNumber(double value);  // Defined below

    String getLineContent() { return m_lineContent; }
    void setLineContent(const String& value);  // Defined below

    template<int STATE>
    class SearchMatchBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LineNumberSet = 1 << 1,
            LineContentSet = 1 << 2,
            AllFieldsSet = (LineNumberSet | LineContentSet | 0)};


        SearchMatchBuilder<STATE | LineNumberSet>& setLineNumber(double value);  // Defined below

        SearchMatchBuilder<STATE | LineContentSet>& setLineContent(const String& value);  // Defined below

        std::unique_ptr<SearchMatch> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SearchMatch;
        SearchMatchBuilder() : m_result(new SearchMatch()) { }

        template<int STEP> SearchMatchBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SearchMatchBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::SearchMatch> m_result;
    };

    static SearchMatchBuilder<0> create()
    {
        return SearchMatchBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SearchMatch();  // Defined below

    double m_lineNumber;
    String m_lineContent;
};


class  BreakLocation : public ::v8_crdtp::ProtocolObject<BreakLocation> {
public:
    ~BreakLocation() override;  // Defined below

    String getScriptId() { return m_scriptId; }
    void setScriptId(const String& value);  // Defined below

    int getLineNumber() { return m_lineNumber; }
    void setLineNumber(int value);  // Defined below

    bool hasColumnNumber() { return !!m_columnNumber; }
    int getColumnNumber(int defaultValue) const {
       return m_columnNumber.value_or(defaultValue);
    }
    const std::optional<int>& getColumnNumber() const {
       return m_columnNumber;
    }
    void setColumnNumber(int value);  // Defined below

    struct  TypeEnum {
        static const char* DebuggerStatement;
        static const char* Call;
        static const char* Return;
    }; // TypeEnum

    bool hasType() { return !!m_type; }
    String getType(const String& defaultValue) const {
       return m_type.value_or(defaultValue);
    }
    const std::optional<String>& getType() const {
       return m_type;
    }
    void setType(const String& value);  // Defined below

    template<int STATE>
    class BreakLocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ScriptIdSet = 1 << 1,
            LineNumberSet = 1 << 2,
            AllFieldsSet = (ScriptIdSet | LineNumberSet | 0)};


        BreakLocationBuilder<STATE | ScriptIdSet>& setScriptId(const String& value);  // Defined below

        BreakLocationBuilder<STATE | LineNumberSet>& setLineNumber(int value);  // Defined below

        BreakLocationBuilder<STATE>& setColumnNumber(int value);  // Defined below

        BreakLocationBuilder<STATE>& setType(const String& value);  // Defined below

        std::unique_ptr<BreakLocation> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BreakLocation;
        BreakLocationBuilder() : m_result(new BreakLocation()) { }

        template<int STEP> BreakLocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BreakLocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::BreakLocation> m_result;
    };

    static BreakLocationBuilder<0> create()
    {
        return BreakLocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BreakLocation();  // Defined below

    String m_scriptId;
    int m_lineNumber;
    std::optional<int> m_columnNumber;
    std::optional<String> m_type;
};


class  WasmDisassemblyChunk : public ::v8_crdtp::ProtocolObject<WasmDisassemblyChunk> {
public:
    ~WasmDisassemblyChunk() override;  // Defined below

    protocol::Array<String>* getLines() { return m_lines.get(); }
    void setLines(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Array<int>* getBytecodeOffsets() { return m_bytecodeOffsets.get(); }
    void setBytecodeOffsets(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    template<int STATE>
    class WasmDisassemblyChunkBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LinesSet = 1 << 1,
            BytecodeOffsetsSet = 1 << 2,
            AllFieldsSet = (LinesSet | BytecodeOffsetsSet | 0)};


        WasmDisassemblyChunkBuilder<STATE | LinesSet>& setLines(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        WasmDisassemblyChunkBuilder<STATE | BytecodeOffsetsSet>& setBytecodeOffsets(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        std::unique_ptr<WasmDisassemblyChunk> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WasmDisassemblyChunk;
        WasmDisassemblyChunkBuilder() : m_result(new WasmDisassemblyChunk()) { }

        template<int STEP> WasmDisassemblyChunkBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WasmDisassemblyChunkBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::WasmDisassemblyChunk> m_result;
    };

    static WasmDisassemblyChunkBuilder<0> create()
    {
        return WasmDisassemblyChunkBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WasmDisassemblyChunk();  // Defined below

    std::unique_ptr<protocol::Array<String>> m_lines;
    std::unique_ptr<protocol::Array<int>> m_bytecodeOffsets;
};


class  DebugSymbols : public ::v8_crdtp::ProtocolObject<DebugSymbols> {
public:
    ~DebugSymbols() override;  // Defined below

    struct  TypeEnum {
        static const char* SourceMap;
        static const char* EmbeddedDWARF;
        static const char* ExternalDWARF;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    bool hasExternalURL() { return !!m_externalURL; }
    String getExternalURL(const String& defaultValue) const {
       return m_externalURL.value_or(defaultValue);
    }
    const std::optional<String>& getExternalURL() const {
       return m_externalURL;
    }
    void setExternalURL(const String& value);  // Defined below

    template<int STATE>
    class DebugSymbolsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        DebugSymbolsBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        DebugSymbolsBuilder<STATE>& setExternalURL(const String& value);  // Defined below

        std::unique_ptr<DebugSymbols> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DebugSymbols;
        DebugSymbolsBuilder() : m_result(new DebugSymbols()) { }

        template<int STEP> DebugSymbolsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DebugSymbolsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::DebugSymbols> m_result;
    };

    static DebugSymbolsBuilder<0> create()
    {
        return DebugSymbolsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DebugSymbols();  // Defined below

    String m_type;
    std::optional<String> m_externalURL;
};


class  ResolvedBreakpoint : public ::v8_crdtp::ProtocolObject<ResolvedBreakpoint> {
public:
    ~ResolvedBreakpoint() override;  // Defined below

    String getBreakpointId() { return m_breakpointId; }
    void setBreakpointId(const String& value);  // Defined below

    protocol::Debugger::Location* getLocation() { return m_location.get(); }
    void setLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

    template<int STATE>
    class ResolvedBreakpointBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BreakpointIdSet = 1 << 1,
            LocationSet = 1 << 2,
            AllFieldsSet = (BreakpointIdSet | LocationSet | 0)};


        ResolvedBreakpointBuilder<STATE | BreakpointIdSet>& setBreakpointId(const String& value);  // Defined below

        ResolvedBreakpointBuilder<STATE | LocationSet>& setLocation(std::unique_ptr<protocol::Debugger::Location> value);  // Defined below

        std::unique_ptr<ResolvedBreakpoint> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ResolvedBreakpoint;
        ResolvedBreakpointBuilder() : m_result(new ResolvedBreakpoint()) { }

        template<int STEP> ResolvedBreakpointBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ResolvedBreakpointBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Debugger::ResolvedBreakpoint> m_result;
    };

    static ResolvedBreakpointBuilder<0> create()
    {
        return ResolvedBreakpointBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ResolvedBreakpoint();  // Defined below

    String m_breakpointId;
    std::unique_ptr<protocol::Debugger::Location> m_location;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline Location::~Location() = default;
inline void Location::setScriptId(const String& value) { m_scriptId = value; }
inline void Location::setLineNumber(int value) { m_lineNumber = value; }
inline void Location::setColumnNumber(int value) { m_columnNumber = value; }

template<int STATE>
inline Location::LocationBuilder<STATE | Location::LocationBuilder<STATE>::ScriptIdSet>&
Location::LocationBuilder<STATE>::setScriptId(const String& value) {
  static_assert(!(STATE & ScriptIdSet), "property scriptId should not be set yet");
  m_result->setScriptId(value);
  return castState<ScriptIdSet>();
}
template<int STATE>
inline Location::LocationBuilder<STATE | Location::LocationBuilder<STATE>::LineNumberSet>&
Location::LocationBuilder<STATE>::setLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->setLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline Location::LocationBuilder<STATE>& Location::LocationBuilder<STATE>::setColumnNumber(int value) {
  m_result->setColumnNumber(value);
  return *this;
}

inline Location::Location() {
  m_lineNumber = 0;
}
inline ScriptPosition::~ScriptPosition() = default;
inline void ScriptPosition::setLineNumber(int value) { m_lineNumber = value; }
inline void ScriptPosition::setColumnNumber(int value) { m_columnNumber = value; }

template<int STATE>
inline ScriptPosition::ScriptPositionBuilder<STATE | ScriptPosition::ScriptPositionBuilder<STATE>::LineNumberSet>&
ScriptPosition::ScriptPositionBuilder<STATE>::setLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->setLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline ScriptPosition::ScriptPositionBuilder<STATE | ScriptPosition::ScriptPositionBuilder<STATE>::ColumnNumberSet>&
ScriptPosition::ScriptPositionBuilder<STATE>::setColumnNumber(int value) {
  static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
  m_result->setColumnNumber(value);
  return castState<ColumnNumberSet>();
}

inline ScriptPosition::ScriptPosition() {
  m_lineNumber = 0;
  m_columnNumber = 0;
}
inline LocationRange::~LocationRange() = default;
inline void LocationRange::setScriptId(const String& value) { m_scriptId = value; }
inline void LocationRange::setStart(std::unique_ptr<protocol::Debugger::ScriptPosition> value) { m_start = std::move(value); }
inline void LocationRange::setEnd(std::unique_ptr<protocol::Debugger::ScriptPosition> value) { m_end = std::move(value); }

template<int STATE>
inline LocationRange::LocationRangeBuilder<STATE | LocationRange::LocationRangeBuilder<STATE>::ScriptIdSet>&
LocationRange::LocationRangeBuilder<STATE>::setScriptId(const String& value) {
  static_assert(!(STATE & ScriptIdSet), "property scriptId should not be set yet");
  m_result->setScriptId(value);
  return castState<ScriptIdSet>();
}
template<int STATE>
inline LocationRange::LocationRangeBuilder<STATE | LocationRange::LocationRangeBuilder<STATE>::StartSet>&
LocationRange::LocationRangeBuilder<STATE>::setStart(std::unique_ptr<protocol::Debugger::ScriptPosition> value) {
  static_assert(!(STATE & StartSet), "property start should not be set yet");
  m_result->setStart(std::move(value));
  return castState<StartSet>();
}
template<int STATE>
inline LocationRange::LocationRangeBuilder<STATE | LocationRange::LocationRangeBuilder<STATE>::EndSet>&
LocationRange::LocationRangeBuilder<STATE>::setEnd(std::unique_ptr<protocol::Debugger::ScriptPosition> value) {
  static_assert(!(STATE & EndSet), "property end should not be set yet");
  m_result->setEnd(std::move(value));
  return castState<EndSet>();
}

inline LocationRange::LocationRange() {
}
inline CallFrame::~CallFrame() = default;
inline void CallFrame::setCallFrameId(const String& value) { m_callFrameId = value; }
inline void CallFrame::setFunctionName(const String& value) { m_functionName = value; }
inline void CallFrame::setFunctionLocation(std::unique_ptr<protocol::Debugger::Location> value) { m_functionLocation = std::move(value); }
inline void CallFrame::setLocation(std::unique_ptr<protocol::Debugger::Location> value) { m_location = std::move(value); }
inline void CallFrame::setUrl(const String& value) { m_url = value; }
inline void CallFrame::setScopeChain(std::unique_ptr<protocol::Array<protocol::Debugger::Scope>> value) { m_scopeChain = std::move(value); }
inline void CallFrame::setThis(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_this = std::move(value); }
inline void CallFrame::setReturnValue(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_returnValue = std::move(value); }
inline void CallFrame::setCanBeRestarted(bool value) { m_canBeRestarted = value; }

template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::CallFrameIdSet>&
CallFrame::CallFrameBuilder<STATE>::setCallFrameId(const String& value) {
  static_assert(!(STATE & CallFrameIdSet), "property callFrameId should not be set yet");
  m_result->setCallFrameId(value);
  return castState<CallFrameIdSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::FunctionNameSet>&
CallFrame::CallFrameBuilder<STATE>::setFunctionName(const String& value) {
  static_assert(!(STATE & FunctionNameSet), "property functionName should not be set yet");
  m_result->setFunctionName(value);
  return castState<FunctionNameSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE>& CallFrame::CallFrameBuilder<STATE>::setFunctionLocation(std::unique_ptr<protocol::Debugger::Location> value) {
  m_result->setFunctionLocation(std::move(value));
  return *this;
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::LocationSet>&
CallFrame::CallFrameBuilder<STATE>::setLocation(std::unique_ptr<protocol::Debugger::Location> value) {
  static_assert(!(STATE & LocationSet), "property location should not be set yet");
  m_result->setLocation(std::move(value));
  return castState<LocationSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::UrlSet>&
CallFrame::CallFrameBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::ScopeChainSet>&
CallFrame::CallFrameBuilder<STATE>::setScopeChain(std::unique_ptr<protocol::Array<protocol::Debugger::Scope>> value) {
  static_assert(!(STATE & ScopeChainSet), "property scopeChain should not be set yet");
  m_result->setScopeChain(std::move(value));
  return castState<ScopeChainSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::ThisSet>&
CallFrame::CallFrameBuilder<STATE>::setThis(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  static_assert(!(STATE & ThisSet), "property this should not be set yet");
  m_result->setThis(std::move(value));
  return castState<ThisSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE>& CallFrame::CallFrameBuilder<STATE>::setReturnValue(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  m_result->setReturnValue(std::move(value));
  return *this;
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE>& CallFrame::CallFrameBuilder<STATE>::setCanBeRestarted(bool value) {
  m_result->setCanBeRestarted(value);
  return *this;
}

inline CallFrame::CallFrame() {
}
inline Scope::~Scope() = default;
inline void Scope::setType(const String& value) { m_type = value; }
inline void Scope::setObject(std::unique_ptr<protocol::Runtime::RemoteObject> value) { m_object = std::move(value); }
inline void Scope::setName(const String& value) { m_name = value; }
inline void Scope::setStartLocation(std::unique_ptr<protocol::Debugger::Location> value) { m_startLocation = std::move(value); }
inline void Scope::setEndLocation(std::unique_ptr<protocol::Debugger::Location> value) { m_endLocation = std::move(value); }

template<int STATE>
inline Scope::ScopeBuilder<STATE | Scope::ScopeBuilder<STATE>::TypeSet>&
Scope::ScopeBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline Scope::ScopeBuilder<STATE | Scope::ScopeBuilder<STATE>::ObjectSet>&
Scope::ScopeBuilder<STATE>::setObject(std::unique_ptr<protocol::Runtime::RemoteObject> value) {
  static_assert(!(STATE & ObjectSet), "property object should not be set yet");
  m_result->setObject(std::move(value));
  return castState<ObjectSet>();
}
template<int STATE>
inline Scope::ScopeBuilder<STATE>& Scope::ScopeBuilder<STATE>::setName(const String& value) {
  m_result->setName(value);
  return *this;
}
template<int STATE>
inline Scope::ScopeBuilder<STATE>& Scope::ScopeBuilder<STATE>::setStartLocation(std::unique_ptr<protocol::Debugger::Location> value) {
  m_result->setStartLocation(std::move(value));
  return *this;
}
template<int STATE>
inline Scope::ScopeBuilder<STATE>& Scope::ScopeBuilder<STATE>::setEndLocation(std::unique_ptr<protocol::Debugger::Location> value) {
  m_result->setEndLocation(std::move(value));
  return *this;
}

inline Scope::Scope() {
}
inline SearchMatch::~SearchMatch() = default;
inline void SearchMatch::setLineNumber(double value) { m_lineNumber = value; }
inline void SearchMatch::setLineContent(const String& value) { m_lineContent = value; }

template<int STATE>
inline SearchMatch::SearchMatchBuilder<STATE | SearchMatch::SearchMatchBuilder<STATE>::LineNumberSet>&
SearchMatch::SearchMatchBuilder<STATE>::setLineNumber(double value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->setLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline SearchMatch::SearchMatchBuilder<STATE | SearchMatch::SearchMatchBuilder<STATE>::LineContentSet>&
SearchMatch::SearchMatchBuilder<STATE>::setLineContent(const String& value) {
  static_assert(!(STATE & LineContentSet), "property lineContent should not be set yet");
  m_result->setLineContent(value);
  return castState<LineContentSet>();
}

inline SearchMatch::SearchMatch() {
  m_lineNumber = 0;
}
inline BreakLocation::~BreakLocation() = default;
inline void BreakLocation::setScriptId(const String& value) { m_scriptId = value; }
inline void BreakLocation::setLineNumber(int value) { m_lineNumber = value; }
inline void BreakLocation::setColumnNumber(int value) { m_columnNumber = value; }
inline void BreakLocation::setType(const String& value) { m_type = value; }

template<int STATE>
inline BreakLocation::BreakLocationBuilder<STATE | BreakLocation::BreakLocationBuilder<STATE>::ScriptIdSet>&
BreakLocation::BreakLocationBuilder<STATE>::setScriptId(const String& value) {
  static_assert(!(STATE & ScriptIdSet), "property scriptId should not be set yet");
  m_result->setScriptId(value);
  return castState<ScriptIdSet>();
}
template<int STATE>
inline BreakLocation::BreakLocationBuilder<STATE | BreakLocation::BreakLocationBuilder<STATE>::LineNumberSet>&
BreakLocation::BreakLocationBuilder<STATE>::setLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->setLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline BreakLocation::BreakLocationBuilder<STATE>& BreakLocation::BreakLocationBuilder<STATE>::setColumnNumber(int value) {
  m_result->setColumnNumber(value);
  return *this;
}
template<int STATE>
inline BreakLocation::BreakLocationBuilder<STATE>& BreakLocation::BreakLocationBuilder<STATE>::setType(const String& value) {
  m_result->setType(value);
  return *this;
}

inline BreakLocation::BreakLocation() {
  m_lineNumber = 0;
}
inline WasmDisassemblyChunk::~WasmDisassemblyChunk() = default;
inline void WasmDisassemblyChunk::setLines(std::unique_ptr<protocol::Array<String>> value) { m_lines = std::move(value); }
inline void WasmDisassemblyChunk::setBytecodeOffsets(std::unique_ptr<protocol::Array<int>> value) { m_bytecodeOffsets = std::move(value); }

template<int STATE>
inline WasmDisassemblyChunk::WasmDisassemblyChunkBuilder<STATE | WasmDisassemblyChunk::WasmDisassemblyChunkBuilder<STATE>::LinesSet>&
WasmDisassemblyChunk::WasmDisassemblyChunkBuilder<STATE>::setLines(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & LinesSet), "property lines should not be set yet");
  m_result->setLines(std::move(value));
  return castState<LinesSet>();
}
template<int STATE>
inline WasmDisassemblyChunk::WasmDisassemblyChunkBuilder<STATE | WasmDisassemblyChunk::WasmDisassemblyChunkBuilder<STATE>::BytecodeOffsetsSet>&
WasmDisassemblyChunk::WasmDisassemblyChunkBuilder<STATE>::setBytecodeOffsets(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & BytecodeOffsetsSet), "property bytecodeOffsets should not be set yet");
  m_result->setBytecodeOffsets(std::move(value));
  return castState<BytecodeOffsetsSet>();
}

inline WasmDisassemblyChunk::WasmDisassemblyChunk() {
}
inline DebugSymbols::~DebugSymbols() = default;
inline void DebugSymbols::setType(const String& value) { m_type = value; }
inline void DebugSymbols::setExternalURL(const String& value) { m_externalURL = value; }

template<int STATE>
inline DebugSymbols::DebugSymbolsBuilder<STATE | DebugSymbols::DebugSymbolsBuilder<STATE>::TypeSet>&
DebugSymbols::DebugSymbolsBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline DebugSymbols::DebugSymbolsBuilder<STATE>& DebugSymbols::DebugSymbolsBuilder<STATE>::setExternalURL(const String& value) {
  m_result->setExternalURL(value);
  return *this;
}

inline DebugSymbols::DebugSymbols() {
}
inline ResolvedBreakpoint::~ResolvedBreakpoint() = default;
inline void ResolvedBreakpoint::setBreakpointId(const String& value) { m_breakpointId = value; }
inline void ResolvedBreakpoint::setLocation(std::unique_ptr<protocol::Debugger::Location> value) { m_location = std::move(value); }

template<int STATE>
inline ResolvedBreakpoint::ResolvedBreakpointBuilder<STATE | ResolvedBreakpoint::ResolvedBreakpointBuilder<STATE>::BreakpointIdSet>&
ResolvedBreakpoint::ResolvedBreakpointBuilder<STATE>::setBreakpointId(const String& value) {
  static_assert(!(STATE & BreakpointIdSet), "property breakpointId should not be set yet");
  m_result->setBreakpointId(value);
  return castState<BreakpointIdSet>();
}
template<int STATE>
inline ResolvedBreakpoint::ResolvedBreakpointBuilder<STATE | ResolvedBreakpoint::ResolvedBreakpointBuilder<STATE>::LocationSet>&
ResolvedBreakpoint::ResolvedBreakpointBuilder<STATE>::setLocation(std::unique_ptr<protocol::Debugger::Location> value) {
  static_assert(!(STATE & LocationSet), "property location should not be set yet");
  m_result->setLocation(std::move(value));
  return castState<LocationSet>();
}

inline ResolvedBreakpoint::ResolvedBreakpoint() {
}

// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse continueToLocation(std::unique_ptr<protocol::Debugger::Location> in_location, std::optional<String> in_targetCallFrames) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable(std::optional<double> in_maxScriptsCacheSize, String* out_debuggerId) = 0;
    virtual DispatchResponse evaluateOnCallFrame(const String& in_callFrameId, const String& in_expression, std::optional<String> in_objectGroup, std::optional<bool> in_includeCommandLineAPI, std::optional<bool> in_silent, std::optional<bool> in_returnByValue, std::optional<bool> in_generatePreview, std::optional<bool> in_throwOnSideEffect, std::optional<double> in_timeout, std::unique_ptr<protocol::Runtime::RemoteObject>* out_result, std::unique_ptr<protocol::Runtime::ExceptionDetails>* out_exceptionDetails) = 0;
    virtual DispatchResponse getPossibleBreakpoints(std::unique_ptr<protocol::Debugger::Location> in_start, std::unique_ptr<protocol::Debugger::Location> in_end, std::optional<bool> in_restrictToFunction, std::unique_ptr<protocol::Array<protocol::Debugger::BreakLocation>>* out_locations) = 0;
    virtual DispatchResponse getScriptSource(const String& in_scriptId, String* out_scriptSource, std::optional<Binary>* out_bytecode) = 0;
    virtual DispatchResponse disassembleWasmModule(const String& in_scriptId, std::optional<String>* out_streamId, int* out_totalNumberOfLines, std::unique_ptr<protocol::Array<int>>* out_functionBodyOffsets, std::unique_ptr<protocol::Debugger::WasmDisassemblyChunk>* out_chunk) = 0;
    virtual DispatchResponse nextWasmDisassemblyChunk(const String& in_streamId, std::unique_ptr<protocol::Debugger::WasmDisassemblyChunk>* out_chunk) = 0;
    virtual DispatchResponse getWasmBytecode(const String& in_scriptId, Binary* out_bytecode) = 0;
    virtual DispatchResponse getStackTrace(std::unique_ptr<protocol::Runtime::StackTraceId> in_stackTraceId, std::unique_ptr<protocol::Runtime::StackTrace>* out_stackTrace) = 0;
    virtual DispatchResponse pause() = 0;
    virtual DispatchResponse pauseOnAsyncCall(std::unique_ptr<protocol::Runtime::StackTraceId> in_parentStackTraceId) = 0;
    virtual DispatchResponse removeBreakpoint(const String& in_breakpointId) = 0;
    virtual DispatchResponse restartFrame(const String& in_callFrameId, std::optional<String> in_mode, std::unique_ptr<protocol::Array<protocol::Debugger::CallFrame>>* out_callFrames, std::unique_ptr<protocol::Runtime::StackTrace>* out_asyncStackTrace, std::unique_ptr<protocol::Runtime::StackTraceId>* out_asyncStackTraceId) = 0;
    virtual DispatchResponse resume(std::optional<bool> in_terminateOnResume) = 0;
    virtual DispatchResponse searchInContent(const String& in_scriptId, const String& in_query, std::optional<bool> in_caseSensitive, std::optional<bool> in_isRegex, std::unique_ptr<protocol::Array<protocol::Debugger::SearchMatch>>* out_result) = 0;
    virtual DispatchResponse setAsyncCallStackDepth(int in_maxDepth) = 0;
    virtual DispatchResponse setBlackboxExecutionContexts(std::unique_ptr<protocol::Array<String>> in_uniqueIds) = 0;
    virtual DispatchResponse setBlackboxPatterns(std::unique_ptr<protocol::Array<String>> in_patterns, std::optional<bool> in_skipAnonymous) = 0;
    virtual DispatchResponse setBlackboxedRanges(const String& in_scriptId, std::unique_ptr<protocol::Array<protocol::Debugger::ScriptPosition>> in_positions) = 0;
    virtual DispatchResponse setBreakpoint(std::unique_ptr<protocol::Debugger::Location> in_location, std::optional<String> in_condition, String* out_breakpointId, std::unique_ptr<protocol::Debugger::Location>* out_actualLocation) = 0;
    virtual DispatchResponse setInstrumentationBreakpoint(const String& in_instrumentation, String* out_breakpointId) = 0;
    virtual DispatchResponse setBreakpointByUrl(int in_lineNumber, std::optional<String> in_url, std::optional<String> in_urlRegex, std::optional<String> in_scriptHash, std::optional<int> in_columnNumber, std::optional<String> in_condition, String* out_breakpointId, std::unique_ptr<protocol::Array<protocol::Debugger::Location>>* out_locations) = 0;
    virtual DispatchResponse setBreakpointOnFunctionCall(const String& in_objectId, std::optional<String> in_condition, String* out_breakpointId) = 0;
    virtual DispatchResponse setBreakpointsActive(bool in_active) = 0;
    virtual DispatchResponse setPauseOnExceptions(const String& in_state) = 0;
    virtual DispatchResponse setReturnValue(std::unique_ptr<protocol::Runtime::CallArgument> in_newValue) = 0;
    virtual DispatchResponse setScriptSource(const String& in_scriptId, const String& in_scriptSource, std::optional<bool> in_dryRun, std::optional<bool> in_allowTopFrameEditing, std::unique_ptr<protocol::Array<protocol::Debugger::CallFrame>>* out_callFrames, std::optional<bool>* out_stackChanged, std::unique_ptr<protocol::Runtime::StackTrace>* out_asyncStackTrace, std::unique_ptr<protocol::Runtime::StackTraceId>* out_asyncStackTraceId, String* out_status, std::unique_ptr<protocol::Runtime::ExceptionDetails>* out_exceptionDetails) = 0;
    virtual DispatchResponse setSkipAllPauses(bool in_skip) = 0;
    virtual DispatchResponse setVariableValue(int in_scopeNumber, const String& in_variableName, std::unique_ptr<protocol::Runtime::CallArgument> in_newValue, const String& in_callFrameId) = 0;
    virtual DispatchResponse stepInto(std::optional<bool> in_breakOnAsyncCall, std::unique_ptr<protocol::Array<protocol::Debugger::LocationRange>> in_skipList) = 0;
    virtual DispatchResponse stepOut() = 0;
    virtual DispatchResponse stepOver(std::unique_ptr<protocol::Array<protocol::Debugger::LocationRange>> in_skipList) = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void breakpointResolved(const String& breakpointId, std::unique_ptr<protocol::Debugger::Location> location);
    void paused(std::unique_ptr<protocol::Array<protocol::Debugger::CallFrame>> callFrames, const String& reason, std::unique_ptr<protocol::DictionaryValue> data = {}, std::unique_ptr<protocol::Array<String>> hitBreakpoints = {}, std::unique_ptr<protocol::Runtime::StackTrace> asyncStackTrace = {}, std::unique_ptr<protocol::Runtime::StackTraceId> asyncStackTraceId = {}, std::unique_ptr<protocol::Runtime::StackTraceId> asyncCallStackTraceId = {});
    void resumed();
    void scriptFailedToParse(const String& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, int executionContextId, const String& hash, const String& buildId, std::unique_ptr<protocol::DictionaryValue> executionContextAuxData = {}, std::optional<String> sourceMapURL = {}, std::optional<bool> hasSourceURL = {}, std::optional<bool> isModule = {}, std::optional<int> length = {}, std::unique_ptr<protocol::Runtime::StackTrace> stackTrace = {}, std::optional<int> codeOffset = {}, std::optional<String> scriptLanguage = {}, std::optional<String> embedderName = {});
    void scriptParsed(const String& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, int executionContextId, const String& hash, const String& buildId, std::unique_ptr<protocol::DictionaryValue> executionContextAuxData = {}, std::optional<bool> isLiveEdit = {}, std::optional<String> sourceMapURL = {}, std::optional<bool> hasSourceURL = {}, std::optional<bool> isModule = {}, std::optional<int> length = {}, std::unique_ptr<protocol::Runtime::StackTrace> stackTrace = {}, std::optional<int> codeOffset = {}, std::optional<String> scriptLanguage = {}, std::unique_ptr<protocol::Array<protocol::Debugger::DebugSymbols>> debugSymbols = {}, std::optional<String> embedderName = {}, std::unique_ptr<protocol::Array<protocol::Debugger::ResolvedBreakpoint>> resolvedBreakpoints = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Debugger
} // namespace v8_inspector
} // namespace protocol

#endif // !defined(v8_inspector_protocol_Debugger_h)
