// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './audio_wave.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './animated_glow.css.js';
import { getHtml } from './animated_glow.html.js';
import { GlowAnimationState } from './constants.js';
/*
 * Animation glow for expanding, submitting, voice, dragging.
 * Parent must pass animationState to trigger one of 4 animations, or idle.
 * RequiresVoice, isCollapsible are optional. RequiresVoice is
 * false by default. And if it is true, then it renders the eclipse audio wave
 * element as well. IsCollapsible adds an animation for expand (see .css file).
 */
export class SearchAnimatedGlowElement extends CrLitElement {
    static get is() {
        return 'search-animated-glow';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            animationState: {
                type: String,
                reflect: true,
            },
            entrypointName: { type: String },
            dragDropPlaceholder: { type: String },
            requiresVoice: { type: Boolean },
            isCollapsible: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #animationState_accessor_storage = GlowAnimationState.NONE;
    get animationState() { return this.#animationState_accessor_storage; }
    set animationState(value) { this.#animationState_accessor_storage = value; }
    #dragDropPlaceholder_accessor_storage = loadTimeData.getString('composeboxDragAndDropHint');
    get dragDropPlaceholder() { return this.#dragDropPlaceholder_accessor_storage; }
    set dragDropPlaceholder(value) { this.#dragDropPlaceholder_accessor_storage = value; }
    #requiresVoice_accessor_storage = false;
    get requiresVoice() { return this.#requiresVoice_accessor_storage; }
    set requiresVoice(value) { this.#requiresVoice_accessor_storage = value; }
    #isCollapsible_accessor_storage = false;
    get isCollapsible() { return this.#isCollapsible_accessor_storage; }
    set isCollapsible(value) { this.#isCollapsible_accessor_storage = value; }
}
customElements.define(SearchAnimatedGlowElement.is, SearchAnimatedGlowElement);
