// ui/webui/resources/js/browser_command/browser_command.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';






export const CommandSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum Command {

  MIN_VALUE = 0,
  MAX_VALUE = 20,
  kUnknownCommand = 0,
  kOpenSafetyCheck = 1,
  kOpenSafeBrowsingEnhancedProtectionSettings = 2,
  kOpenFeedbackForm = 3,
  kOpenPrivacyGuide = 4,
  kStartTabGroupTutorial = 5,
  kOpenPasswordManager = 6,
  kNoOpCommand = 7,
  kOpenPerformanceSettings = 8,
  kOpenNTPAndStartCustomizeChromeTutorial = 9,
  kStartPasswordManagerTutorial = 10,
  kStartSavedTabGroupTutorial = 11,
  kOpenAISettings = 12,
  kOpenSafetyCheckFromWhatsNew = 13,
  kOpenPaymentsSettings = 14,
  kOpenGlic = 16,
  kOpenGlicSettings = 17,
  kPrewarmGlicFre = 18,
  kOpenSplitView = 19,
  kOpenAutofillSettings = 20,
}



export type CommandHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CommandHandlerFactoryPendingReceiver>;

export class CommandHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CommandHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<CommandHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|CommandHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'browser_command.mojom.CommandHandlerFactory',
        scope);
  }
}

export interface CommandHandlerFactoryInterface {
  createBrowserCommandHandler(handler: CommandHandlerPendingReceiver): void;
}

export class CommandHandlerFactoryRemote implements CommandHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CommandHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CommandHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CommandHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CommandHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createBrowserCommandHandler(
      handler: CommandHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        CommandHandlerFactory_CreateBrowserCommandHandler_ParamsSpec.$,
        null,
        [
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CommandHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CommandHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommandHandlerFactoryRemote, CommandHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommandHandlerFactoryRemote, CommandHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CommandHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CommandHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CommandHandlerFactory_CreateBrowserCommandHandler_ParamsSpec.$,
        null,
        impl.createBrowserCommandHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CommandHandlerFactory {
  static get $interfaceName(): string {
    return "browser_command.mojom.CommandHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CommandHandlerFactoryRemote {
    let remote = new CommandHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CommandHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CommandHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommandHandlerFactoryRemote, CommandHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommandHandlerFactoryRemote, CommandHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createBrowserCommandHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CommandHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createBrowserCommandHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CommandHandlerFactory_CreateBrowserCommandHandler_ParamsSpec.$,
        null,
        this.createBrowserCommandHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CommandHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CommandHandlerPendingReceiver>;

export class CommandHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CommandHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<CommandHandlerPendingReceiver>;
  constructor(handle: MojoHandle|CommandHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'browser_command.mojom.CommandHandler',
        scope);
  }
}

export interface CommandHandlerInterface {
  canExecuteCommand(commandId: Command): Promise<{
        canExecute: boolean, }>;
  executeCommand(commandId: Command, clickInfo: ClickInfo): Promise<{
        commandExecuted: boolean, }>;
}

export class CommandHandlerRemote implements CommandHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CommandHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CommandHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CommandHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CommandHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  canExecuteCommand(
      commandId: Command): Promise<{
        canExecute: boolean, }> {
    return this.proxy.sendMessage(
        0,
        CommandHandler_CanExecuteCommand_ParamsSpec.$,
        CommandHandler_CanExecuteCommand_ResponseParamsSpec.$,
        [
          commandId
        ],
        false);
  }

  executeCommand(
      commandId: Command,
      clickInfo: ClickInfo): Promise<{
        commandExecuted: boolean, }> {
    return this.proxy.sendMessage(
        1,
        CommandHandler_ExecuteCommand_ParamsSpec.$,
        CommandHandler_ExecuteCommand_ResponseParamsSpec.$,
        [
          commandId,
          clickInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CommandHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CommandHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommandHandlerRemote, CommandHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommandHandlerRemote, CommandHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CommandHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CommandHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CommandHandler_CanExecuteCommand_ParamsSpec.$,
        CommandHandler_CanExecuteCommand_ResponseParamsSpec.$,
        impl.canExecuteCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CommandHandler_ExecuteCommand_ParamsSpec.$,
        CommandHandler_ExecuteCommand_ResponseParamsSpec.$,
        impl.executeCommand.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CommandHandler {
  static get $interfaceName(): string {
    return "browser_command.mojom.CommandHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CommandHandlerRemote {
    let remote = new CommandHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CommandHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CommandHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CommandHandlerRemote, CommandHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CommandHandlerRemote, CommandHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  canExecuteCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CommandHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.canExecuteCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CommandHandler_CanExecuteCommand_ParamsSpec.$,
        CommandHandler_CanExecuteCommand_ResponseParamsSpec.$,
        this.canExecuteCommand.createReceiverHandler(true /* expectsResponse */),
        false);
    this.executeCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CommandHandler_ExecuteCommand_ParamsSpec.$,
        CommandHandler_ExecuteCommand_ResponseParamsSpec.$,
        this.executeCommand.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ClickInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommandHandlerFactory_CreateBrowserCommandHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommandHandler_CanExecuteCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommandHandler_CanExecuteCommand_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommandHandler_ExecuteCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CommandHandler_ExecuteCommand_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ClickInfoMojoType {
  middleButton: boolean;
  altKey: boolean;
  ctrlKey: boolean;
  metaKey: boolean;
  shiftKey: boolean;
}


export type ClickInfo = ClickInfoMojoType;
mojo.internal.Struct<ClickInfoMojoType>(
    ClickInfoSpec.$,
    'ClickInfo',
    [
      mojo.internal.StructField<ClickInfoMojoType, boolean>(
        'middleButton', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClickInfoMojoType, boolean>(
        'altKey', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClickInfoMojoType, boolean>(
        'ctrlKey', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClickInfoMojoType, boolean>(
        'metaKey', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClickInfoMojoType, boolean>(
        'shiftKey', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommandHandlerFactory_CreateBrowserCommandHandler_ParamsMojoType {
  handler: CommandHandlerPendingReceiver;
}


export type CommandHandlerFactory_CreateBrowserCommandHandler_Params = CommandHandlerFactory_CreateBrowserCommandHandler_ParamsMojoType;
mojo.internal.Struct<CommandHandlerFactory_CreateBrowserCommandHandler_ParamsMojoType>(
    CommandHandlerFactory_CreateBrowserCommandHandler_ParamsSpec.$,
    'CommandHandlerFactory_CreateBrowserCommandHandler_Params',
    [
      mojo.internal.StructField<CommandHandlerFactory_CreateBrowserCommandHandler_ParamsMojoType, CommandHandlerPendingReceiver>(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(CommandHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommandHandler_CanExecuteCommand_ParamsMojoType {
  commandId: Command;
}


export type CommandHandler_CanExecuteCommand_Params = CommandHandler_CanExecuteCommand_ParamsMojoType;
mojo.internal.Struct<CommandHandler_CanExecuteCommand_ParamsMojoType>(
    CommandHandler_CanExecuteCommand_ParamsSpec.$,
    'CommandHandler_CanExecuteCommand_Params',
    [
      mojo.internal.StructField<CommandHandler_CanExecuteCommand_ParamsMojoType, Command>(
        'commandId', 0,
        0,
        CommandSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommandHandler_CanExecuteCommand_ResponseParamsMojoType {
  canExecute: boolean;
}


export type CommandHandler_CanExecuteCommand_ResponseParams = CommandHandler_CanExecuteCommand_ResponseParamsMojoType;
mojo.internal.Struct<CommandHandler_CanExecuteCommand_ResponseParamsMojoType>(
    CommandHandler_CanExecuteCommand_ResponseParamsSpec.$,
    'CommandHandler_CanExecuteCommand_ResponseParams',
    [
      mojo.internal.StructField<CommandHandler_CanExecuteCommand_ResponseParamsMojoType, boolean>(
        'canExecute', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CommandHandler_ExecuteCommand_ParamsMojoType {
  commandId: Command;
  clickInfo: ClickInfo;
}


export type CommandHandler_ExecuteCommand_Params = CommandHandler_ExecuteCommand_ParamsMojoType;
mojo.internal.Struct<CommandHandler_ExecuteCommand_ParamsMojoType>(
    CommandHandler_ExecuteCommand_ParamsSpec.$,
    'CommandHandler_ExecuteCommand_Params',
    [
      mojo.internal.StructField<CommandHandler_ExecuteCommand_ParamsMojoType, Command>(
        'commandId', 0,
        0,
        CommandSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CommandHandler_ExecuteCommand_ParamsMojoType, ClickInfo>(
        'clickInfo', 8,
        0,
        ClickInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CommandHandler_ExecuteCommand_ResponseParamsMojoType {
  commandExecuted: boolean;
}


export type CommandHandler_ExecuteCommand_ResponseParams = CommandHandler_ExecuteCommand_ResponseParamsMojoType;
mojo.internal.Struct<CommandHandler_ExecuteCommand_ResponseParamsMojoType>(
    CommandHandler_ExecuteCommand_ResponseParamsSpec.$,
    'CommandHandler_ExecuteCommand_ResponseParams',
    [
      mojo.internal.StructField<CommandHandler_ExecuteCommand_ResponseParamsMojoType, boolean>(
        'commandExecuted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



