// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{CrRippleMixin}from"//resources/cr_elements/cr_ripple/cr_ripple_mixin.js";import{assert}from"//resources/js/assert.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{RelatedSearchAction}from"./history_clusters.mojom-webui.js";import{MetricsProxyImpl}from"./metrics_proxy.js";import{getCss}from"./search_query.css.js";import{getHtml}from"./search_query.html.js";const SearchQueryElementBase=CrRippleMixin(CrLitElement);export class SearchQueryElement extends SearchQueryElementBase{static get is(){return"search-query"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{index:{type:Number},searchQuery:{type:Object}}}#index_accessor_storage=-1;get index(){return this.#index_accessor_storage}set index(value){this.#index_accessor_storage=value}#searchQuery_accessor_storage;get searchQuery(){return this.#searchQuery_accessor_storage}set searchQuery(value){this.#searchQuery_accessor_storage=value}firstUpdated(){this.addEventListener("pointerdown",this.onPointerDown_.bind(this));this.addEventListener("pointercancel",this.onPointerCancel_.bind(this))}onAuxClick_(){MetricsProxyImpl.getInstance().recordRelatedSearchAction(RelatedSearchAction.kClicked,this.index);this.fire("related-search-clicked")}onClick_(event){event.preventDefault();this.onAuxClick_();this.openUrl_(event)}onKeydown_(e){this.noink=e.key===" ";if(e.key!=="Enter"){return}this.getRipple().uiDownAction();this.onAuxClick_();this.openUrl_(e);setTimeout((()=>this.getRipple().uiUpAction()),100)}onPointerDown_(){this.noink=false;this.ensureRipple()}onPointerCancel_(){this.getRipple().clear()}openUrl_(event){assert(this.searchQuery);BrowserProxyImpl.getInstance().handler.openHistoryUrl(this.searchQuery.url,{middleButton:false,altKey:event.altKey,ctrlKey:event.ctrlKey,metaKey:event.metaKey,shiftKey:event.shiftKey})}createRipple(){this.rippleContainer=this.$.searchQueryLink;const ripple=super.createRipple();return ripple}}customElements.define(SearchQueryElement.is,SearchQueryElement);