// ui/webui/resources/cr_components/history_clusters/history_clusters.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-params-data.h"
#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-shared-message-ids.h"

#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-import-headers.h"
#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-test-utils.h"


namespace history_clusters::mojom {
QueryResult::QueryResult()
    : query(),
      clusters(),
      can_load_more(),
      is_continuation() {}

QueryResult::QueryResult(
    const std::string& query_in,
    std::vector<::history_clusters::mojom::ClusterPtr> clusters_in,
    bool can_load_more_in,
    bool is_continuation_in)
    : query(std::move(query_in)),
      clusters(std::move(clusters_in)),
      can_load_more(std::move(can_load_more_in)),
      is_continuation(std::move(is_continuation_in)) {}

QueryResult::~QueryResult() = default;

void QueryResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "query"), this->query,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clusters"), this->clusters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::history_clusters::mojom::ClusterPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_load_more"), this->can_load_more,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_continuation"), this->is_continuation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool QueryResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kOpenHistoryUrl: {
      return &PageHandler::OpenHistoryUrl_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetPage: {
      return &PageHandler::SetPage_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowContextMenuForSearchbox: {
      return &PageHandler::ShowContextMenuForSearchbox_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowContextMenuForURL: {
      return &PageHandler::ShowContextMenuForURL_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowSidePanelUI: {
      return &PageHandler::ShowSidePanelUI_Sym::IPCStableHash;
    }
    case messages::PageHandler::kToggleVisibility: {
      return &PageHandler::ToggleVisibility_Sym::IPCStableHash;
    }
    case messages::PageHandler::kStartQueryClusters: {
      return &PageHandler::StartQueryClusters_Sym::IPCStableHash;
    }
    case messages::PageHandler::kLoadMoreClusters: {
      return &PageHandler::LoadMoreClusters_Sym::IPCStableHash;
    }
    case messages::PageHandler::kHideVisits: {
      return &PageHandler::HideVisits_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRemoveVisits: {
      return &PageHandler::RemoveVisits_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRemoveVisitByUrlAndTime: {
      return &PageHandler::RemoveVisitByUrlAndTime_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenVisitUrlsInTabGroup: {
      return &PageHandler::OpenVisitUrlsInTabGroup_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordVisitAction: {
      return &PageHandler::RecordVisitAction_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordRelatedSearchAction: {
      return &PageHandler::RecordRelatedSearchAction_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordClusterAction: {
      return &PageHandler::RecordClusterAction_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordToggledVisibility: {
      return &PageHandler::RecordToggledVisibility_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kOpenHistoryUrl:
            return "Receive history_clusters::mojom::PageHandler::OpenHistoryUrl";
      case messages::PageHandler::kSetPage:
            return "Receive history_clusters::mojom::PageHandler::SetPage";
      case messages::PageHandler::kShowContextMenuForSearchbox:
            return "Receive history_clusters::mojom::PageHandler::ShowContextMenuForSearchbox";
      case messages::PageHandler::kShowContextMenuForURL:
            return "Receive history_clusters::mojom::PageHandler::ShowContextMenuForURL";
      case messages::PageHandler::kShowSidePanelUI:
            return "Receive history_clusters::mojom::PageHandler::ShowSidePanelUI";
      case messages::PageHandler::kToggleVisibility:
            return "Receive history_clusters::mojom::PageHandler::ToggleVisibility";
      case messages::PageHandler::kStartQueryClusters:
            return "Receive history_clusters::mojom::PageHandler::StartQueryClusters";
      case messages::PageHandler::kLoadMoreClusters:
            return "Receive history_clusters::mojom::PageHandler::LoadMoreClusters";
      case messages::PageHandler::kHideVisits:
            return "Receive history_clusters::mojom::PageHandler::HideVisits";
      case messages::PageHandler::kRemoveVisits:
            return "Receive history_clusters::mojom::PageHandler::RemoveVisits";
      case messages::PageHandler::kRemoveVisitByUrlAndTime:
            return "Receive history_clusters::mojom::PageHandler::RemoveVisitByUrlAndTime";
      case messages::PageHandler::kOpenVisitUrlsInTabGroup:
            return "Receive history_clusters::mojom::PageHandler::OpenVisitUrlsInTabGroup";
      case messages::PageHandler::kRecordVisitAction:
            return "Receive history_clusters::mojom::PageHandler::RecordVisitAction";
      case messages::PageHandler::kRecordRelatedSearchAction:
            return "Receive history_clusters::mojom::PageHandler::RecordRelatedSearchAction";
      case messages::PageHandler::kRecordClusterAction:
            return "Receive history_clusters::mojom::PageHandler::RecordClusterAction";
      case messages::PageHandler::kRecordToggledVisibility:
            return "Receive history_clusters::mojom::PageHandler::RecordToggledVisibility";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kOpenHistoryUrl:
            return "Receive reply history_clusters::mojom::PageHandler::OpenHistoryUrl";
      case messages::PageHandler::kSetPage:
            return "Receive reply history_clusters::mojom::PageHandler::SetPage";
      case messages::PageHandler::kShowContextMenuForSearchbox:
            return "Receive reply history_clusters::mojom::PageHandler::ShowContextMenuForSearchbox";
      case messages::PageHandler::kShowContextMenuForURL:
            return "Receive reply history_clusters::mojom::PageHandler::ShowContextMenuForURL";
      case messages::PageHandler::kShowSidePanelUI:
            return "Receive reply history_clusters::mojom::PageHandler::ShowSidePanelUI";
      case messages::PageHandler::kToggleVisibility:
            return "Receive reply history_clusters::mojom::PageHandler::ToggleVisibility";
      case messages::PageHandler::kStartQueryClusters:
            return "Receive reply history_clusters::mojom::PageHandler::StartQueryClusters";
      case messages::PageHandler::kLoadMoreClusters:
            return "Receive reply history_clusters::mojom::PageHandler::LoadMoreClusters";
      case messages::PageHandler::kHideVisits:
            return "Receive reply history_clusters::mojom::PageHandler::HideVisits";
      case messages::PageHandler::kRemoveVisits:
            return "Receive reply history_clusters::mojom::PageHandler::RemoveVisits";
      case messages::PageHandler::kRemoveVisitByUrlAndTime:
            return "Receive reply history_clusters::mojom::PageHandler::RemoveVisitByUrlAndTime";
      case messages::PageHandler::kOpenVisitUrlsInTabGroup:
            return "Receive reply history_clusters::mojom::PageHandler::OpenVisitUrlsInTabGroup";
      case messages::PageHandler::kRecordVisitAction:
            return "Receive reply history_clusters::mojom::PageHandler::RecordVisitAction";
      case messages::PageHandler::kRecordRelatedSearchAction:
            return "Receive reply history_clusters::mojom::PageHandler::RecordRelatedSearchAction";
      case messages::PageHandler::kRecordClusterAction:
            return "Receive reply history_clusters::mojom::PageHandler::RecordClusterAction";
      case messages::PageHandler::kRecordToggledVisibility:
            return "Receive reply history_clusters::mojom::PageHandler::RecordToggledVisibility";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::OpenHistoryUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf26e59f9;  // IPCStableHash for history_clusters::mojom::PageHandler::OpenHistoryUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdc982801;  // IPCStableHash for history_clusters::mojom::PageHandler::SetPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowContextMenuForSearchbox_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25005dea;  // IPCStableHash for history_clusters::mojom::PageHandler::ShowContextMenuForSearchbox
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowContextMenuForURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1edd0b6;  // IPCStableHash for history_clusters::mojom::PageHandler::ShowContextMenuForURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowSidePanelUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc60ce72e;  // IPCStableHash for history_clusters::mojom::PageHandler::ShowSidePanelUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ToggleVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd6435c5b;  // IPCStableHash for history_clusters::mojom::PageHandler::ToggleVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::StartQueryClusters_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30b6337b;  // IPCStableHash for history_clusters::mojom::PageHandler::StartQueryClusters
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::LoadMoreClusters_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7330f6d4;  // IPCStableHash for history_clusters::mojom::PageHandler::LoadMoreClusters
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::HideVisits_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9e3be93;  // IPCStableHash for history_clusters::mojom::PageHandler::HideVisits
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RemoveVisits_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x739e8fd3;  // IPCStableHash for history_clusters::mojom::PageHandler::RemoveVisits
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RemoveVisitByUrlAndTime_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0fe2ac4a;  // IPCStableHash for history_clusters::mojom::PageHandler::RemoveVisitByUrlAndTime
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenVisitUrlsInTabGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa76fa97;  // IPCStableHash for history_clusters::mojom::PageHandler::OpenVisitUrlsInTabGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordVisitAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4b956fdc;  // IPCStableHash for history_clusters::mojom::PageHandler::RecordVisitAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordRelatedSearchAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb0ac562d;  // IPCStableHash for history_clusters::mojom::PageHandler::RecordRelatedSearchAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordClusterAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x063bea99;  // IPCStableHash for history_clusters::mojom::PageHandler::RecordClusterAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordToggledVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa94d5dc8;  // IPCStableHash for history_clusters::mojom::PageHandler::RecordToggledVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_ToggleVisibility_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_ToggleVisibility_ForwardToCallback(
      PageHandler::ToggleVisibilityCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_ToggleVisibility_ForwardToCallback(const PageHandler_ToggleVisibility_ForwardToCallback&) = delete;
  PageHandler_ToggleVisibility_ForwardToCallback& operator=(const PageHandler_ToggleVisibility_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::ToggleVisibilityCallback callback_;
};

class PageHandler_HideVisits_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_HideVisits_ForwardToCallback(
      PageHandler::HideVisitsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_HideVisits_ForwardToCallback(const PageHandler_HideVisits_ForwardToCallback&) = delete;
  PageHandler_HideVisits_ForwardToCallback& operator=(const PageHandler_HideVisits_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::HideVisitsCallback callback_;
};

class PageHandler_RemoveVisits_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_RemoveVisits_ForwardToCallback(
      PageHandler::RemoveVisitsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_RemoveVisits_ForwardToCallback(const PageHandler_RemoveVisits_ForwardToCallback&) = delete;
  PageHandler_RemoveVisits_ForwardToCallback& operator=(const PageHandler_RemoveVisits_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::RemoveVisitsCallback callback_;
};

class PageHandler_RemoveVisitByUrlAndTime_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_RemoveVisitByUrlAndTime_ForwardToCallback(
      PageHandler::RemoveVisitByUrlAndTimeCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_RemoveVisitByUrlAndTime_ForwardToCallback(const PageHandler_RemoveVisitByUrlAndTime_ForwardToCallback&) = delete;
  PageHandler_RemoveVisitByUrlAndTime_ForwardToCallback& operator=(const PageHandler_RemoveVisitByUrlAndTime_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::RemoveVisitByUrlAndTimeCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::OpenHistoryUrl(
    const ::GURL& in_url, ::ui::mojom::ClickModifiersPtr in_click_modifiers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::OpenHistoryUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("click_modifiers"), in_click_modifiers,
                        "<value of type ::ui::mojom::ClickModifiersPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenHistoryUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_OpenHistoryUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.OpenHistoryUrl request");
  mojo::internal::MessageFragment<
      typename decltype(params->click_modifiers)::BaseType> click_modifiers_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::ClickModifiersDataView>(
    in_click_modifiers,
    click_modifiers_fragment);

  params->click_modifiers.Set(
      click_modifiers_fragment.is_null() ? nullptr : click_modifiers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->click_modifiers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null click_modifiers in PageHandler.OpenHistoryUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenHistoryUrl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetPage(
    ::mojo::PendingRemote<Page> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::SetPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_SetPage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::history_clusters::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandler.SetPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowContextMenuForSearchbox(
    const std::string& in_query, const ::gfx::Point& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::ShowContextMenuForSearchbox", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowContextMenuForSearchbox), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_ShowContextMenuForSearchbox_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in PageHandler.ShowContextMenuForSearchbox request");
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point,
    point_fragment);

  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point in PageHandler.ShowContextMenuForSearchbox request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowContextMenuForSearchbox");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowContextMenuForURL(
    const ::GURL& in_url, const ::gfx::Point& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::ShowContextMenuForURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowContextMenuForURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_ShowContextMenuForURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.ShowContextMenuForURL request");
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point,
    point_fragment);

  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point in PageHandler.ShowContextMenuForURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowContextMenuForURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowSidePanelUI(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history_clusters::mojom::PageHandler::ShowSidePanelUI");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowSidePanelUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_ShowSidePanelUI_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowSidePanelUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ToggleVisibility(
    bool in_visible, ToggleVisibilityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::ToggleVisibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kToggleVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_ToggleVisibility_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ToggleVisibility");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_ToggleVisibility_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::StartQueryClusters(
    const std::string& in_query, std::optional<::base::Time> in_begin_time, bool in_recluster) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::StartQueryClusters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("begin_time"), in_begin_time,
                        "<value of type std::optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recluster"), in_recluster,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kStartQueryClusters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_StartQueryClusters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in PageHandler.StartQueryClusters request");
  mojo::internal::MessageFragment<
      typename decltype(params->begin_time)::BaseType> begin_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_begin_time,
    begin_time_fragment);

  params->begin_time.Set(
      begin_time_fragment.is_null() ? nullptr : begin_time_fragment.data());

  params->recluster = in_recluster;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("StartQueryClusters");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::LoadMoreClusters(
    const std::string& in_query) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::LoadMoreClusters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLoadMoreClusters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_LoadMoreClusters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in PageHandler.LoadMoreClusters request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LoadMoreClusters");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::HideVisits(
    std::vector<::history_clusters::mojom::URLVisitPtr> in_visits, HideVisitsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::HideVisits", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visits"), in_visits,
                        "<value of type std::vector<::history_clusters::mojom::URLVisitPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kHideVisits), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_HideVisits_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->visits)::BaseType>
      visits_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::URLVisitDataView>>(
    in_visits,
    visits_fragment,
    &visits_validate_params);

  params->visits.Set(
      visits_fragment.is_null() ? nullptr : visits_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->visits.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null visits in PageHandler.HideVisits request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("HideVisits");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_HideVisits_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::RemoveVisits(
    std::vector<::history_clusters::mojom::URLVisitPtr> in_visits, RemoveVisitsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::RemoveVisits", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visits"), in_visits,
                        "<value of type std::vector<::history_clusters::mojom::URLVisitPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveVisits), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_RemoveVisits_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->visits)::BaseType>
      visits_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::URLVisitDataView>>(
    in_visits,
    visits_fragment,
    &visits_validate_params);

  params->visits.Set(
      visits_fragment.is_null() ? nullptr : visits_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->visits.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null visits in PageHandler.RemoveVisits request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveVisits");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_RemoveVisits_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::RemoveVisitByUrlAndTime(
    const ::GURL& in_url, double in_timestamp, RemoveVisitByUrlAndTimeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::RemoveVisitByUrlAndTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timestamp"), in_timestamp,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveVisitByUrlAndTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_RemoveVisitByUrlAndTime_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.RemoveVisitByUrlAndTime request");

  params->timestamp = in_timestamp;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveVisitByUrlAndTime");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_RemoveVisitByUrlAndTime_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::OpenVisitUrlsInTabGroup(
    std::vector<::history_clusters::mojom::URLVisitPtr> in_visits, const std::optional<std::string>& in_tab_group_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::OpenVisitUrlsInTabGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visits"), in_visits,
                        "<value of type std::vector<::history_clusters::mojom::URLVisitPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_group_name"), in_tab_group_name,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenVisitUrlsInTabGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_OpenVisitUrlsInTabGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->visits)::BaseType>
      visits_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::URLVisitDataView>>(
    in_visits,
    visits_fragment,
    &visits_validate_params);

  params->visits.Set(
      visits_fragment.is_null() ? nullptr : visits_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->visits.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null visits in PageHandler.OpenVisitUrlsInTabGroup request");
  mojo::internal::MessageFragment<
      typename decltype(params->tab_group_name)::BaseType> tab_group_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_tab_group_name,
    tab_group_name_fragment);

  params->tab_group_name.Set(
      tab_group_name_fragment.is_null() ? nullptr : tab_group_name_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenVisitUrlsInTabGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordVisitAction(
    VisitAction in_visit_action, uint32_t in_visit_index, VisitType in_visit_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::RecordVisitAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visit_action"), in_visit_action,
                        "<value of type VisitAction>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visit_index"), in_visit_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visit_type"), in_visit_type,
                        "<value of type VisitType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordVisitAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_RecordVisitAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::history_clusters::mojom::VisitAction>(
    in_visit_action,
    &params->visit_action);

  params->visit_index = in_visit_index;

  
  mojo::internal::Serialize<::history_clusters::mojom::VisitType>(
    in_visit_type,
    &params->visit_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordVisitAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordRelatedSearchAction(
    RelatedSearchAction in_action, uint32_t in_visit_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::RecordRelatedSearchAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type RelatedSearchAction>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visit_index"), in_visit_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordRelatedSearchAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_RecordRelatedSearchAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::history_clusters::mojom::RelatedSearchAction>(
    in_action,
    &params->action);

  params->visit_index = in_visit_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordRelatedSearchAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordClusterAction(
    ClusterAction in_cluster_action, uint32_t in_cluster_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::RecordClusterAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cluster_action"), in_cluster_action,
                        "<value of type ClusterAction>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cluster_index"), in_cluster_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordClusterAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_RecordClusterAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::history_clusters::mojom::ClusterAction>(
    in_cluster_action,
    &params->cluster_action);

  params->cluster_index = in_cluster_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordClusterAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordToggledVisibility(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::PageHandler::RecordToggledVisibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordToggledVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_RecordToggledVisibility_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordToggledVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_ToggleVisibility_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::ToggleVisibilityCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_ToggleVisibility_ProxyToResponder> proxy(
        new PageHandler_ToggleVisibility_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_ToggleVisibility_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_ToggleVisibility_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_ToggleVisibility_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::ToggleVisibilityCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_visible);
};

bool PageHandler_ToggleVisibility_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_ToggleVisibility_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_ToggleVisibility_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.5
  bool success = true;
  bool p_visible{};
  PageHandler_ToggleVisibility_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_visible = input_data_view.visible();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_visible));
  }
  return true;
}

void PageHandler_ToggleVisibility_ProxyToResponder::Run(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply history_clusters::mojom::PageHandler::ToggleVisibility", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kToggleVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_ToggleVisibility_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ToggleVisibility");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_HideVisits_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::HideVisitsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_HideVisits_ProxyToResponder> proxy(
        new PageHandler_HideVisits_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_HideVisits_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_HideVisits_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_HideVisits_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::HideVisitsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_HideVisits_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_HideVisits_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_HideVisits_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.8
  bool success = true;
  bool p_success{};
  PageHandler_HideVisits_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_HideVisits_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply history_clusters::mojom::PageHandler::HideVisits", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kHideVisits), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_HideVisits_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("HideVisits");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_RemoveVisits_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::RemoveVisitsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_RemoveVisits_ProxyToResponder> proxy(
        new PageHandler_RemoveVisits_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_RemoveVisits_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_RemoveVisits_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_RemoveVisits_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::RemoveVisitsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_RemoveVisits_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_RemoveVisits_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_RemoveVisits_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.9
  bool success = true;
  bool p_success{};
  PageHandler_RemoveVisits_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_RemoveVisits_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply history_clusters::mojom::PageHandler::RemoveVisits", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveVisits), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_RemoveVisits_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveVisits");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_RemoveVisitByUrlAndTime_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::RemoveVisitByUrlAndTimeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_RemoveVisitByUrlAndTime_ProxyToResponder> proxy(
        new PageHandler_RemoveVisitByUrlAndTime_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_RemoveVisitByUrlAndTime_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_RemoveVisitByUrlAndTime_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_RemoveVisitByUrlAndTime_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::RemoveVisitByUrlAndTimeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_RemoveVisitByUrlAndTime_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_RemoveVisitByUrlAndTime_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_RemoveVisitByUrlAndTime_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.10
  bool success = true;
  bool p_success{};
  PageHandler_RemoveVisitByUrlAndTime_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_RemoveVisitByUrlAndTime_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply history_clusters::mojom::PageHandler::RemoveVisitByUrlAndTime", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveVisitByUrlAndTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::PageHandler_RemoveVisitByUrlAndTime_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveVisitByUrlAndTime");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kOpenHistoryUrl: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenHistoryUrl_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenHistoryUrl_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      ::GURL p_url{};
      ::ui::mojom::ClickModifiersPtr p_click_modifiers{};
      PageHandler_OpenHistoryUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadClickModifiers(&p_click_modifiers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenHistoryUrl(        
        std::move(p_url), 
        std::move(p_click_modifiers));
      return true;
    }
    case messages::PageHandler::kSetPage: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetPage_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      PageHandler_SetPage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPage(        
        std::move(p_page));
      return true;
    }
    case messages::PageHandler::kShowContextMenuForSearchbox: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowContextMenuForSearchbox_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowContextMenuForSearchbox_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      std::string p_query{};
      ::gfx::Point p_point{};
      PageHandler_ShowContextMenuForSearchbox_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenuForSearchbox(        
        std::move(p_query), 
        std::move(p_point));
      return true;
    }
    case messages::PageHandler::kShowContextMenuForURL: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowContextMenuForURL_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowContextMenuForURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      ::GURL p_url{};
      ::gfx::Point p_point{};
      PageHandler_ShowContextMenuForURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenuForURL(        
        std::move(p_url), 
        std::move(p_point));
      return true;
    }
    case messages::PageHandler::kShowSidePanelUI: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowSidePanelUI_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowSidePanelUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      PageHandler_ShowSidePanelUI_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSidePanelUI(        );
      return true;
    }
    case messages::PageHandler::kToggleVisibility: {
      break;
    }
    case messages::PageHandler::kStartQueryClusters: {
      DCHECK(message->is_serialized());
      internal::PageHandler_StartQueryClusters_Params_Data* params =
          reinterpret_cast<internal::PageHandler_StartQueryClusters_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      std::string p_query{};
      std::optional<::base::Time> p_begin_time{};
      bool p_recluster{};
      PageHandler_StartQueryClusters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (success && !input_data_view.ReadBeginTime(&p_begin_time))
        success = false;
      if (success)
        p_recluster = input_data_view.recluster();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartQueryClusters(        
        std::move(p_query), 
        std::move(p_begin_time), 
        std::move(p_recluster));
      return true;
    }
    case messages::PageHandler::kLoadMoreClusters: {
      DCHECK(message->is_serialized());
      internal::PageHandler_LoadMoreClusters_Params_Data* params =
          reinterpret_cast<internal::PageHandler_LoadMoreClusters_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      std::string p_query{};
      PageHandler_LoadMoreClusters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadMoreClusters(        
        std::move(p_query));
      return true;
    }
    case messages::PageHandler::kHideVisits: {
      break;
    }
    case messages::PageHandler::kRemoveVisits: {
      break;
    }
    case messages::PageHandler::kRemoveVisitByUrlAndTime: {
      break;
    }
    case messages::PageHandler::kOpenVisitUrlsInTabGroup: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenVisitUrlsInTabGroup_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenVisitUrlsInTabGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      std::vector<::history_clusters::mojom::URLVisitPtr> p_visits{};
      std::optional<std::string> p_tab_group_name{};
      PageHandler_OpenVisitUrlsInTabGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisits(&p_visits))
        success = false;
      if (success && !input_data_view.ReadTabGroupName(&p_tab_group_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenVisitUrlsInTabGroup(        
        std::move(p_visits), 
        std::move(p_tab_group_name));
      return true;
    }
    case messages::PageHandler::kRecordVisitAction: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordVisitAction_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordVisitAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      VisitAction p_visit_action{};
      uint32_t p_visit_index{};
      VisitType p_visit_type{};
      PageHandler_RecordVisitAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisitAction(&p_visit_action))
        success = false;
      if (success)
        p_visit_index = input_data_view.visit_index();
      if (success && !input_data_view.ReadVisitType(&p_visit_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordVisitAction(        
        std::move(p_visit_action), 
        std::move(p_visit_index), 
        std::move(p_visit_type));
      return true;
    }
    case messages::PageHandler::kRecordRelatedSearchAction: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordRelatedSearchAction_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordRelatedSearchAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      RelatedSearchAction p_action{};
      uint32_t p_visit_index{};
      PageHandler_RecordRelatedSearchAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (success)
        p_visit_index = input_data_view.visit_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordRelatedSearchAction(        
        std::move(p_action), 
        std::move(p_visit_index));
      return true;
    }
    case messages::PageHandler::kRecordClusterAction: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordClusterAction_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordClusterAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      ClusterAction p_cluster_action{};
      uint32_t p_cluster_index{};
      PageHandler_RecordClusterAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClusterAction(&p_cluster_action))
        success = false;
      if (success)
        p_cluster_index = input_data_view.cluster_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordClusterAction(        
        std::move(p_cluster_action), 
        std::move(p_cluster_index));
      return true;
    }
    case messages::PageHandler::kRecordToggledVisibility: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordToggledVisibility_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordToggledVisibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      bool p_visible{};
      PageHandler_RecordToggledVisibility_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordToggledVisibility(        
        std::move(p_visible));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kOpenHistoryUrl: {
      break;
    }
    case messages::PageHandler::kSetPage: {
      break;
    }
    case messages::PageHandler::kShowContextMenuForSearchbox: {
      break;
    }
    case messages::PageHandler::kShowContextMenuForURL: {
      break;
    }
    case messages::PageHandler::kShowSidePanelUI: {
      break;
    }
    case messages::PageHandler::kToggleVisibility: {
      internal::PageHandler_ToggleVisibility_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_ToggleVisibility_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      bool p_visible{};
      PageHandler_ToggleVisibility_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          PageHandler_ToggleVisibility_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleVisibility(        
        std::move(p_visible), std::move(callback));
      return true;
    }
    case messages::PageHandler::kStartQueryClusters: {
      break;
    }
    case messages::PageHandler::kLoadMoreClusters: {
      break;
    }
    case messages::PageHandler::kHideVisits: {
      internal::PageHandler_HideVisits_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_HideVisits_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      std::vector<::history_clusters::mojom::URLVisitPtr> p_visits{};
      PageHandler_HideVisits_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisits(&p_visits))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          PageHandler_HideVisits_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HideVisits(        
        std::move(p_visits), std::move(callback));
      return true;
    }
    case messages::PageHandler::kRemoveVisits: {
      internal::PageHandler_RemoveVisits_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_RemoveVisits_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      std::vector<::history_clusters::mojom::URLVisitPtr> p_visits{};
      PageHandler_RemoveVisits_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisits(&p_visits))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      auto callback =
          PageHandler_RemoveVisits_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveVisits(        
        std::move(p_visits), std::move(callback));
      return true;
    }
    case messages::PageHandler::kRemoveVisitByUrlAndTime: {
      internal::PageHandler_RemoveVisitByUrlAndTime_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_RemoveVisitByUrlAndTime_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      ::GURL p_url{};
      double p_timestamp{};
      PageHandler_RemoveVisitByUrlAndTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_timestamp = input_data_view.timestamp();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      auto callback =
          PageHandler_RemoveVisitByUrlAndTime_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveVisitByUrlAndTime(        
        std::move(p_url), 
        std::move(p_timestamp), std::move(callback));
      return true;
    }
    case messages::PageHandler::kOpenVisitUrlsInTabGroup: {
      break;
    }
    case messages::PageHandler::kRecordVisitAction: {
      break;
    }
    case messages::PageHandler::kRecordRelatedSearchAction: {
      break;
    }
    case messages::PageHandler::kRecordClusterAction: {
      break;
    }
    case messages::PageHandler::kRecordToggledVisibility: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_OpenHistoryUrl_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowContextMenuForSearchbox_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowContextMenuForURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowSidePanelUI_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ToggleVisibility_Params_Data::Validate,
     &internal::PageHandler_ToggleVisibility_ResponseParams_Data::Validate},
    { &internal::PageHandler_StartQueryClusters_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_LoadMoreClusters_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_HideVisits_Params_Data::Validate,
     &internal::PageHandler_HideVisits_ResponseParams_Data::Validate},
    { &internal::PageHandler_RemoveVisits_Params_Data::Validate,
     &internal::PageHandler_RemoveVisits_ResponseParams_Data::Validate},
    { &internal::PageHandler_RemoveVisitByUrlAndTime_Params_Data::Validate,
     &internal::PageHandler_RemoveVisitByUrlAndTime_ResponseParams_Data::Validate},
    { &internal::PageHandler_OpenVisitUrlsInTabGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordVisitAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordRelatedSearchAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordClusterAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordToggledVisibility_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::history_clusters::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::history_clusters::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnClustersQueryResult: {
      return &Page::OnClustersQueryResult_Sym::IPCStableHash;
    }
    case messages::Page::kOnClusterImageUpdated: {
      return &Page::OnClusterImageUpdated_Sym::IPCStableHash;
    }
    case messages::Page::kOnVisitsHidden: {
      return &Page::OnVisitsHidden_Sym::IPCStableHash;
    }
    case messages::Page::kOnVisitsRemoved: {
      return &Page::OnVisitsRemoved_Sym::IPCStableHash;
    }
    case messages::Page::kOnHistoryDeleted: {
      return &Page::OnHistoryDeleted_Sym::IPCStableHash;
    }
    case messages::Page::kOnQueryChangedByUser: {
      return &Page::OnQueryChangedByUser_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnClustersQueryResult:
            return "Receive history_clusters::mojom::Page::OnClustersQueryResult";
      case messages::Page::kOnClusterImageUpdated:
            return "Receive history_clusters::mojom::Page::OnClusterImageUpdated";
      case messages::Page::kOnVisitsHidden:
            return "Receive history_clusters::mojom::Page::OnVisitsHidden";
      case messages::Page::kOnVisitsRemoved:
            return "Receive history_clusters::mojom::Page::OnVisitsRemoved";
      case messages::Page::kOnHistoryDeleted:
            return "Receive history_clusters::mojom::Page::OnHistoryDeleted";
      case messages::Page::kOnQueryChangedByUser:
            return "Receive history_clusters::mojom::Page::OnQueryChangedByUser";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnClustersQueryResult:
            return "Receive reply history_clusters::mojom::Page::OnClustersQueryResult";
      case messages::Page::kOnClusterImageUpdated:
            return "Receive reply history_clusters::mojom::Page::OnClusterImageUpdated";
      case messages::Page::kOnVisitsHidden:
            return "Receive reply history_clusters::mojom::Page::OnVisitsHidden";
      case messages::Page::kOnVisitsRemoved:
            return "Receive reply history_clusters::mojom::Page::OnVisitsRemoved";
      case messages::Page::kOnHistoryDeleted:
            return "Receive reply history_clusters::mojom::Page::OnHistoryDeleted";
      case messages::Page::kOnQueryChangedByUser:
            return "Receive reply history_clusters::mojom::Page::OnQueryChangedByUser";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnClustersQueryResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5edfd9d4;  // IPCStableHash for history_clusters::mojom::Page::OnClustersQueryResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnClusterImageUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4bd1fbc2;  // IPCStableHash for history_clusters::mojom::Page::OnClusterImageUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnVisitsHidden_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6aa74adf;  // IPCStableHash for history_clusters::mojom::Page::OnVisitsHidden
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnVisitsRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc156ed8b;  // IPCStableHash for history_clusters::mojom::Page::OnVisitsRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnHistoryDeleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2facf1e5;  // IPCStableHash for history_clusters::mojom::Page::OnHistoryDeleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnQueryChangedByUser_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x50aaba61;  // IPCStableHash for history_clusters::mojom::Page::OnQueryChangedByUser
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnClustersQueryResult(
    QueryResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::Page::OnClustersQueryResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type QueryResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnClustersQueryResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::Page_OnClustersQueryResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::history_clusters::mojom::QueryResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in Page.OnClustersQueryResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnClustersQueryResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnClusterImageUpdated(
    int32_t in_cluster_index, const ::GURL& in_image_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::Page::OnClusterImageUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cluster_index"), in_cluster_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_url"), in_image_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnClusterImageUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::Page_OnClusterImageUpdated_Params_Data> params(
          message);
  params.Allocate();

  params->cluster_index = in_cluster_index;
  mojo::internal::MessageFragment<
      typename decltype(params->image_url)::BaseType> image_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_image_url,
    image_url_fragment);

  params->image_url.Set(
      image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image_url in Page.OnClusterImageUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnClusterImageUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnVisitsHidden(
    std::vector<::history_clusters::mojom::URLVisitPtr> in_hidden_visits) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::Page::OnVisitsHidden", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hidden_visits"), in_hidden_visits,
                        "<value of type std::vector<::history_clusters::mojom::URLVisitPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnVisitsHidden), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::Page_OnVisitsHidden_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hidden_visits)::BaseType>
      hidden_visits_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& hidden_visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::URLVisitDataView>>(
    in_hidden_visits,
    hidden_visits_fragment,
    &hidden_visits_validate_params);

  params->hidden_visits.Set(
      hidden_visits_fragment.is_null() ? nullptr : hidden_visits_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hidden_visits.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hidden_visits in Page.OnVisitsHidden request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnVisitsHidden");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnVisitsRemoved(
    std::vector<::history_clusters::mojom::URLVisitPtr> in_removed_visits) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::Page::OnVisitsRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("removed_visits"), in_removed_visits,
                        "<value of type std::vector<::history_clusters::mojom::URLVisitPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnVisitsRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::Page_OnVisitsRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->removed_visits)::BaseType>
      removed_visits_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& removed_visits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::URLVisitDataView>>(
    in_removed_visits,
    removed_visits_fragment,
    &removed_visits_validate_params);

  params->removed_visits.Set(
      removed_visits_fragment.is_null() ? nullptr : removed_visits_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->removed_visits.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null removed_visits in Page.OnVisitsRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnVisitsRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnHistoryDeleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history_clusters::mojom::Page::OnHistoryDeleted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnHistoryDeleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::Page_OnHistoryDeleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnHistoryDeleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnQueryChangedByUser(
    const std::string& in_query) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history_clusters::mojom::Page::OnQueryChangedByUser", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnQueryChangedByUser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history_clusters::mojom::internal::Page_OnQueryChangedByUser_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in Page.OnQueryChangedByUser request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnQueryChangedByUser");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnClustersQueryResult: {
      DCHECK(message->is_serialized());
      internal::Page_OnClustersQueryResult_Params_Data* params =
          reinterpret_cast<internal::Page_OnClustersQueryResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      QueryResultPtr p_result{};
      Page_OnClustersQueryResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClustersQueryResult(        
        std::move(p_result));
      return true;
    }
    case messages::Page::kOnClusterImageUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_OnClusterImageUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_OnClusterImageUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      int32_t p_cluster_index{};
      ::GURL p_image_url{};
      Page_OnClusterImageUpdated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cluster_index = input_data_view.cluster_index();
      if (success && !input_data_view.ReadImageUrl(&p_image_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClusterImageUpdated(        
        std::move(p_cluster_index), 
        std::move(p_image_url));
      return true;
    }
    case messages::Page::kOnVisitsHidden: {
      DCHECK(message->is_serialized());
      internal::Page_OnVisitsHidden_Params_Data* params =
          reinterpret_cast<internal::Page_OnVisitsHidden_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      std::vector<::history_clusters::mojom::URLVisitPtr> p_hidden_visits{};
      Page_OnVisitsHidden_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHiddenVisits(&p_hidden_visits))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVisitsHidden(        
        std::move(p_hidden_visits));
      return true;
    }
    case messages::Page::kOnVisitsRemoved: {
      DCHECK(message->is_serialized());
      internal::Page_OnVisitsRemoved_Params_Data* params =
          reinterpret_cast<internal::Page_OnVisitsRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      std::vector<::history_clusters::mojom::URLVisitPtr> p_removed_visits{};
      Page_OnVisitsRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRemovedVisits(&p_removed_visits))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVisitsRemoved(        
        std::move(p_removed_visits));
      return true;
    }
    case messages::Page::kOnHistoryDeleted: {
      DCHECK(message->is_serialized());
      internal::Page_OnHistoryDeleted_Params_Data* params =
          reinterpret_cast<internal::Page_OnHistoryDeleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.4
      bool success = true;
      Page_OnHistoryDeleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHistoryDeleted(        );
      return true;
    }
    case messages::Page::kOnQueryChangedByUser: {
      DCHECK(message->is_serialized());
      internal::Page_OnQueryChangedByUser_Params_Data* params =
          reinterpret_cast<internal::Page_OnQueryChangedByUser_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.5
      bool success = true;
      std::string p_query{};
      Page_OnQueryChangedByUser_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnQueryChangedByUser(        
        std::move(p_query));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnClustersQueryResult: {
      break;
    }
    case messages::Page::kOnClusterImageUpdated: {
      break;
    }
    case messages::Page::kOnVisitsHidden: {
      break;
    }
    case messages::Page::kOnVisitsRemoved: {
      break;
    }
    case messages::Page::kOnHistoryDeleted: {
      break;
    }
    case messages::Page::kOnQueryChangedByUser: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnClustersQueryResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnClusterImageUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnVisitsHidden_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnVisitsRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnHistoryDeleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnQueryChangedByUser_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::history_clusters::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // history_clusters::mojom


namespace mojo {


// static
bool StructTraits<::history_clusters::mojom::QueryResult::DataView, ::history_clusters::mojom::QueryResultPtr>::Read(
    ::history_clusters::mojom::QueryResult::DataView input,
    ::history_clusters::mojom::QueryResultPtr* output) {
  bool success = true;
  ::history_clusters::mojom::QueryResultPtr result(::history_clusters::mojom::QueryResult::New());
  
      if (success && !input.ReadQuery(&result->query))
        success = false;
      if (success && !input.ReadClusters(&result->clusters))
        success = false;
      if (success)
        result->can_load_more = input.can_load_more();
      if (success)
        result->is_continuation = input.is_continuation();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace history_clusters::mojom {


void PageHandlerInterceptorForTesting::OpenHistoryUrl(const ::GURL& url, ::ui::mojom::ClickModifiersPtr click_modifiers) {
  GetForwardingInterface()->OpenHistoryUrl(
    std::move(url)
    , 
    std::move(click_modifiers)
    );
}
void PageHandlerInterceptorForTesting::SetPage(::mojo::PendingRemote<Page> page) {
  GetForwardingInterface()->SetPage(
    std::move(page)
    );
}
void PageHandlerInterceptorForTesting::ShowContextMenuForSearchbox(const std::string& query, const ::gfx::Point& point) {
  GetForwardingInterface()->ShowContextMenuForSearchbox(
    std::move(query)
    , 
    std::move(point)
    );
}
void PageHandlerInterceptorForTesting::ShowContextMenuForURL(const ::GURL& url, const ::gfx::Point& point) {
  GetForwardingInterface()->ShowContextMenuForURL(
    std::move(url)
    , 
    std::move(point)
    );
}
void PageHandlerInterceptorForTesting::ShowSidePanelUI() {
  GetForwardingInterface()->ShowSidePanelUI();
}
void PageHandlerInterceptorForTesting::ToggleVisibility(bool visible, ToggleVisibilityCallback callback) {
  GetForwardingInterface()->ToggleVisibility(
    std::move(visible)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::StartQueryClusters(const std::string& query, std::optional<::base::Time> begin_time, bool recluster) {
  GetForwardingInterface()->StartQueryClusters(
    std::move(query)
    , 
    std::move(begin_time)
    , 
    std::move(recluster)
    );
}
void PageHandlerInterceptorForTesting::LoadMoreClusters(const std::string& query) {
  GetForwardingInterface()->LoadMoreClusters(
    std::move(query)
    );
}
void PageHandlerInterceptorForTesting::HideVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits, HideVisitsCallback callback) {
  GetForwardingInterface()->HideVisits(
    std::move(visits)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::RemoveVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits, RemoveVisitsCallback callback) {
  GetForwardingInterface()->RemoveVisits(
    std::move(visits)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::RemoveVisitByUrlAndTime(const ::GURL& url, double timestamp, RemoveVisitByUrlAndTimeCallback callback) {
  GetForwardingInterface()->RemoveVisitByUrlAndTime(
    std::move(url)
    , 
    std::move(timestamp)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::OpenVisitUrlsInTabGroup(std::vector<::history_clusters::mojom::URLVisitPtr> visits, const std::optional<std::string>& tab_group_name) {
  GetForwardingInterface()->OpenVisitUrlsInTabGroup(
    std::move(visits)
    , 
    std::move(tab_group_name)
    );
}
void PageHandlerInterceptorForTesting::RecordVisitAction(VisitAction visit_action, uint32_t visit_index, VisitType visit_type) {
  GetForwardingInterface()->RecordVisitAction(
    std::move(visit_action)
    , 
    std::move(visit_index)
    , 
    std::move(visit_type)
    );
}
void PageHandlerInterceptorForTesting::RecordRelatedSearchAction(RelatedSearchAction action, uint32_t visit_index) {
  GetForwardingInterface()->RecordRelatedSearchAction(
    std::move(action)
    , 
    std::move(visit_index)
    );
}
void PageHandlerInterceptorForTesting::RecordClusterAction(ClusterAction cluster_action, uint32_t cluster_index) {
  GetForwardingInterface()->RecordClusterAction(
    std::move(cluster_action)
    , 
    std::move(cluster_index)
    );
}
void PageHandlerInterceptorForTesting::RecordToggledVisibility(bool visible) {
  GetForwardingInterface()->RecordToggledVisibility(
    std::move(visible)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::ToggleVisibility(
    bool visible, bool* out_visible) {
  base::RunLoop loop;
  proxy_->ToggleVisibility(
      std::move(visible),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_visible
,
             bool visible) {*out_visible = std::move(visible);
            loop->Quit();
          },
          &loop,
          out_visible));
  loop.Run();
}

bool PageHandlerAsyncWaiter::ToggleVisibility(
    bool visible) {
  bool async_wait_result;
  ToggleVisibility(std::move(visible),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::HideVisits(
    std::vector<::history_clusters::mojom::URLVisitPtr> visits, bool* out_success) {
  base::RunLoop loop;
  proxy_->HideVisits(
      std::move(visits),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::HideVisits(
    std::vector<::history_clusters::mojom::URLVisitPtr> visits) {
  bool async_wait_result;
  HideVisits(std::move(visits),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::RemoveVisits(
    std::vector<::history_clusters::mojom::URLVisitPtr> visits, bool* out_success) {
  base::RunLoop loop;
  proxy_->RemoveVisits(
      std::move(visits),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::RemoveVisits(
    std::vector<::history_clusters::mojom::URLVisitPtr> visits) {
  bool async_wait_result;
  RemoveVisits(std::move(visits),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::RemoveVisitByUrlAndTime(
    const ::GURL& url, double timestamp, bool* out_success) {
  base::RunLoop loop;
  proxy_->RemoveVisitByUrlAndTime(
      std::move(url),
      std::move(timestamp),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::RemoveVisitByUrlAndTime(
    const ::GURL& url, double timestamp) {
  bool async_wait_result;
  RemoveVisitByUrlAndTime(std::move(url),std::move(timestamp),&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::OnClustersQueryResult(QueryResultPtr result) {
  GetForwardingInterface()->OnClustersQueryResult(
    std::move(result)
    );
}
void PageInterceptorForTesting::OnClusterImageUpdated(int32_t cluster_index, const ::GURL& image_url) {
  GetForwardingInterface()->OnClusterImageUpdated(
    std::move(cluster_index)
    , 
    std::move(image_url)
    );
}
void PageInterceptorForTesting::OnVisitsHidden(std::vector<::history_clusters::mojom::URLVisitPtr> hidden_visits) {
  GetForwardingInterface()->OnVisitsHidden(
    std::move(hidden_visits)
    );
}
void PageInterceptorForTesting::OnVisitsRemoved(std::vector<::history_clusters::mojom::URLVisitPtr> removed_visits) {
  GetForwardingInterface()->OnVisitsRemoved(
    std::move(removed_visits)
    );
}
void PageInterceptorForTesting::OnHistoryDeleted() {
  GetForwardingInterface()->OnHistoryDeleted();
}
void PageInterceptorForTesting::OnQueryChangedByUser(const std::string& query) {
  GetForwardingInterface()->OnQueryChangedByUser(
    std::move(query)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // history_clusters::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif