// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/icons.html.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{FileUploadStatus}from"./composebox_query.mojom-webui.js";import{getCss}from"./file_thumbnail.css.js";import{getHtml}from"./file_thumbnail.html.js";export class ComposeboxFileThumbnailElement extends CrLitElement{static get is(){return"cr-composebox-file-thumbnail"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{file:{type:Object}}}#file_accessor_storage={name:"",type:"",objectUrl:null,dataUrl:null,uuid:"",status:FileUploadStatus.kNotUploaded,url:null,tabId:null,isDeletable:true};get file(){return this.#file_accessor_storage}set file(value){this.#file_accessor_storage=value}deleteFile_(){this.fire("delete-file",{uuid:this.file.uuid})}get deleteFileButtonTitle_(){return loadTimeData.getStringF("composeboxDeleteFileTitle",this.file.name)}get formattedUrl_(){if(!this.file?.url){return null}const link=new URL(this.file.url.url);return(link.host+link.pathname).replace(/\/$/,"")}}customElements.define(ComposeboxFileThumbnailElement.is,ComposeboxFileThumbnailElement);