// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import{I18nMixinLit}from"//resources/cr_elements/i18n_mixin_lit.js";import{assert}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./composebox_voice_search.css.js";import{getHtml}from"./composebox_voice_search.html.js";import{WindowProxy}from"./window_proxy.js";const RECOGNITION_CONFIDENCE_THRESHOLD=.5;const IDLE_TIMEOUT_MS=8e3;var State;(function(State){State[State["UNINITIALIZED"]=-1]="UNINITIALIZED";State[State["STARTED"]=0]="STARTED";State[State["AUDIO_RECEIVED"]=1]="AUDIO_RECEIVED";State[State["SPEECH_RECEIVED"]=2]="SPEECH_RECEIVED";State[State["RESULT_RECEIVED"]=3]="RESULT_RECEIVED";State[State["ERROR_RECEIVED"]=4]="ERROR_RECEIVED";State[State["RESULT_FINAL"]=5]="RESULT_FINAL"})(State||(State={}));var Error;(function(Error){Error[Error["NOT_ALLOWED"]=0]="NOT_ALLOWED"})(Error||(Error={}));const ComposeboxVoiceSearchElementBase=I18nMixinLit(CrLitElement);export class ComposeboxVoiceSearchElement extends ComposeboxVoiceSearchElementBase{static get is(){return"cr-composebox-voice-search"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{transcript_:{type:String},listeningPlaceholder_:{type:String},state_:{type:Number},finalResult_:{type:String},interimResult_:{type:String},errorMessage_:{type:String},error_:{type:Number}}}#state__accessor_storage=State.UNINITIALIZED;get state_(){return this.#state__accessor_storage}set state_(value){this.#state__accessor_storage=value}#transcript__accessor_storage="";get transcript_(){return this.#transcript__accessor_storage}set transcript_(value){this.#transcript__accessor_storage=value}#listeningPlaceholder__accessor_storage=loadTimeData.getString("listening");get listeningPlaceholder_(){return this.#listeningPlaceholder__accessor_storage}set listeningPlaceholder_(value){this.#listeningPlaceholder__accessor_storage=value}voiceRecognition_;#finalResult__accessor_storage="";get finalResult_(){return this.#finalResult__accessor_storage}set finalResult_(value){this.#finalResult__accessor_storage=value}#interimResult__accessor_storage="";get interimResult_(){return this.#interimResult__accessor_storage}set interimResult_(value){this.#interimResult__accessor_storage=value}timerId_=null;#error__accessor_storage=null;get error_(){return this.#error__accessor_storage}set error_(value){this.#error__accessor_storage=value}#errorMessage__accessor_storage="";get errorMessage_(){return this.#errorMessage__accessor_storage}set errorMessage_(value){this.#errorMessage__accessor_storage=value}detailsUrl_=`https://support.google.com/chrome/?p=ui_voice_search&hl=${window.navigator.language}`;get showErrorScrim_(){return!!this.errorMessage_}constructor(){super();this.voiceRecognition_=new window.webkitSpeechRecognition;this.voiceRecognition_.continuous=false;this.voiceRecognition_.interimResults=true;this.voiceRecognition_.lang=window.navigator.language;this.voiceRecognition_.onresult=this.onResult_.bind(this);this.voiceRecognition_.onend=this.onEnd_.bind(this);this.voiceRecognition_.onaudiostart=this.onAudioStart_.bind(this);this.voiceRecognition_.onspeechstart=this.onSpeechStart_.bind(this);this.voiceRecognition_.onerror=e=>{this.onError_(e.error)}}disconnectedCallback(){super.disconnectedCallback();this.voiceRecognition_.abort()}start(){this.errorMessage_="";this.voiceRecognition_.start();this.state_=State.STARTED;this.resetIdleTimer_()}stop(){this.voiceRecognition_.stop()}resetIdleTimer_(){WindowProxy.getInstance().clearTimeout(this.timerId_);this.timerId_=WindowProxy.getInstance().setTimeout(this.onIdleTimeout_.bind(this),IDLE_TIMEOUT_MS)}onIdleTimeout_(){if(this.state_===State.RESULT_FINAL){return}if(this.finalResult_){this.onFinalResult_();return}this.voiceRecognition_.abort()}onAudioStart_(){this.resetIdleTimer_();this.state_=State.AUDIO_RECEIVED}onSpeechStart_(){this.resetIdleTimer_();this.state_=State.SPEECH_RECEIVED}onResult_(e){this.resetIdleTimer_();const results=e.results;if(results.length===0){return}this.state_=State.RESULT_RECEIVED;this.interimResult_="";this.finalResult_="";const speechResult=results[e.resultIndex];assert(speechResult);if(!!speechResult&&speechResult.isFinal){this.finalResult_=speechResult[0].transcript;this.fire("on-transcription-update",this.finalResult_);this.onFinalResult_();return}for(let j=0;j<results.length;j++){const resultList=results[j];const result=resultList[0];assert(result);if(result.confidence>RECOGNITION_CONFIDENCE_THRESHOLD){this.finalResult_+=result.transcript}else{this.interimResult_+=result.transcript}}}onEnd_(){switch(this.state_){case State.STARTED:case State.AUDIO_RECEIVED:case State.SPEECH_RECEIVED:case State.RESULT_RECEIVED:this.fire("on-voice-search-cancel");return;case State.ERROR_RECEIVED:if(this.error_!==Error.NOT_ALLOWED){this.resetState_();this.fire("on-voice-search-cancel")}return;case State.RESULT_FINAL:return;default:return}}onError_(webkitError){this.state_=State.ERROR_RECEIVED;switch(webkitError){case"not-allowed":this.error_=Error.NOT_ALLOWED;this.errorMessage_=loadTimeData.getString("permissionError");return;default:return}}onFinalResult_(){if(!this.finalResult_){return}this.state_=State.RESULT_FINAL;this.fire("on-voice-search-final-result",this.finalResult_)}onCloseClick_(){this.voiceRecognition_.abort();this.resetState_();this.fire("on-voice-search-cancel")}resetState_(){this.state_=State.UNINITIALIZED;this.finalResult_="";this.interimResult_="";this.error_=null;this.errorMessage_=""}onLinkClick_(){this.fire("on-voice-search-cancel")}}customElements.define(ComposeboxVoiceSearchElement.is,ComposeboxVoiceSearchElement);