// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./composebox_match.js";import{assert}from"//resources/js/assert.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./composebox_dropdown.css.js";import{getHtml}from"./composebox_dropdown.html.js";function remainder(lhs,rhs){return(lhs%rhs+rhs)%rhs}export class ComposeboxDropdownElement extends CrLitElement{static get is(){return"cr-composebox-dropdown"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{result:{type:Object},selectedMatchIndex:{type:Number,notify:true},lastQueriedInput:{type:String,notify:true}}}#result_accessor_storage=null;get result(){return this.#result_accessor_storage}set result(value){this.#result_accessor_storage=value}#selectedMatchIndex_accessor_storage=-1;get selectedMatchIndex(){return this.#selectedMatchIndex_accessor_storage}set selectedMatchIndex(value){this.#selectedMatchIndex_accessor_storage=value}#lastQueriedInput_accessor_storage="";get lastQueriedInput(){return this.#lastQueriedInput_accessor_storage}set lastQueriedInput(value){this.#lastQueriedInput_accessor_storage=value}unselect(){this.selectedMatchIndex=-1}focusSelected(){const selectableMatchElements=this.shadowRoot.querySelectorAll("cr-composebox-match");selectableMatchElements[this.selectedMatchIndex]?.focus()}selectFirst(){this.selectedMatchIndex=0}selectIndex(index){this.selectedMatchIndex=index}selectPrevious(){if(!this.result){this.selectedMatchIndex=-1;return}let previous;const isTypedSuggest=this.lastQueriedInput.trim().length>0;if(isTypedSuggest&&this.selectedMatchIndex===1){previous=-1}else{previous=Math.max(this.selectedMatchIndex,0)-1}this.selectedMatchIndex=remainder(previous,this.result.matches.length)}selectLast(){this.selectedMatchIndex=this.result?this.result.matches.length-1:-1}selectNext(){if(!this.result){this.selectedMatchIndex=-1;return}let next;const isTypedSuggest=this.lastQueriedInput.trim().length>0;if(isTypedSuggest&&this.selectedMatchIndex===this.result.matches.length-1){next=1}else{next=this.selectedMatchIndex+1}this.selectedMatchIndex=remainder(next,this.result.matches.length)}matchIndex_(match){return this.result?.matches.indexOf(match)??-1}isSelected_(match){return this.matchIndex_(match)===this.selectedMatchIndex}isLastMatch_(index){assert(this.result);return index===this.result.matches.length-1}hideVerbatimMatch_(index){assert(this.result);if(!this.result.input){return false}return index===0}computeAriaLabel_(match){return match.a11yLabel}}customElements.define(ComposeboxDropdownElement.is,ComposeboxDropdownElement);