// ui/webui/resources/cr_components/app_management/app_management.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/app_management/app_management.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/app_management/app_management.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/app_management/app_management.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/services/app_service/public/cpp/app_types.h"
#include "components/services/app_service/public/cpp/permission.h"
#include "components/services/app_service/public/cpp/run_on_os_login_types.h"
#include "ui/webui/resources/cr_components/app_management/app_management_mojom_traits.h"




namespace app_management::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "app_management.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "app_management.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAppsMinVersion = 0,
    kGetAppMinVersion = 0,
    kGetSubAppToParentMapMinVersion = 0,
    kGetExtensionAppPermissionMessagesMinVersion = 0,
    kSetPinnedMinVersion = 0,
    kSetPermissionMinVersion = 0,
    kSetResizeLockedMinVersion = 0,
    kUninstallMinVersion = 0,
    kOpenNativeSettingsMinVersion = 0,
    kSetPreferredAppMinVersion = 0,
    kGetOverlappingPreferredAppsMinVersion = 0,
    kUpdateAppSizeMinVersion = 0,
    kSetWindowModeMinVersion = 0,
    kSetRunOnOsLoginModeMinVersion = 0,
    kSetFileHandlingEnabledMinVersion = 0,
    kShowDefaultAppAssociationsUiMinVersion = 0,
    kOpenStorePageMinVersion = 0,
    kSetAppLocaleMinVersion = 0,
    kOpenSystemNotificationSettingsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetApps_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSubAppToParentMap_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetExtensionAppPermissionMessages_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPinned_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetResizeLocked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Uninstall_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenNativeSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPreferredApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetOverlappingPreferredApps_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateAppSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWindowMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRunOnOsLoginMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFileHandlingEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowDefaultAppAssociationsUi_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenStorePage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAppLocale_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenSystemNotificationSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetAppsCallback = base::OnceCallback<void(std::vector<AppPtr>)>;
  using GetAppsMojoCallback = base::OnceCallback<void(std::vector<AppPtr>)>;

  virtual void GetApps(GetAppsCallback callback) = 0;

  using GetAppCallback = base::OnceCallback<void(AppPtr)>;
  using GetAppMojoCallback = base::OnceCallback<void(AppPtr)>;

  virtual void GetApp(const std::string& app_id, GetAppCallback callback) = 0;

  using GetSubAppToParentMapCallback = base::OnceCallback<void(const base::flat_map<std::string, std::string>&)>;
  using GetSubAppToParentMapMojoCallback = base::OnceCallback<void(const base::flat_map<std::string, std::string>&)>;

  virtual void GetSubAppToParentMap(GetSubAppToParentMapCallback callback) = 0;

  using GetExtensionAppPermissionMessagesCallback = base::OnceCallback<void(std::vector<ExtensionAppPermissionMessagePtr>)>;
  using GetExtensionAppPermissionMessagesMojoCallback = base::OnceCallback<void(std::vector<ExtensionAppPermissionMessagePtr>)>;

  virtual void GetExtensionAppPermissionMessages(const std::string& app_id, GetExtensionAppPermissionMessagesCallback callback) = 0;

  virtual void SetPinned(const std::string& app_id, bool pinned) = 0;

  virtual void SetPermission(const std::string& app_id, ::apps::PermissionPtr permission) = 0;

  virtual void SetResizeLocked(const std::string& app_id, bool locked) = 0;

  virtual void Uninstall(const std::string& app_id) = 0;

  virtual void OpenNativeSettings(const std::string& app_id) = 0;

  virtual void SetPreferredApp(const std::string& app_id, bool is_preferred_app) = 0;

  using GetOverlappingPreferredAppsCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  using GetOverlappingPreferredAppsMojoCallback = base::OnceCallback<void(const std::vector<std::string>&)>;

  virtual void GetOverlappingPreferredApps(const std::string& app_id, GetOverlappingPreferredAppsCallback callback) = 0;

  virtual void UpdateAppSize(const std::string& app_id) = 0;

  virtual void SetWindowMode(const std::string& app_id, ::apps::WindowMode window_mode) = 0;

  virtual void SetRunOnOsLoginMode(const std::string& app_id, ::apps::RunOnOsLoginMode run_on_os_login_mode) = 0;

  virtual void SetFileHandlingEnabled(const std::string& app_id, bool enabled) = 0;

  virtual void ShowDefaultAppAssociationsUi() = 0;

  virtual void OpenStorePage(const std::string& app_id) = 0;

  virtual void SetAppLocale(const std::string& app_id, const std::string& locale_tag) = 0;

  virtual void OpenSystemNotificationSettings(const std::string& app_id) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "app_management.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnAppAddedMinVersion = 0,
    kOnAppChangedMinVersion = 0,
    kOnAppRemovedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnAppAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAppChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAppRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnAppAdded(AppPtr app) = 0;

  virtual void OnAppChanged(AppPtr update) = 0;

  virtual void OnAppRemoved(const std::string& app_id) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetApps(GetAppsCallback callback) final;
  
  void GetApp(const std::string& app_id, GetAppCallback callback) final;
  
  void GetSubAppToParentMap(GetSubAppToParentMapCallback callback) final;
  
  void GetExtensionAppPermissionMessages(const std::string& app_id, GetExtensionAppPermissionMessagesCallback callback) final;
  
  void SetPinned(const std::string& app_id, bool pinned) final;
  
  void SetPermission(const std::string& app_id, ::apps::PermissionPtr permission) final;
  
  void SetResizeLocked(const std::string& app_id, bool locked) final;
  
  void Uninstall(const std::string& app_id) final;
  
  void OpenNativeSettings(const std::string& app_id) final;
  
  void SetPreferredApp(const std::string& app_id, bool is_preferred_app) final;
  
  void GetOverlappingPreferredApps(const std::string& app_id, GetOverlappingPreferredAppsCallback callback) final;
  
  void UpdateAppSize(const std::string& app_id) final;
  
  void SetWindowMode(const std::string& app_id, ::apps::WindowMode window_mode) final;
  
  void SetRunOnOsLoginMode(const std::string& app_id, ::apps::RunOnOsLoginMode run_on_os_login_mode) final;
  
  void SetFileHandlingEnabled(const std::string& app_id, bool enabled) final;
  
  void ShowDefaultAppAssociationsUi() final;
  
  void OpenStorePage(const std::string& app_id) final;
  
  void SetAppLocale(const std::string& app_id, const std::string& locale_tag) final;
  
  void OpenSystemNotificationSettings(const std::string& app_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAppAdded(AppPtr app) final;
  
  void OnAppChanged(AppPtr update) final;
  
  void OnAppRemoved(const std::string& app_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  RunOnOsLogin {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RunOnOsLogin, T>::value>;
  using DataView = RunOnOsLoginDataView;
  using Data_ = internal::RunOnOsLogin_Data;

  template <typename... Args>
  static RunOnOsLoginPtr New(Args&&... args) {
    return RunOnOsLoginPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RunOnOsLoginPtr From(const U& u) {
    return mojo::TypeConverter<RunOnOsLoginPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunOnOsLogin>::Convert(*this);
  }


  RunOnOsLogin();

  RunOnOsLogin(
      ::apps::RunOnOsLoginMode login_mode,
      bool is_managed);


  ~RunOnOsLogin();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunOnOsLoginPtr>
  RunOnOsLoginPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RunOnOsLogin::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RunOnOsLogin::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RunOnOsLogin::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunOnOsLogin::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunOnOsLogin::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunOnOsLogin::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RunOnOsLogin_UnserializedMessageContext<
            UserType, RunOnOsLogin::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RunOnOsLogin::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RunOnOsLogin::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RunOnOsLogin_UnserializedMessageContext<
            UserType, RunOnOsLogin::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RunOnOsLogin::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::apps::RunOnOsLoginMode login_mode;
  
  bool is_managed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RunOnOsLogin::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RunOnOsLogin::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RunOnOsLogin::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RunOnOsLogin::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Locale {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Locale, T>::value>;
  using DataView = LocaleDataView;
  using Data_ = internal::Locale_Data;

  template <typename... Args>
  static LocalePtr New(Args&&... args) {
    return LocalePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocalePtr From(const U& u) {
    return mojo::TypeConverter<LocalePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Locale>::Convert(*this);
  }


  Locale();

  Locale(
      const std::string& locale_tag,
      const std::string& display_name,
      const std::string& native_display_name);


  ~Locale();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocalePtr>
  LocalePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Locale::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Locale::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Locale::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Locale::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Locale::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Locale::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Locale_UnserializedMessageContext<
            UserType, Locale::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Locale::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Locale::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Locale_UnserializedMessageContext<
            UserType, Locale::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Locale::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string locale_tag;
  
  std::string display_name;
  
  std::string native_display_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Locale::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Locale::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Locale::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Locale::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  PermissionValue {
 public:
  using DataView = PermissionValueDataView;
  using Data_ = internal::PermissionValue_Data;
  using Tag = Data_::PermissionValue_Tag;

  template <typename... Args>
  static PermissionValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |bool_value|.
  static PermissionValuePtr NewBoolValue(
      bool value);
  // Construct an instance holding |tristate_value|.
  static PermissionValuePtr NewTristateValue(
      TriState value);

  template <typename U>
  static PermissionValuePtr From(const U& u) {
    return mojo::TypeConverter<PermissionValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionValue>::Convert(*this);
  }
  ~PermissionValue();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PermissionValuePtr>
  PermissionValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PermissionValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PermissionValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_bool_value() const { return tag_ == Tag::kBoolValue; }
  bool get_bool_value() const {
    CHECK(tag_ == Tag::kBoolValue);
    return data_.bool_value;
  }
  void set_bool_value(bool bool_value);

  bool is_tristate_value() const { return tag_ == Tag::kTristateValue; }
  TriState get_tristate_value() const {
    CHECK(tag_ == Tag::kTristateValue);
    return data_.tristate_value;
  }
  void set_tristate_value(TriState tristate_value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PermissionValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTristateValue)>,
        TriState value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    bool bool_value;
    TriState tristate_value;
  };

  PermissionValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
      bool value);
  PermissionValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kTristateValue)>,
      TriState value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  Permission {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Permission, T>::value>;
  using DataView = PermissionDataView;
  using Data_ = internal::Permission_Data;

  template <typename... Args>
  static PermissionPtr New(Args&&... args) {
    return PermissionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PermissionPtr From(const U& u) {
    return mojo::TypeConverter<PermissionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Permission>::Convert(*this);
  }


  Permission();

  Permission(
      ::apps::PermissionType permission_type,
      PermissionValuePtr value,
      bool is_managed,
      const std::optional<std::string>& details);

Permission(const Permission&) = delete;
Permission& operator=(const Permission&) = delete;

  ~Permission();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PermissionPtr>
  PermissionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Permission::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Permission::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Permission::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Permission::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Permission::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Permission::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Permission_UnserializedMessageContext<
            UserType, Permission::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Permission::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Permission::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Permission_UnserializedMessageContext<
            UserType, Permission::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Permission::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::apps::PermissionType permission_type;
  
  PermissionValuePtr value;
  
  bool is_managed;
  
  std::optional<std::string> details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Permission::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Permission::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Permission::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Permission::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  App {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<App, T>::value>;
  using DataView = AppDataView;
  using Data_ = internal::App_Data;

  template <typename... Args>
  static AppPtr New(Args&&... args) {
    return AppPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AppPtr From(const U& u) {
    return mojo::TypeConverter<AppPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, App>::Convert(*this);
  }


  App();

  App(
      const std::string& id,
      ::apps::AppType type,
      const std::optional<std::string>& title,
      const std::optional<std::string>& description,
      std::optional<bool> is_pinned,
      std::optional<bool> is_policy_pinned,
      const std::optional<std::string>& version,
      const std::optional<std::string>& size,
      base::flat_map<::apps::PermissionType, ::apps::PermissionPtr> permissions,
      ::apps::InstallReason install_reason,
      ::apps::InstallSource install_source,
      bool hide_more_settings,
      bool hide_pin_to_shelf,
      bool is_preferred_app,
      ::apps::WindowMode window_mode,
      bool hide_window_mode,
      bool resize_locked,
      bool hide_resize_locked,
      std::vector<std::string> supported_links,
      std::optional<::apps::RunOnOsLoginPtr> run_on_os_login,
      FileHandlingStatePtr file_handling_state,
      const std::optional<std::string>& app_size,
      const std::optional<std::string>& data_size,
      const std::string& publisher_id,
      const std::optional<std::string>& formatted_origin,
      std::vector<std::string> scope_extensions,
      std::vector<LocalePtr> supported_locales,
      LocalePtr selected_locale,
      bool show_system_notifications_settings_link,
      bool allow_uninstall,
      bool disable_user_choice_navigation_capturing);

App(const App&) = delete;
App& operator=(const App&) = delete;

  ~App();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AppPtr>
  AppPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, App::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, App::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, App::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        App::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        App::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        App::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::App_UnserializedMessageContext<
            UserType, App::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<App::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return App::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::App_UnserializedMessageContext<
            UserType, App::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<App::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  ::apps::AppType type;
  
  std::optional<std::string> title;
  
  std::optional<std::string> description;
  
  std::optional<bool> is_pinned;
  
  std::optional<bool> is_policy_pinned;
  
  std::optional<std::string> version;
  
  std::optional<std::string> size;
  
  base::flat_map<::apps::PermissionType, ::apps::PermissionPtr> permissions;
  
  ::apps::InstallReason install_reason;
  
  ::apps::InstallSource install_source;
  
  bool hide_more_settings;
  
  bool hide_pin_to_shelf;
  
  bool is_preferred_app;
  
  ::apps::WindowMode window_mode;
  
  bool hide_window_mode;
  
  bool resize_locked;
  
  bool hide_resize_locked;
  
  std::vector<std::string> supported_links;
  
  std::optional<::apps::RunOnOsLoginPtr> run_on_os_login;
  
  FileHandlingStatePtr file_handling_state;
  
  std::optional<std::string> app_size;
  
  std::optional<std::string> data_size;
  
  std::string publisher_id;
  
  std::optional<std::string> formatted_origin;
  
  std::vector<std::string> scope_extensions;
  
  std::vector<LocalePtr> supported_locales;
  
  LocalePtr selected_locale;
  
  bool show_system_notifications_settings_link;
  
  bool allow_uninstall;
  
  bool disable_user_choice_navigation_capturing;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, App::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, App::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, App::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, App::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ExtensionAppPermissionMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtensionAppPermissionMessage, T>::value>;
  using DataView = ExtensionAppPermissionMessageDataView;
  using Data_ = internal::ExtensionAppPermissionMessage_Data;

  template <typename... Args>
  static ExtensionAppPermissionMessagePtr New(Args&&... args) {
    return ExtensionAppPermissionMessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtensionAppPermissionMessagePtr From(const U& u) {
    return mojo::TypeConverter<ExtensionAppPermissionMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionAppPermissionMessage>::Convert(*this);
  }


  ExtensionAppPermissionMessage();

  ExtensionAppPermissionMessage(
      const std::string& message,
      std::vector<std::string> submessages);


  ~ExtensionAppPermissionMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtensionAppPermissionMessagePtr>
  ExtensionAppPermissionMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtensionAppPermissionMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtensionAppPermissionMessage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtensionAppPermissionMessage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionAppPermissionMessage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionAppPermissionMessage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionAppPermissionMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtensionAppPermissionMessage_UnserializedMessageContext<
            UserType, ExtensionAppPermissionMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtensionAppPermissionMessage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtensionAppPermissionMessage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtensionAppPermissionMessage_UnserializedMessageContext<
            UserType, ExtensionAppPermissionMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtensionAppPermissionMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string message;
  
  std::vector<std::string> submessages;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtensionAppPermissionMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtensionAppPermissionMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtensionAppPermissionMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtensionAppPermissionMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FileHandlingState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileHandlingState, T>::value>;
  using DataView = FileHandlingStateDataView;
  using Data_ = internal::FileHandlingState_Data;

  template <typename... Args>
  static FileHandlingStatePtr New(Args&&... args) {
    return FileHandlingStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileHandlingStatePtr From(const U& u) {
    return mojo::TypeConverter<FileHandlingStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileHandlingState>::Convert(*this);
  }


  FileHandlingState();

  FileHandlingState(
      bool enabled,
      bool is_managed,
      const std::string& user_visible_types,
      const std::string& user_visible_types_label,
      const std::optional<::GURL>& learn_more_url);


  ~FileHandlingState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileHandlingStatePtr>
  FileHandlingStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileHandlingState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileHandlingState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileHandlingState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileHandlingState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileHandlingState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileHandlingState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileHandlingState_UnserializedMessageContext<
            UserType, FileHandlingState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileHandlingState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileHandlingState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileHandlingState_UnserializedMessageContext<
            UserType, FileHandlingState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileHandlingState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool enabled;
  
  bool is_managed;
  
  std::string user_visible_types;
  
  std::string user_visible_types_label;
  
  std::optional<::GURL> learn_more_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileHandlingState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileHandlingState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileHandlingState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileHandlingState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PermissionValuePtr PermissionValue::Clone() const {
  switch (tag_) {
    case Tag::kBoolValue:
      return NewBoolValue(
          mojo::Clone(data_.bool_value));
    case Tag::kTristateValue:
      return NewTristateValue(
          mojo::Clone(data_.tristate_value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PermissionValue>::value>::type*>
bool PermissionValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kBoolValue:
      return mojo::Equals(data_.bool_value, other.data_.bool_value);
    case Tag::kTristateValue:
      return mojo::Equals(data_.tristate_value, other.data_.tristate_value);
  }

  return false;
}
template <typename StructPtrType>
PermissionPtr Permission::Clone() const {
  return New(
      mojo::Clone(permission_type),
      mojo::Clone(value),
      mojo::Clone(is_managed),
      mojo::Clone(details)
  );
}

template <typename T, Permission::EnableIfSame<T>*>
bool Permission::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->permission_type, other_struct.permission_type))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->is_managed, other_struct.is_managed))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, Permission::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.permission_type < rhs.permission_type)
    return true;
  if (rhs.permission_type < lhs.permission_type)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.is_managed < rhs.is_managed)
    return true;
  if (rhs.is_managed < lhs.is_managed)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  return false;
}
template <typename StructPtrType>
RunOnOsLoginPtr RunOnOsLogin::Clone() const {
  return New(
      mojo::Clone(login_mode),
      mojo::Clone(is_managed)
  );
}

template <typename T, RunOnOsLogin::EnableIfSame<T>*>
bool RunOnOsLogin::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->login_mode, other_struct.login_mode))
    return false;
  if (!mojo::Equals(this->is_managed, other_struct.is_managed))
    return false;
  return true;
}

template <typename T, RunOnOsLogin::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.login_mode < rhs.login_mode)
    return true;
  if (rhs.login_mode < lhs.login_mode)
    return false;
  if (lhs.is_managed < rhs.is_managed)
    return true;
  if (rhs.is_managed < lhs.is_managed)
    return false;
  return false;
}
template <typename StructPtrType>
LocalePtr Locale::Clone() const {
  return New(
      mojo::Clone(locale_tag),
      mojo::Clone(display_name),
      mojo::Clone(native_display_name)
  );
}

template <typename T, Locale::EnableIfSame<T>*>
bool Locale::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->locale_tag, other_struct.locale_tag))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->native_display_name, other_struct.native_display_name))
    return false;
  return true;
}

template <typename T, Locale::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.locale_tag < rhs.locale_tag)
    return true;
  if (rhs.locale_tag < lhs.locale_tag)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.native_display_name < rhs.native_display_name)
    return true;
  if (rhs.native_display_name < lhs.native_display_name)
    return false;
  return false;
}
template <typename StructPtrType>
AppPtr App::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(type),
      mojo::Clone(title),
      mojo::Clone(description),
      mojo::Clone(is_pinned),
      mojo::Clone(is_policy_pinned),
      mojo::Clone(version),
      mojo::Clone(size),
      mojo::Clone(permissions),
      mojo::Clone(install_reason),
      mojo::Clone(install_source),
      mojo::Clone(hide_more_settings),
      mojo::Clone(hide_pin_to_shelf),
      mojo::Clone(is_preferred_app),
      mojo::Clone(window_mode),
      mojo::Clone(hide_window_mode),
      mojo::Clone(resize_locked),
      mojo::Clone(hide_resize_locked),
      mojo::Clone(supported_links),
      mojo::Clone(run_on_os_login),
      mojo::Clone(file_handling_state),
      mojo::Clone(app_size),
      mojo::Clone(data_size),
      mojo::Clone(publisher_id),
      mojo::Clone(formatted_origin),
      mojo::Clone(scope_extensions),
      mojo::Clone(supported_locales),
      mojo::Clone(selected_locale),
      mojo::Clone(show_system_notifications_settings_link),
      mojo::Clone(allow_uninstall),
      mojo::Clone(disable_user_choice_navigation_capturing)
  );
}

template <typename T, App::EnableIfSame<T>*>
bool App::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->is_pinned, other_struct.is_pinned))
    return false;
  if (!mojo::Equals(this->is_policy_pinned, other_struct.is_policy_pinned))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->permissions, other_struct.permissions))
    return false;
  if (!mojo::Equals(this->install_reason, other_struct.install_reason))
    return false;
  if (!mojo::Equals(this->install_source, other_struct.install_source))
    return false;
  if (!mojo::Equals(this->hide_more_settings, other_struct.hide_more_settings))
    return false;
  if (!mojo::Equals(this->hide_pin_to_shelf, other_struct.hide_pin_to_shelf))
    return false;
  if (!mojo::Equals(this->is_preferred_app, other_struct.is_preferred_app))
    return false;
  if (!mojo::Equals(this->window_mode, other_struct.window_mode))
    return false;
  if (!mojo::Equals(this->hide_window_mode, other_struct.hide_window_mode))
    return false;
  if (!mojo::Equals(this->resize_locked, other_struct.resize_locked))
    return false;
  if (!mojo::Equals(this->hide_resize_locked, other_struct.hide_resize_locked))
    return false;
  if (!mojo::Equals(this->supported_links, other_struct.supported_links))
    return false;
  if (!mojo::Equals(this->run_on_os_login, other_struct.run_on_os_login))
    return false;
  if (!mojo::Equals(this->file_handling_state, other_struct.file_handling_state))
    return false;
  if (!mojo::Equals(this->app_size, other_struct.app_size))
    return false;
  if (!mojo::Equals(this->data_size, other_struct.data_size))
    return false;
  if (!mojo::Equals(this->publisher_id, other_struct.publisher_id))
    return false;
  if (!mojo::Equals(this->formatted_origin, other_struct.formatted_origin))
    return false;
  if (!mojo::Equals(this->scope_extensions, other_struct.scope_extensions))
    return false;
  if (!mojo::Equals(this->supported_locales, other_struct.supported_locales))
    return false;
  if (!mojo::Equals(this->selected_locale, other_struct.selected_locale))
    return false;
  if (!mojo::Equals(this->show_system_notifications_settings_link, other_struct.show_system_notifications_settings_link))
    return false;
  if (!mojo::Equals(this->allow_uninstall, other_struct.allow_uninstall))
    return false;
  if (!mojo::Equals(this->disable_user_choice_navigation_capturing, other_struct.disable_user_choice_navigation_capturing))
    return false;
  return true;
}

template <typename T, App::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.is_pinned < rhs.is_pinned)
    return true;
  if (rhs.is_pinned < lhs.is_pinned)
    return false;
  if (lhs.is_policy_pinned < rhs.is_policy_pinned)
    return true;
  if (rhs.is_policy_pinned < lhs.is_policy_pinned)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.permissions < rhs.permissions)
    return true;
  if (rhs.permissions < lhs.permissions)
    return false;
  if (lhs.install_reason < rhs.install_reason)
    return true;
  if (rhs.install_reason < lhs.install_reason)
    return false;
  if (lhs.install_source < rhs.install_source)
    return true;
  if (rhs.install_source < lhs.install_source)
    return false;
  if (lhs.hide_more_settings < rhs.hide_more_settings)
    return true;
  if (rhs.hide_more_settings < lhs.hide_more_settings)
    return false;
  if (lhs.hide_pin_to_shelf < rhs.hide_pin_to_shelf)
    return true;
  if (rhs.hide_pin_to_shelf < lhs.hide_pin_to_shelf)
    return false;
  if (lhs.is_preferred_app < rhs.is_preferred_app)
    return true;
  if (rhs.is_preferred_app < lhs.is_preferred_app)
    return false;
  if (lhs.window_mode < rhs.window_mode)
    return true;
  if (rhs.window_mode < lhs.window_mode)
    return false;
  if (lhs.hide_window_mode < rhs.hide_window_mode)
    return true;
  if (rhs.hide_window_mode < lhs.hide_window_mode)
    return false;
  if (lhs.resize_locked < rhs.resize_locked)
    return true;
  if (rhs.resize_locked < lhs.resize_locked)
    return false;
  if (lhs.hide_resize_locked < rhs.hide_resize_locked)
    return true;
  if (rhs.hide_resize_locked < lhs.hide_resize_locked)
    return false;
  if (lhs.supported_links < rhs.supported_links)
    return true;
  if (rhs.supported_links < lhs.supported_links)
    return false;
  if (lhs.run_on_os_login < rhs.run_on_os_login)
    return true;
  if (rhs.run_on_os_login < lhs.run_on_os_login)
    return false;
  if (lhs.file_handling_state < rhs.file_handling_state)
    return true;
  if (rhs.file_handling_state < lhs.file_handling_state)
    return false;
  if (lhs.app_size < rhs.app_size)
    return true;
  if (rhs.app_size < lhs.app_size)
    return false;
  if (lhs.data_size < rhs.data_size)
    return true;
  if (rhs.data_size < lhs.data_size)
    return false;
  if (lhs.publisher_id < rhs.publisher_id)
    return true;
  if (rhs.publisher_id < lhs.publisher_id)
    return false;
  if (lhs.formatted_origin < rhs.formatted_origin)
    return true;
  if (rhs.formatted_origin < lhs.formatted_origin)
    return false;
  if (lhs.scope_extensions < rhs.scope_extensions)
    return true;
  if (rhs.scope_extensions < lhs.scope_extensions)
    return false;
  if (lhs.supported_locales < rhs.supported_locales)
    return true;
  if (rhs.supported_locales < lhs.supported_locales)
    return false;
  if (lhs.selected_locale < rhs.selected_locale)
    return true;
  if (rhs.selected_locale < lhs.selected_locale)
    return false;
  if (lhs.show_system_notifications_settings_link < rhs.show_system_notifications_settings_link)
    return true;
  if (rhs.show_system_notifications_settings_link < lhs.show_system_notifications_settings_link)
    return false;
  if (lhs.allow_uninstall < rhs.allow_uninstall)
    return true;
  if (rhs.allow_uninstall < lhs.allow_uninstall)
    return false;
  if (lhs.disable_user_choice_navigation_capturing < rhs.disable_user_choice_navigation_capturing)
    return true;
  if (rhs.disable_user_choice_navigation_capturing < lhs.disable_user_choice_navigation_capturing)
    return false;
  return false;
}
template <typename StructPtrType>
ExtensionAppPermissionMessagePtr ExtensionAppPermissionMessage::Clone() const {
  return New(
      mojo::Clone(message),
      mojo::Clone(submessages)
  );
}

template <typename T, ExtensionAppPermissionMessage::EnableIfSame<T>*>
bool ExtensionAppPermissionMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->submessages, other_struct.submessages))
    return false;
  return true;
}

template <typename T, ExtensionAppPermissionMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.submessages < rhs.submessages)
    return true;
  if (rhs.submessages < lhs.submessages)
    return false;
  return false;
}
template <typename StructPtrType>
FileHandlingStatePtr FileHandlingState::Clone() const {
  return New(
      mojo::Clone(enabled),
      mojo::Clone(is_managed),
      mojo::Clone(user_visible_types),
      mojo::Clone(user_visible_types_label),
      mojo::Clone(learn_more_url)
  );
}

template <typename T, FileHandlingState::EnableIfSame<T>*>
bool FileHandlingState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->enabled, other_struct.enabled))
    return false;
  if (!mojo::Equals(this->is_managed, other_struct.is_managed))
    return false;
  if (!mojo::Equals(this->user_visible_types, other_struct.user_visible_types))
    return false;
  if (!mojo::Equals(this->user_visible_types_label, other_struct.user_visible_types_label))
    return false;
  if (!mojo::Equals(this->learn_more_url, other_struct.learn_more_url))
    return false;
  return true;
}

template <typename T, FileHandlingState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.enabled < rhs.enabled)
    return true;
  if (rhs.enabled < lhs.enabled)
    return false;
  if (lhs.is_managed < rhs.is_managed)
    return true;
  if (rhs.is_managed < lhs.is_managed)
    return false;
  if (lhs.user_visible_types < rhs.user_visible_types)
    return true;
  if (rhs.user_visible_types < lhs.user_visible_types)
    return false;
  if (lhs.user_visible_types_label < rhs.user_visible_types_label)
    return true;
  if (rhs.user_visible_types_label < lhs.user_visible_types_label)
    return false;
  if (lhs.learn_more_url < rhs.learn_more_url)
    return true;
  if (rhs.learn_more_url < lhs.learn_more_url)
    return false;
  return false;
}


}  // app_management::mojom

namespace mojo {


template <>
struct  StructTraits<::app_management::mojom::Permission::DataView,
                                         ::app_management::mojom::PermissionPtr> {
  static bool IsNull(const ::app_management::mojom::PermissionPtr& input) { return !input; }
  static void SetToNull(::app_management::mojom::PermissionPtr* output) { output->reset(); }

  static decltype(::app_management::mojom::Permission::permission_type) permission_type(
      const ::app_management::mojom::PermissionPtr& input) {
    return input->permission_type;
  }

  static const decltype(::app_management::mojom::Permission::value)& value(
      const ::app_management::mojom::PermissionPtr& input) {
    return input->value;
  }

  static decltype(::app_management::mojom::Permission::is_managed) is_managed(
      const ::app_management::mojom::PermissionPtr& input) {
    return input->is_managed;
  }

  static const decltype(::app_management::mojom::Permission::details)& details(
      const ::app_management::mojom::PermissionPtr& input) {
    return input->details;
  }

  static bool Read(::app_management::mojom::Permission::DataView input, ::app_management::mojom::PermissionPtr* output);
};


template <>
struct  StructTraits<::app_management::mojom::RunOnOsLogin::DataView,
                                         ::app_management::mojom::RunOnOsLoginPtr> {
  static bool IsNull(const ::app_management::mojom::RunOnOsLoginPtr& input) { return !input; }
  static void SetToNull(::app_management::mojom::RunOnOsLoginPtr* output) { output->reset(); }

  static decltype(::app_management::mojom::RunOnOsLogin::login_mode) login_mode(
      const ::app_management::mojom::RunOnOsLoginPtr& input) {
    return input->login_mode;
  }

  static decltype(::app_management::mojom::RunOnOsLogin::is_managed) is_managed(
      const ::app_management::mojom::RunOnOsLoginPtr& input) {
    return input->is_managed;
  }

  static bool Read(::app_management::mojom::RunOnOsLogin::DataView input, ::app_management::mojom::RunOnOsLoginPtr* output);
};


template <>
struct  StructTraits<::app_management::mojom::Locale::DataView,
                                         ::app_management::mojom::LocalePtr> {
  static bool IsNull(const ::app_management::mojom::LocalePtr& input) { return !input; }
  static void SetToNull(::app_management::mojom::LocalePtr* output) { output->reset(); }

  static const decltype(::app_management::mojom::Locale::locale_tag)& locale_tag(
      const ::app_management::mojom::LocalePtr& input) {
    return input->locale_tag;
  }

  static const decltype(::app_management::mojom::Locale::display_name)& display_name(
      const ::app_management::mojom::LocalePtr& input) {
    return input->display_name;
  }

  static const decltype(::app_management::mojom::Locale::native_display_name)& native_display_name(
      const ::app_management::mojom::LocalePtr& input) {
    return input->native_display_name;
  }

  static bool Read(::app_management::mojom::Locale::DataView input, ::app_management::mojom::LocalePtr* output);
};


template <>
struct  StructTraits<::app_management::mojom::App::DataView,
                                         ::app_management::mojom::AppPtr> {
  static bool IsNull(const ::app_management::mojom::AppPtr& input) { return !input; }
  static void SetToNull(::app_management::mojom::AppPtr* output) { output->reset(); }

  static const decltype(::app_management::mojom::App::id)& id(
      const ::app_management::mojom::AppPtr& input) {
    return input->id;
  }

  static decltype(::app_management::mojom::App::type) type(
      const ::app_management::mojom::AppPtr& input) {
    return input->type;
  }

  static const decltype(::app_management::mojom::App::title)& title(
      const ::app_management::mojom::AppPtr& input) {
    return input->title;
  }

  static const decltype(::app_management::mojom::App::description)& description(
      const ::app_management::mojom::AppPtr& input) {
    return input->description;
  }

  static decltype(::app_management::mojom::App::is_pinned) is_pinned(
      const ::app_management::mojom::AppPtr& input) {
    return input->is_pinned;
  }

  static decltype(::app_management::mojom::App::is_policy_pinned) is_policy_pinned(
      const ::app_management::mojom::AppPtr& input) {
    return input->is_policy_pinned;
  }

  static const decltype(::app_management::mojom::App::version)& version(
      const ::app_management::mojom::AppPtr& input) {
    return input->version;
  }

  static const decltype(::app_management::mojom::App::size)& size(
      const ::app_management::mojom::AppPtr& input) {
    return input->size;
  }

  static const decltype(::app_management::mojom::App::permissions)& permissions(
      const ::app_management::mojom::AppPtr& input) {
    return input->permissions;
  }

  static decltype(::app_management::mojom::App::install_reason) install_reason(
      const ::app_management::mojom::AppPtr& input) {
    return input->install_reason;
  }

  static decltype(::app_management::mojom::App::install_source) install_source(
      const ::app_management::mojom::AppPtr& input) {
    return input->install_source;
  }

  static decltype(::app_management::mojom::App::hide_more_settings) hide_more_settings(
      const ::app_management::mojom::AppPtr& input) {
    return input->hide_more_settings;
  }

  static decltype(::app_management::mojom::App::hide_pin_to_shelf) hide_pin_to_shelf(
      const ::app_management::mojom::AppPtr& input) {
    return input->hide_pin_to_shelf;
  }

  static decltype(::app_management::mojom::App::is_preferred_app) is_preferred_app(
      const ::app_management::mojom::AppPtr& input) {
    return input->is_preferred_app;
  }

  static decltype(::app_management::mojom::App::window_mode) window_mode(
      const ::app_management::mojom::AppPtr& input) {
    return input->window_mode;
  }

  static decltype(::app_management::mojom::App::hide_window_mode) hide_window_mode(
      const ::app_management::mojom::AppPtr& input) {
    return input->hide_window_mode;
  }

  static decltype(::app_management::mojom::App::resize_locked) resize_locked(
      const ::app_management::mojom::AppPtr& input) {
    return input->resize_locked;
  }

  static decltype(::app_management::mojom::App::hide_resize_locked) hide_resize_locked(
      const ::app_management::mojom::AppPtr& input) {
    return input->hide_resize_locked;
  }

  static const decltype(::app_management::mojom::App::supported_links)& supported_links(
      const ::app_management::mojom::AppPtr& input) {
    return input->supported_links;
  }

  static const decltype(::app_management::mojom::App::run_on_os_login)& run_on_os_login(
      const ::app_management::mojom::AppPtr& input) {
    return input->run_on_os_login;
  }

  static const decltype(::app_management::mojom::App::file_handling_state)& file_handling_state(
      const ::app_management::mojom::AppPtr& input) {
    return input->file_handling_state;
  }

  static const decltype(::app_management::mojom::App::app_size)& app_size(
      const ::app_management::mojom::AppPtr& input) {
    return input->app_size;
  }

  static const decltype(::app_management::mojom::App::data_size)& data_size(
      const ::app_management::mojom::AppPtr& input) {
    return input->data_size;
  }

  static const decltype(::app_management::mojom::App::publisher_id)& publisher_id(
      const ::app_management::mojom::AppPtr& input) {
    return input->publisher_id;
  }

  static const decltype(::app_management::mojom::App::formatted_origin)& formatted_origin(
      const ::app_management::mojom::AppPtr& input) {
    return input->formatted_origin;
  }

  static const decltype(::app_management::mojom::App::scope_extensions)& scope_extensions(
      const ::app_management::mojom::AppPtr& input) {
    return input->scope_extensions;
  }

  static const decltype(::app_management::mojom::App::supported_locales)& supported_locales(
      const ::app_management::mojom::AppPtr& input) {
    return input->supported_locales;
  }

  static const decltype(::app_management::mojom::App::selected_locale)& selected_locale(
      const ::app_management::mojom::AppPtr& input) {
    return input->selected_locale;
  }

  static decltype(::app_management::mojom::App::show_system_notifications_settings_link) show_system_notifications_settings_link(
      const ::app_management::mojom::AppPtr& input) {
    return input->show_system_notifications_settings_link;
  }

  static decltype(::app_management::mojom::App::allow_uninstall) allow_uninstall(
      const ::app_management::mojom::AppPtr& input) {
    return input->allow_uninstall;
  }

  static decltype(::app_management::mojom::App::disable_user_choice_navigation_capturing) disable_user_choice_navigation_capturing(
      const ::app_management::mojom::AppPtr& input) {
    return input->disable_user_choice_navigation_capturing;
  }

  static bool Read(::app_management::mojom::App::DataView input, ::app_management::mojom::AppPtr* output);
};


template <>
struct  StructTraits<::app_management::mojom::ExtensionAppPermissionMessage::DataView,
                                         ::app_management::mojom::ExtensionAppPermissionMessagePtr> {
  static bool IsNull(const ::app_management::mojom::ExtensionAppPermissionMessagePtr& input) { return !input; }
  static void SetToNull(::app_management::mojom::ExtensionAppPermissionMessagePtr* output) { output->reset(); }

  static const decltype(::app_management::mojom::ExtensionAppPermissionMessage::message)& message(
      const ::app_management::mojom::ExtensionAppPermissionMessagePtr& input) {
    return input->message;
  }

  static const decltype(::app_management::mojom::ExtensionAppPermissionMessage::submessages)& submessages(
      const ::app_management::mojom::ExtensionAppPermissionMessagePtr& input) {
    return input->submessages;
  }

  static bool Read(::app_management::mojom::ExtensionAppPermissionMessage::DataView input, ::app_management::mojom::ExtensionAppPermissionMessagePtr* output);
};


template <>
struct  StructTraits<::app_management::mojom::FileHandlingState::DataView,
                                         ::app_management::mojom::FileHandlingStatePtr> {
  static bool IsNull(const ::app_management::mojom::FileHandlingStatePtr& input) { return !input; }
  static void SetToNull(::app_management::mojom::FileHandlingStatePtr* output) { output->reset(); }

  static decltype(::app_management::mojom::FileHandlingState::enabled) enabled(
      const ::app_management::mojom::FileHandlingStatePtr& input) {
    return input->enabled;
  }

  static decltype(::app_management::mojom::FileHandlingState::is_managed) is_managed(
      const ::app_management::mojom::FileHandlingStatePtr& input) {
    return input->is_managed;
  }

  static const decltype(::app_management::mojom::FileHandlingState::user_visible_types)& user_visible_types(
      const ::app_management::mojom::FileHandlingStatePtr& input) {
    return input->user_visible_types;
  }

  static const decltype(::app_management::mojom::FileHandlingState::user_visible_types_label)& user_visible_types_label(
      const ::app_management::mojom::FileHandlingStatePtr& input) {
    return input->user_visible_types_label;
  }

  static const decltype(::app_management::mojom::FileHandlingState::learn_more_url)& learn_more_url(
      const ::app_management::mojom::FileHandlingStatePtr& input) {
    return input->learn_more_url;
  }

  static bool Read(::app_management::mojom::FileHandlingState::DataView input, ::app_management::mojom::FileHandlingStatePtr* output);
};


template <>
struct  UnionTraits<::app_management::mojom::PermissionValue::DataView,
                                        ::app_management::mojom::PermissionValuePtr> {
  static bool IsNull(const ::app_management::mojom::PermissionValuePtr& input) { return !input; }
  static void SetToNull(::app_management::mojom::PermissionValuePtr* output) { output->reset(); }

  static ::app_management::mojom::PermissionValue::Tag GetTag(const ::app_management::mojom::PermissionValuePtr& input) {
    return input->which();
  }

  static  bool bool_value(const ::app_management::mojom::PermissionValuePtr& input) {
    return input->get_bool_value();
  }

  static  ::app_management::mojom::TriState tristate_value(const ::app_management::mojom::PermissionValuePtr& input) {
    return input->get_tristate_value();
  }

  static bool Read(::app_management::mojom::PermissionValue::DataView input, ::app_management::mojom::PermissionValuePtr* output);
};

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_H_