// ui/webui/resources/cr_components/app_management/app_management.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_TEST_UTILS_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_TEST_UTILS_H_

#include "ui/webui/resources/cr_components/app_management/app_management.mojom.h"


namespace app_management::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void GetApps(GetAppsCallback callback) override;
  void GetApp(const std::string& app_id, GetAppCallback callback) override;
  void GetSubAppToParentMap(GetSubAppToParentMapCallback callback) override;
  void GetExtensionAppPermissionMessages(const std::string& app_id, GetExtensionAppPermissionMessagesCallback callback) override;
  void SetPinned(const std::string& app_id, bool pinned) override;
  void SetPermission(const std::string& app_id, ::apps::PermissionPtr permission) override;
  void SetResizeLocked(const std::string& app_id, bool locked) override;
  void Uninstall(const std::string& app_id) override;
  void OpenNativeSettings(const std::string& app_id) override;
  void SetPreferredApp(const std::string& app_id, bool is_preferred_app) override;
  void GetOverlappingPreferredApps(const std::string& app_id, GetOverlappingPreferredAppsCallback callback) override;
  void UpdateAppSize(const std::string& app_id) override;
  void SetWindowMode(const std::string& app_id, ::apps::WindowMode window_mode) override;
  void SetRunOnOsLoginMode(const std::string& app_id, ::apps::RunOnOsLoginMode run_on_os_login_mode) override;
  void SetFileHandlingEnabled(const std::string& app_id, bool enabled) override;
  void ShowDefaultAppAssociationsUi() override;
  void OpenStorePage(const std::string& app_id) override;
  void SetAppLocale(const std::string& app_id, const std::string& locale_tag) override;
  void OpenSystemNotificationSettings(const std::string& app_id) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void GetApps(
      std::vector<AppPtr>* out_apps);
  std::vector<AppPtr> GetApps();
  void GetApp(
      const std::string& app_id, AppPtr* out_app);
  AppPtr GetApp(const std::string& app_id);
  void GetSubAppToParentMap(
      base::flat_map<std::string, std::string>* out_sub_app_to_parent_map);
  base::flat_map<std::string, std::string> GetSubAppToParentMap();
  void GetExtensionAppPermissionMessages(
      const std::string& app_id, std::vector<ExtensionAppPermissionMessagePtr>* out_messages);
  std::vector<ExtensionAppPermissionMessagePtr> GetExtensionAppPermissionMessages(const std::string& app_id);
  void GetOverlappingPreferredApps(
      const std::string& app_id, std::vector<std::string>* out_app_ids);
  std::vector<std::string> GetOverlappingPreferredApps(const std::string& app_id);

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void OnAppAdded(AppPtr app) override;
  void OnAppChanged(AppPtr update) override;
  void OnAppRemoved(const std::string& app_id) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // app_management::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_TEST_UTILS_H_