// ui/gfx/mojom/swap_timings.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/gfx/mojom/swap_timings.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gfx.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }



  function SwapTimings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SwapTimings.prototype.initDefaults_ = function() {
    this.swapStart = null;
    this.swapEnd = null;
  };
  SwapTimings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SwapTimings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SwapTimings.swapStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SwapTimings.swapEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SwapTimings.encodedSize = codec.kStructHeaderSize + 16;

  SwapTimings.decode = function(decoder) {
    var packed;
    var val = new SwapTimings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.swapStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.swapEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  SwapTimings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SwapTimings.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.swapStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.swapEnd);
  };
  exports.SwapTimings = SwapTimings;
})();