// ui/gfx/mojom/native_handle_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/native_handle_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/native_handle_types.mojom-params-data.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/native_handle_types.mojom-import-headers.h"
#include "ui/gfx/mojom/native_handle_types.mojom-test-utils.h"


namespace gfx::mojom {
IOSurfaceHandle::IOSurfaceHandle()
    : mach_send_right() {}

IOSurfaceHandle::IOSurfaceHandle(
    ::mojo::PlatformHandle mach_send_right_in)
    : mach_send_right(std::move(mach_send_right_in)) {}

IOSurfaceHandle::~IOSurfaceHandle() = default;

void IOSurfaceHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mach_send_right"), this->mach_send_right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PlatformHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IOSurfaceHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuMemoryBufferPlatformHandlePtr
GpuMemoryBufferPlatformHandle::NewSharedMemoryHandle(
    ::base::UnsafeSharedMemoryRegion value) {
  return GpuMemoryBufferPlatformHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSharedMemoryHandle)>,
      std::move(value));
}

GpuMemoryBufferPlatformHandlePtr
GpuMemoryBufferPlatformHandle::NewIoSurfaceHandle(
    IOSurfaceHandlePtr value) {
  return GpuMemoryBufferPlatformHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIoSurfaceHandle)>,
      std::move(value));
}

GpuMemoryBufferPlatformHandle::GpuMemoryBufferPlatformHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemoryHandle)>,
    ::base::UnsafeSharedMemoryRegion value)
    : tag_(Tag::kSharedMemoryHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSharedMemoryHandle)>,
            std::move(value)) {}

GpuMemoryBufferPlatformHandle::GpuMemoryBufferPlatformHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kIoSurfaceHandle)>,
    IOSurfaceHandlePtr value)
    : tag_(Tag::kIoSurfaceHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIoSurfaceHandle)>,
            std::move(value)) {}
GpuMemoryBufferPlatformHandle::~GpuMemoryBufferPlatformHandle() {
  DestroyActive();
}

void GpuMemoryBufferPlatformHandle::set_shared_memory_handle(::base::UnsafeSharedMemoryRegion shared_memory_handle) {
  if (tag_ == Tag::kSharedMemoryHandle) {
    data_.shared_memory_handle = std::move(shared_memory_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kSharedMemoryHandle;
    new (&data_.shared_memory_handle) ::base::UnsafeSharedMemoryRegion(
        std::move(shared_memory_handle));
  }
}

void GpuMemoryBufferPlatformHandle::set_io_surface_handle(IOSurfaceHandlePtr io_surface_handle) {
  if (tag_ == Tag::kIoSurfaceHandle) {
    data_.io_surface_handle = std::move(io_surface_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kIoSurfaceHandle;
    new (&data_.io_surface_handle) IOSurfaceHandlePtr(
        std::move(io_surface_handle));
  }
}


GpuMemoryBufferPlatformHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemoryHandle)>,
    ::base::UnsafeSharedMemoryRegion value)
    : shared_memory_handle(std::move(value)) {}

GpuMemoryBufferPlatformHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIoSurfaceHandle)>,
    IOSurfaceHandlePtr value)
    : io_surface_handle(std::move(value)) {}

void GpuMemoryBufferPlatformHandle::DestroyActive() {
  switch (tag_) {

    case Tag::kSharedMemoryHandle:
      std::destroy_at(&data_.shared_memory_handle);
      break;
    case Tag::kIoSurfaceHandle:
      std::destroy_at(&data_.io_surface_handle);
      break;
  }
}

bool GpuMemoryBufferPlatformHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // gfx::mojom


namespace mojo {


// static
bool StructTraits<::gfx::mojom::IOSurfaceHandle::DataView, ::gfx::mojom::IOSurfaceHandlePtr>::Read(
    ::gfx::mojom::IOSurfaceHandle::DataView input,
    ::gfx::mojom::IOSurfaceHandlePtr* output) {
  bool success = true;
  ::gfx::mojom::IOSurfaceHandlePtr result(::gfx::mojom::IOSurfaceHandle::New());
  
      if (success)
        result->mach_send_right = input.TakeMachSendRight();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::gfx::mojom::GpuMemoryBufferPlatformHandle::DataView, ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr>::Read(
    ::gfx::mojom::GpuMemoryBufferPlatformHandle::DataView input,
    ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr* output) {
  using UnionType = ::gfx::mojom::GpuMemoryBufferPlatformHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSharedMemoryHandle: {
      ::base::UnsafeSharedMemoryRegion result_shared_memory_handle{};
      if (!input.ReadSharedMemoryHandle(&result_shared_memory_handle))
        return false;

      *output = UnionType::NewSharedMemoryHandle(
          std::move(result_shared_memory_handle));
      break;
    }
    case Tag::kIoSurfaceHandle: {
      ::gfx::mojom::IOSurfaceHandlePtr result_io_surface_handle{};
      if (!input.ReadIoSurfaceHandle(&result_io_surface_handle))
        return false;

      *output = UnionType::NewIoSurfaceHandle(
          std::move(result_io_surface_handle));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gfx::mojom {




}  // gfx::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif