// ui/gfx/mojom/native_handle_types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/mojom/native_handle_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"

#include "ui/gfx/mojom/native_handle_types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::IOSurfaceHandleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::IOSurfaceHandleDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::IOSurfaceHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mach_send_right(input)) in_mach_send_right = Traits::mach_send_right(input);

      
      mojo::internal::Serialize<mojo::PlatformHandle>(
        in_mach_send_right,
        &fragment->mach_send_right,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->mach_send_right)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid mach_send_right in IOSurfaceHandle struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView::Tag::kSharedMemoryHandle: {
    decltype(Traits::shared_memory_handle(input))
    in_shared_memory_handle = Traits::shared_memory_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_memory_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView, send_validation>(
  in_shared_memory_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_memory_handle in GpuMemoryBufferPlatformHandle union");
    fragment->data.f_shared_memory_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView::Tag::kIoSurfaceHandle: {
    decltype(Traits::io_surface_handle(input))
    in_io_surface_handle = Traits::io_surface_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_io_surface_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::IOSurfaceHandleDataView, send_validation>(
  in_io_surface_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null io_surface_handle in GpuMemoryBufferPlatformHandle union");
    fragment->data.f_io_surface_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SEND_VALIDATION_H_